/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtException;
import java.io.IOException;

class OrtAllocator
implements AutoCloseable {
    final long handle;
    private final boolean isDefault;
    private boolean closed = false;

    OrtAllocator(long handle, boolean isDefault) {
        this.handle = handle;
        this.isDefault = isDefault;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void close() throws OrtException {
        if (!this.closed) {
            if (!this.isDefault) {
                this.closeAllocator(OnnxRuntime.ortApiHandle, this.handle);
                this.closed = true;
            }
        } else {
            throw new IllegalStateException("Trying to close an already closed OrtAllocator.");
        }
    }

    private native void closeAllocator(long var1, long var3) throws OrtException;

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

