/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public enum FieldType {
    BOOLEAN(Boolean.TYPE, Boolean.class),
    BYTE(Byte.TYPE, Byte.class),
    CHAR(Character.TYPE, Character.class),
    SHORT(Short.TYPE, Short.class),
    INTEGER(Integer.TYPE, Integer.class),
    LONG(Long.TYPE, Long.class),
    FLOAT(Float.TYPE, Float.class),
    DOUBLE(Double.TYPE, Double.class),
    STRING(String.class),
    BYTE_ARRAY(byte[].class),
    CHAR_ARRAY(char[].class),
    SHORT_ARRAY(short[].class),
    INTEGER_ARRAY(int[].class),
    LONG_ARRAY(long[].class),
    FLOAT_ARRAY(float[].class),
    DOUBLE_ARRAY(double[].class),
    BOOLEAN_ARRAY(boolean[].class),
    CONFIGURABLE(Configurable.class),
    STRING_ARRAY(String[].class),
    CONFIGURABLE_ARRAY(Configurable[].class),
    LIST(List.class),
    ENUM_SET(EnumSet.class),
    SET(Set.class),
    MAP(Map.class),
    ATOMIC_INTEGER(AtomicInteger.class),
    ATOMIC_LONG(AtomicLong.class),
    FILE(File.class),
    PATH(Path.class),
    URL(URL.class),
    DATE_TIME(OffsetDateTime.class),
    DATE(LocalDate.class),
    TIME(OffsetTime.class),
    ENUM(Enum.class),
    RANDOM(Random.class);

    private static final Class<?> configurableClass;
    private static final Class<?> configurableArrayClass;
    private static final Class<?> enumClass;
    private final List<Class<?>> types;
    private static final Map<Class<?>, FieldType> m;
    public static final EnumSet<FieldType> arrayTypes;
    public static final EnumSet<FieldType> listTypes;
    public static final EnumSet<FieldType> simpleTypes;
    public static final EnumSet<FieldType> mapTypes;
    public static final EnumSet<FieldType> configurableTypes;

    private FieldType(Class<?> ... types) {
        this.types = Collections.unmodifiableList(Arrays.asList(types));
    }

    public static FieldType getFieldType(Class<?> clazz) {
        if (configurableClass.isAssignableFrom(clazz)) {
            return m.get(configurableClass);
        }
        if (configurableArrayClass.isAssignableFrom(clazz)) {
            return m.get(configurableArrayClass);
        }
        if (enumClass.isAssignableFrom(clazz)) {
            return m.get(enumClass);
        }
        return m.get(clazz);
    }

    public static FieldType getFieldType(Field f) {
        Class<?> fieldClass = f.getType();
        return FieldType.getFieldType(fieldClass);
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    public static boolean isBoolean(FieldType ft) {
        return ft.equals((Object)BOOLEAN);
    }

    static {
        configurableClass = Configurable.class;
        configurableArrayClass = Configurable[].class;
        enumClass = Enum.class;
        m = new HashMap();
        arrayTypes = EnumSet.of(BYTE_ARRAY, new FieldType[]{CHAR_ARRAY, SHORT_ARRAY, INTEGER_ARRAY, LONG_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, BOOLEAN_ARRAY, STRING_ARRAY, CONFIGURABLE_ARRAY});
        listTypes = EnumSet.of(LIST, SET, ENUM_SET);
        simpleTypes = EnumSet.of(BOOLEAN, new FieldType[]{BYTE, CHAR, SHORT, INTEGER, LONG, FLOAT, DOUBLE, STRING, CONFIGURABLE, ATOMIC_INTEGER, ATOMIC_LONG, FILE, PATH, URL, RANDOM, DATE_TIME, DATE, TIME, ENUM});
        mapTypes = EnumSet.of(MAP);
        configurableTypes = EnumSet.of(CONFIGURABLE, CONFIGURABLE_ARRAY);
        for (FieldType ft : FieldType.values()) {
            for (Class<?> type : ft.types) {
                m.put(type, ft);
            }
        }
    }
}

