/* alpm_utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alpm_utils.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2018-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <alpm.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "pamac.h"
#include <errno.h>
#include <glib/gi18n-lib.h>
#include <stdarg.h>
#include <alpm_list.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_ALPM_UTILS (pamac_alpm_utils_get_type ())
#define PAMAC_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils))
#define PAMAC_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))
#define PAMAC_IS_ALPM_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_IS_ALPM_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_UTILS))
#define PAMAC_ALPM_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtilsClass))

typedef struct _PamacAlpmUtils PamacAlpmUtils;
typedef struct _PamacAlpmUtilsClass PamacAlpmUtilsClass;
typedef struct _PamacAlpmUtilsPrivate PamacAlpmUtilsPrivate;

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
enum  {
	PAMAC_ALPM_UTILS_0_PROPERTY,
	PAMAC_ALPM_UTILS_NUM_PROPERTIES
};
static GParamSpec* pamac_alpm_utils_properties[PAMAC_ALPM_UTILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alpm_config_unref0(var) ((var == NULL) ? NULL : (var = (alpm_config_unref (var), NULL)))
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PAMAC_TYPE_ALPM_PACKAGE_LINKED (pamac_alpm_package_linked_get_type ())
#define PAMAC_ALPM_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinked))
#define PAMAC_ALPM_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinkedClass))
#define PAMAC_IS_ALPM_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED))
#define PAMAC_IS_ALPM_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_PACKAGE_LINKED))
#define PAMAC_ALPM_PACKAGE_LINKED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_PACKAGE_LINKED, PamacAlpmPackageLinkedClass))

typedef struct _PamacAlpmPackageLinked PamacAlpmPackageLinked;
typedef struct _PamacAlpmPackageLinkedClass PamacAlpmPackageLinkedClass;

#define PAMAC_TYPE_ALPM_PACKAGE_STATIC (pamac_alpm_package_static_get_type ())
#define PAMAC_ALPM_PACKAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStatic))
#define PAMAC_ALPM_PACKAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStaticClass))
#define PAMAC_IS_ALPM_PACKAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC))
#define PAMAC_IS_ALPM_PACKAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_ALPM_PACKAGE_STATIC))
#define PAMAC_ALPM_PACKAGE_STATIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_ALPM_PACKAGE_STATIC, PamacAlpmPackageStaticClass))

typedef struct _PamacAlpmPackageStatic PamacAlpmPackageStatic;
typedef struct _PamacAlpmPackageStaticClass PamacAlpmPackageStaticClass;
#define _alpm_list_free0(var) ((var == NULL) ? NULL : (var = (alpm_list_free (var), NULL)))
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _alpm_pkg_free0(var) ((var == NULL) ? NULL : (var = (alpm_pkg_free (var), NULL)))
#define _alpm_depmissing_free0(var) ((var == NULL) ? NULL : (var = (alpm_depmissing_free (var), NULL)))
#define _alpm_conflict_free0(var) ((var == NULL) ? NULL : (var = (alpm_conflict_free (var), NULL)))
typedef struct _Block55Data Block55Data;
#define _alpm_fileconflict_free0(var) ((var == NULL) ? NULL : (var = (alpm_fileconflict_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL,
	PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL,
	PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL,
	PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL,
	PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL,
	PAMAC_ALPM_UTILS_NUM_SIGNALS
};
static guint pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_NUM_SIGNALS] = {0};
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _PamacAlpmUtils {
	GObject parent_instance;
	PamacAlpmUtilsPrivate * priv;
	AlpmConfig* alpm_config;
	GFile* lockfile;
	alpm_handle_t* alpm_handle;
	GCancellable* cancellable;
	gboolean downloading_updates;
	gchar* current_filename;
	gchar* current_action;
	gdouble current_progress;
	GPtrArray* unresolvables;
	guint64 total_download;
	guint64 already_downloaded;
	GHashTable* multi_progress;
	GTimer* rate_timer;
};

struct _PamacAlpmUtilsClass {
	GObjectClass parent_class;
};

struct _PamacAlpmUtilsPrivate {
	gchar* sender;
	PamacConfig* config;
	gchar* tmp_path;
	guint8 commit_retries;
	gchar* current_status;
	gboolean sysupgrade;
	gboolean enable_downgrade;
	gboolean simple_install;
	gboolean no_confirm_commit;
	gboolean keep_built_pkgs;
	gint trans_flags;
	GHashTable* to_install;
	GHashTable* deps_to_install;
	GHashTable* to_remove;
	GHashTable* required_to_remove;
	GHashTable* orphans_to_remove;
	GHashTable* conflicts_to_remove;
	GHashTable* local_paths;
	GHashTable* remote_paths;
	GHashTable* to_build;
	GHashTable* checked_deps;
	GHashTable* to_install_as_dep;
	GHashTable* ignorepkgs;
	GHashTable* overwrite_files;
	GHashTable* to_syncfirst;
	GQueue* download_rates;
	gdouble download_rate;
};

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gchar* dbpath;
	gboolean checkspace;
	GHashTable* ignorepkgs;
	GHashTable* holdpkgs;
	GHashTable* syncfirsts;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

struct _Block55Data {
	int _ref_count_;
	PamacAlpmUtils* self;
	alpm_handle_t* alpm_handle;
};

static gint PamacAlpmUtils_private_offset;
static gpointer pamac_alpm_utils_parent_class = NULL;

VALA_EXTERN GType pamac_alpm_utils_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_new (PamacConfig* config);
VALA_EXTERN PamacAlpmUtils* pamac_alpm_utils_construct (GType object_type,
                                            PamacConfig* config);
VALA_EXTERN AlpmConfig* pamac_config_get_alpm_config (PamacConfig* self);
static void pamac_alpm_utils_check_old_lock (PamacAlpmUtils* self);
VALA_EXTERN gint pamac_alpm_utils_do_choose_provider (PamacAlpmUtils* self,
                                          const gchar* depend,
                                          GPtrArray* providers);
static void pamac_alpm_utils_do_start_downloading (PamacAlpmUtils* self);
static void pamac_alpm_utils_do_stop_downloading (PamacAlpmUtils* self);
VALA_EXTERN void pamac_alpm_utils_do_emit_action (PamacAlpmUtils* self,
                                      const gchar* action);
static void pamac_alpm_utils_do_emit_action_progress (PamacAlpmUtils* self,
                                               const gchar* action,
                                               const gchar* status,
                                               gdouble progress);
static void pamac_alpm_utils_do_emit_download_progress (PamacAlpmUtils* self,
                                                 const gchar* action,
                                                 const gchar* status,
                                                 gdouble progress);
static void pamac_alpm_utils_do_emit_hook_progress (PamacAlpmUtils* self,
                                             const gchar* action,
                                             const gchar* details,
                                             const gchar* status,
                                             gdouble progress);
VALA_EXTERN void pamac_alpm_utils_do_emit_script_output (PamacAlpmUtils* self,
                                             const gchar* message);
static void pamac_alpm_utils_do_emit_warning (PamacAlpmUtils* self,
                                       const gchar* message);
static void pamac_alpm_utils_do_emit_error (PamacAlpmUtils* self,
                                     const gchar* message,
                                     GPtrArray* details);
static void pamac_alpm_utils_do_important_details_outpout (PamacAlpmUtils* self,
                                                    gboolean must_show);
VALA_EXTERN alpm_handle_t* pamac_alpm_utils_get_handle (PamacAlpmUtils* self,
                                            gboolean files_db,
                                            gboolean tmp_db,
                                            gboolean callbacks);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self,
                                       gboolean files_db,
                                       gboolean tmp_db,
                                       gboolean copy_dbs);
VALA_EXTERN void cb_event (void* ctx,
               alpm_event_t* data);
static void _cb_event_alpm_cb_event (void* ctx,
                              alpm_event_t* data);
VALA_EXTERN void cb_progress (void* ctx,
                  alpm_progress_t progress,
                  const gchar* pkgname,
                  gint percent,
                  guint n_targets,
                  guint current_target);
static void _cb_progress_alpm_cb_progress (void* ctx,
                                    alpm_progress_t progress,
                                    const gchar* pkgname,
                                    gint percent,
                                    guint n_targets,
                                    guint current_target);
VALA_EXTERN void cb_question (void* ctx,
                  alpm_question_t* data);
static void _cb_question_alpm_cb_question (void* ctx,
                                    alpm_question_t* data);
VALA_EXTERN void cb_download (void* ctx,
                  const gchar* filename,
                  alpm_download_event_type_t event_type,
                  void* event_data);
static void _cb_download_alpm_cb_download (void* ctx,
                                    const gchar* filename,
                                    alpm_download_event_type_t event_type,
                                    void* event_data);
VALA_EXTERN void cb_log (void* ctx,
             alpm_loglevel_t level,
             const gchar* fmt,
             va_list args);
static void _cb_log_alpm_cb_log (void* ctx,
                          alpm_loglevel_t level,
                          const gchar* fmt,
                          va_list args);
VALA_EXTERN void alpm_config_register_syncdbs (AlpmConfig* self,
                                   alpm_handle_t* handle);
VALA_EXTERN gboolean pamac_alpm_utils_set_pkgreason (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         const gchar* pkgname,
                                         guint reason);
VALA_EXTERN gboolean pamac_alpm_utils_clean_cache (PamacAlpmUtils* self,
                                       gchar** filenames,
                                       gint filenames_length1);
VALA_EXTERN gboolean pamac_alpm_utils_clean_build_files (PamacAlpmUtils* self,
                                             const gchar* aur_build_dir);
static alpm_pkg_t* pamac_alpm_utils_get_syncpkg (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          const gchar* name);
static gboolean pamac_alpm_utils_update_dbs (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle,
                                      gint force);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         gboolean force_refresh);
VALA_EXTERN void write_log_file (const gchar* event);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh_files (PamacAlpmUtils* self,
                                               const gchar* sender,
                                               gboolean force_refresh);
VALA_EXTERN gboolean pamac_alpm_utils_trans_refresh_aur (PamacAlpmUtils* self,
                                             const gchar* sender,
                                             gboolean force_refresh);
VALA_EXTERN gchar* get_os_id (void);
static void pamac_alpm_utils_add_ignorepkgs (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_ignorepkgs (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_add_overwrite_files (PamacAlpmUtils* self,
                                           alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_overwrite_files (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle);
static PamacAlpmPackage* pamac_alpm_utils_initialise_pkg (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle,
                                                   alpm_pkg_t* alpm_pkg);
VALA_EXTERN PamacAlpmPackageStatic* pamac_alpm_package_static_new_transaction (alpm_pkg_t* alpm_pkg,
                                                                   alpm_pkg_t* local_pkg,
                                                                   alpm_pkg_t* sync_pkg);
VALA_EXTERN PamacAlpmPackageStatic* pamac_alpm_package_static_construct_transaction (GType object_type,
                                                                         alpm_pkg_t* alpm_pkg,
                                                                         alpm_pkg_t* local_pkg,
                                                                         alpm_pkg_t* sync_pkg);
VALA_EXTERN GType pamac_alpm_package_linked_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_alpm_package_static_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean pamac_alpm_utils_download_updates (PamacAlpmUtils* self,
                                            const gchar* sender);
static gboolean pamac_alpm_utils_trans_init (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle,
                                      gint flags,
                                      gboolean emit_error);
static gboolean pamac_alpm_utils_trans_sysupgrade (PamacAlpmUtils* self,
                                            alpm_handle_t* alpm_handle,
                                            gboolean emit_error);
static gboolean pamac_alpm_utils_trans_add_pkg_real (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle,
                                              alpm_pkg_t* pkg,
                                              gboolean emit_error);
static gboolean pamac_alpm_utils_trans_add_pkg (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle,
                                         const gchar* pkgname,
                                         gboolean emit_error);
VALA_EXTERN gboolean pamac_alpm_utils_download_pkgs (PamacAlpmUtils* self,
                                         const gchar* sender,
                                         gchar** urls,
                                         gint urls_length1,
                                         GPtrArray** dload_paths);
static gboolean pamac_alpm_utils_trans_load_pkg (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          const gchar* path,
                                          gint siglevel,
                                          gboolean emit_error);
static gboolean pamac_alpm_utils_trans_remove_pkg (PamacAlpmUtils* self,
                                            alpm_handle_t* alpm_handle,
                                            const gchar* pkgname,
                                            gboolean emit_error);
static gboolean pamac_alpm_utils_trans_prepare_real (PamacAlpmUtils* self,
                                              alpm_handle_t* alpm_handle,
                                              gboolean emit_error);
static void pamac_alpm_utils_trans_release (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_prepare_aur_db (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_aur_db (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle);
VALA_EXTERN gboolean pamac_alpm_utils_trans_check_prepare (PamacAlpmUtils* self,
                                               gboolean sysupgrade,
                                               gboolean enable_downgrade,
                                               gboolean simple_install,
                                               gint trans_flags,
                                               GHashTable* to_install,
                                               GHashTable* to_remove,
                                               GHashTable* local_paths,
                                               GHashTable* remote_paths,
                                               GHashTable* to_build,
                                               GHashTable* ignorepkgs,
                                               GHashTable* overwrite_files,
                                               PamacTransactionSummary** summary);
static void pamac_alpm_utils_intern_compute_pkgs_to_remove (PamacAlpmUtils* self,
                                                     alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_intern_compute_pkgs_to_install (PamacAlpmUtils* self,
                                                      alpm_handle_t* alpm_handle,
                                                      alpm_db_t* aur_db);
static void pamac_alpm_utils_intern_compute_orphans_to_remove (PamacAlpmUtils* self,
                                                        alpm_handle_t* alpm_handle);
static gboolean pamac_alpm_utils_trans_prepare (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle,
                                         alpm_db_t* aur_db);
static void pamac_alpm_utils_get_transaction_summary (PamacAlpmUtils* self,
                                               alpm_handle_t* alpm_handle,
                                               PamacTransactionSummary** summary);
static void pamac_alpm_utils_trans_reset (PamacAlpmUtils* self);
VALA_EXTERN gboolean pamac_alpm_utils_trans_run (PamacAlpmUtils* self,
                                     const gchar* sender,
                                     gboolean sysupgrade,
                                     gboolean enable_downgrade,
                                     gboolean simple_install,
                                     gboolean keep_built_pkgs,
                                     gint trans_flags,
                                     gchar** to_install,
                                     gint to_install_length1,
                                     gchar** to_remove,
                                     gint to_remove_length1,
                                     gchar** to_load_local,
                                     gint to_load_local_length1,
                                     gchar** to_load_remote,
                                     gint to_load_remote_length1,
                                     gchar** to_install_as_dep,
                                     gint to_install_as_dep_length1,
                                     gchar** ignorepkgs,
                                     gint ignorepkgs_length1,
                                     gchar** overwrite_files,
                                     gint overwrite_files_length1);
static gboolean pamac_alpm_utils_trans_run_real (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle);
static gboolean pamac_alpm_utils_trans_commit (PamacAlpmUtils* self,
                                        alpm_handle_t* alpm_handle);
static void pamac_alpm_utils_remove_install_deps_in_to_remove (PamacAlpmUtils* self,
                                                        alpm_handle_t* alpm_handle,
                                                        alpm_list_t* deps_to_check);
static void pamac_alpm_utils_check_orphans_to_remove (PamacAlpmUtils* self,
                                               alpm_handle_t* alpm_handle,
                                               alpm_list_t* deps_to_check);
static void _g_free_alpm_list_fn_free (gconstpointer a);
VALA_EXTERN GPtrArray* pamac_transaction_summary_get_aur_pkgbases_to_build (PamacTransactionSummary* self);
VALA_EXTERN GPtrArray* pamac_transaction_summary_get_to_load (PamacTransactionSummary* self);
static gboolean pamac_alpm_utils_need_reboot (PamacAlpmUtils* self,
                                       alpm_handle_t* alpm_handle);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static gboolean pamac_alpm_utils_trans_commit_real (PamacAlpmUtils* self,
                                             alpm_handle_t* alpm_handle,
                                             gboolean* need_retry);
static gboolean ___lambda44_ (Block55Data* _data55_,
                       const gchar* pkgname,
                       const gchar* val);
static gboolean ____lambda44__ghr_func (gconstpointer key,
                                 gconstpointer value,
                                 gpointer self);
static gchar* pamac_alpm_utils_backup_conflict_file (PamacAlpmUtils* self,
                                              const gchar* file_path);
VALA_EXTERN void pamac_alpm_utils_trans_cancel (PamacAlpmUtils* self,
                                    const gchar* sender);
static gchar* pamac_alpm_utils_remove_bash_colors (PamacAlpmUtils* self,
                                            const gchar* msg);
VALA_EXTERN void pamac_alpm_utils_emit_event (PamacAlpmUtils* self,
                                  guint primary_event,
                                  guint secondary_event,
                                  GPtrArray* details);
VALA_EXTERN void pamac_alpm_utils_emit_progress (PamacAlpmUtils* self,
                                     guint progress,
                                     const gchar* pkgname,
                                     guint percent,
                                     guint n_targets,
                                     guint current_target);
VALA_EXTERN void pamac_alpm_utils_emit_download (PamacAlpmUtils* self,
                                     guint64 xfered,
                                     guint64 total);
static gdouble* _double_dup (gdouble* self);
VALA_EXTERN void pamac_alpm_utils_emit_totaldownload (PamacAlpmUtils* self,
                                          guint64 total);
VALA_EXTERN void pamac_alpm_utils_emit_log (PamacAlpmUtils* self,
                                guint level,
                                const gchar* msg);
static void g_cclosure_user_marshal_INT__STRING_BOXED (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                       GValue * return_value,
                                                                       guint n_param_values,
                                                                       const GValue * param_values,
                                                                       gpointer invocation_hint,
                                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOXED (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void pamac_alpm_utils_finalize (GObject * obj);
static GType pamac_alpm_utils_get_type_once (void);
VALA_EXTERN void compute_multi_download_progress (PamacAlpmUtils* alpm_utils);
static guint64* _uint64_dup (guint64* self);
VALA_EXTERN void emit_download (PamacAlpmUtils* alpm_utils,
                    const gchar* filename,
                    guint64 xfered,
                    guint64 total);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
pamac_alpm_utils_get_instance_private (PamacAlpmUtils* self)
{
	return G_STRUCT_MEMBER_P (self, PamacAlpmUtils_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_alpm_config_ref0 (gpointer self)
{
	return self ? alpm_config_ref (self) : NULL;
}

PamacAlpmUtils*
pamac_alpm_utils_construct (GType object_type,
                            PamacConfig* config)
{
	PamacAlpmUtils * self = NULL;
	gchar* _tmp0_;
	PamacConfig* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	AlpmConfig* _tmp5_;
	AlpmConfig* _tmp6_;
	AlpmConfig* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GHashTable* _tmp18_;
	GHashFunc _tmp19_;
	GEqualFunc _tmp20_;
	GHashTable* _tmp21_;
	GHashFunc _tmp22_;
	GEqualFunc _tmp23_;
	GHashTable* _tmp24_;
	GHashFunc _tmp25_;
	GEqualFunc _tmp26_;
	GHashTable* _tmp27_;
	GHashFunc _tmp28_;
	GEqualFunc _tmp29_;
	GHashTable* _tmp30_;
	GHashFunc _tmp31_;
	GEqualFunc _tmp32_;
	GHashTable* _tmp33_;
	GHashFunc _tmp34_;
	GEqualFunc _tmp35_;
	GHashTable* _tmp36_;
	GHashFunc _tmp37_;
	GEqualFunc _tmp38_;
	GHashTable* _tmp39_;
	GHashFunc _tmp40_;
	GEqualFunc _tmp41_;
	GHashTable* _tmp42_;
	GHashFunc _tmp43_;
	GEqualFunc _tmp44_;
	GHashTable* _tmp45_;
	GHashFunc _tmp46_;
	GEqualFunc _tmp47_;
	GHashTable* _tmp48_;
	GHashFunc _tmp49_;
	GEqualFunc _tmp50_;
	GHashTable* _tmp51_;
	GPtrArray* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GTimer* _tmp56_;
	GQueue* _tmp57_;
	GCancellable* _tmp58_;
	g_return_val_if_fail (config != NULL, NULL);
	self = (PamacAlpmUtils*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->multi_progress);
	self->multi_progress = _tmp4_;
	_tmp5_ = pamac_config_get_alpm_config (config);
	_tmp6_ = _tmp5_;
	_tmp7_ = _alpm_config_ref0 (_tmp6_);
	_alpm_config_unref0 (self->alpm_config);
	self->alpm_config = _tmp7_;
	_tmp8_ = g_get_user_name ();
	_tmp9_ = g_strdup_printf ("/tmp/pamac-%s", _tmp8_);
	_g_free0 (self->priv->tmp_path);
	self->priv->tmp_path = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_syncfirst);
	self->priv->to_syncfirst = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_install);
	self->priv->to_install = _tmp15_;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->deps_to_install);
	self->priv->deps_to_install = _tmp18_;
	_tmp19_ = g_str_hash;
	_tmp20_ = g_str_equal;
	_tmp21_ = g_hash_table_new_full (_tmp19_, _tmp20_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_remove);
	self->priv->to_remove = _tmp21_;
	_tmp22_ = g_str_hash;
	_tmp23_ = g_str_equal;
	_tmp24_ = g_hash_table_new_full (_tmp22_, _tmp23_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->required_to_remove);
	self->priv->required_to_remove = _tmp24_;
	_tmp25_ = g_str_hash;
	_tmp26_ = g_str_equal;
	_tmp27_ = g_hash_table_new_full (_tmp25_, _tmp26_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->orphans_to_remove);
	self->priv->orphans_to_remove = _tmp27_;
	_tmp28_ = g_str_hash;
	_tmp29_ = g_str_equal;
	_tmp30_ = g_hash_table_new_full (_tmp28_, _tmp29_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->conflicts_to_remove);
	self->priv->conflicts_to_remove = _tmp30_;
	_tmp31_ = g_str_hash;
	_tmp32_ = g_str_equal;
	_tmp33_ = g_hash_table_new_full (_tmp31_, _tmp32_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->local_paths);
	self->priv->local_paths = _tmp33_;
	_tmp34_ = g_str_hash;
	_tmp35_ = g_str_equal;
	_tmp36_ = g_hash_table_new_full (_tmp34_, _tmp35_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->remote_paths);
	self->priv->remote_paths = _tmp36_;
	_tmp37_ = g_str_hash;
	_tmp38_ = g_str_equal;
	_tmp39_ = g_hash_table_new_full (_tmp37_, _tmp38_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_build);
	self->priv->to_build = _tmp39_;
	_tmp40_ = g_str_hash;
	_tmp41_ = g_str_equal;
	_tmp42_ = g_hash_table_new_full (_tmp40_, _tmp41_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->checked_deps);
	self->priv->checked_deps = _tmp42_;
	_tmp43_ = g_str_hash;
	_tmp44_ = g_str_equal;
	_tmp45_ = g_hash_table_new_full (_tmp43_, _tmp44_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->to_install_as_dep);
	self->priv->to_install_as_dep = _tmp45_;
	_tmp46_ = g_str_hash;
	_tmp47_ = g_str_equal;
	_tmp48_ = g_hash_table_new_full (_tmp46_, _tmp47_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->ignorepkgs);
	self->priv->ignorepkgs = _tmp48_;
	_tmp49_ = g_str_hash;
	_tmp50_ = g_str_equal;
	_tmp51_ = g_hash_table_new_full (_tmp49_, _tmp50_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->overwrite_files);
	self->priv->overwrite_files = _tmp51_;
	_tmp52_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->unresolvables);
	self->unresolvables = _tmp52_;
	_tmp53_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp53_;
	_tmp54_ = g_strdup ("");
	_g_free0 (self->current_action);
	self->current_action = _tmp54_;
	_tmp55_ = g_strdup ("");
	_g_free0 (self->priv->current_status);
	self->priv->current_status = _tmp55_;
	_tmp56_ = g_timer_new ();
	_g_timer_destroy0 (self->rate_timer);
	self->rate_timer = _tmp56_;
	_tmp57_ = g_queue_new ();
	(self->priv->download_rates == NULL) ? NULL : (self->priv->download_rates = (_g_queue_free__g_free0_ (self->priv->download_rates), NULL));
	self->priv->download_rates = _tmp57_;
	_tmp58_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp58_;
	self->downloading_updates = FALSE;
	pamac_alpm_utils_check_old_lock (self);
	return self;
}

PamacAlpmUtils*
pamac_alpm_utils_new (PamacConfig* config)
{
	return pamac_alpm_utils_construct (PAMAC_TYPE_ALPM_UTILS, config);
}

gint
pamac_alpm_utils_do_choose_provider (PamacAlpmUtils* self,
                                     const gchar* depend,
                                     GPtrArray* providers)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (depend != NULL, 0);
	g_return_val_if_fail (providers != NULL, 0);
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL], 0, depend, providers, &_tmp0_);
	result = _tmp0_;
	return result;
}

static void
pamac_alpm_utils_do_start_downloading (PamacAlpmUtils* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL], 0, _tmp0_);
}

static void
pamac_alpm_utils_do_stop_downloading (PamacAlpmUtils* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL], 0, _tmp0_);
}

void
pamac_alpm_utils_do_emit_action (PamacAlpmUtils* self,
                                 const gchar* action)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL], 0, _tmp0_, action);
}

static void
pamac_alpm_utils_do_emit_action_progress (PamacAlpmUtils* self,
                                          const gchar* action,
                                          const gchar* status,
                                          gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL], 0, _tmp0_, action, status, progress);
}

static void
pamac_alpm_utils_do_emit_download_progress (PamacAlpmUtils* self,
                                            const gchar* action,
                                            const gchar* status,
                                            gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL], 0, _tmp0_, action, status, progress);
}

static void
pamac_alpm_utils_do_emit_hook_progress (PamacAlpmUtils* self,
                                        const gchar* action,
                                        const gchar* details,
                                        const gchar* status,
                                        gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL], 0, _tmp0_, action, details, status, progress);
}

void
pamac_alpm_utils_do_emit_script_output (PamacAlpmUtils* self,
                                        const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL], 0, _tmp0_, message);
}

static void
pamac_alpm_utils_do_emit_warning (PamacAlpmUtils* self,
                                  const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL], 0, _tmp0_, message);
}

static void
pamac_alpm_utils_do_emit_error (PamacAlpmUtils* self,
                                const gchar* message,
                                GPtrArray* details)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL], 0, _tmp0_, message, details);
}

static void
pamac_alpm_utils_do_important_details_outpout (PamacAlpmUtils* self,
                                               gboolean must_show)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit (self, pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL], 0, _tmp0_, must_show);
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
pamac_alpm_utils_check_old_lock (PamacAlpmUtils* self)
{
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp0_;
	_tmp1_ = alpm_handle;
	if (_tmp1_ == NULL) {
		_alpm_release0 (alpm_handle);
		return;
	}
	_tmp2_ = alpm_handle;
	_tmp3_ = alpm_option_get_lockfile (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_g_object_unref0 (self->lockfile);
	self->lockfile = _tmp5_;
	_tmp6_ = self->lockfile;
	if (g_file_query_exists (_tmp6_, NULL)) {
		gint exit_status = 0;
		gchar* output = NULL;
		guint64 lockfile_time = 0ULL;
		{
			alpm_handle_t* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			_tmp7_ = alpm_handle;
			_tmp8_ = alpm_option_get_lockfile (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("stat -c %Y %s", _tmp9_);
			_tmp11_ = _tmp10_;
			g_spawn_command_line_sync (_tmp11_, &_tmp12_, NULL, &_tmp13_, &_inner_error0_);
			_g_free0 (output);
			output = _tmp12_;
			exit_status = _tmp13_;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (output);
				_alpm_release0 (alpm_handle);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (exit_status == 0) {
				gchar** splitted = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp14_ = output;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "\n", 0);
				splitted = _tmp16_;
				splitted_length1 = _vala_array_length (_tmp15_);
				_splitted_size_ = splitted_length1;
				_tmp17_ = splitted;
				_tmp17__length1 = splitted_length1;
				if (_tmp17__length1 == 2) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					guint64 _tmp20_ = 0ULL;
					gboolean _tmp21_;
					_tmp18_ = splitted;
					_tmp18__length1 = splitted_length1;
					_tmp19_ = _tmp18_[0];
					_tmp21_ = uint64_try_parse (_tmp19_, &_tmp20_, NULL, (guint) 0);
					lockfile_time = _tmp20_;
					if (_tmp21_) {
						guint64 boot_time = 0ULL;
						gchar* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						g_spawn_command_line_sync ("cat /proc/stat", &_tmp22_, NULL, &_tmp23_, &_inner_error0_);
						_g_free0 (output);
						output = _tmp22_;
						exit_status = _tmp23_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error0_->domain == G_SPAWN_ERROR) {
								goto __catch0_g_spawn_error;
							}
							_g_free0 (output);
							_alpm_release0 (alpm_handle);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						if (exit_status == 0) {
							const gchar* _tmp24_;
							gchar** _tmp25_;
							gchar** _tmp26_;
							gchar** _tmp27_;
							gint _tmp27__length1;
							_tmp24_ = output;
							_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "\n", 0);
							splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
							splitted = _tmp26_;
							splitted_length1 = _vala_array_length (_tmp25_);
							_splitted_size_ = splitted_length1;
							_tmp27_ = splitted;
							_tmp27__length1 = splitted_length1;
							{
								gchar** line_collection = NULL;
								gint line_collection_length1 = 0;
								gint _line_collection_size_ = 0;
								gint line_it = 0;
								line_collection = _tmp27_;
								line_collection_length1 = _tmp27__length1;
								for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
									const gchar* line = NULL;
									line = line_collection[line_it];
									{
										const gchar* _tmp28_;
										_tmp28_ = line;
										if (string_contains (_tmp28_, "btime")) {
											gchar** space_splitted = NULL;
											const gchar* _tmp29_;
											gchar** _tmp30_;
											gchar** _tmp31_;
											gint space_splitted_length1;
											gint _space_splitted_size_;
											gchar** _tmp32_;
											gint _tmp32__length1;
											_tmp29_ = line;
											_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, " ", 0);
											space_splitted = _tmp31_;
											space_splitted_length1 = _vala_array_length (_tmp30_);
											_space_splitted_size_ = space_splitted_length1;
											_tmp32_ = space_splitted;
											_tmp32__length1 = space_splitted_length1;
											if (_tmp32__length1 == 2) {
												gchar** _tmp33_;
												gint _tmp33__length1;
												const gchar* _tmp34_;
												guint64 _tmp35_ = 0ULL;
												gboolean _tmp36_;
												_tmp33_ = space_splitted;
												_tmp33__length1 = space_splitted_length1;
												_tmp34_ = _tmp33_[1];
												_tmp36_ = uint64_try_parse (_tmp34_, &_tmp35_, NULL, (guint) 0);
												boot_time = _tmp35_;
												if (_tmp36_) {
													if (lockfile_time < boot_time) {
														{
															GFile* _tmp37_;
															_tmp37_ = self->lockfile;
															g_file_delete (_tmp37_, NULL, &_inner_error0_);
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
																goto __catch1_g_error;
															}
														}
														goto __finally1;
														__catch1_g_error:
														{
															GError* e = NULL;
															GError* _tmp38_;
															const gchar* _tmp39_;
															e = _inner_error0_;
															_inner_error0_ = NULL;
															_tmp38_ = e;
															_tmp39_ = _tmp38_->message;
															g_warning ("alpm_utils.vala:192: %s", _tmp39_);
															_g_error_free0 (e);
														}
														__finally1:
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
															space_splitted = (_vala_array_free (space_splitted, space_splitted_length1, (GDestroyNotify) g_free), NULL);
															splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
															if (_inner_error0_->domain == G_SPAWN_ERROR) {
																goto __catch0_g_spawn_error;
															}
															_g_free0 (output);
															_alpm_release0 (alpm_handle);
															g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
															g_clear_error (&_inner_error0_);
															return;
														}
													}
												}
											}
											space_splitted = (_vala_array_free (space_splitted, space_splitted_length1, (GDestroyNotify) g_free), NULL);
										}
									}
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			g_warning ("alpm_utils.vala:204: %s", _tmp41_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (output);
			_alpm_release0 (alpm_handle);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (output);
	}
	_alpm_release0 (alpm_handle);
}

static void
_cb_event_alpm_cb_event (void* ctx,
                         alpm_event_t* data)
{
	cb_event (ctx, data);
}

static void
_cb_progress_alpm_cb_progress (void* ctx,
                               alpm_progress_t progress,
                               const gchar* pkgname,
                               gint percent,
                               guint n_targets,
                               guint current_target)
{
	cb_progress (ctx, progress, pkgname, percent, n_targets, current_target);
}

static void
_cb_question_alpm_cb_question (void* ctx,
                               alpm_question_t* data)
{
	cb_question (ctx, data);
}

static void
_cb_download_alpm_cb_download (void* ctx,
                               const gchar* filename,
                               alpm_download_event_type_t event_type,
                               void* event_data)
{
	cb_download (ctx, filename, event_type, event_data);
}

static void
_cb_log_alpm_cb_log (void* ctx,
                     alpm_loglevel_t level,
                     const gchar* fmt,
                     va_list args)
{
	cb_log (ctx, level, fmt, args);
}

alpm_handle_t*
pamac_alpm_utils_get_handle (PamacAlpmUtils* self,
                             gboolean files_db,
                             gboolean tmp_db,
                             gboolean callbacks)
{
	AlpmConfig* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	AlpmConfig* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	AlpmConfig* _tmp13_;
	alpm_handle_t* _tmp14_;
	alpm_handle_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->alpm_config;
	alpm_config_reload (_tmp0_);
	_tmp1_ = self->alpm_config;
	_tmp2_ = alpm_config_get_handle (_tmp1_, files_db, tmp_db, TRUE);
	alpm_handle = _tmp2_;
	_tmp3_ = alpm_handle;
	if (_tmp3_ == NULL) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp4_;
		GPtrArray* _tmp5_;
		gchar* _tmp6_;
		GPtrArray* _tmp7_;
		_tmp4_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
		details = _tmp4_;
		_tmp5_ = details;
		_tmp6_ = g_strdup (_ ("Failed to initialize alpm library"));
		g_ptr_array_add (_tmp5_, _tmp6_);
		_tmp7_ = details;
		pamac_alpm_utils_do_emit_error (self, "Alpm Error", _tmp7_);
		result = alpm_handle;
		_g_ptr_array_unref0 (details);
		return result;
	}
	if (callbacks) {
		alpm_handle_t* _tmp8_;
		alpm_handle_t* _tmp9_;
		alpm_handle_t* _tmp10_;
		alpm_handle_t* _tmp11_;
		alpm_handle_t* _tmp12_;
		_tmp8_ = alpm_handle;
		alpm_option_set_eventcb (_tmp8_, _cb_event_alpm_cb_event, self);
		_tmp9_ = alpm_handle;
		alpm_option_set_progresscb (_tmp9_, _cb_progress_alpm_cb_progress, self);
		_tmp10_ = alpm_handle;
		alpm_option_set_questioncb (_tmp10_, _cb_question_alpm_cb_question, self);
		_tmp11_ = alpm_handle;
		alpm_option_set_dlcb (_tmp11_, _cb_download_alpm_cb_download, self);
		_tmp12_ = alpm_handle;
		alpm_option_set_logcb (_tmp12_, _cb_log_alpm_cb_log, self);
	}
	_tmp13_ = self->alpm_config;
	_tmp14_ = alpm_handle;
	alpm_config_register_syncdbs (_tmp13_, _tmp14_);
	result = alpm_handle;
	return result;
}

gboolean
pamac_alpm_utils_set_pkgreason (PamacAlpmUtils* self,
                                const gchar* sender,
                                const gchar* pkgname,
                                guint reason)
{
	gchar* _tmp0_;
	alpm_handle_t* alpm_handle = NULL;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_pkg_t* pkg = NULL;
	alpm_handle_t* _tmp3_;
	alpm_db_t* _tmp4_;
	alpm_db_t* _tmp5_;
	alpm_pkg_t* _tmp6_;
	alpm_pkg_t* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	alpm_handle = _tmp1_;
	_tmp2_ = alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_alpm_release0 (alpm_handle);
		return result;
	}
	_tmp3_ = alpm_handle;
	_tmp4_ = alpm_get_localdb (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = alpm_db_get_pkg (_tmp5_, pkgname);
	pkg = _tmp6_;
	_tmp7_ = pkg;
	if (_tmp7_ != NULL) {
		alpm_handle_t* _tmp8_;
		_tmp8_ = alpm_handle;
		if (alpm_trans_init (_tmp8_, 0) == 0) {
			alpm_pkg_t* _tmp9_;
			alpm_handle_t* _tmp10_;
			_tmp9_ = pkg;
			alpm_pkg_set_reason (_tmp9_, (alpm_pkgreason_t) reason);
			_tmp10_ = alpm_handle;
			alpm_trans_release (_tmp10_);
			result = TRUE;
			_alpm_release0 (alpm_handle);
			return result;
		}
	}
	result = FALSE;
	_alpm_release0 (alpm_handle);
	return result;
}

gboolean
pamac_alpm_utils_clean_cache (PamacAlpmUtils* self,
                              gchar** filenames,
                              gint filenames_length1)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = filenames;
		filename_collection_length1 = filenames_length1;
		for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
			const gchar* filename = NULL;
			filename = filename_collection[filename_it];
			{
				GFile* file = NULL;
				const gchar* _tmp0_;
				GFile* _tmp1_;
				_tmp0_ = filename;
				_tmp1_ = g_file_new_for_path (_tmp0_);
				file = _tmp1_;
				{
					GFile* _tmp2_;
					_tmp2_ = file;
					g_file_delete (_tmp2_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp3_;
					const gchar* _tmp4_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp3_ = e;
					_tmp4_ = _tmp3_->message;
					g_warning ("alpm_utils.vala:253: %s", _tmp4_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp5_ = FALSE;
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
				_g_object_unref0 (file);
			}
		}
	}
	result = TRUE;
	return result;
}

gboolean
pamac_alpm_utils_clean_build_files (PamacAlpmUtils* self,
                                    const gchar* aur_build_dir)
{
	GFile* build_directory = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (aur_build_dir != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (aur_build_dir);
	build_directory = _tmp0_;
	_tmp1_ = build_directory;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = TRUE;
		_g_object_unref0 (build_directory);
		return result;
	}
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* info = NULL;
		_tmp2_ = build_directory;
		_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* absolute_filename = NULL;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			if (g_strcmp0 (_tmp10_, "packages-meta-ext-v1.json.gz") == 0) {
				_g_object_unref0 (_tmp4_);
				continue;
			}
			_tmp11_ = build_directory;
			_tmp12_ = g_file_get_path (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_name (_tmp14_);
			_tmp16_ = g_build_filename (_tmp13_, _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp13_);
			absolute_filename = _tmp17_;
			_tmp18_ = absolute_filename;
			_tmp19_ = g_strdup_printf ("rm -rf %s", _tmp18_);
			_tmp20_ = _tmp19_;
			g_spawn_command_line_sync (_tmp20_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp20_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (absolute_filename);
				_g_object_unref0 (_tmp4_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_g_free0 (absolute_filename);
			_g_object_unref0 (_tmp4_);
		}
		result = TRUE;
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (build_directory);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("alpm_utils.vala:276: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		_g_object_unref0 (build_directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp23_;
	}
	result = FALSE;
	_g_object_unref0 (build_directory);
	return result;
}

static alpm_pkg_t*
pamac_alpm_utils_get_syncpkg (PamacAlpmUtils* self,
                              alpm_handle_t* alpm_handle,
                              const gchar* name)
{
	alpm_pkg_t* pkg = NULL;
	alpm_list_t* syncdbs = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_pkg_t* _tmp8_;
	alpm_pkg_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	pkg = NULL;
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	syncdbs = _tmp1_;
	while (TRUE) {
		alpm_list_t* _tmp2_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp3_;
		gconstpointer _tmp4_;
		alpm_db_t* _tmp5_;
		alpm_pkg_t* _tmp6_;
		alpm_pkg_t* _tmp7_;
		_tmp2_ = syncdbs;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = syncdbs;
		_tmp4_ = _tmp3_->data;
		db = (alpm_db_t*) _tmp4_;
		_tmp5_ = db;
		_tmp6_ = alpm_db_get_pkg (_tmp5_, name);
		pkg = _tmp6_;
		_tmp7_ = pkg;
		if (_tmp7_ != NULL) {
			break;
		}
		syncdbs = alpm_list_next (syncdbs);
	}
	_tmp8_ = pkg;
	result = _tmp8_;
	return result;
}

static gboolean
pamac_alpm_utils_update_dbs (PamacAlpmUtils* self,
                             alpm_handle_t* alpm_handle,
                             gint force)
{
	gboolean success = FALSE;
	alpm_list_t* syncdbs = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_list_t* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	syncdbs = _tmp1_;
	_tmp2_ = syncdbs;
	if (alpm_db_update (alpm_handle, _tmp2_, force) < 0) {
		alpm_errno_t err_no = 0;
		success = FALSE;
		err_no = alpm_errno (alpm_handle);
		if (err_no != 0) {
			const gchar* _tmp10_;
			if (err_no == ALPM_ERR_HANDLE_LOCK) {
				{
					const gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = self->priv->tmp_path;
					_tmp4_ = g_strdup_printf ("rm -f %s/dbs/db.lck", _tmp3_);
					_tmp5_ = _tmp4_;
					g_spawn_command_line_sync (_tmp5_, NULL, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp5_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp6_ = FALSE;
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch0_g_spawn_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp6_;
					}
				}
				goto __finally0;
				__catch0_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp7_;
					const gchar* _tmp8_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp7_ = e;
					_tmp8_ = _tmp7_->message;
					g_warning ("alpm_utils.vala:307: %s", _tmp8_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp9_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			_tmp10_ = alpm_strerror (err_no);
			pamac_alpm_utils_do_emit_warning (self, _tmp10_);
		}
	}
	result = success;
	return result;
}

gboolean
pamac_alpm_utils_trans_refresh (PamacAlpmUtils* self,
                                const gchar* sender,
                                gboolean force_refresh)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	gint _tmp4_ = 0;
	gint force = 0;
	alpm_handle_t* _tmp12_;
	alpm_handle_t* _tmp13_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp14_;
	GCancellable* _tmp15_;
	GCancellable* _tmp19_;
	gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = g_strconcat (_ ("Synchronizing package databases"), "...", NULL);
	_tmp2_ = _tmp1_;
	pamac_alpm_utils_do_emit_action (self, _tmp2_);
	_g_free0 (_tmp2_);
	write_log_file ("synchronizing package lists");
	_tmp3_ = self->cancellable;
	g_cancellable_reset (_tmp3_);
	if (force_refresh) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	force = _tmp4_;
	if (force_refresh) {
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->tmp_path;
			_tmp6_ = g_strdup_printf ("bash -c 'rm -rf %s/dbs'", _tmp5_);
			_tmp7_ = _tmp6_;
			g_spawn_command_line_sync (_tmp7_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp7_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp8_;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("alpm_utils.vala:327: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	_tmp12_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, TRUE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp12_;
	_tmp13_ = self->alpm_handle;
	if (_tmp13_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->alpm_handle;
	success = pamac_alpm_utils_update_dbs (self, _tmp14_, force);
	_tmp15_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp15_)) {
		result = FALSE;
		return result;
	}
	if (force_refresh) {
		alpm_handle_t* _tmp16_;
		alpm_handle_t* _tmp17_;
		_tmp16_ = pamac_alpm_utils_get_handle (self, TRUE, FALSE, TRUE);
		_alpm_release0 (self->alpm_handle);
		self->alpm_handle = _tmp16_;
		_tmp17_ = self->alpm_handle;
		if (_tmp17_ != NULL) {
			alpm_handle_t* _tmp18_;
			_tmp18_ = self->alpm_handle;
			pamac_alpm_utils_update_dbs (self, _tmp18_, force);
		}
	}
	_tmp19_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp19_)) {
		result = FALSE;
		return result;
	} else {
		if (!success) {
			pamac_alpm_utils_do_emit_warning (self, _ ("Failed to synchronize databases"));
		}
	}
	if (success) {
		{
			gchar* timestamp_path = NULL;
			alpm_handle_t* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp20_ = self->alpm_handle;
			_tmp21_ = alpm_option_get_dbpath (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_build_filename (_tmp22_, "sync", "refresh_timestamp", NULL);
			timestamp_path = _tmp23_;
			_tmp24_ = timestamp_path;
			_tmp25_ = g_strdup_printf ("touch %s", _tmp24_);
			_tmp26_ = _tmp25_;
			g_spawn_command_line_sync (_tmp26_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp26_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp27_ = FALSE;
				_g_free0 (timestamp_path);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp27_;
			}
			_g_free0 (timestamp_path);
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_warning ("alpm_utils.vala:359: %s", _tmp29_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp30_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp30_;
		}
	}
	_tmp31_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp31_;
	result = TRUE;
	return result;
}

gboolean
pamac_alpm_utils_trans_refresh_files (PamacAlpmUtils* self,
                                      const gchar* sender,
                                      gboolean force_refresh)
{
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	gint _tmp4_ = 0;
	gint force = 0;
	alpm_handle_t* _tmp5_;
	GCancellable* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = self->cancellable;
	g_cancellable_reset (_tmp1_);
	_tmp2_ = pamac_alpm_utils_get_handle (self, TRUE, FALSE, TRUE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp2_;
	_tmp3_ = self->alpm_handle;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	if (force_refresh) {
		_tmp4_ = 1;
	} else {
		_tmp4_ = 0;
	}
	force = _tmp4_;
	_tmp5_ = self->alpm_handle;
	pamac_alpm_utils_update_dbs (self, _tmp5_, force);
	_tmp6_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp6_)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
pamac_alpm_utils_trans_refresh_aur (PamacAlpmUtils* self,
                                    const gchar* sender,
                                    gboolean force_refresh)
{
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	AlpmConfig* _tmp2_;
	alpm_handle_t* _tmp3_;
	alpm_handle_t* _tmp4_;
	alpm_handle_t* _tmp5_;
	alpm_handle_t* _tmp6_;
	alpm_db_t* db = NULL;
	alpm_handle_t* _tmp7_;
	alpm_db_t* _tmp8_;
	const gchar* server = NULL;
	gchar* id = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	alpm_db_t* _tmp13_;
	const gchar* _tmp14_;
	alpm_db_t* _tmp15_;
	gint _tmp16_ = 0;
	gint force = 0;
	alpm_handle_t* _tmp17_;
	GCancellable* _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = self->cancellable;
	g_cancellable_reset (_tmp1_);
	_tmp2_ = self->alpm_config;
	_tmp3_ = alpm_config_get_handle (_tmp2_, FALSE, FALSE, FALSE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp3_;
	_tmp4_ = self->alpm_handle;
	if (_tmp4_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->alpm_handle;
	alpm_option_set_dbext (_tmp5_, ".json.gz");
	_tmp6_ = self->alpm_handle;
	alpm_option_set_dlcb (_tmp6_, _cb_download_alpm_cb_download, self);
	_tmp7_ = self->alpm_handle;
	_tmp8_ = alpm_register_syncdb (_tmp7_, "packages-meta-ext-v1", (gint) ALPM_SIG_USE_DEFAULT);
	db = _tmp8_;
	_tmp9_ = get_os_id ();
	id = _tmp9_;
	_tmp11_ = id;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = id;
		_tmp10_ = g_strcmp0 (_tmp12_, "manjaro") != 0;
	}
	if (_tmp10_) {
		server = "https://aur.archlinux.org";
	} else {
		server = "https://aur.manjaro.org";
	}
	_tmp13_ = db;
	_tmp14_ = server;
	alpm_db_add_server (_tmp13_, _tmp14_);
	_tmp15_ = db;
	alpm_db_set_usage (_tmp15_, (gint) ALPM_DB_USAGE_ALL);
	if (force_refresh) {
		_tmp16_ = 1;
	} else {
		_tmp16_ = 0;
	}
	force = _tmp16_;
	_tmp17_ = self->alpm_handle;
	pamac_alpm_utils_update_dbs (self, _tmp17_, force);
	_tmp18_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp18_)) {
		result = FALSE;
		_g_free0 (id);
		return result;
	}
	result = TRUE;
	_g_free0 (id);
	return result;
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pamac_alpm_utils_add_ignorepkgs (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _pkgname_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* pkgname = NULL;
		_tmp0_ = self->priv->ignorepkgs;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_pkgname_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_pkgname_it);
			pkgname = (const gchar*) _tmp2_;
			_tmp3_ = pkgname;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = pkgname;
			alpm_option_add_ignorepkg (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_remove_ignorepkgs (PamacAlpmUtils* self,
                                    alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _pkgname_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* pkgname = NULL;
		_tmp0_ = self->priv->ignorepkgs;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_pkgname_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_pkgname_it);
			pkgname = (const gchar*) _tmp2_;
			_tmp3_ = pkgname;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = pkgname;
			alpm_option_remove_ignorepkg (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_add_overwrite_files (PamacAlpmUtils* self,
                                      alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* name = NULL;
		_tmp0_ = self->priv->overwrite_files;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_name_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			alpm_option_add_overwrite_file (alpm_handle, _tmp4_);
		}
	}
}

static void
pamac_alpm_utils_remove_overwrite_files (PamacAlpmUtils* self,
                                         alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp0_;
		GHashTableIter _tmp1_ = {0};
		const gchar* name = NULL;
		_tmp0_ = self->priv->overwrite_files;
		g_hash_table_iter_init (&_tmp1_, _tmp0_);
		_name_it = _tmp1_;
		while (TRUE) {
			gconstpointer _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp2_;
			_tmp3_ = name;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = name;
			alpm_option_remove_overwrite_file (alpm_handle, _tmp4_);
		}
	}
}

static PamacAlpmPackage*
pamac_alpm_utils_initialise_pkg (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle,
                                 alpm_pkg_t* alpm_pkg)
{
	alpm_pkg_t* local_pkg = NULL;
	alpm_pkg_t* sync_pkg = NULL;
	alpm_pkgfrom_t _tmp0_;
	alpm_pkgfrom_t _tmp1_;
	alpm_pkg_t* _tmp17_;
	alpm_pkg_t* _tmp18_;
	PamacAlpmPackageStatic* _tmp19_;
	PamacAlpmPackage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = alpm_pkg_get_origin (alpm_pkg);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ALPM_PKG_FROM_LOCALDB) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		alpm_pkg_t* _tmp4_;
		local_pkg = alpm_pkg;
		_tmp2_ = alpm_pkg_get_name (alpm_pkg);
		_tmp3_ = _tmp2_;
		_tmp4_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp3_);
		sync_pkg = _tmp4_;
	} else {
		alpm_pkgfrom_t _tmp5_;
		alpm_pkgfrom_t _tmp6_;
		_tmp5_ = alpm_pkg_get_origin (alpm_pkg);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == ALPM_PKG_FROM_SYNCDB) {
			alpm_db_t* _tmp7_;
			alpm_db_t* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			alpm_pkg_t* _tmp11_;
			_tmp7_ = alpm_get_localdb (alpm_handle);
			_tmp8_ = _tmp7_;
			_tmp9_ = alpm_pkg_get_name (alpm_pkg);
			_tmp10_ = _tmp9_;
			_tmp11_ = alpm_db_get_pkg (_tmp8_, _tmp10_);
			local_pkg = _tmp11_;
			sync_pkg = alpm_pkg;
		} else {
			alpm_db_t* _tmp12_;
			alpm_db_t* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			_tmp12_ = alpm_get_localdb (alpm_handle);
			_tmp13_ = _tmp12_;
			_tmp14_ = alpm_pkg_get_name (alpm_pkg);
			_tmp15_ = _tmp14_;
			_tmp16_ = alpm_db_get_pkg (_tmp13_, _tmp15_);
			local_pkg = _tmp16_;
			sync_pkg = NULL;
		}
	}
	_tmp17_ = local_pkg;
	_tmp18_ = sync_pkg;
	_tmp19_ = pamac_alpm_package_static_new_transaction (alpm_pkg, _tmp17_, _tmp18_);
	result = (PamacAlpmPackage*) _tmp19_;
	return result;
}

gboolean
pamac_alpm_utils_download_updates (PamacAlpmUtils* self,
                                   const gchar* sender)
{
	gchar* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	PamacConfig* _tmp4_;
	guint64 _tmp5_;
	guint64 _tmp6_;
	alpm_handle_t* _tmp7_;
	GCancellable* _tmp8_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp9_;
	gboolean _tmp18_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	self->downloading_updates = TRUE;
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, TRUE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp1_;
	_tmp2_ = self->alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->alpm_handle;
	_tmp4_ = self->priv->config;
	_tmp5_ = pamac_config_get_max_parallel_downloads (_tmp4_);
	_tmp6_ = _tmp5_;
	alpm_option_set_parallel_downloads (_tmp3_, (guint) _tmp6_);
	_tmp7_ = self->alpm_handle;
	alpm_option_set_questioncb (_tmp7_, _cb_question_alpm_cb_question, self);
	_tmp8_ = self->cancellable;
	g_cancellable_reset (_tmp8_);
	success = FALSE;
	_tmp9_ = self->alpm_handle;
	if (alpm_trans_init (_tmp9_, (gint) ALPM_TRANS_FLAG_DOWNLOADONLY) == 0) {
		alpm_handle_t* _tmp10_;
		alpm_handle_t* _tmp17_;
		_tmp10_ = self->alpm_handle;
		if (alpm_sync_sysupgrade (_tmp10_, 0) == 0) {
			alpm_list_t* err_data = NULL;
			alpm_handle_t* _tmp11_;
			alpm_list_t* _tmp12_ = NULL;
			gint _tmp13_;
			_tmp11_ = self->alpm_handle;
			_tmp13_ = alpm_trans_prepare (_tmp11_, &_tmp12_);
			_alpm_list_free0 (err_data);
			err_data = _tmp12_;
			if (_tmp13_ == 0) {
				alpm_handle_t* _tmp14_;
				alpm_list_t* _tmp15_ = NULL;
				gint _tmp16_;
				_tmp14_ = self->alpm_handle;
				_tmp16_ = alpm_trans_commit (_tmp14_, &_tmp15_);
				_alpm_list_free0 (err_data);
				err_data = _tmp15_;
				if (_tmp16_ == 0) {
					success = TRUE;
				}
			}
			_alpm_list_free0 (err_data);
		}
		_tmp17_ = self->alpm_handle;
		alpm_trans_release (_tmp17_);
	}
	self->downloading_updates = FALSE;
	if (success) {
		PamacConfig* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->priv->config;
		_tmp20_ = pamac_config_get_offline_upgrade (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp18_ = _tmp21_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		{
			g_spawn_command_line_sync ("touch /system-update", NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp22_ = FALSE;
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp22_;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp23_;
			const gchar* _tmp24_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning ("alpm_utils.vala:484: %s", _tmp24_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp25_;
		}
	}
	result = success;
	return result;
}

static gboolean
pamac_alpm_utils_trans_init (PamacAlpmUtils* self,
                             alpm_handle_t* alpm_handle,
                             gint flags,
                             gboolean emit_error)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->cancellable;
	g_cancellable_reset (_tmp0_);
	if (alpm_trans_init (alpm_handle, (gint) ((alpm_transflag_t) flags)) == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp1_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp5_;
			_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp1_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp2_ = details;
				_tmp3_ = alpm_strerror (err_no);
				_tmp4_ = g_strdup (_tmp3_);
				g_ptr_array_add (_tmp2_, _tmp4_);
			}
			_tmp5_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to init transaction"), _tmp5_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_sysupgrade (PamacAlpmUtils* self,
                                   alpm_handle_t* alpm_handle,
                                   gboolean emit_error)
{
	gint _tmp0_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	pamac_alpm_utils_add_ignorepkgs (self, alpm_handle);
	if (self->priv->enable_downgrade) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	if (alpm_sync_sysupgrade (alpm_handle, _tmp0_) == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp1_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp5_;
			_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp1_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp2_ = details;
				_tmp3_ = alpm_strerror (err_no);
				_tmp4_ = g_strdup (_tmp3_);
				g_ptr_array_add (_tmp2_, _tmp4_);
			}
			_tmp5_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp5_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	}
	{
		GHashTableIter _name_it = {0};
		AlpmConfig* _tmp6_;
		GHashTable* _tmp7_;
		GHashTableIter _tmp8_ = {0};
		const gchar* name = NULL;
		_tmp6_ = self->alpm_config;
		_tmp7_ = _tmp6_->syncfirsts;
		g_hash_table_iter_init (&_tmp8_, _tmp7_);
		_name_it = _tmp8_;
		while (TRUE) {
			gconstpointer _tmp9_;
			const gchar* _tmp10_;
			alpm_pkg_t* pkg = NULL;
			alpm_db_t* _tmp11_;
			alpm_db_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			alpm_pkg_t* _tmp17_;
			_tmp9_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = alpm_get_localdb (alpm_handle);
			_tmp12_ = _tmp11_;
			_tmp13_ = alpm_db_get_pkgcache (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			_tmp16_ = alpm_find_satisfier (_tmp14_, _tmp15_);
			pkg = _tmp16_;
			_tmp17_ = pkg;
			if (_tmp17_ != NULL) {
				alpm_pkg_t* candidate = NULL;
				alpm_pkg_t* _tmp18_;
				alpm_list_t* _tmp19_;
				alpm_list_t* _tmp20_;
				alpm_pkg_t* _tmp21_;
				alpm_pkg_t* _tmp22_;
				_tmp18_ = pkg;
				_tmp19_ = alpm_get_syncdbs (alpm_handle);
				_tmp20_ = _tmp19_;
				_tmp21_ = alpm_sync_get_new_version (_tmp18_, _tmp20_);
				candidate = _tmp21_;
				_tmp22_ = candidate;
				if (_tmp22_ != NULL) {
					GHashTable* _tmp23_;
					alpm_pkg_t* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp23_ = self->priv->to_syncfirst;
					_tmp24_ = candidate;
					_tmp25_ = alpm_pkg_get_name (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strdup (_tmp26_);
					g_hash_table_add (_tmp23_, _tmp27_);
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_add_pkg_real (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle,
                                     alpm_pkg_t* pkg,
                                     gboolean emit_error)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (alpm_add_pkg (alpm_handle, pkg) == -1) {
		alpm_errno_t err_no = 0;
		err_no = alpm_errno (alpm_handle);
		if (err_no == ALPM_ERR_TRANS_DUP_TARGET) {
			result = TRUE;
			return result;
		} else {
			if (emit_error) {
				GPtrArray* details = NULL;
				GPtrArray* _tmp0_;
				GPtrArray* _tmp4_;
				_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				details = _tmp0_;
				if (err_no != 0) {
					GPtrArray* _tmp1_;
					const gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = details;
					_tmp2_ = alpm_strerror (err_no);
					_tmp3_ = g_strdup (_tmp2_);
					g_ptr_array_add (_tmp1_, _tmp3_);
				}
				_tmp4_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp4_);
				_g_ptr_array_unref0 (details);
			}
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_add_pkg (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle,
                                const gchar* pkgname,
                                gboolean emit_error)
{
	alpm_pkg_t* pkg = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	_tmp0_ = alpm_get_syncdbs (alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_find_dbs_satisfier (alpm_handle, _tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ == NULL) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp4_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp10_;
			_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp4_;
			err_no = alpm_errno (alpm_handle);
			if (err_no == ALPM_ERR_PKG_IGNORED) {
				GPtrArray* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp5_ = details;
				_tmp6_ = alpm_strerror (err_no);
				_tmp7_ = g_strdup (_tmp6_);
				g_ptr_array_add (_tmp5_, _tmp7_);
			} else {
				GPtrArray* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = details;
				_tmp9_ = g_strdup_printf (_ ("target not found: %s"), pkgname);
				g_ptr_array_add (_tmp8_, _tmp9_);
			}
			_tmp10_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp10_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	} else {
		gboolean success = FALSE;
		alpm_pkg_t* _tmp11_;
		_tmp11_ = pkg;
		success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp11_, emit_error);
		if (success) {
			gboolean _tmp12_ = FALSE;
			alpm_pkg_t* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = pkg;
			_tmp14_ = alpm_pkg_get_name (_tmp13_);
			_tmp15_ = _tmp14_;
			if (string_contains (_tmp15_, "linux5")) {
				_tmp12_ = TRUE;
			} else {
				alpm_pkg_t* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = pkg;
				_tmp17_ = alpm_pkg_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp12_ = string_contains (_tmp18_, "linux6");
			}
			if (_tmp12_) {
				GPtrArray* installed_kernels = NULL;
				GPtrArray* _tmp19_;
				GPtrArray* installed_modules = NULL;
				GPtrArray* _tmp20_;
				alpm_list_t* pkgcache = NULL;
				alpm_db_t* _tmp21_;
				alpm_db_t* _tmp22_;
				alpm_list_t* _tmp23_;
				alpm_list_t* _tmp24_;
				gchar** splitted = NULL;
				alpm_pkg_t* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				gchar** _tmp60_;
				gchar** _tmp61_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp62_;
				gint _tmp62__length1;
				_tmp19_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				installed_kernels = _tmp19_;
				_tmp20_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
				installed_modules = _tmp20_;
				_tmp21_ = alpm_get_localdb (alpm_handle);
				_tmp22_ = _tmp21_;
				_tmp23_ = alpm_db_get_pkgcache (_tmp22_);
				_tmp24_ = _tmp23_;
				pkgcache = _tmp24_;
				while (TRUE) {
					alpm_list_t* _tmp25_;
					alpm_pkg_t* local_pkg = NULL;
					alpm_list_t* _tmp26_;
					gconstpointer _tmp27_;
					gboolean _tmp28_ = FALSE;
					alpm_pkg_t* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp25_ = pkgcache;
					if (!(_tmp25_ != NULL)) {
						break;
					}
					_tmp26_ = pkgcache;
					_tmp27_ = _tmp26_->data;
					local_pkg = (alpm_pkg_t*) _tmp27_;
					_tmp29_ = local_pkg;
					_tmp30_ = alpm_pkg_get_name (_tmp29_);
					_tmp31_ = _tmp30_;
					if (string_contains (_tmp31_, "linux5")) {
						_tmp28_ = TRUE;
					} else {
						alpm_pkg_t* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp32_ = local_pkg;
						_tmp33_ = alpm_pkg_get_name (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp28_ = string_contains (_tmp34_, "linux6");
					}
					if (_tmp28_) {
						gchar** local_pkg_splitted = NULL;
						alpm_pkg_t* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gchar** _tmp38_;
						gchar** _tmp39_;
						gint local_pkg_splitted_length1;
						gint _local_pkg_splitted_size_;
						GPtrArray* _tmp40_;
						gchar** _tmp41_;
						gint _tmp41__length1;
						const gchar* _tmp42_;
						GEqualFunc _tmp43_;
						gchar** _tmp48_;
						gint _tmp48__length1;
						_tmp35_ = local_pkg;
						_tmp36_ = alpm_pkg_get_name (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "-", 2);
						local_pkg_splitted = _tmp39_;
						local_pkg_splitted_length1 = _vala_array_length (_tmp38_);
						_local_pkg_splitted_size_ = local_pkg_splitted_length1;
						_tmp40_ = installed_kernels;
						_tmp41_ = local_pkg_splitted;
						_tmp41__length1 = local_pkg_splitted_length1;
						_tmp42_ = _tmp41_[0];
						_tmp43_ = g_str_equal;
						if (!g_ptr_array_find_with_equal_func (_tmp40_, _tmp42_, _tmp43_, NULL)) {
							GPtrArray* _tmp44_;
							gchar** _tmp45_;
							gint _tmp45__length1;
							const gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp44_ = installed_kernels;
							_tmp45_ = local_pkg_splitted;
							_tmp45__length1 = local_pkg_splitted_length1;
							_tmp46_ = _tmp45_[0];
							_tmp47_ = g_strdup (_tmp46_);
							g_ptr_array_add (_tmp44_, _tmp47_);
						}
						_tmp48_ = local_pkg_splitted;
						_tmp48__length1 = local_pkg_splitted_length1;
						if (_tmp48__length1 == 2) {
							GPtrArray* _tmp49_;
							gchar** _tmp50_;
							gint _tmp50__length1;
							const gchar* _tmp51_;
							GEqualFunc _tmp52_;
							_tmp49_ = installed_modules;
							_tmp50_ = local_pkg_splitted;
							_tmp50__length1 = local_pkg_splitted_length1;
							_tmp51_ = _tmp50_[1];
							_tmp52_ = g_str_equal;
							if (!g_ptr_array_find_with_equal_func (_tmp49_, _tmp51_, _tmp52_, NULL)) {
								GPtrArray* _tmp53_;
								gchar** _tmp54_;
								gint _tmp54__length1;
								const gchar* _tmp55_;
								gchar* _tmp56_;
								_tmp53_ = installed_modules;
								_tmp54_ = local_pkg_splitted;
								_tmp54__length1 = local_pkg_splitted_length1;
								_tmp55_ = _tmp54_[1];
								_tmp56_ = g_strdup (_tmp55_);
								g_ptr_array_add (_tmp53_, _tmp56_);
							}
						}
						local_pkg_splitted = (_vala_array_free (local_pkg_splitted, local_pkg_splitted_length1, (GDestroyNotify) g_free), NULL);
					}
					pkgcache = alpm_list_next (pkgcache);
				}
				_tmp57_ = pkg;
				_tmp58_ = alpm_pkg_get_name (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp61_ = _tmp60_ = g_strsplit (_tmp59_, "-", 2);
				splitted = _tmp61_;
				splitted_length1 = _vala_array_length (_tmp60_);
				_splitted_size_ = splitted_length1;
				_tmp62_ = splitted;
				_tmp62__length1 = splitted_length1;
				if (_tmp62__length1 == 2) {
					GPtrArray* _tmp63_;
					_tmp63_ = installed_kernels;
					{
						GPtrArray* installed_kernel_collection = NULL;
						guint installed_kernel_index = 0U;
						installed_kernel_collection = _tmp63_;
						for (installed_kernel_index = 0; installed_kernel_index < installed_kernel_collection->len; installed_kernel_index = installed_kernel_index + 1) {
							const gchar* installed_kernel = NULL;
							installed_kernel = (const gchar*) g_ptr_array_index (installed_kernel_collection, installed_kernel_index);
							{
								GString* module = NULL;
								GString* _tmp64_;
								GString* _tmp65_;
								const gchar* _tmp66_;
								GString* _tmp67_;
								GString* _tmp68_;
								gchar** _tmp69_;
								gint _tmp69__length1;
								const gchar* _tmp70_;
								alpm_pkg_t* installed_module_pkg = NULL;
								alpm_db_t* _tmp71_;
								alpm_db_t* _tmp72_;
								GString* _tmp73_;
								const gchar* _tmp74_;
								alpm_pkg_t* _tmp75_;
								alpm_pkg_t* _tmp76_;
								_tmp64_ = g_string_new ("");
								module = _tmp64_;
								_tmp65_ = module;
								_tmp66_ = installed_kernel;
								g_string_append (_tmp65_, _tmp66_);
								_tmp67_ = module;
								g_string_append (_tmp67_, "-");
								_tmp68_ = module;
								_tmp69_ = splitted;
								_tmp69__length1 = splitted_length1;
								_tmp70_ = _tmp69_[1];
								g_string_append (_tmp68_, _tmp70_);
								_tmp71_ = alpm_get_localdb (alpm_handle);
								_tmp72_ = _tmp71_;
								_tmp73_ = module;
								_tmp74_ = _tmp73_->str;
								_tmp75_ = alpm_db_get_pkg (_tmp72_, _tmp74_);
								installed_module_pkg = _tmp75_;
								_tmp76_ = installed_module_pkg;
								if (_tmp76_ == NULL) {
									alpm_pkg_t* module_pkg = NULL;
									GString* _tmp77_;
									const gchar* _tmp78_;
									alpm_pkg_t* _tmp79_;
									alpm_pkg_t* _tmp80_;
									_tmp77_ = module;
									_tmp78_ = _tmp77_->str;
									_tmp79_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp78_);
									module_pkg = _tmp79_;
									_tmp80_ = module_pkg;
									if (_tmp80_ != NULL) {
										alpm_pkg_t* _tmp81_;
										_tmp81_ = module_pkg;
										pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp81_, emit_error);
									}
								}
								_g_string_free0 (module);
							}
						}
					}
				} else {
					gchar** _tmp82_;
					gint _tmp82__length1;
					_tmp82_ = splitted;
					_tmp82__length1 = splitted_length1;
					if (_tmp82__length1 == 1) {
						GPtrArray* _tmp83_;
						_tmp83_ = installed_modules;
						{
							GPtrArray* installed_module_collection = NULL;
							guint installed_module_index = 0U;
							installed_module_collection = _tmp83_;
							for (installed_module_index = 0; installed_module_index < installed_module_collection->len; installed_module_index = installed_module_index + 1) {
								const gchar* installed_module = NULL;
								installed_module = (const gchar*) g_ptr_array_index (installed_module_collection, installed_module_index);
								{
									GString* module = NULL;
									GString* _tmp84_;
									GString* _tmp85_;
									gchar** _tmp86_;
									gint _tmp86__length1;
									const gchar* _tmp87_;
									GString* _tmp88_;
									GString* _tmp89_;
									const gchar* _tmp90_;
									alpm_pkg_t* module_pkg = NULL;
									GString* _tmp91_;
									const gchar* _tmp92_;
									alpm_pkg_t* _tmp93_;
									alpm_pkg_t* _tmp94_;
									_tmp84_ = g_string_new ("");
									module = _tmp84_;
									_tmp85_ = module;
									_tmp86_ = splitted;
									_tmp86__length1 = splitted_length1;
									_tmp87_ = _tmp86_[0];
									g_string_append (_tmp85_, _tmp87_);
									_tmp88_ = module;
									g_string_append (_tmp88_, "-");
									_tmp89_ = module;
									_tmp90_ = installed_module;
									g_string_append (_tmp89_, _tmp90_);
									_tmp91_ = module;
									_tmp92_ = _tmp91_->str;
									_tmp93_ = pamac_alpm_utils_get_syncpkg (self, alpm_handle, _tmp92_);
									module_pkg = _tmp93_;
									_tmp94_ = module_pkg;
									if (_tmp94_ != NULL) {
										alpm_pkg_t* _tmp95_;
										_tmp95_ = module_pkg;
										pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp95_, emit_error);
									}
									_g_string_free0 (module);
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_ptr_array_unref0 (installed_modules);
				_g_ptr_array_unref0 (installed_kernels);
			}
		}
		result = success;
		return result;
	}
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gboolean
pamac_alpm_utils_download_pkgs (PamacAlpmUtils* self,
                                const gchar* sender,
                                gchar** urls,
                                gint urls_length1,
                                GPtrArray** dload_paths)
{
	gchar* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	PamacConfig* _tmp4_;
	guint64 _tmp5_;
	guint64 _tmp6_;
	alpm_list_t* urls_list = NULL;
	alpm_list_t* fetched = NULL;
	gint ret = 0;
	alpm_handle_t* _tmp9_;
	alpm_list_t* _tmp10_;
	alpm_list_t* _tmp11_ = NULL;
	gint _tmp12_;
	GCancellable* _tmp13_;
	alpm_list_t* cachedirs = NULL;
	alpm_handle_t* _tmp14_;
	alpm_list_t* _tmp15_;
	alpm_list_t* _tmp16_;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gint _tmp34_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (*dload_paths != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, TRUE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp1_;
	_tmp2_ = self->alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->alpm_handle;
	_tmp4_ = self->priv->config;
	_tmp5_ = pamac_config_get_max_parallel_downloads (_tmp4_);
	_tmp6_ = _tmp5_;
	alpm_option_set_parallel_downloads (_tmp3_, (guint) _tmp6_);
	urls_list = NULL;
	{
		gchar** url_collection = NULL;
		gint url_collection_length1 = 0;
		gint _url_collection_size_ = 0;
		gint url_it = 0;
		url_collection = urls;
		url_collection_length1 = urls_length1;
		for (url_it = 0; url_it < url_collection_length1; url_it = url_it + 1) {
			const gchar* url = NULL;
			url = url_collection[url_it];
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = url;
				_tmp8_ = g_strdup (_tmp7_);
				urls_list = alpm_list_add (urls_list, _tmp8_);
			}
		}
	}
	fetched = NULL;
	_tmp9_ = self->alpm_handle;
	_tmp10_ = urls_list;
	_tmp12_ = alpm_fetch_pkgurl (_tmp9_, _tmp10_, &_tmp11_);
	_alpm_list_free0 (fetched);
	fetched = _tmp11_;
	ret = _tmp12_;
	if (ret != 0) {
		result = FALSE;
		_alpm_list_free0 (fetched);
		_alpm_list_free0 (urls_list);
		return result;
	}
	_tmp13_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp13_)) {
		result = FALSE;
		_alpm_list_free0 (fetched);
		_alpm_list_free0 (urls_list);
		return result;
	}
	_tmp14_ = self->alpm_handle;
	_tmp15_ = alpm_option_get_cachedirs (_tmp14_);
	_tmp16_ = _tmp15_;
	cachedirs = _tmp16_;
	while (TRUE) {
		alpm_list_t* _tmp17_;
		const gchar* cachedir = NULL;
		alpm_list_t* _tmp18_;
		gconstpointer _tmp19_;
		_tmp17_ = cachedirs;
		if (!(_tmp17_ != NULL)) {
			break;
		}
		_tmp18_ = cachedirs;
		_tmp19_ = _tmp18_->data;
		cachedir = (const gchar*) _tmp19_;
		while (TRUE) {
			alpm_list_t* _tmp20_;
			const gchar* url = NULL;
			alpm_list_t* _tmp21_;
			gconstpointer _tmp22_;
			gchar* filename = NULL;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* dload_path = NULL;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			GFile* destfile = NULL;
			const gchar* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			_tmp20_ = fetched;
			if (!(_tmp20_ != NULL)) {
				break;
			}
			_tmp21_ = fetched;
			_tmp22_ = _tmp21_->data;
			url = (const gchar*) _tmp22_;
			_tmp23_ = url;
			_tmp24_ = g_path_get_basename (_tmp23_);
			filename = _tmp24_;
			_tmp25_ = cachedir;
			_tmp26_ = filename;
			_tmp27_ = g_build_filename (_tmp25_, _tmp26_, NULL);
			dload_path = _tmp27_;
			_tmp28_ = dload_path;
			_tmp29_ = g_file_new_for_path (_tmp28_);
			destfile = _tmp29_;
			_tmp30_ = destfile;
			if (g_file_query_exists (_tmp30_, NULL)) {
				gchar* _tmp31_;
				_tmp31_ = dload_path;
				dload_path = NULL;
				g_ptr_array_add (*dload_paths, _tmp31_);
			}
			fetched = alpm_list_next (fetched);
			_g_object_unref0 (destfile);
			_g_free0 (dload_path);
			_g_free0 (filename);
		}
		cachedirs = alpm_list_next (cachedirs);
	}
	_tmp33_ = vala_g_ptr_array_get_length (*dload_paths);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == 0) {
		GCancellable* _tmp35_;
		_tmp35_ = self->cancellable;
		_tmp32_ = !g_cancellable_is_cancelled (_tmp35_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp36_;
		GPtrArray* _tmp37_;
		gchar* _tmp38_;
		GPtrArray* _tmp39_;
		_tmp36_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp36_;
		_tmp37_ = details;
		_tmp38_ = g_strdup (_ ("failed to retrieve some files"));
		g_ptr_array_add (_tmp37_, _tmp38_);
		_tmp39_ = details;
		pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp39_);
		result = FALSE;
		_g_ptr_array_unref0 (details);
		_alpm_list_free0 (fetched);
		_alpm_list_free0 (urls_list);
		return result;
	}
	result = TRUE;
	_alpm_list_free0 (fetched);
	_alpm_list_free0 (urls_list);
	return result;
}

static gboolean
pamac_alpm_utils_trans_load_pkg (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle,
                                 const gchar* path,
                                 gint siglevel,
                                 gboolean emit_error)
{
	alpm_pkg_t* pkg = NULL;
	alpm_pkg_t* _tmp0_ = NULL;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = alpm_pkg_load (alpm_handle, path, 1, siglevel, &_tmp0_);
	pkg = _tmp0_;
	if (_tmp1_ == -1) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp2_;
			alpm_errno_t err_no = 0;
			GPtrArray* _tmp6_;
			_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp2_;
			err_no = alpm_errno (alpm_handle);
			if (err_no != 0) {
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp3_ = details;
				_tmp4_ = alpm_strerror (err_no);
				_tmp5_ = g_strdup (_tmp4_);
				g_ptr_array_add (_tmp3_, _tmp5_);
			}
			_tmp6_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp6_);
			_g_ptr_array_unref0 (details);
		}
		result = FALSE;
		return result;
	} else {
		alpm_pkg_t* _tmp7_;
		_tmp7_ = pkg;
		if (alpm_add_pkg (alpm_handle, _tmp7_) == -1) {
			alpm_errno_t err_no = 0;
			err_no = alpm_errno (alpm_handle);
			if (err_no == ALPM_ERR_TRANS_DUP_TARGET) {
				result = TRUE;
				return result;
			} else {
				alpm_pkg_t* _tmp16_;
				if (emit_error) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp8_;
					GPtrArray* _tmp15_;
					_tmp8_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
					details = _tmp8_;
					if (err_no != 0) {
						GPtrArray* _tmp9_;
						alpm_pkg_t* _tmp10_;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp9_ = details;
						_tmp10_ = pkg;
						_tmp11_ = alpm_pkg_get_name (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = alpm_strerror (err_no);
						_tmp14_ = g_strdup_printf ("%s: %s", _tmp12_, _tmp13_);
						g_ptr_array_add (_tmp9_, _tmp14_);
					}
					_tmp15_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp15_);
					_g_ptr_array_unref0 (details);
				}
				_tmp16_ = pkg;
				_alpm_pkg_free0 (_tmp16_);
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pamac_alpm_utils_trans_remove_pkg (PamacAlpmUtils* self,
                                   alpm_handle_t* alpm_handle,
                                   const gchar* pkgname,
                                   gboolean emit_error)
{
	gboolean success = FALSE;
	alpm_pkg_t* pkg = NULL;
	alpm_db_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkgname != NULL, FALSE);
	success = TRUE;
	_tmp0_ = alpm_get_localdb (alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_db_get_pkg (_tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ == NULL) {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			gchar* _tmp6_;
			GPtrArray* _tmp7_;
			_tmp4_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
			details = _tmp4_;
			_tmp5_ = details;
			_tmp6_ = g_strdup_printf (_ ("target not found: %s"), pkgname);
			g_ptr_array_add (_tmp5_, _tmp6_);
			_tmp7_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp7_);
			_g_ptr_array_unref0 (details);
		}
		success = FALSE;
	} else {
		alpm_pkg_t* _tmp8_;
		_tmp8_ = pkg;
		if (alpm_remove_pkg (alpm_handle, _tmp8_) == -1) {
			alpm_errno_t err_no = 0;
			err_no = alpm_errno (alpm_handle);
			if (err_no != ALPM_ERR_TRANS_DUP_TARGET) {
				if (emit_error) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp9_;
					GPtrArray* _tmp16_;
					_tmp9_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
					details = _tmp9_;
					if (err_no != 0) {
						GPtrArray* _tmp10_;
						alpm_pkg_t* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp10_ = details;
						_tmp11_ = pkg;
						_tmp12_ = alpm_pkg_get_name (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = alpm_strerror (err_no);
						_tmp15_ = g_strdup_printf ("%s: %s", _tmp13_, _tmp14_);
						g_ptr_array_add (_tmp10_, _tmp15_);
					}
					_tmp16_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp16_);
					_g_ptr_array_unref0 (details);
				}
				success = FALSE;
			}
		}
	}
	result = success;
	return result;
}

static gboolean
pamac_alpm_utils_trans_prepare_real (PamacAlpmUtils* self,
                                     alpm_handle_t* alpm_handle,
                                     gboolean emit_error)
{
	gboolean success = FALSE;
	gboolean need_retry = FALSE;
	alpm_list_t* err_data = NULL;
	alpm_list_t* _tmp0_ = NULL;
	gint _tmp1_;
	GCancellable* _tmp157_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	need_retry = FALSE;
	_tmp1_ = alpm_trans_prepare (alpm_handle, &_tmp0_);
	_alpm_list_free0 (err_data);
	err_data = _tmp0_;
	if (_tmp1_ == -1) {
		GPtrArray* details = NULL;
		GPtrArray* _tmp2_;
		alpm_errno_t err_no = 0;
		gboolean _tmp136_ = FALSE;
		_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp2_;
		err_no = alpm_errno (alpm_handle);
		switch (err_no) {
			case 0:
			{
				break;
			}
			case ALPM_ERR_PKG_INVALID_ARCH:
			{
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp6_;
				_tmp3_ = details;
				_tmp4_ = alpm_strerror (err_no);
				_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
				g_ptr_array_add (_tmp3_, _tmp5_);
				_tmp6_ = err_data;
				list = _tmp6_;
				while (TRUE) {
					alpm_list_t* _tmp7_;
					const gchar* pkgname = NULL;
					alpm_list_t* _tmp8_;
					gconstpointer _tmp9_;
					GPtrArray* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp7_ = list;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = list;
					_tmp9_ = _tmp8_->data;
					pkgname = _tmp9_;
					_tmp10_ = details;
					_tmp11_ = pkgname;
					_tmp12_ = g_strdup_printf (_ ("package %s does not have a valid architecture"), _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat ("- ", _tmp13_, NULL);
					g_ptr_array_add (_tmp10_, _tmp14_);
					_g_free0 (_tmp13_);
					_tmp15_ = pkgname;
					_g_free0 (_tmp15_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_UNSATISFIED_DEPS:
			{
				GPtrArray* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp19_;
				GHashTable* depstrings = NULL;
				GHashFunc _tmp20_;
				GEqualFunc _tmp21_;
				GHashTable* _tmp22_;
				_tmp16_ = details;
				_tmp17_ = alpm_strerror (err_no);
				_tmp18_ = g_strconcat (_tmp17_, ":", NULL);
				g_ptr_array_add (_tmp16_, _tmp18_);
				_tmp19_ = err_data;
				list = _tmp19_;
				_tmp20_ = g_str_hash;
				_tmp21_ = g_str_equal;
				_tmp22_ = g_hash_table_new_full (_tmp20_, _tmp21_, NULL, _g_free0_);
				depstrings = _tmp22_;
				while (TRUE) {
					alpm_list_t* _tmp23_;
					alpm_depmissing_t* miss = NULL;
					alpm_list_t* _tmp24_;
					gconstpointer _tmp25_;
					gchar* depstring = NULL;
					alpm_depmissing_t* _tmp26_;
					alpm_depend_t* _tmp27_;
					gchar* _tmp28_;
					GHashTable* _tmp29_;
					const gchar* _tmp30_;
					alpm_list_t* trans_add = NULL;
					alpm_list_t* _tmp32_;
					alpm_pkg_t* pkg = NULL;
					alpm_depmissing_t* _tmp33_;
					const gchar* _tmp34_;
					GHashTable* _tmp98_;
					gchar* _tmp99_;
					alpm_depmissing_t* _tmp100_;
					_tmp23_ = list;
					if (!(_tmp23_ != NULL)) {
						break;
					}
					_tmp24_ = list;
					_tmp25_ = _tmp24_->data;
					miss = _tmp25_;
					_tmp26_ = miss;
					_tmp27_ = _tmp26_->depend;
					_tmp28_ = alpm_dep_compute_string (_tmp27_);
					depstring = _tmp28_;
					_tmp29_ = depstrings;
					_tmp30_ = depstring;
					if (g_hash_table_contains (_tmp29_, _tmp30_)) {
						alpm_depmissing_t* _tmp31_;
						_tmp31_ = miss;
						_alpm_depmissing_free0 (_tmp31_);
						list = alpm_list_next (list);
						_g_free0 (depstring);
						continue;
					}
					_tmp32_ = alpm_trans_get_add (alpm_handle);
					trans_add = _tmp32_;
					_tmp33_ = miss;
					_tmp34_ = _tmp33_->causingpkg;
					if (_tmp34_ == NULL) {
						GPtrArray* _tmp35_;
						const gchar* _tmp36_;
						alpm_depmissing_t* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp35_ = details;
						_tmp36_ = depstring;
						_tmp37_ = miss;
						_tmp38_ = _tmp37_->target;
						_tmp39_ = g_strdup_printf (_ ("unable to satisfy dependency '%1$s' required by %2$s"), _tmp36_, _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strconcat ("- ", _tmp40_, NULL);
						g_ptr_array_add (_tmp35_, _tmp41_);
						_g_free0 (_tmp40_);
					} else {
						alpm_list_t* _tmp42_;
						alpm_depmissing_t* _tmp43_;
						const gchar* _tmp44_;
						alpm_pkg_t* _tmp45_;
						alpm_pkg_t* _tmp46_;
						_tmp42_ = trans_add;
						_tmp43_ = miss;
						_tmp44_ = _tmp43_->causingpkg;
						_tmp45_ = alpm_pkg_find (_tmp42_, _tmp44_);
						pkg = _tmp45_;
						_tmp46_ = pkg;
						if (_tmp46_ != NULL) {
							if (((gint) self->priv->commit_retries) < 1) {
								gchar* _tmp47_;
								gchar* _tmp48_;
								alpm_depmissing_t* _tmp49_;
								const gchar* _tmp50_;
								alpm_pkg_t* _tmp51_;
								const gchar* _tmp52_;
								const gchar* _tmp53_;
								const gchar* _tmp54_;
								alpm_depmissing_t* _tmp55_;
								const gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								alpm_depmissing_t* _tmp61_;
								const gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								GHashTable* _tmp65_;
								alpm_depmissing_t* _tmp66_;
								const gchar* _tmp67_;
								gchar* _tmp68_;
								alpm_depmissing_t* _tmp69_;
								const gchar* _tmp70_;
								_tmp47_ = g_strconcat (_ ("Warning"), ": ", NULL);
								_tmp48_ = _tmp47_;
								_tmp49_ = miss;
								_tmp50_ = _tmp49_->causingpkg;
								_tmp51_ = pkg;
								_tmp52_ = alpm_pkg_get_version (_tmp51_);
								_tmp53_ = _tmp52_;
								_tmp54_ = depstring;
								_tmp55_ = miss;
								_tmp56_ = _tmp55_->target;
								_tmp57_ = g_strdup_printf (_ ("installing %1$s (%2$s) breaks dependency '%3$s' required by %4$s"), _tmp50_, _tmp53_, _tmp54_, _tmp56_);
								_tmp58_ = _tmp57_;
								_tmp59_ = g_strconcat (_tmp48_, _tmp58_, NULL);
								_tmp60_ = _tmp59_;
								pamac_alpm_utils_do_emit_warning (self, _tmp60_);
								_g_free0 (_tmp60_);
								_g_free0 (_tmp58_);
								_g_free0 (_tmp48_);
								_tmp61_ = miss;
								_tmp62_ = _tmp61_->target;
								_tmp63_ = g_strdup_printf (_ ("Add %s to remove"), _tmp62_);
								_tmp64_ = _tmp63_;
								pamac_alpm_utils_do_emit_warning (self, _tmp64_);
								_g_free0 (_tmp64_);
								_tmp65_ = self->priv->required_to_remove;
								_tmp66_ = miss;
								_tmp67_ = _tmp66_->target;
								_tmp68_ = g_strdup (_tmp67_);
								g_hash_table_add (_tmp65_, _tmp68_);
								_tmp69_ = miss;
								_tmp70_ = _tmp69_->target;
								if (pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp70_, TRUE)) {
									need_retry = TRUE;
								}
							} else {
								GPtrArray* _tmp71_;
								alpm_depmissing_t* _tmp72_;
								const gchar* _tmp73_;
								alpm_pkg_t* _tmp74_;
								const gchar* _tmp75_;
								const gchar* _tmp76_;
								const gchar* _tmp77_;
								alpm_depmissing_t* _tmp78_;
								const gchar* _tmp79_;
								gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp82_;
								GPtrArray* _tmp83_;
								alpm_depmissing_t* _tmp84_;
								const gchar* _tmp85_;
								gchar* _tmp86_;
								gchar* _tmp87_;
								gchar* _tmp88_;
								_tmp71_ = details;
								_tmp72_ = miss;
								_tmp73_ = _tmp72_->causingpkg;
								_tmp74_ = pkg;
								_tmp75_ = alpm_pkg_get_version (_tmp74_);
								_tmp76_ = _tmp75_;
								_tmp77_ = depstring;
								_tmp78_ = miss;
								_tmp79_ = _tmp78_->target;
								_tmp80_ = g_strdup_printf (_ ("installing %1$s (%2$s) breaks dependency '%3$s' required by %4$s"), _tmp73_, _tmp76_, _tmp77_, _tmp79_);
								_tmp81_ = _tmp80_;
								_tmp82_ = g_strconcat ("- ", _tmp81_, NULL);
								g_ptr_array_add (_tmp71_, _tmp82_);
								_g_free0 (_tmp81_);
								_tmp83_ = details;
								_tmp84_ = miss;
								_tmp85_ = _tmp84_->target;
								_tmp86_ = g_strdup_printf (_ ("if possible, remove %s and retry"), _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = g_strconcat ("- ", _tmp87_, NULL);
								g_ptr_array_add (_tmp83_, _tmp88_);
								_g_free0 (_tmp87_);
							}
						} else {
							GPtrArray* _tmp89_;
							alpm_depmissing_t* _tmp90_;
							const gchar* _tmp91_;
							const gchar* _tmp92_;
							alpm_depmissing_t* _tmp93_;
							const gchar* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							_tmp89_ = details;
							_tmp90_ = miss;
							_tmp91_ = _tmp90_->causingpkg;
							_tmp92_ = depstring;
							_tmp93_ = miss;
							_tmp94_ = _tmp93_->target;
							_tmp95_ = g_strdup_printf (_ ("removing %1$s breaks dependency '%2$s' required by %3$s"), _tmp91_, _tmp92_, _tmp94_);
							_tmp96_ = _tmp95_;
							_tmp97_ = g_strconcat ("- ", _tmp96_, NULL);
							g_ptr_array_add (_tmp89_, _tmp97_);
							_g_free0 (_tmp96_);
						}
					}
					_tmp98_ = depstrings;
					_tmp99_ = depstring;
					depstring = NULL;
					g_hash_table_add (_tmp98_, _tmp99_);
					_tmp100_ = miss;
					_alpm_depmissing_free0 (_tmp100_);
					list = alpm_list_next (list);
					_g_free0 (depstring);
				}
				_g_hash_table_unref0 (depstrings);
				break;
			}
			case ALPM_ERR_CONFLICTING_DEPS:
			{
				GPtrArray* _tmp101_;
				const gchar* _tmp102_;
				gchar* _tmp103_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp104_;
				_tmp101_ = details;
				_tmp102_ = alpm_strerror (err_no);
				_tmp103_ = g_strconcat (_tmp102_, ":", NULL);
				g_ptr_array_add (_tmp101_, _tmp103_);
				_tmp104_ = err_data;
				list = _tmp104_;
				while (TRUE) {
					alpm_list_t* _tmp105_;
					alpm_conflict_t* conflict = NULL;
					alpm_list_t* _tmp106_;
					gconstpointer _tmp107_;
					gchar* conflict_detail = NULL;
					alpm_conflict_t* _tmp108_;
					alpm_pkg_t* _tmp109_;
					const gchar* _tmp110_;
					const gchar* _tmp111_;
					alpm_conflict_t* _tmp112_;
					alpm_pkg_t* _tmp113_;
					const gchar* _tmp114_;
					const gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					alpm_conflict_t* _tmp120_;
					alpm_depend_t* _tmp121_;
					GPtrArray* _tmp130_;
					gchar* _tmp131_;
					alpm_conflict_t* _tmp132_;
					_tmp105_ = list;
					if (!(_tmp105_ != NULL)) {
						break;
					}
					_tmp106_ = list;
					_tmp107_ = _tmp106_->data;
					conflict = _tmp107_;
					_tmp108_ = conflict;
					_tmp109_ = _tmp108_->package1;
					_tmp110_ = alpm_pkg_get_name (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = conflict;
					_tmp113_ = _tmp112_->package2;
					_tmp114_ = alpm_pkg_get_name (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = g_strdup_printf (_ ("%1$s and %2$s are in conflict"), _tmp111_, _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = g_strconcat ("- ", _tmp117_, NULL);
					_tmp119_ = _tmp118_;
					_g_free0 (_tmp117_);
					conflict_detail = _tmp119_;
					_tmp120_ = conflict;
					_tmp121_ = _tmp120_->reason;
					if (_tmp121_->mod != ALPM_DEP_MOD_ANY) {
						const gchar* _tmp122_;
						alpm_conflict_t* _tmp123_;
						alpm_depend_t* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						gchar* _tmp129_;
						_tmp122_ = conflict_detail;
						_tmp123_ = conflict;
						_tmp124_ = _tmp123_->reason;
						_tmp125_ = alpm_dep_compute_string (_tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = g_strdup_printf (" (%s)", _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = g_strconcat (_tmp122_, _tmp128_, NULL);
						_g_free0 (conflict_detail);
						conflict_detail = _tmp129_;
						_g_free0 (_tmp128_);
						_g_free0 (_tmp126_);
					}
					_tmp130_ = details;
					_tmp131_ = conflict_detail;
					conflict_detail = NULL;
					g_ptr_array_add (_tmp130_, _tmp131_);
					_tmp132_ = conflict;
					_alpm_conflict_free0 (_tmp132_);
					list = alpm_list_next (list);
					_g_free0 (conflict_detail);
				}
				break;
			}
			default:
			{
				GPtrArray* _tmp133_;
				const gchar* _tmp134_;
				gchar* _tmp135_;
				_tmp133_ = details;
				_tmp134_ = alpm_strerror (err_no);
				_tmp135_ = g_strdup (_tmp134_);
				g_ptr_array_add (_tmp133_, _tmp135_);
				break;
			}
		}
		if (need_retry) {
			_tmp136_ = ((gint) self->priv->commit_retries) < 1;
		} else {
			_tmp136_ = FALSE;
		}
		if (_tmp136_) {
			guint8 _tmp137_;
			_tmp137_ = self->priv->commit_retries;
			self->priv->commit_retries = _tmp137_ + 1;
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, TRUE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
			if (emit_error) {
				GPtrArray* _tmp138_;
				_tmp138_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp138_);
			}
			success = FALSE;
		}
		_g_ptr_array_unref0 (details);
	} else {
		if (emit_error) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp139_;
			gboolean found_locked_pkg = FALSE;
			alpm_list_t* to_remove = NULL;
			alpm_list_t* _tmp140_;
			_tmp139_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			details = _tmp139_;
			found_locked_pkg = FALSE;
			_tmp140_ = alpm_trans_get_remove (alpm_handle);
			to_remove = _tmp140_;
			while (TRUE) {
				alpm_list_t* _tmp141_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp142_;
				gconstpointer _tmp143_;
				AlpmConfig* _tmp144_;
				GHashTable* _tmp145_;
				alpm_pkg_t* _tmp146_;
				const gchar* _tmp147_;
				const gchar* _tmp148_;
				_tmp141_ = to_remove;
				if (!(_tmp141_ != NULL)) {
					break;
				}
				_tmp142_ = to_remove;
				_tmp143_ = _tmp142_->data;
				pkg = (alpm_pkg_t*) _tmp143_;
				_tmp144_ = self->alpm_config;
				_tmp145_ = _tmp144_->holdpkgs;
				_tmp146_ = pkg;
				_tmp147_ = alpm_pkg_get_name (_tmp146_);
				_tmp148_ = _tmp147_;
				if (g_hash_table_contains (_tmp145_, _tmp148_)) {
					GPtrArray* _tmp149_;
					alpm_pkg_t* _tmp150_;
					const gchar* _tmp151_;
					const gchar* _tmp152_;
					gchar* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					_tmp149_ = details;
					_tmp150_ = pkg;
					_tmp151_ = alpm_pkg_get_name (_tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = g_strdup_printf (_ ("%s needs to be removed but it is a locked package"), _tmp152_);
					_tmp154_ = _tmp153_;
					_tmp155_ = g_strconcat ("- ", _tmp154_, NULL);
					g_ptr_array_add (_tmp149_, _tmp155_);
					_g_free0 (_tmp154_);
					found_locked_pkg = TRUE;
				}
				to_remove = alpm_list_next (to_remove);
			}
			if (found_locked_pkg) {
				GPtrArray* _tmp156_;
				_tmp156_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp156_);
				pamac_alpm_utils_trans_release (self, alpm_handle);
				success = FALSE;
			}
			_g_ptr_array_unref0 (details);
		}
	}
	_tmp157_ = self->cancellable;
	if (g_cancellable_is_cancelled (_tmp157_)) {
		pamac_alpm_utils_trans_release (self, alpm_handle);
		result = FALSE;
		_alpm_list_free0 (err_data);
		return result;
	}
	result = success;
	_alpm_list_free0 (err_data);
	return result;
}

static void
pamac_alpm_utils_prepare_aur_db (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	gchar* devel_pkgname = NULL;
	gchar* _tmp20_;
	alpm_db_t* _tmp21_;
	alpm_db_t* _tmp22_;
	alpm_list_t* _tmp23_;
	alpm_list_t* _tmp24_;
	const gchar* _tmp25_;
	alpm_pkg_t* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->tmp_path;
		_tmp1_ = alpm_option_get_dbpath (alpm_handle);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("cp %s/pamac_aur.db %ssync", _tmp0_, _tmp2_);
		_tmp4_ = _tmp3_;
		g_spawn_command_line_sync (_tmp4_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		pamac_alpm_utils_do_emit_warning (self, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp7_;
		GHashTableIter _tmp8_ = {0};
		const gchar* name = NULL;
		_tmp7_ = self->priv->to_build;
		g_hash_table_iter_init (&_tmp8_, _tmp7_);
		_name_it = _tmp8_;
		while (TRUE) {
			gconstpointer _tmp9_;
			const gchar* _tmp10_;
			gchar* debug_pkg_name = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			alpm_db_t* _tmp13_;
			alpm_db_t* _tmp14_;
			const gchar* _tmp15_;
			alpm_pkg_t* _tmp16_;
			_tmp9_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = name;
			_tmp12_ = g_strdup_printf ("%s-debug", _tmp11_);
			debug_pkg_name = _tmp12_;
			_tmp13_ = alpm_get_localdb (alpm_handle);
			_tmp14_ = _tmp13_;
			_tmp15_ = debug_pkg_name;
			_tmp16_ = alpm_db_get_pkg (_tmp14_, _tmp15_);
			if (_tmp16_ != NULL) {
				GHashTable* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = self->priv->to_remove;
				_tmp18_ = debug_pkg_name;
				_tmp19_ = g_strdup (_tmp18_);
				g_hash_table_add (_tmp17_, _tmp19_);
			}
			_g_free0 (debug_pkg_name);
		}
	}
	_tmp20_ = g_strdup ("base-devel");
	devel_pkgname = _tmp20_;
	_tmp21_ = alpm_get_localdb (alpm_handle);
	_tmp22_ = _tmp21_;
	_tmp23_ = alpm_db_get_pkgcache (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = devel_pkgname;
	_tmp26_ = alpm_find_satisfier (_tmp24_, _tmp25_);
	if (_tmp26_ == NULL) {
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp27_;
		alpm_list_t* _tmp28_;
		const gchar* _tmp29_;
		alpm_pkg_t* _tmp30_;
		alpm_pkg_t* _tmp31_;
		_tmp27_ = alpm_get_syncdbs (alpm_handle);
		_tmp28_ = _tmp27_;
		_tmp29_ = devel_pkgname;
		_tmp30_ = alpm_find_dbs_satisfier (alpm_handle, _tmp28_, _tmp29_);
		pkg = _tmp30_;
		_tmp31_ = pkg;
		if (_tmp31_ != NULL) {
			GHashTable* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp32_ = self->priv->to_install;
			_tmp33_ = devel_pkgname;
			_tmp34_ = g_strdup (_tmp33_);
			g_hash_table_add (_tmp32_, _tmp34_);
		}
	} else {
		GHashTable* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = self->priv->to_remove;
		_tmp36_ = devel_pkgname;
		g_hash_table_remove (_tmp35_, _tmp36_);
	}
	_g_free0 (devel_pkgname);
}

static void
pamac_alpm_utils_remove_aur_db (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = alpm_option_get_dbpath (alpm_handle);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("rm -f %ssync/pamac_aur.db", _tmp1_);
		_tmp3_ = _tmp2_;
		g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("alpm_utils.vala:891: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
pamac_alpm_utils_trans_check_prepare (PamacAlpmUtils* self,
                                      gboolean sysupgrade,
                                      gboolean enable_downgrade,
                                      gboolean simple_install,
                                      gint trans_flags,
                                      GHashTable* to_install,
                                      GHashTable* to_remove,
                                      GHashTable* local_paths,
                                      GHashTable* remote_paths,
                                      GHashTable* to_build,
                                      GHashTable* ignorepkgs,
                                      GHashTable* overwrite_files,
                                      PamacTransactionSummary** summary)
{
	alpm_handle_t* tmp_handle = NULL;
	alpm_handle_t* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	gchar* _tmp3_;
	alpm_db_t* aur_db = NULL;
	guint _tmp46_;
	guint _tmp47_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	guint _tmp53_;
	guint _tmp54_;
	alpm_handle_t* _tmp77_;
	alpm_handle_t* _tmp78_;
	alpm_handle_t* _tmp79_;
	gboolean success = FALSE;
	alpm_handle_t* _tmp80_;
	alpm_db_t* _tmp81_;
	alpm_db_t* _tmp84_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (to_install != NULL, FALSE);
	g_return_val_if_fail (to_remove != NULL, FALSE);
	g_return_val_if_fail (local_paths != NULL, FALSE);
	g_return_val_if_fail (remote_paths != NULL, FALSE);
	g_return_val_if_fail (to_build != NULL, FALSE);
	g_return_val_if_fail (ignorepkgs != NULL, FALSE);
	g_return_val_if_fail (overwrite_files != NULL, FALSE);
	g_return_val_if_fail (*summary != NULL, FALSE);
	_tmp0_ = pamac_alpm_utils_get_handle (self, FALSE, TRUE, FALSE);
	tmp_handle = _tmp0_;
	_tmp1_ = tmp_handle;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_alpm_release0 (tmp_handle);
		return result;
	}
	_tmp2_ = tmp_handle;
	alpm_option_set_questioncb (_tmp2_, _cb_question_alpm_cb_question, self);
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp3_;
	self->priv->sysupgrade = sysupgrade;
	self->priv->enable_downgrade = enable_downgrade;
	self->priv->simple_install = simple_install;
	self->priv->trans_flags = trans_flags | ALPM_TRANS_FLAG_NOLOCK;
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp4_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp4_, to_install);
		_name_it = _tmp4_;
		while (TRUE) {
			gconstpointer _tmp5_;
			const gchar* _tmp6_;
			GHashTable* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp5_;
			_tmp6_ = name;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = self->priv->to_install;
			_tmp8_ = name;
			_tmp9_ = g_strdup (_tmp8_);
			g_hash_table_add (_tmp7_, _tmp9_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp10_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp10_, to_remove);
		_name_it = _tmp10_;
		while (TRUE) {
			gconstpointer _tmp11_;
			const gchar* _tmp12_;
			GHashTable* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp11_;
			_tmp12_ = name;
			if (!(_tmp12_ != NULL)) {
				break;
			}
			_tmp13_ = self->priv->to_remove;
			_tmp14_ = name;
			_tmp15_ = g_strdup (_tmp14_);
			g_hash_table_add (_tmp13_, _tmp15_);
		}
	}
	{
		GHashTableIter _path_it = {0};
		GHashTableIter _tmp16_ = {0};
		const gchar* path = NULL;
		g_hash_table_iter_init (&_tmp16_, local_paths);
		_path_it = _tmp16_;
		while (TRUE) {
			gconstpointer _tmp17_;
			const gchar* _tmp18_;
			GHashTable* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = _vala_hash_set_next_value (&_path_it);
			path = (const gchar*) _tmp17_;
			_tmp18_ = path;
			if (!(_tmp18_ != NULL)) {
				break;
			}
			_tmp19_ = self->priv->local_paths;
			_tmp20_ = path;
			_tmp21_ = g_strdup (_tmp20_);
			g_hash_table_add (_tmp19_, _tmp21_);
		}
	}
	{
		GHashTableIter _path_it = {0};
		GHashTableIter _tmp22_ = {0};
		const gchar* path = NULL;
		g_hash_table_iter_init (&_tmp22_, remote_paths);
		_path_it = _tmp22_;
		while (TRUE) {
			gconstpointer _tmp23_;
			const gchar* _tmp24_;
			GHashTable* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp23_ = _vala_hash_set_next_value (&_path_it);
			path = (const gchar*) _tmp23_;
			_tmp24_ = path;
			if (!(_tmp24_ != NULL)) {
				break;
			}
			_tmp25_ = self->priv->remote_paths;
			_tmp26_ = path;
			_tmp27_ = g_strdup (_tmp26_);
			g_hash_table_add (_tmp25_, _tmp27_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp28_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp28_, to_build);
		_name_it = _tmp28_;
		while (TRUE) {
			gconstpointer _tmp29_;
			const gchar* _tmp30_;
			GHashTable* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp29_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp29_;
			_tmp30_ = name;
			if (!(_tmp30_ != NULL)) {
				break;
			}
			_tmp31_ = self->priv->to_build;
			_tmp32_ = name;
			_tmp33_ = g_strdup (_tmp32_);
			g_hash_table_add (_tmp31_, _tmp33_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp34_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp34_, ignorepkgs);
		_name_it = _tmp34_;
		while (TRUE) {
			gconstpointer _tmp35_;
			const gchar* _tmp36_;
			GHashTable* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp35_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp35_;
			_tmp36_ = name;
			if (!(_tmp36_ != NULL)) {
				break;
			}
			_tmp37_ = self->priv->ignorepkgs;
			_tmp38_ = name;
			_tmp39_ = g_strdup (_tmp38_);
			g_hash_table_add (_tmp37_, _tmp39_);
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTableIter _tmp40_ = {0};
		const gchar* name = NULL;
		g_hash_table_iter_init (&_tmp40_, overwrite_files);
		_name_it = _tmp40_;
		while (TRUE) {
			gconstpointer _tmp41_;
			const gchar* _tmp42_;
			GHashTable* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp41_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp41_;
			_tmp42_ = name;
			if (!(_tmp42_ != NULL)) {
				break;
			}
			_tmp43_ = self->priv->overwrite_files;
			_tmp44_ = name;
			_tmp45_ = g_strdup (_tmp44_);
			g_hash_table_add (_tmp43_, _tmp45_);
		}
	}
	aur_db = NULL;
	_tmp46_ = g_hash_table_size (to_remove);
	_tmp47_ = _tmp46_;
	if (_tmp47_ > ((guint) 0)) {
		alpm_handle_t* _tmp48_;
		_tmp48_ = tmp_handle;
		pamac_alpm_utils_intern_compute_pkgs_to_remove (self, _tmp48_);
	}
	_tmp53_ = g_hash_table_size (to_install);
	_tmp54_ = _tmp53_;
	if (_tmp54_ > ((guint) 0)) {
		_tmp52_ = TRUE;
	} else {
		_tmp52_ = sysupgrade;
	}
	if (_tmp52_) {
		_tmp51_ = TRUE;
	} else {
		guint _tmp55_;
		guint _tmp56_;
		_tmp55_ = g_hash_table_size (to_build);
		_tmp56_ = _tmp55_;
		_tmp51_ = _tmp56_ > ((guint) 0);
	}
	if (_tmp51_) {
		_tmp50_ = TRUE;
	} else {
		guint _tmp57_;
		guint _tmp58_;
		_tmp57_ = g_hash_table_size (local_paths);
		_tmp58_ = _tmp57_;
		_tmp50_ = _tmp58_ > ((guint) 0);
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		guint _tmp59_;
		guint _tmp60_;
		_tmp59_ = g_hash_table_size (remote_paths);
		_tmp60_ = _tmp59_;
		_tmp49_ = _tmp60_ > ((guint) 0);
	}
	if (_tmp49_) {
		guint _tmp61_;
		guint _tmp62_;
		alpm_handle_t* _tmp74_;
		alpm_db_t* _tmp75_;
		_tmp61_ = g_hash_table_size (to_build);
		_tmp62_ = _tmp61_;
		if (_tmp62_ > ((guint) 0)) {
			alpm_handle_t* _tmp63_;
			alpm_handle_t* _tmp64_;
			alpm_db_t* _tmp65_;
			alpm_db_t* _tmp66_;
			_tmp63_ = tmp_handle;
			pamac_alpm_utils_prepare_aur_db (self, _tmp63_);
			_tmp64_ = tmp_handle;
			_tmp65_ = alpm_register_syncdb (_tmp64_, "pamac_aur", 0);
			aur_db = _tmp65_;
			_tmp66_ = aur_db;
			if (_tmp66_ == NULL) {
				alpm_handle_t* _tmp67_;
				alpm_errno_t err_no = 0;
				alpm_handle_t* _tmp68_;
				GPtrArray* details = NULL;
				GPtrArray* _tmp69_;
				GPtrArray* _tmp70_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				GPtrArray* _tmp73_;
				_tmp67_ = tmp_handle;
				pamac_alpm_utils_remove_aur_db (self, _tmp67_);
				_tmp68_ = tmp_handle;
				err_no = alpm_errno (_tmp68_);
				_tmp69_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
				details = _tmp69_;
				_tmp70_ = details;
				_tmp71_ = alpm_strerror (err_no);
				_tmp72_ = g_strdup (_tmp71_);
				g_ptr_array_add (_tmp70_, _tmp72_);
				_tmp73_ = details;
				pamac_alpm_utils_do_emit_error (self, _ ("Failed to initialize AUR database"), _tmp73_);
				result = FALSE;
				_g_ptr_array_unref0 (details);
				_alpm_release0 (tmp_handle);
				return result;
			}
		}
		_tmp74_ = tmp_handle;
		_tmp75_ = aur_db;
		pamac_alpm_utils_intern_compute_pkgs_to_install (self, _tmp74_, _tmp75_);
	}
	if ((trans_flags & ALPM_TRANS_FLAG_RECURSE) != 0) {
		alpm_handle_t* _tmp76_;
		_tmp76_ = tmp_handle;
		pamac_alpm_utils_intern_compute_orphans_to_remove (self, _tmp76_);
	}
	_tmp77_ = tmp_handle;
	alpm_option_set_eventcb (_tmp77_, _cb_event_alpm_cb_event, self);
	_tmp78_ = tmp_handle;
	alpm_option_set_progresscb (_tmp78_, _cb_progress_alpm_cb_progress, self);
	_tmp79_ = tmp_handle;
	alpm_option_set_logcb (_tmp79_, _cb_log_alpm_cb_log, self);
	_tmp80_ = tmp_handle;
	_tmp81_ = aur_db;
	success = pamac_alpm_utils_trans_prepare (self, _tmp80_, _tmp81_);
	if (success) {
		alpm_handle_t* _tmp82_;
		alpm_handle_t* _tmp83_;
		_tmp82_ = tmp_handle;
		pamac_alpm_utils_get_transaction_summary (self, _tmp82_, summary);
		_tmp83_ = tmp_handle;
		pamac_alpm_utils_trans_release (self, _tmp83_);
	}
	_tmp84_ = aur_db;
	if (_tmp84_ != NULL) {
		alpm_handle_t* _tmp85_;
		_tmp85_ = tmp_handle;
		pamac_alpm_utils_remove_aur_db (self, _tmp85_);
	}
	pamac_alpm_utils_trans_reset (self);
	result = success;
	_alpm_release0 (tmp_handle);
	return result;
}

gboolean
pamac_alpm_utils_trans_run (PamacAlpmUtils* self,
                            const gchar* sender,
                            gboolean sysupgrade,
                            gboolean enable_downgrade,
                            gboolean simple_install,
                            gboolean keep_built_pkgs,
                            gint trans_flags,
                            gchar** to_install,
                            gint to_install_length1,
                            gchar** to_remove,
                            gint to_remove_length1,
                            gchar** to_load_local,
                            gint to_load_local_length1,
                            gchar** to_load_remote,
                            gint to_load_remote_length1,
                            gchar** to_install_as_dep,
                            gint to_install_as_dep_length1,
                            gchar** ignorepkgs,
                            gint ignorepkgs_length1,
                            gchar** overwrite_files,
                            gint overwrite_files_length1)
{
	gchar* _tmp0_;
	alpm_handle_t* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_handle_t* _tmp3_;
	PamacConfig* _tmp4_;
	guint64 _tmp5_;
	guint64 _tmp6_;
	alpm_handle_t* _tmp7_;
	alpm_handle_t* _tmp31_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	self->priv->sysupgrade = sysupgrade;
	self->priv->enable_downgrade = enable_downgrade;
	self->priv->simple_install = simple_install;
	self->priv->no_confirm_commit = TRUE;
	self->priv->keep_built_pkgs = keep_built_pkgs;
	self->priv->trans_flags = trans_flags;
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_CASCADE);
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_RECURSE);
	_tmp1_ = pamac_alpm_utils_get_handle (self, FALSE, FALSE, FALSE);
	_alpm_release0 (self->alpm_handle);
	self->alpm_handle = _tmp1_;
	_tmp2_ = self->alpm_handle;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->alpm_handle;
	_tmp4_ = self->priv->config;
	_tmp5_ = pamac_config_get_max_parallel_downloads (_tmp4_);
	_tmp6_ = _tmp5_;
	alpm_option_set_parallel_downloads (_tmp3_, (guint) _tmp6_);
	_tmp7_ = self->alpm_handle;
	alpm_option_set_questioncb (_tmp7_, _cb_question_alpm_cb_question, self);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_install;
		name_collection_length1 = to_install_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = self->priv->to_install;
				_tmp9_ = name;
				_tmp10_ = g_strdup (_tmp9_);
				g_hash_table_add (_tmp8_, _tmp10_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_remove;
		name_collection_length1 = to_remove_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->to_remove;
				_tmp12_ = name;
				_tmp13_ = g_strdup (_tmp12_);
				g_hash_table_add (_tmp11_, _tmp13_);
			}
		}
	}
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = to_load_local;
		path_collection_length1 = to_load_local_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				GHashTable* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = self->priv->local_paths;
				_tmp15_ = path;
				_tmp16_ = g_strdup (_tmp15_);
				g_hash_table_add (_tmp14_, _tmp16_);
			}
		}
	}
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = to_load_remote;
		path_collection_length1 = to_load_remote_length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				GHashTable* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = self->priv->remote_paths;
				_tmp18_ = path;
				_tmp19_ = g_strdup (_tmp18_);
				g_hash_table_add (_tmp17_, _tmp19_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = to_install_as_dep;
		name_collection_length1 = to_install_as_dep_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp20_ = self->priv->to_install_as_dep;
				_tmp21_ = name;
				_tmp22_ = g_strdup (_tmp21_);
				_tmp23_ = name;
				_tmp24_ = g_strdup (_tmp23_);
				g_hash_table_insert (_tmp20_, _tmp22_, _tmp24_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = ignorepkgs;
		name_collection_length1 = ignorepkgs_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp25_ = self->priv->ignorepkgs;
				_tmp26_ = name;
				_tmp27_ = g_strdup (_tmp26_);
				g_hash_table_add (_tmp25_, _tmp27_);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = overwrite_files;
		name_collection_length1 = overwrite_files_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp28_ = self->priv->overwrite_files;
				_tmp29_ = name;
				_tmp30_ = g_strdup (_tmp29_);
				g_hash_table_add (_tmp28_, _tmp30_);
			}
		}
	}
	_tmp31_ = self->alpm_handle;
	result = pamac_alpm_utils_trans_run_real (self, _tmp31_);
	return result;
}

static gboolean
pamac_alpm_utils_trans_run_real (PamacAlpmUtils* self,
                                 alpm_handle_t* alpm_handle)
{
	alpm_db_t* aur_db = NULL;
	gboolean success = FALSE;
	alpm_db_t* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	aur_db = NULL;
	_tmp0_ = aur_db;
	success = pamac_alpm_utils_trans_prepare (self, alpm_handle, _tmp0_);
	if (success) {
		gboolean _tmp1_ = FALSE;
		alpm_list_t* _tmp2_;
		_tmp2_ = alpm_trans_get_add (alpm_handle);
		if (_tmp2_ != NULL) {
			_tmp1_ = TRUE;
		} else {
			alpm_list_t* _tmp3_;
			_tmp3_ = alpm_trans_get_remove (alpm_handle);
			_tmp1_ = _tmp3_ != NULL;
		}
		if (_tmp1_) {
			alpm_option_set_eventcb (alpm_handle, _cb_event_alpm_cb_event, self);
			alpm_option_set_progresscb (alpm_handle, _cb_progress_alpm_cb_progress, self);
			alpm_option_set_dlcb (alpm_handle, _cb_download_alpm_cb_download, self);
			alpm_option_set_logcb (alpm_handle, _cb_log_alpm_cb_log, self);
			success = pamac_alpm_utils_trans_commit (self, alpm_handle);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
			pamac_alpm_utils_trans_reset (self);
			success = TRUE;
		}
	}
	result = success;
	return result;
}

static void
pamac_alpm_utils_trans_reset (PamacAlpmUtils* self)
{
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	g_return_if_fail (self != NULL);
	self->priv->commit_retries = (guint8) 0;
	self->total_download = (guint64) 0;
	self->already_downloaded = (guint64) 0;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->current_filename);
	self->current_filename = _tmp0_;
	_tmp1_ = self->priv->to_syncfirst;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = self->priv->to_install;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = self->priv->deps_to_install;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->to_remove;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = self->priv->required_to_remove;
	g_hash_table_remove_all (_tmp5_);
	_tmp6_ = self->priv->orphans_to_remove;
	g_hash_table_remove_all (_tmp6_);
	_tmp7_ = self->priv->conflicts_to_remove;
	g_hash_table_remove_all (_tmp7_);
	_tmp8_ = self->priv->local_paths;
	g_hash_table_remove_all (_tmp8_);
	_tmp9_ = self->priv->remote_paths;
	g_hash_table_remove_all (_tmp9_);
	_tmp10_ = self->priv->to_build;
	g_hash_table_remove_all (_tmp10_);
	_tmp11_ = self->priv->checked_deps;
	g_hash_table_remove_all (_tmp11_);
	_tmp12_ = self->priv->ignorepkgs;
	g_hash_table_remove_all (_tmp12_);
	_tmp13_ = self->priv->overwrite_files;
	g_hash_table_remove_all (_tmp13_);
	_tmp14_ = self->priv->to_install_as_dep;
	g_hash_table_remove_all (_tmp14_);
	self->priv->no_confirm_commit = FALSE;
}

static void
pamac_alpm_utils_intern_compute_pkgs_to_remove (PamacAlpmUtils* self,
                                                alpm_handle_t* alpm_handle)
{
	gint tmp_trans_flags = 0;
	gboolean success = FALSE;
	g_return_if_fail (self != NULL);
	tmp_trans_flags = (gint) ALPM_TRANS_FLAG_NOLOCK;
	if ((self->priv->trans_flags & ALPM_TRANS_FLAG_UNNEEDED) != 0) {
		tmp_trans_flags |= (gint) ALPM_TRANS_FLAG_UNNEEDED;
	} else {
		if ((self->priv->trans_flags & ALPM_TRANS_FLAG_CASCADE) != 0) {
			self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_CASCADE);
			tmp_trans_flags |= (gint) ALPM_TRANS_FLAG_CASCADE;
		}
	}
	success = pamac_alpm_utils_trans_init (self, alpm_handle, tmp_trans_flags, FALSE);
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp0_;
			GHashTableIter _tmp1_ = {0};
			const gchar* name = NULL;
			_tmp0_ = self->priv->to_remove;
			g_hash_table_iter_init (&_tmp1_, _tmp0_);
			_name_it = _tmp1_;
			while (TRUE) {
				gconstpointer _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp2_;
				_tmp3_ = name;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp4_, FALSE);
				if (!success) {
					break;
				}
			}
		}
		if (success) {
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, FALSE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		alpm_list_t* pkgs_to_remove = NULL;
		alpm_list_t* _tmp5_;
		_tmp5_ = alpm_trans_get_remove (alpm_handle);
		pkgs_to_remove = _tmp5_;
		while (TRUE) {
			alpm_list_t* _tmp6_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp7_;
			gconstpointer _tmp8_;
			const gchar* name = NULL;
			alpm_pkg_t* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			GHashTable* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = pkgs_to_remove;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = pkgs_to_remove;
			_tmp8_ = _tmp7_->data;
			trans_pkg = (alpm_pkg_t*) _tmp8_;
			_tmp9_ = trans_pkg;
			_tmp10_ = alpm_pkg_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			name = _tmp11_;
			_tmp12_ = self->priv->to_remove;
			_tmp13_ = name;
			if (!g_hash_table_contains (_tmp12_, _tmp13_)) {
				GHashTable* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = self->priv->required_to_remove;
				_tmp15_ = name;
				_tmp16_ = g_strdup (_tmp15_);
				g_hash_table_add (_tmp14_, _tmp16_);
			}
			pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		}
		pamac_alpm_utils_trans_release (self, alpm_handle);
	}
}

static void
pamac_alpm_utils_remove_install_deps_in_to_remove (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle,
                                                   alpm_list_t* deps_to_check)
{
	alpm_list_t* deps_to_check_next = NULL;
	alpm_list_t* _tmp72_;
	g_return_if_fail (self != NULL);
	deps_to_check_next = NULL;
	while (TRUE) {
		alpm_pkg_t* alpm_pkg = NULL;
		gconstpointer _tmp0_;
		GHashTable* _tmp1_;
		alpm_pkg_t* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		alpm_list_t* depends = NULL;
		alpm_pkg_t* _tmp6_;
		alpm_list_t* _tmp7_;
		alpm_list_t* _tmp8_;
		alpm_pkg_t* _tmp39_;
		alpm_list_t* _tmp40_;
		alpm_list_t* _tmp41_;
		if (!(deps_to_check != NULL)) {
			break;
		}
		_tmp0_ = deps_to_check->data;
		alpm_pkg = (alpm_pkg_t*) _tmp0_;
		_tmp1_ = self->priv->checked_deps;
		_tmp2_ = alpm_pkg;
		_tmp3_ = alpm_pkg_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		g_hash_table_add (_tmp1_, _tmp5_);
		_tmp6_ = alpm_pkg;
		_tmp7_ = alpm_pkg_get_depends (_tmp6_);
		_tmp8_ = _tmp7_;
		depends = _tmp8_;
		while (TRUE) {
			alpm_list_t* _tmp9_;
			alpm_pkg_t* satisfier = NULL;
			alpm_db_t* _tmp10_;
			alpm_db_t* _tmp11_;
			alpm_list_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp14_;
			gconstpointer _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			alpm_pkg_t* _tmp18_;
			alpm_pkg_t* _tmp19_;
			alpm_pkg_t* _tmp20_;
			_tmp9_ = depends;
			if (!(_tmp9_ != NULL)) {
				break;
			}
			_tmp10_ = alpm_get_localdb (alpm_handle);
			_tmp11_ = _tmp10_;
			_tmp12_ = alpm_db_get_pkgcache (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = depends;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = alpm_find_satisfier (_tmp13_, _tmp17_);
			_tmp19_ = _tmp18_;
			_g_free0 (_tmp17_);
			satisfier = _tmp19_;
			_tmp20_ = satisfier;
			if (_tmp20_ != NULL) {
				GHashTable* _tmp21_;
				alpm_pkg_t* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp21_ = self->priv->checked_deps;
				_tmp22_ = satisfier;
				_tmp23_ = alpm_pkg_get_name (_tmp22_);
				_tmp24_ = _tmp23_;
				if (!g_hash_table_contains (_tmp21_, _tmp24_)) {
					GHashTable* _tmp25_;
					alpm_pkg_t* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					alpm_pkg_t* _tmp38_;
					_tmp25_ = self->priv->to_remove;
					_tmp26_ = satisfier;
					_tmp27_ = alpm_pkg_get_name (_tmp26_);
					_tmp28_ = _tmp27_;
					if (g_hash_table_remove (_tmp25_, _tmp28_)) {
						gchar* _tmp29_;
						gchar* _tmp30_;
						alpm_pkg_t* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp29_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
						_tmp30_ = _tmp29_;
						_tmp31_ = satisfier;
						_tmp32_ = alpm_pkg_get_name (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strconcat (_tmp30_, _tmp35_, NULL);
						_tmp37_ = _tmp36_;
						pamac_alpm_utils_do_emit_script_output (self, _tmp37_);
						_g_free0 (_tmp37_);
						_g_free0 (_tmp35_);
						_g_free0 (_tmp30_);
					}
					_tmp38_ = satisfier;
					deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp38_);
				}
			}
			depends = alpm_list_next (depends);
		}
		_tmp39_ = alpm_pkg;
		_tmp40_ = alpm_pkg_get_optdepends (_tmp39_);
		_tmp41_ = _tmp40_;
		depends = _tmp41_;
		while (TRUE) {
			alpm_list_t* _tmp42_;
			alpm_pkg_t* satisfier = NULL;
			alpm_db_t* _tmp43_;
			alpm_db_t* _tmp44_;
			alpm_list_t* _tmp45_;
			alpm_list_t* _tmp46_;
			alpm_list_t* _tmp47_;
			gconstpointer _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			alpm_pkg_t* _tmp51_;
			alpm_pkg_t* _tmp52_;
			alpm_pkg_t* _tmp53_;
			_tmp42_ = depends;
			if (!(_tmp42_ != NULL)) {
				break;
			}
			_tmp43_ = alpm_get_localdb (alpm_handle);
			_tmp44_ = _tmp43_;
			_tmp45_ = alpm_db_get_pkgcache (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = depends;
			_tmp48_ = _tmp47_->data;
			_tmp49_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = alpm_find_satisfier (_tmp46_, _tmp50_);
			_tmp52_ = _tmp51_;
			_g_free0 (_tmp50_);
			satisfier = _tmp52_;
			_tmp53_ = satisfier;
			if (_tmp53_ != NULL) {
				GHashTable* _tmp54_;
				alpm_pkg_t* _tmp55_;
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				_tmp54_ = self->priv->checked_deps;
				_tmp55_ = satisfier;
				_tmp56_ = alpm_pkg_get_name (_tmp55_);
				_tmp57_ = _tmp56_;
				if (!g_hash_table_contains (_tmp54_, _tmp57_)) {
					GHashTable* _tmp58_;
					alpm_pkg_t* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					alpm_pkg_t* _tmp71_;
					_tmp58_ = self->priv->to_remove;
					_tmp59_ = satisfier;
					_tmp60_ = alpm_pkg_get_name (_tmp59_);
					_tmp61_ = _tmp60_;
					if (g_hash_table_remove (_tmp58_, _tmp61_)) {
						gchar* _tmp62_;
						gchar* _tmp63_;
						alpm_pkg_t* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						_tmp62_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
						_tmp63_ = _tmp62_;
						_tmp64_ = satisfier;
						_tmp65_ = alpm_pkg_get_name (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
						_tmp70_ = _tmp69_;
						pamac_alpm_utils_do_emit_script_output (self, _tmp70_);
						_g_free0 (_tmp70_);
						_g_free0 (_tmp68_);
						_g_free0 (_tmp63_);
					}
					_tmp71_ = satisfier;
					deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp71_);
				}
			}
			depends = alpm_list_next (depends);
		}
		deps_to_check = alpm_list_next (deps_to_check);
	}
	_tmp72_ = deps_to_check_next;
	if (_tmp72_ != NULL) {
		alpm_list_t* _tmp73_;
		_tmp73_ = deps_to_check_next;
		pamac_alpm_utils_remove_install_deps_in_to_remove (self, alpm_handle, _tmp73_);
	}
	_alpm_list_free0 (deps_to_check_next);
}

static void
pamac_alpm_utils_intern_compute_pkgs_to_install (PamacAlpmUtils* self,
                                                 alpm_handle_t* alpm_handle,
                                                 alpm_db_t* aur_db)
{
	gint tmp_trans_flags = 0;
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	tmp_trans_flags = (gint) ALPM_TRANS_FLAG_NOLOCK;
	success = pamac_alpm_utils_trans_init (self, alpm_handle, tmp_trans_flags, FALSE);
	if (success) {
		_tmp0_ = self->priv->sysupgrade;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		success = pamac_alpm_utils_trans_sysupgrade (self, alpm_handle, FALSE);
		if (!success) {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp1_;
			GHashTableIter _tmp2_ = {0};
			const gchar* name = NULL;
			_tmp1_ = self->priv->to_install;
			g_hash_table_iter_init (&_tmp2_, _tmp1_);
			_name_it = _tmp2_;
			while (TRUE) {
				gconstpointer _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp3_;
				_tmp4_ = name;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp5_, FALSE);
				if (!success) {
					break;
				}
			}
		}
		if (success) {
			alpm_list_t* dbs = NULL;
			dbs = NULL;
			dbs = alpm_list_add (dbs, aur_db);
			{
				GHashTableIter _name_it = {0};
				GHashTable* _tmp6_;
				GHashTableIter _tmp7_ = {0};
				const gchar* name = NULL;
				_tmp6_ = self->priv->to_build;
				g_hash_table_iter_init (&_tmp7_, _tmp6_);
				_name_it = _tmp7_;
				while (TRUE) {
					gconstpointer _tmp8_;
					const gchar* _tmp9_;
					alpm_pkg_t* pkg = NULL;
					alpm_list_t* _tmp10_;
					const gchar* _tmp11_;
					alpm_pkg_t* _tmp12_;
					alpm_pkg_t* _tmp13_;
					_tmp8_ = _vala_hash_set_next_value (&_name_it);
					name = (const gchar*) _tmp8_;
					_tmp9_ = name;
					if (!(_tmp9_ != NULL)) {
						break;
					}
					_tmp10_ = dbs;
					_tmp11_ = name;
					_tmp12_ = alpm_find_dbs_satisfier (alpm_handle, _tmp10_, _tmp11_);
					pkg = _tmp12_;
					_tmp13_ = pkg;
					if (_tmp13_ == NULL) {
						success = FALSE;
						break;
					} else {
						alpm_pkg_t* _tmp14_;
						_tmp14_ = pkg;
						success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp14_, FALSE);
						if (!success) {
							break;
						}
					}
				}
			}
			_alpm_list_free0 (dbs);
		}
		if (success) {
			{
				GHashTableIter _path_it = {0};
				GHashTable* _tmp15_;
				GHashTableIter _tmp16_ = {0};
				const gchar* path = NULL;
				_tmp15_ = self->priv->local_paths;
				g_hash_table_iter_init (&_tmp16_, _tmp15_);
				_path_it = _tmp16_;
				while (TRUE) {
					gconstpointer _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp17_ = _vala_hash_set_next_value (&_path_it);
					path = (const gchar*) _tmp17_;
					_tmp18_ = path;
					if (!(_tmp18_ != NULL)) {
						break;
					}
					_tmp19_ = path;
					_tmp20_ = alpm_option_get_local_file_siglevel (alpm_handle);
					_tmp21_ = _tmp20_;
					success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp19_, _tmp21_, FALSE);
					if (!success) {
						break;
					}
				}
			}
		}
		if (success) {
			{
				GHashTableIter _path_it = {0};
				GHashTable* _tmp22_;
				GHashTableIter _tmp23_ = {0};
				const gchar* path = NULL;
				_tmp22_ = self->priv->remote_paths;
				g_hash_table_iter_init (&_tmp23_, _tmp22_);
				_path_it = _tmp23_;
				while (TRUE) {
					gconstpointer _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp24_ = _vala_hash_set_next_value (&_path_it);
					path = (const gchar*) _tmp24_;
					_tmp25_ = path;
					if (!(_tmp25_ != NULL)) {
						break;
					}
					_tmp26_ = path;
					_tmp27_ = alpm_option_get_remote_file_siglevel (alpm_handle);
					_tmp28_ = _tmp27_;
					success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp26_, _tmp28_, FALSE);
					if (!success) {
						break;
					}
				}
			}
		}
		if (success) {
			success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, FALSE);
		} else {
			pamac_alpm_utils_trans_release (self, alpm_handle);
		}
	}
	if (success) {
		GHashTable* to_install_copy = NULL;
		GHashTable* _tmp29_;
		GHashFunc _tmp30_;
		GEqualFunc _tmp31_;
		GHashTable* _tmp32_;
		GHashFunc _tmp33_;
		GEqualFunc _tmp34_;
		GHashTable* _tmp35_;
		alpm_list_t* deps_to_check = NULL;
		alpm_list_t* pkgs_to_add = NULL;
		alpm_list_t* _tmp36_;
		alpm_list_t* pkgs_to_remove = NULL;
		alpm_list_t* _tmp149_;
		alpm_list_t* _tmp158_;
		_tmp29_ = self->priv->to_install;
		self->priv->to_install = NULL;
		to_install_copy = _tmp29_;
		_tmp30_ = g_str_hash;
		_tmp31_ = g_str_equal;
		_tmp32_ = g_hash_table_new_full (_tmp30_, _tmp31_, NULL, _g_free0_);
		_g_hash_table_unref0 (self->priv->to_install);
		self->priv->to_install = _tmp32_;
		_tmp33_ = g_str_hash;
		_tmp34_ = g_str_equal;
		_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, NULL, _g_free0_);
		_g_hash_table_unref0 (self->priv->to_build);
		self->priv->to_build = _tmp35_;
		deps_to_check = NULL;
		_tmp36_ = alpm_trans_get_add (alpm_handle);
		pkgs_to_add = _tmp36_;
		while (TRUE) {
			alpm_list_t* _tmp37_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp38_;
			gconstpointer _tmp39_;
			alpm_pkg_t* _tmp40_;
			alpm_db_t* _tmp41_;
			alpm_db_t* _tmp42_;
			GHashTable* _tmp62_;
			guint _tmp63_;
			guint _tmp64_;
			_tmp37_ = pkgs_to_add;
			if (!(_tmp37_ != NULL)) {
				break;
			}
			_tmp38_ = pkgs_to_add;
			_tmp39_ = _tmp38_->data;
			trans_pkg = (alpm_pkg_t*) _tmp39_;
			_tmp40_ = trans_pkg;
			_tmp41_ = alpm_pkg_get_db (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != NULL) {
				const gchar* name = NULL;
				alpm_pkg_t* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				alpm_pkg_t* _tmp46_;
				alpm_db_t* _tmp47_;
				alpm_db_t* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp43_ = trans_pkg;
				_tmp44_ = alpm_pkg_get_name (_tmp43_);
				_tmp45_ = _tmp44_;
				name = _tmp45_;
				_tmp46_ = trans_pkg;
				_tmp47_ = alpm_pkg_get_db (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = alpm_db_get_name (_tmp48_);
				_tmp50_ = _tmp49_;
				if (g_strcmp0 (_tmp50_, "pamac_aur") == 0) {
					GHashTable* _tmp51_;
					const gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp51_ = self->priv->to_build;
					_tmp52_ = name;
					_tmp53_ = g_strdup (_tmp52_);
					g_hash_table_add (_tmp51_, _tmp53_);
				} else {
					GHashTable* _tmp54_;
					const gchar* _tmp55_;
					_tmp54_ = to_install_copy;
					_tmp55_ = name;
					if (g_hash_table_contains (_tmp54_, _tmp55_)) {
						GHashTable* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp56_ = self->priv->to_install;
						_tmp57_ = name;
						_tmp58_ = g_strdup (_tmp57_);
						g_hash_table_add (_tmp56_, _tmp58_);
					} else {
						GHashTable* _tmp59_;
						const gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp59_ = self->priv->deps_to_install;
						_tmp60_ = name;
						_tmp61_ = g_strdup (_tmp60_);
						g_hash_table_add (_tmp59_, _tmp61_);
					}
				}
			}
			_tmp62_ = self->priv->to_remove;
			_tmp63_ = g_hash_table_size (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ > ((guint) 0)) {
				GHashTable* _tmp65_;
				alpm_pkg_t* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				GHashTable* _tmp78_;
				alpm_pkg_t* _tmp79_;
				const gchar* _tmp80_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				alpm_list_t* depends = NULL;
				alpm_pkg_t* _tmp83_;
				alpm_list_t* _tmp84_;
				alpm_list_t* _tmp85_;
				alpm_pkg_t* _tmp116_;
				alpm_list_t* _tmp117_;
				alpm_list_t* _tmp118_;
				_tmp65_ = self->priv->to_remove;
				_tmp66_ = trans_pkg;
				_tmp67_ = alpm_pkg_get_name (_tmp66_);
				_tmp68_ = _tmp67_;
				if (g_hash_table_remove (_tmp65_, _tmp68_)) {
					gchar* _tmp69_;
					gchar* _tmp70_;
					alpm_pkg_t* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp69_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp70_ = _tmp69_;
					_tmp71_ = trans_pkg;
					_tmp72_ = alpm_pkg_get_name (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
					_tmp77_ = _tmp76_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp77_);
					_g_free0 (_tmp77_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp70_);
				}
				_tmp78_ = self->priv->checked_deps;
				_tmp79_ = trans_pkg;
				_tmp80_ = alpm_pkg_get_name (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = g_strdup (_tmp81_);
				g_hash_table_add (_tmp78_, _tmp82_);
				_tmp83_ = trans_pkg;
				_tmp84_ = alpm_pkg_get_depends (_tmp83_);
				_tmp85_ = _tmp84_;
				depends = _tmp85_;
				while (TRUE) {
					alpm_list_t* _tmp86_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp87_;
					alpm_db_t* _tmp88_;
					alpm_list_t* _tmp89_;
					alpm_list_t* _tmp90_;
					alpm_list_t* _tmp91_;
					gconstpointer _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					alpm_pkg_t* _tmp95_;
					alpm_pkg_t* _tmp96_;
					alpm_pkg_t* _tmp97_;
					_tmp86_ = depends;
					if (!(_tmp86_ != NULL)) {
						break;
					}
					_tmp87_ = alpm_get_localdb (alpm_handle);
					_tmp88_ = _tmp87_;
					_tmp89_ = alpm_db_get_pkgcache (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = depends;
					_tmp92_ = _tmp91_->data;
					_tmp93_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = alpm_find_satisfier (_tmp90_, _tmp94_);
					_tmp96_ = _tmp95_;
					_g_free0 (_tmp94_);
					satisfier = _tmp96_;
					_tmp97_ = satisfier;
					if (_tmp97_ != NULL) {
						GHashTable* _tmp98_;
						alpm_pkg_t* _tmp99_;
						const gchar* _tmp100_;
						const gchar* _tmp101_;
						_tmp98_ = self->priv->checked_deps;
						_tmp99_ = satisfier;
						_tmp100_ = alpm_pkg_get_name (_tmp99_);
						_tmp101_ = _tmp100_;
						if (!g_hash_table_contains (_tmp98_, _tmp101_)) {
							GHashTable* _tmp102_;
							alpm_pkg_t* _tmp103_;
							const gchar* _tmp104_;
							const gchar* _tmp105_;
							alpm_pkg_t* _tmp115_;
							_tmp102_ = self->priv->to_remove;
							_tmp103_ = satisfier;
							_tmp104_ = alpm_pkg_get_name (_tmp103_);
							_tmp105_ = _tmp104_;
							if (g_hash_table_remove (_tmp102_, _tmp105_)) {
								gchar* _tmp106_;
								gchar* _tmp107_;
								alpm_pkg_t* _tmp108_;
								const gchar* _tmp109_;
								const gchar* _tmp110_;
								gchar* _tmp111_;
								gchar* _tmp112_;
								gchar* _tmp113_;
								gchar* _tmp114_;
								_tmp106_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
								_tmp107_ = _tmp106_;
								_tmp108_ = satisfier;
								_tmp109_ = alpm_pkg_get_name (_tmp108_);
								_tmp110_ = _tmp109_;
								_tmp111_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = g_strconcat (_tmp107_, _tmp112_, NULL);
								_tmp114_ = _tmp113_;
								pamac_alpm_utils_do_emit_script_output (self, _tmp114_);
								_g_free0 (_tmp114_);
								_g_free0 (_tmp112_);
								_g_free0 (_tmp107_);
							}
							_tmp115_ = satisfier;
							deps_to_check = alpm_list_add (deps_to_check, _tmp115_);
						}
					}
					depends = alpm_list_next (depends);
				}
				_tmp116_ = trans_pkg;
				_tmp117_ = alpm_pkg_get_optdepends (_tmp116_);
				_tmp118_ = _tmp117_;
				depends = _tmp118_;
				while (TRUE) {
					alpm_list_t* _tmp119_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp120_;
					alpm_db_t* _tmp121_;
					alpm_list_t* _tmp122_;
					alpm_list_t* _tmp123_;
					alpm_list_t* _tmp124_;
					gconstpointer _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					alpm_pkg_t* _tmp128_;
					alpm_pkg_t* _tmp129_;
					alpm_pkg_t* _tmp130_;
					_tmp119_ = depends;
					if (!(_tmp119_ != NULL)) {
						break;
					}
					_tmp120_ = alpm_get_localdb (alpm_handle);
					_tmp121_ = _tmp120_;
					_tmp122_ = alpm_db_get_pkgcache (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = depends;
					_tmp125_ = _tmp124_->data;
					_tmp126_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = alpm_find_satisfier (_tmp123_, _tmp127_);
					_tmp129_ = _tmp128_;
					_g_free0 (_tmp127_);
					satisfier = _tmp129_;
					_tmp130_ = satisfier;
					if (_tmp130_ != NULL) {
						GHashTable* _tmp131_;
						alpm_pkg_t* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp131_ = self->priv->checked_deps;
						_tmp132_ = satisfier;
						_tmp133_ = alpm_pkg_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						if (!g_hash_table_contains (_tmp131_, _tmp134_)) {
							GHashTable* _tmp135_;
							alpm_pkg_t* _tmp136_;
							const gchar* _tmp137_;
							const gchar* _tmp138_;
							alpm_pkg_t* _tmp148_;
							_tmp135_ = self->priv->to_remove;
							_tmp136_ = satisfier;
							_tmp137_ = alpm_pkg_get_name (_tmp136_);
							_tmp138_ = _tmp137_;
							if (g_hash_table_remove (_tmp135_, _tmp138_)) {
								gchar* _tmp139_;
								gchar* _tmp140_;
								alpm_pkg_t* _tmp141_;
								const gchar* _tmp142_;
								const gchar* _tmp143_;
								gchar* _tmp144_;
								gchar* _tmp145_;
								gchar* _tmp146_;
								gchar* _tmp147_;
								_tmp139_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
								_tmp140_ = _tmp139_;
								_tmp141_ = satisfier;
								_tmp142_ = alpm_pkg_get_name (_tmp141_);
								_tmp143_ = _tmp142_;
								_tmp144_ = g_strdup_printf (g_dgettext (NULL, "removing %s from target list"), _tmp143_);
								_tmp145_ = _tmp144_;
								_tmp146_ = g_strconcat (_tmp140_, _tmp145_, NULL);
								_tmp147_ = _tmp146_;
								pamac_alpm_utils_do_emit_script_output (self, _tmp147_);
								_g_free0 (_tmp147_);
								_g_free0 (_tmp145_);
								_g_free0 (_tmp140_);
							}
							_tmp148_ = satisfier;
							deps_to_check = alpm_list_add (deps_to_check, _tmp148_);
						}
					}
					depends = alpm_list_next (depends);
				}
			}
			pkgs_to_add = alpm_list_next (pkgs_to_add);
		}
		_tmp149_ = alpm_trans_get_remove (alpm_handle);
		pkgs_to_remove = _tmp149_;
		while (TRUE) {
			alpm_list_t* _tmp150_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_list_t* _tmp151_;
			gconstpointer _tmp152_;
			GHashTable* _tmp153_;
			alpm_pkg_t* _tmp154_;
			const gchar* _tmp155_;
			const gchar* _tmp156_;
			gchar* _tmp157_;
			_tmp150_ = pkgs_to_remove;
			if (!(_tmp150_ != NULL)) {
				break;
			}
			_tmp151_ = pkgs_to_remove;
			_tmp152_ = _tmp151_->data;
			trans_pkg = (alpm_pkg_t*) _tmp152_;
			_tmp153_ = self->priv->conflicts_to_remove;
			_tmp154_ = trans_pkg;
			_tmp155_ = alpm_pkg_get_name (_tmp154_);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strdup (_tmp156_);
			g_hash_table_add (_tmp153_, _tmp157_);
			pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		}
		pamac_alpm_utils_trans_release (self, alpm_handle);
		_tmp158_ = deps_to_check;
		if (_tmp158_ != NULL) {
			alpm_list_t* _tmp159_;
			_tmp159_ = deps_to_check;
			pamac_alpm_utils_remove_install_deps_in_to_remove (self, alpm_handle, _tmp159_);
		}
		_alpm_list_free0 (deps_to_check);
		_g_hash_table_unref0 (to_install_copy);
	}
}

static void
_g_free_alpm_list_fn_free (gconstpointer a)
{
	g_free (a);
}

static void
pamac_alpm_utils_check_orphans_to_remove (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          alpm_list_t* deps_to_check)
{
	alpm_list_t* deps_to_check_next = NULL;
	alpm_list_t* _tmp102_;
	g_return_if_fail (self != NULL);
	deps_to_check_next = NULL;
	while (TRUE) {
		alpm_pkg_t* alpm_pkg = NULL;
		gconstpointer _tmp0_;
		GHashTable* _tmp1_;
		alpm_pkg_t* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		if (!(deps_to_check != NULL)) {
			break;
		}
		_tmp0_ = deps_to_check->data;
		alpm_pkg = (alpm_pkg_t*) _tmp0_;
		_tmp1_ = self->priv->checked_deps;
		_tmp2_ = alpm_pkg;
		_tmp3_ = alpm_pkg_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!g_hash_table_contains (_tmp1_, _tmp4_)) {
			alpm_pkg_t* _tmp5_;
			alpm_pkgreason_t _tmp6_;
			alpm_pkgreason_t _tmp7_;
			_tmp5_ = alpm_pkg;
			_tmp6_ = alpm_pkg_get_reason (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ == ALPM_PKG_REASON_DEPEND) {
				alpm_list_t* requiredby = NULL;
				alpm_pkg_t* _tmp8_;
				alpm_list_t* _tmp9_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp10_;
				gboolean extern_dep = FALSE;
				alpm_list_t* _tmp34_;
				_tmp8_ = alpm_pkg;
				_tmp9_ = alpm_pkg_compute_requiredby (_tmp8_);
				requiredby = _tmp9_;
				_tmp10_ = requiredby;
				list = _tmp10_;
				extern_dep = FALSE;
				while (TRUE) {
					alpm_list_t* _tmp11_;
					alpm_pkg_t* satisfier = NULL;
					alpm_db_t* _tmp12_;
					alpm_db_t* _tmp13_;
					alpm_list_t* _tmp14_;
					alpm_list_t* _tmp15_;
					alpm_list_t* _tmp16_;
					gconstpointer _tmp17_;
					alpm_pkg_t* _tmp18_;
					alpm_pkg_t* _tmp19_;
					_tmp11_ = list;
					if (!(_tmp11_ != NULL)) {
						break;
					}
					_tmp12_ = alpm_get_localdb (alpm_handle);
					_tmp13_ = _tmp12_;
					_tmp14_ = alpm_db_get_pkgcache (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = list;
					_tmp17_ = _tmp16_->data;
					_tmp18_ = alpm_find_satisfier (_tmp15_, (const gchar*) _tmp17_);
					satisfier = _tmp18_;
					_tmp19_ = satisfier;
					if (_tmp19_ != NULL) {
						gboolean _tmp20_ = FALSE;
						gboolean _tmp21_ = FALSE;
						GHashTable* _tmp22_;
						alpm_pkg_t* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp22_ = self->priv->to_remove;
						_tmp23_ = satisfier;
						_tmp24_ = alpm_pkg_get_name (_tmp23_);
						_tmp25_ = _tmp24_;
						if (!g_hash_table_contains (_tmp22_, _tmp25_)) {
							GHashTable* _tmp26_;
							alpm_pkg_t* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp26_ = self->priv->required_to_remove;
							_tmp27_ = satisfier;
							_tmp28_ = alpm_pkg_get_name (_tmp27_);
							_tmp29_ = _tmp28_;
							_tmp21_ = !g_hash_table_contains (_tmp26_, _tmp29_);
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							GHashTable* _tmp30_;
							alpm_pkg_t* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							_tmp30_ = self->priv->orphans_to_remove;
							_tmp31_ = satisfier;
							_tmp32_ = alpm_pkg_get_name (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp20_ = !g_hash_table_contains (_tmp30_, _tmp33_);
						} else {
							_tmp20_ = FALSE;
						}
						if (_tmp20_) {
							extern_dep = TRUE;
							break;
						}
					}
					list = alpm_list_next (list);
				}
				_tmp34_ = requiredby;
				alpm_list_free_inner (_tmp34_, _g_free_alpm_list_fn_free);
				if (!extern_dep) {
					alpm_list_t* optionalfor = NULL;
					alpm_pkg_t* _tmp35_;
					alpm_list_t* _tmp36_;
					alpm_list_t* _tmp37_;
					alpm_list_t* _tmp61_;
					_tmp35_ = alpm_pkg;
					_tmp36_ = alpm_pkg_compute_optionalfor (_tmp35_);
					optionalfor = _tmp36_;
					_tmp37_ = optionalfor;
					list = _tmp37_;
					while (TRUE) {
						alpm_list_t* _tmp38_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp39_;
						alpm_db_t* _tmp40_;
						alpm_list_t* _tmp41_;
						alpm_list_t* _tmp42_;
						alpm_list_t* _tmp43_;
						gconstpointer _tmp44_;
						alpm_pkg_t* _tmp45_;
						alpm_pkg_t* _tmp46_;
						_tmp38_ = list;
						if (!(_tmp38_ != NULL)) {
							break;
						}
						_tmp39_ = alpm_get_localdb (alpm_handle);
						_tmp40_ = _tmp39_;
						_tmp41_ = alpm_db_get_pkgcache (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = list;
						_tmp44_ = _tmp43_->data;
						_tmp45_ = alpm_find_satisfier (_tmp42_, (const gchar*) _tmp44_);
						satisfier = _tmp45_;
						_tmp46_ = satisfier;
						if (_tmp46_ != NULL) {
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							GHashTable* _tmp49_;
							alpm_pkg_t* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							_tmp49_ = self->priv->to_remove;
							_tmp50_ = satisfier;
							_tmp51_ = alpm_pkg_get_name (_tmp50_);
							_tmp52_ = _tmp51_;
							if (!g_hash_table_contains (_tmp49_, _tmp52_)) {
								GHashTable* _tmp53_;
								alpm_pkg_t* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
								_tmp53_ = self->priv->required_to_remove;
								_tmp54_ = satisfier;
								_tmp55_ = alpm_pkg_get_name (_tmp54_);
								_tmp56_ = _tmp55_;
								_tmp48_ = !g_hash_table_contains (_tmp53_, _tmp56_);
							} else {
								_tmp48_ = FALSE;
							}
							if (_tmp48_) {
								GHashTable* _tmp57_;
								alpm_pkg_t* _tmp58_;
								const gchar* _tmp59_;
								const gchar* _tmp60_;
								_tmp57_ = self->priv->orphans_to_remove;
								_tmp58_ = satisfier;
								_tmp59_ = alpm_pkg_get_name (_tmp58_);
								_tmp60_ = _tmp59_;
								_tmp47_ = !g_hash_table_contains (_tmp57_, _tmp60_);
							} else {
								_tmp47_ = FALSE;
							}
							if (_tmp47_) {
								extern_dep = TRUE;
								break;
							}
						}
						list = alpm_list_next (list);
					}
					_tmp61_ = optionalfor;
					alpm_list_free_inner (_tmp61_, _g_free_alpm_list_fn_free);
					if (!extern_dep) {
						GHashTable* _tmp62_;
						alpm_pkg_t* _tmp63_;
						const gchar* _tmp64_;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						GHashTable* _tmp67_;
						alpm_pkg_t* _tmp68_;
						const gchar* _tmp69_;
						const gchar* _tmp70_;
						gchar* _tmp71_;
						alpm_list_t* depends = NULL;
						alpm_pkg_t* _tmp72_;
						alpm_list_t* _tmp73_;
						alpm_list_t* _tmp74_;
						_tmp62_ = self->priv->orphans_to_remove;
						_tmp63_ = alpm_pkg;
						_tmp64_ = alpm_pkg_get_name (_tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup (_tmp65_);
						g_hash_table_add (_tmp62_, _tmp66_);
						_tmp67_ = self->priv->checked_deps;
						_tmp68_ = alpm_pkg;
						_tmp69_ = alpm_pkg_get_name (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strdup (_tmp70_);
						g_hash_table_add (_tmp67_, _tmp71_);
						_tmp72_ = alpm_pkg;
						_tmp73_ = alpm_pkg_get_depends (_tmp72_);
						_tmp74_ = _tmp73_;
						depends = _tmp74_;
						while (TRUE) {
							alpm_list_t* _tmp75_;
							alpm_pkg_t* satisfier = NULL;
							alpm_db_t* _tmp76_;
							alpm_db_t* _tmp77_;
							alpm_list_t* _tmp78_;
							alpm_list_t* _tmp79_;
							alpm_list_t* _tmp80_;
							gconstpointer _tmp81_;
							gchar* _tmp82_;
							gchar* _tmp83_;
							alpm_pkg_t* _tmp84_;
							alpm_pkg_t* _tmp85_;
							alpm_pkg_t* _tmp86_;
							_tmp75_ = depends;
							if (!(_tmp75_ != NULL)) {
								break;
							}
							_tmp76_ = alpm_get_localdb (alpm_handle);
							_tmp77_ = _tmp76_;
							_tmp78_ = alpm_db_get_pkgcache (_tmp77_);
							_tmp79_ = _tmp78_;
							_tmp80_ = depends;
							_tmp81_ = _tmp80_->data;
							_tmp82_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp81_);
							_tmp83_ = _tmp82_;
							_tmp84_ = alpm_find_satisfier (_tmp79_, _tmp83_);
							_tmp85_ = _tmp84_;
							_g_free0 (_tmp83_);
							satisfier = _tmp85_;
							_tmp86_ = satisfier;
							if (_tmp86_ != NULL) {
								gboolean _tmp87_ = FALSE;
								gboolean _tmp88_ = FALSE;
								GHashTable* _tmp89_;
								alpm_pkg_t* _tmp90_;
								const gchar* _tmp91_;
								const gchar* _tmp92_;
								_tmp89_ = self->priv->to_remove;
								_tmp90_ = satisfier;
								_tmp91_ = alpm_pkg_get_name (_tmp90_);
								_tmp92_ = _tmp91_;
								if (!g_hash_table_contains (_tmp89_, _tmp92_)) {
									GHashTable* _tmp93_;
									alpm_pkg_t* _tmp94_;
									const gchar* _tmp95_;
									const gchar* _tmp96_;
									_tmp93_ = self->priv->required_to_remove;
									_tmp94_ = satisfier;
									_tmp95_ = alpm_pkg_get_name (_tmp94_);
									_tmp96_ = _tmp95_;
									_tmp88_ = !g_hash_table_contains (_tmp93_, _tmp96_);
								} else {
									_tmp88_ = FALSE;
								}
								if (_tmp88_) {
									GHashTable* _tmp97_;
									alpm_pkg_t* _tmp98_;
									const gchar* _tmp99_;
									const gchar* _tmp100_;
									_tmp97_ = self->priv->orphans_to_remove;
									_tmp98_ = satisfier;
									_tmp99_ = alpm_pkg_get_name (_tmp98_);
									_tmp100_ = _tmp99_;
									_tmp87_ = !g_hash_table_contains (_tmp97_, _tmp100_);
								} else {
									_tmp87_ = FALSE;
								}
								if (_tmp87_) {
									alpm_pkg_t* _tmp101_;
									_tmp101_ = satisfier;
									deps_to_check_next = alpm_list_add (deps_to_check_next, _tmp101_);
								}
							}
							depends = alpm_list_next (depends);
						}
					}
					_alpm_list_free0 (optionalfor);
				}
				_alpm_list_free0 (requiredby);
			}
		}
		deps_to_check = alpm_list_next (deps_to_check);
	}
	_tmp102_ = deps_to_check_next;
	if (_tmp102_ != NULL) {
		alpm_list_t* _tmp103_;
		_tmp103_ = deps_to_check_next;
		pamac_alpm_utils_check_orphans_to_remove (self, alpm_handle, _tmp103_);
	}
	_alpm_list_free0 (deps_to_check_next);
}

static void
pamac_alpm_utils_intern_compute_orphans_to_remove (PamacAlpmUtils* self,
                                                   alpm_handle_t* alpm_handle)
{
	GHashTable* _tmp0_;
	alpm_list_t* deps_to_check = NULL;
	alpm_list_t* _tmp87_;
	g_return_if_fail (self != NULL);
	self->priv->trans_flags = self->priv->trans_flags & (~ALPM_TRANS_FLAG_RECURSE);
	_tmp0_ = self->priv->checked_deps;
	g_hash_table_remove_all (_tmp0_);
	deps_to_check = NULL;
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp1_;
		GHashTableIter _tmp2_ = {0};
		const gchar* name = NULL;
		_tmp1_ = self->priv->to_remove;
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_name_it = _tmp2_;
		while (TRUE) {
			gconstpointer _tmp3_;
			const gchar* _tmp4_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_db_t* _tmp5_;
			alpm_db_t* _tmp6_;
			const gchar* _tmp7_;
			alpm_pkg_t* _tmp8_;
			alpm_pkg_t* _tmp9_;
			_tmp3_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp3_;
			_tmp4_ = name;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = alpm_get_localdb (alpm_handle);
			_tmp6_ = _tmp5_;
			_tmp7_ = name;
			_tmp8_ = alpm_db_get_pkg (_tmp6_, _tmp7_);
			trans_pkg = _tmp8_;
			_tmp9_ = trans_pkg;
			if (_tmp9_ != NULL) {
				GHashTable* _tmp10_;
				alpm_pkg_t* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = self->priv->checked_deps;
				_tmp11_ = trans_pkg;
				_tmp12_ = alpm_pkg_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!g_hash_table_contains (_tmp10_, _tmp13_)) {
					GHashTable* _tmp14_;
					alpm_pkg_t* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					alpm_list_t* depends = NULL;
					alpm_pkg_t* _tmp19_;
					alpm_list_t* _tmp20_;
					alpm_list_t* _tmp21_;
					_tmp14_ = self->priv->checked_deps;
					_tmp15_ = trans_pkg;
					_tmp16_ = alpm_pkg_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup (_tmp17_);
					g_hash_table_add (_tmp14_, _tmp18_);
					_tmp19_ = trans_pkg;
					_tmp20_ = alpm_pkg_get_depends (_tmp19_);
					_tmp21_ = _tmp20_;
					depends = _tmp21_;
					while (TRUE) {
						alpm_list_t* _tmp22_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp23_;
						alpm_db_t* _tmp24_;
						alpm_list_t* _tmp25_;
						alpm_list_t* _tmp26_;
						alpm_list_t* _tmp27_;
						gconstpointer _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						alpm_pkg_t* _tmp31_;
						alpm_pkg_t* _tmp32_;
						alpm_pkg_t* _tmp33_;
						_tmp22_ = depends;
						if (!(_tmp22_ != NULL)) {
							break;
						}
						_tmp23_ = alpm_get_localdb (alpm_handle);
						_tmp24_ = _tmp23_;
						_tmp25_ = alpm_db_get_pkgcache (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = depends;
						_tmp28_ = _tmp27_->data;
						_tmp29_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = alpm_find_satisfier (_tmp26_, _tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp30_);
						satisfier = _tmp32_;
						_tmp33_ = satisfier;
						if (_tmp33_ != NULL) {
							gboolean _tmp34_ = FALSE;
							GHashTable* _tmp35_;
							alpm_pkg_t* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							_tmp35_ = self->priv->to_remove;
							_tmp36_ = satisfier;
							_tmp37_ = alpm_pkg_get_name (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!g_hash_table_contains (_tmp35_, _tmp38_)) {
								GHashTable* _tmp39_;
								alpm_pkg_t* _tmp40_;
								const gchar* _tmp41_;
								const gchar* _tmp42_;
								_tmp39_ = self->priv->required_to_remove;
								_tmp40_ = satisfier;
								_tmp41_ = alpm_pkg_get_name (_tmp40_);
								_tmp42_ = _tmp41_;
								_tmp34_ = !g_hash_table_contains (_tmp39_, _tmp42_);
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								alpm_pkg_t* _tmp43_;
								_tmp43_ = satisfier;
								deps_to_check = alpm_list_add (deps_to_check, _tmp43_);
							}
						}
						depends = alpm_list_next (depends);
					}
				}
			}
		}
	}
	{
		GHashTableIter _name_it = {0};
		GHashTable* _tmp44_;
		GHashTableIter _tmp45_ = {0};
		const gchar* name = NULL;
		_tmp44_ = self->priv->required_to_remove;
		g_hash_table_iter_init (&_tmp45_, _tmp44_);
		_name_it = _tmp45_;
		while (TRUE) {
			gconstpointer _tmp46_;
			const gchar* _tmp47_;
			alpm_pkg_t* trans_pkg = NULL;
			alpm_db_t* _tmp48_;
			alpm_db_t* _tmp49_;
			const gchar* _tmp50_;
			alpm_pkg_t* _tmp51_;
			alpm_pkg_t* _tmp52_;
			_tmp46_ = _vala_hash_set_next_value (&_name_it);
			name = (const gchar*) _tmp46_;
			_tmp47_ = name;
			if (!(_tmp47_ != NULL)) {
				break;
			}
			_tmp48_ = alpm_get_localdb (alpm_handle);
			_tmp49_ = _tmp48_;
			_tmp50_ = name;
			_tmp51_ = alpm_db_get_pkg (_tmp49_, _tmp50_);
			trans_pkg = _tmp51_;
			_tmp52_ = trans_pkg;
			if (_tmp52_ != NULL) {
				GHashTable* _tmp53_;
				alpm_pkg_t* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				_tmp53_ = self->priv->checked_deps;
				_tmp54_ = trans_pkg;
				_tmp55_ = alpm_pkg_get_name (_tmp54_);
				_tmp56_ = _tmp55_;
				if (!g_hash_table_contains (_tmp53_, _tmp56_)) {
					GHashTable* _tmp57_;
					alpm_pkg_t* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					alpm_list_t* depends = NULL;
					alpm_pkg_t* _tmp62_;
					alpm_list_t* _tmp63_;
					alpm_list_t* _tmp64_;
					_tmp57_ = self->priv->checked_deps;
					_tmp58_ = trans_pkg;
					_tmp59_ = alpm_pkg_get_name (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strdup (_tmp60_);
					g_hash_table_add (_tmp57_, _tmp61_);
					_tmp62_ = trans_pkg;
					_tmp63_ = alpm_pkg_get_depends (_tmp62_);
					_tmp64_ = _tmp63_;
					depends = _tmp64_;
					while (TRUE) {
						alpm_list_t* _tmp65_;
						alpm_pkg_t* satisfier = NULL;
						alpm_db_t* _tmp66_;
						alpm_db_t* _tmp67_;
						alpm_list_t* _tmp68_;
						alpm_list_t* _tmp69_;
						alpm_list_t* _tmp70_;
						gconstpointer _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						alpm_pkg_t* _tmp74_;
						alpm_pkg_t* _tmp75_;
						alpm_pkg_t* _tmp76_;
						_tmp65_ = depends;
						if (!(_tmp65_ != NULL)) {
							break;
						}
						_tmp66_ = alpm_get_localdb (alpm_handle);
						_tmp67_ = _tmp66_;
						_tmp68_ = alpm_db_get_pkgcache (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = depends;
						_tmp71_ = _tmp70_->data;
						_tmp72_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = alpm_find_satisfier (_tmp69_, _tmp73_);
						_tmp75_ = _tmp74_;
						_g_free0 (_tmp73_);
						satisfier = _tmp75_;
						_tmp76_ = satisfier;
						if (_tmp76_ != NULL) {
							gboolean _tmp77_ = FALSE;
							GHashTable* _tmp78_;
							alpm_pkg_t* _tmp79_;
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							_tmp78_ = self->priv->to_remove;
							_tmp79_ = satisfier;
							_tmp80_ = alpm_pkg_get_name (_tmp79_);
							_tmp81_ = _tmp80_;
							if (!g_hash_table_contains (_tmp78_, _tmp81_)) {
								GHashTable* _tmp82_;
								alpm_pkg_t* _tmp83_;
								const gchar* _tmp84_;
								const gchar* _tmp85_;
								_tmp82_ = self->priv->required_to_remove;
								_tmp83_ = satisfier;
								_tmp84_ = alpm_pkg_get_name (_tmp83_);
								_tmp85_ = _tmp84_;
								_tmp77_ = !g_hash_table_contains (_tmp82_, _tmp85_);
							} else {
								_tmp77_ = FALSE;
							}
							if (_tmp77_) {
								alpm_pkg_t* _tmp86_;
								_tmp86_ = satisfier;
								deps_to_check = alpm_list_add (deps_to_check, _tmp86_);
							}
						}
						depends = alpm_list_next (depends);
					}
				}
			}
		}
	}
	_tmp87_ = deps_to_check;
	if (_tmp87_ != NULL) {
		alpm_list_t* _tmp88_;
		_tmp88_ = deps_to_check;
		pamac_alpm_utils_check_orphans_to_remove (self, alpm_handle, _tmp88_);
	}
	_alpm_list_free0 (deps_to_check);
}

static gboolean
pamac_alpm_utils_trans_prepare (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle,
                                alpm_db_t* aur_db)
{
	gboolean success = FALSE;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = pamac_alpm_utils_trans_init (self, alpm_handle, self->priv->trans_flags, TRUE);
	if (success) {
		_tmp0_ = self->priv->sysupgrade;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		success = pamac_alpm_utils_trans_sysupgrade (self, alpm_handle, TRUE);
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp1_;
			GHashTableIter _tmp2_ = {0};
			const gchar* name = NULL;
			_tmp1_ = self->priv->to_install;
			g_hash_table_iter_init (&_tmp2_, _tmp1_);
			_name_it = _tmp2_;
			while (TRUE) {
				gconstpointer _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp3_;
				_tmp4_ = name;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp5_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp6_;
			GHashTableIter _tmp7_ = {0};
			const gchar* name = NULL;
			_tmp6_ = self->priv->deps_to_install;
			g_hash_table_iter_init (&_tmp7_, _tmp6_);
			_name_it = _tmp7_;
			while (TRUE) {
				gconstpointer _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp8_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp8_;
				_tmp9_ = name;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = name;
				success = pamac_alpm_utils_trans_add_pkg (self, alpm_handle, _tmp10_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	_tmp11_ = self->priv->to_build;
	_tmp12_ = g_hash_table_size (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > ((guint) 0)) {
		alpm_list_t* dbs = NULL;
		dbs = NULL;
		dbs = alpm_list_add (dbs, aur_db);
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp14_;
			GHashTableIter _tmp15_ = {0};
			const gchar* name = NULL;
			_tmp14_ = self->priv->to_build;
			g_hash_table_iter_init (&_tmp15_, _tmp14_);
			_name_it = _tmp15_;
			while (TRUE) {
				gconstpointer _tmp16_;
				const gchar* _tmp17_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp18_;
				const gchar* _tmp19_;
				alpm_pkg_t* _tmp20_;
				alpm_pkg_t* _tmp21_;
				_tmp16_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp16_;
				_tmp17_ = name;
				if (!(_tmp17_ != NULL)) {
					break;
				}
				_tmp18_ = dbs;
				_tmp19_ = name;
				_tmp20_ = alpm_find_dbs_satisfier (alpm_handle, _tmp18_, _tmp19_);
				pkg = _tmp20_;
				_tmp21_ = pkg;
				if (_tmp21_ == NULL) {
					GPtrArray* details = NULL;
					GPtrArray* _tmp22_;
					GPtrArray* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					GPtrArray* _tmp26_;
					_tmp22_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
					details = _tmp22_;
					_tmp23_ = details;
					_tmp24_ = name;
					_tmp25_ = g_strdup_printf (_ ("target not found: %s"), _tmp24_);
					g_ptr_array_add (_tmp23_, _tmp25_);
					_tmp26_ = details;
					pamac_alpm_utils_do_emit_error (self, _ ("Failed to prepare transaction"), _tmp26_);
					success = FALSE;
					_g_ptr_array_unref0 (details);
					break;
				} else {
					alpm_pkg_t* _tmp27_;
					_tmp27_ = pkg;
					success = pamac_alpm_utils_trans_add_pkg_real (self, alpm_handle, _tmp27_, TRUE);
					if (!success) {
						break;
					}
				}
			}
		}
		_alpm_list_free0 (dbs);
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp28_;
			GHashTableIter _tmp29_ = {0};
			const gchar* name = NULL;
			_tmp28_ = self->priv->to_remove;
			g_hash_table_iter_init (&_tmp29_, _tmp28_);
			_name_it = _tmp29_;
			while (TRUE) {
				gconstpointer _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp30_;
				_tmp31_ = name;
				if (!(_tmp31_ != NULL)) {
					break;
				}
				_tmp32_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp32_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp33_;
			GHashTableIter _tmp34_ = {0};
			const gchar* name = NULL;
			_tmp33_ = self->priv->required_to_remove;
			g_hash_table_iter_init (&_tmp34_, _tmp33_);
			_name_it = _tmp34_;
			while (TRUE) {
				gconstpointer _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp35_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp35_;
				_tmp36_ = name;
				if (!(_tmp36_ != NULL)) {
					break;
				}
				_tmp37_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp37_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _name_it = {0};
			GHashTable* _tmp38_;
			GHashTableIter _tmp39_ = {0};
			const gchar* name = NULL;
			_tmp38_ = self->priv->orphans_to_remove;
			g_hash_table_iter_init (&_tmp39_, _tmp38_);
			_name_it = _tmp39_;
			while (TRUE) {
				gconstpointer _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = _vala_hash_set_next_value (&_name_it);
				name = (const gchar*) _tmp40_;
				_tmp41_ = name;
				if (!(_tmp41_ != NULL)) {
					break;
				}
				_tmp42_ = name;
				success = pamac_alpm_utils_trans_remove_pkg (self, alpm_handle, _tmp42_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp43_;
			GHashTableIter _tmp44_ = {0};
			const gchar* path = NULL;
			_tmp43_ = self->priv->local_paths;
			g_hash_table_iter_init (&_tmp44_, _tmp43_);
			_path_it = _tmp44_;
			while (TRUE) {
				gconstpointer _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				_tmp45_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp45_;
				_tmp46_ = path;
				if (!(_tmp46_ != NULL)) {
					break;
				}
				_tmp47_ = path;
				_tmp48_ = alpm_option_get_local_file_siglevel (alpm_handle);
				_tmp49_ = _tmp48_;
				success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp47_, _tmp49_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp50_;
			GHashTableIter _tmp51_ = {0};
			const gchar* path = NULL;
			_tmp50_ = self->priv->remote_paths;
			g_hash_table_iter_init (&_tmp51_, _tmp50_);
			_path_it = _tmp51_;
			while (TRUE) {
				gconstpointer _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				_tmp52_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp52_;
				_tmp53_ = path;
				if (!(_tmp53_ != NULL)) {
					break;
				}
				_tmp54_ = path;
				_tmp55_ = alpm_option_get_remote_file_siglevel (alpm_handle);
				_tmp56_ = _tmp55_;
				success = pamac_alpm_utils_trans_load_pkg (self, alpm_handle, _tmp54_, _tmp56_, TRUE);
				if (!success) {
					break;
				}
			}
		}
	}
	if (success) {
		success = pamac_alpm_utils_trans_prepare_real (self, alpm_handle, TRUE);
	} else {
		pamac_alpm_utils_trans_release (self, alpm_handle);
	}
	result = success;
	return result;
}

static void
pamac_alpm_utils_get_transaction_summary (PamacAlpmUtils* self,
                                          alpm_handle_t* alpm_handle,
                                          PamacTransactionSummary** summary)
{
	GHashTable* checked = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	alpm_list_t* pkgs_to_add = NULL;
	alpm_list_t* _tmp3_;
	GHashTable* _tmp175_;
	alpm_list_t* pkgs_to_remove = NULL;
	alpm_list_t* _tmp176_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*summary != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	checked = _tmp2_;
	_tmp3_ = alpm_trans_get_add (alpm_handle);
	pkgs_to_add = _tmp3_;
	while (TRUE) {
		alpm_list_t* _tmp4_;
		alpm_pkg_t* trans_pkg = NULL;
		alpm_list_t* _tmp5_;
		gconstpointer _tmp6_;
		alpm_db_t* db = NULL;
		alpm_pkg_t* _tmp7_;
		alpm_db_t* _tmp8_;
		alpm_db_t* _tmp9_;
		const gchar* trans_pkg_name = NULL;
		alpm_pkg_t* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		alpm_db_t* _tmp14_;
		_tmp4_ = pkgs_to_add;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = pkgs_to_add;
		_tmp6_ = _tmp5_->data;
		trans_pkg = (alpm_pkg_t*) _tmp6_;
		_tmp7_ = trans_pkg;
		_tmp8_ = alpm_pkg_get_db (_tmp7_);
		_tmp9_ = _tmp8_;
		db = _tmp9_;
		_tmp10_ = trans_pkg;
		_tmp11_ = alpm_pkg_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		trans_pkg_name = _tmp12_;
		_tmp14_ = db;
		if (_tmp14_ != NULL) {
			alpm_db_t* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = db;
			_tmp16_ = alpm_db_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp13_ = g_strcmp0 (_tmp17_, "pamac_aur") == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			PamacAlpmPackage* pkg = NULL;
			alpm_pkg_t* _tmp18_;
			PamacAlpmPackage* _tmp19_;
			GPtrArray* _tmp20_;
			GPtrArray* _tmp21_;
			alpm_pkg_t* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GEqualFunc _tmp25_;
			PamacAlpmPackage* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			GPtrArray* _tmp75_;
			GPtrArray* _tmp76_;
			PamacAlpmPackage* _tmp77_;
			PamacPackage* _tmp78_;
			_tmp18_ = trans_pkg;
			_tmp19_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp18_);
			pkg = _tmp19_;
			_tmp20_ = pamac_transaction_summary_get_aur_pkgbases_to_build (*summary);
			_tmp21_ = _tmp20_;
			_tmp22_ = trans_pkg;
			_tmp23_ = alpm_pkg_get_base (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_str_equal;
			if (!g_ptr_array_find_with_equal_func (_tmp21_, _tmp24_, _tmp25_, NULL)) {
				GPtrArray* _tmp26_;
				GPtrArray* _tmp27_;
				alpm_pkg_t* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp26_ = pamac_transaction_summary_get_aur_pkgbases_to_build (*summary);
				_tmp27_ = _tmp26_;
				_tmp28_ = trans_pkg;
				_tmp29_ = alpm_pkg_get_base (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup (_tmp30_);
				g_ptr_array_add (_tmp27_, _tmp31_);
			}
			_tmp32_ = pkg;
			_tmp33_ = pamac_package_get_installed_version ((PamacPackage*) _tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_ == NULL) {
				GHashTable* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = self->priv->to_build;
				_tmp36_ = trans_pkg_name;
				if (!g_hash_table_contains (_tmp35_, _tmp36_)) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp37_;
					dep_found = FALSE;
					_tmp37_ = trans_pkg;
					check_pkg = _tmp37_;
					while (TRUE) {
						alpm_list_t* pkg_requiredby = NULL;
						alpm_pkg_t* _tmp38_;
						alpm_list_t* _tmp39_;
						alpm_list_t* requiredby_list = NULL;
						alpm_list_t* _tmp40_;
						alpm_list_t* _tmp74_;
						if (!(!dep_found)) {
							break;
						}
						_tmp38_ = check_pkg;
						_tmp39_ = alpm_pkg_compute_requiredby (_tmp38_);
						pkg_requiredby = _tmp39_;
						_tmp40_ = pkg_requiredby;
						requiredby_list = _tmp40_;
						while (TRUE) {
							alpm_list_t* _tmp41_;
							const gchar* requiredby_name = NULL;
							alpm_list_t* _tmp42_;
							gconstpointer _tmp43_;
							gboolean check_pkg_found = FALSE;
							alpm_list_t* pkgs_to_add2 = NULL;
							alpm_list_t* _tmp44_;
							gboolean _tmp73_ = FALSE;
							_tmp41_ = requiredby_list;
							if (!(_tmp41_ != NULL)) {
								break;
							}
							_tmp42_ = requiredby_list;
							_tmp43_ = _tmp42_->data;
							requiredby_name = _tmp43_;
							check_pkg_found = FALSE;
							_tmp44_ = alpm_trans_get_add (alpm_handle);
							pkgs_to_add2 = _tmp44_;
							while (TRUE) {
								alpm_list_t* _tmp45_;
								alpm_pkg_t* pkg_to_add = NULL;
								alpm_list_t* _tmp46_;
								gconstpointer _tmp47_;
								const gchar* pkg_to_add_name = NULL;
								alpm_pkg_t* _tmp48_;
								const gchar* _tmp49_;
								const gchar* _tmp50_;
								const gchar* _tmp51_;
								const gchar* _tmp52_;
								_tmp45_ = pkgs_to_add2;
								if (!(_tmp45_ != NULL)) {
									break;
								}
								_tmp46_ = pkgs_to_add2;
								_tmp47_ = _tmp46_->data;
								pkg_to_add = (alpm_pkg_t*) _tmp47_;
								_tmp48_ = pkg_to_add;
								_tmp49_ = alpm_pkg_get_name (_tmp48_);
								_tmp50_ = _tmp49_;
								pkg_to_add_name = _tmp50_;
								_tmp51_ = pkg_to_add_name;
								_tmp52_ = requiredby_name;
								if (g_strcmp0 (_tmp51_, _tmp52_) == 0) {
									GHashTable* _tmp53_;
									const gchar* _tmp54_;
									_tmp53_ = self->priv->to_build;
									_tmp54_ = pkg_to_add_name;
									if (g_hash_table_contains (_tmp53_, _tmp54_)) {
										PamacAlpmPackage* _tmp55_;
										GPtrArray* _tmp56_;
										GPtrArray* _tmp57_;
										const gchar* _tmp58_;
										_tmp55_ = pkg;
										_tmp56_ = pamac_alpm_package_get_requiredby (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp58_ = requiredby_name;
										requiredby_name = NULL;
										g_ptr_array_add (_tmp57_, (gchar*) _tmp58_);
										dep_found = TRUE;
									} else {
										GHashTable* _tmp59_;
										const gchar* _tmp60_;
										_tmp59_ = checked;
										_tmp60_ = pkg_to_add_name;
										if (g_hash_table_contains (_tmp59_, _tmp60_)) {
											gint i = 0;
											GHashTable* _tmp61_;
											const gchar* _tmp62_;
											gconstpointer _tmp63_;
											_tmp61_ = checked;
											_tmp62_ = pkg_to_add_name;
											_tmp63_ = g_hash_table_lookup (_tmp61_, _tmp62_);
											i = (gint) ((gintptr) _tmp63_);
											if (i < 100) {
												alpm_pkg_t* _tmp64_;
												GHashTable* _tmp65_;
												const gchar* _tmp66_;
												gchar* _tmp67_;
												_tmp64_ = pkg_to_add;
												check_pkg = _tmp64_;
												check_pkg_found = TRUE;
												_tmp65_ = checked;
												_tmp66_ = pkg_to_add_name;
												_tmp67_ = g_strdup (_tmp66_);
												g_hash_table_insert (_tmp65_, _tmp67_, (gpointer) ((gintptr) (i + 1)));
											}
										} else {
											alpm_pkg_t* _tmp68_;
											GHashTable* _tmp69_;
											const gchar* _tmp70_;
											gchar* _tmp71_;
											_tmp68_ = pkg_to_add;
											check_pkg = _tmp68_;
											check_pkg_found = TRUE;
											_tmp69_ = checked;
											_tmp70_ = pkg_to_add_name;
											_tmp71_ = g_strdup (_tmp70_);
											g_hash_table_insert (_tmp69_, _tmp71_, (gpointer) ((gintptr) 0));
										}
									}
									break;
								}
								pkgs_to_add2 = alpm_list_next (pkgs_to_add2);
							}
							if (!dep_found) {
								const gchar* _tmp72_;
								_tmp72_ = requiredby_name;
								_g_free0 (_tmp72_);
							}
							if (dep_found) {
								_tmp73_ = TRUE;
							} else {
								_tmp73_ = check_pkg_found;
							}
							if (_tmp73_) {
								break;
							}
							requiredby_list = alpm_list_next (requiredby_list);
						}
						_tmp74_ = requiredby_list;
						if (_tmp74_ == NULL) {
							_alpm_list_free0 (pkg_requiredby);
							break;
						}
						_alpm_list_free0 (pkg_requiredby);
					}
				}
			}
			_tmp75_ = pamac_transaction_summary_get_to_build (*summary);
			_tmp76_ = _tmp75_;
			_tmp77_ = pkg;
			_tmp78_ = _g_object_ref0 ((PamacPackage*) _tmp77_);
			g_ptr_array_add (_tmp76_, _tmp78_);
			_g_object_unref0 (pkg);
		} else {
			PamacAlpmPackage* pkg = NULL;
			alpm_pkg_t* _tmp79_;
			PamacAlpmPackage* _tmp80_;
			PamacAlpmPackage* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			alpm_db_t* _tmp170_;
			_tmp79_ = trans_pkg;
			_tmp80_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp79_);
			pkg = _tmp80_;
			_tmp81_ = pkg;
			_tmp82_ = pamac_package_get_installed_version ((PamacPackage*) _tmp81_);
			_tmp83_ = _tmp82_;
			if (_tmp83_ == NULL) {
				gboolean _tmp84_ = FALSE;
				alpm_db_t* _tmp85_;
				GPtrArray* _tmp148_;
				GPtrArray* _tmp149_;
				PamacAlpmPackage* _tmp150_;
				PamacPackage* _tmp151_;
				_tmp85_ = db;
				if (_tmp85_ != NULL) {
					GHashTable* _tmp86_;
					const gchar* _tmp87_;
					_tmp86_ = self->priv->to_install;
					_tmp87_ = trans_pkg_name;
					_tmp84_ = !g_hash_table_contains (_tmp86_, _tmp87_);
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp88_;
					dep_found = FALSE;
					_tmp88_ = trans_pkg;
					check_pkg = _tmp88_;
					while (TRUE) {
						alpm_list_t* pkg_requiredby = NULL;
						alpm_pkg_t* _tmp89_;
						alpm_list_t* _tmp90_;
						alpm_list_t* requiredby_list = NULL;
						alpm_list_t* _tmp91_;
						alpm_list_t* _tmp128_;
						if (!(!dep_found)) {
							break;
						}
						_tmp89_ = check_pkg;
						_tmp90_ = alpm_pkg_compute_requiredby (_tmp89_);
						pkg_requiredby = _tmp90_;
						_tmp91_ = pkg_requiredby;
						requiredby_list = _tmp91_;
						while (TRUE) {
							alpm_list_t* _tmp92_;
							const gchar* requiredby_name = NULL;
							alpm_list_t* _tmp93_;
							gconstpointer _tmp94_;
							gboolean check_pkg_found = FALSE;
							alpm_list_t* pkgs_to_add2 = NULL;
							alpm_list_t* _tmp95_;
							gboolean _tmp127_ = FALSE;
							_tmp92_ = requiredby_list;
							if (!(_tmp92_ != NULL)) {
								break;
							}
							_tmp93_ = requiredby_list;
							_tmp94_ = _tmp93_->data;
							requiredby_name = _tmp94_;
							check_pkg_found = FALSE;
							_tmp95_ = alpm_trans_get_add (alpm_handle);
							pkgs_to_add2 = _tmp95_;
							while (TRUE) {
								alpm_list_t* _tmp96_;
								alpm_pkg_t* pkg_to_add = NULL;
								alpm_list_t* _tmp97_;
								gconstpointer _tmp98_;
								const gchar* pkg_to_add_name = NULL;
								alpm_pkg_t* _tmp99_;
								const gchar* _tmp100_;
								const gchar* _tmp101_;
								const gchar* _tmp102_;
								const gchar* _tmp103_;
								_tmp96_ = pkgs_to_add2;
								if (!(_tmp96_ != NULL)) {
									break;
								}
								_tmp97_ = pkgs_to_add2;
								_tmp98_ = _tmp97_->data;
								pkg_to_add = (alpm_pkg_t*) _tmp98_;
								_tmp99_ = pkg_to_add;
								_tmp100_ = alpm_pkg_get_name (_tmp99_);
								_tmp101_ = _tmp100_;
								pkg_to_add_name = _tmp101_;
								_tmp102_ = pkg_to_add_name;
								_tmp103_ = requiredby_name;
								if (g_strcmp0 (_tmp102_, _tmp103_) == 0) {
									gboolean _tmp104_ = FALSE;
									GHashTable* _tmp105_;
									const gchar* _tmp106_;
									_tmp105_ = self->priv->to_install;
									_tmp106_ = pkg_to_add_name;
									if (g_hash_table_contains (_tmp105_, _tmp106_)) {
										_tmp104_ = TRUE;
									} else {
										GHashTable* _tmp107_;
										const gchar* _tmp108_;
										_tmp107_ = self->priv->to_build;
										_tmp108_ = pkg_to_add_name;
										_tmp104_ = g_hash_table_contains (_tmp107_, _tmp108_);
									}
									if (_tmp104_) {
										PamacAlpmPackage* _tmp109_;
										GPtrArray* _tmp110_;
										GPtrArray* _tmp111_;
										const gchar* _tmp112_;
										_tmp109_ = pkg;
										_tmp110_ = pamac_alpm_package_get_requiredby (_tmp109_);
										_tmp111_ = _tmp110_;
										_tmp112_ = requiredby_name;
										requiredby_name = NULL;
										g_ptr_array_add (_tmp111_, (gchar*) _tmp112_);
										dep_found = TRUE;
									} else {
										GHashTable* _tmp113_;
										const gchar* _tmp114_;
										_tmp113_ = checked;
										_tmp114_ = pkg_to_add_name;
										if (g_hash_table_contains (_tmp113_, _tmp114_)) {
											gint i = 0;
											GHashTable* _tmp115_;
											const gchar* _tmp116_;
											gconstpointer _tmp117_;
											_tmp115_ = checked;
											_tmp116_ = pkg_to_add_name;
											_tmp117_ = g_hash_table_lookup (_tmp115_, _tmp116_);
											i = (gint) ((gintptr) _tmp117_);
											if (i < 100) {
												alpm_pkg_t* _tmp118_;
												GHashTable* _tmp119_;
												const gchar* _tmp120_;
												gchar* _tmp121_;
												_tmp118_ = pkg_to_add;
												check_pkg = _tmp118_;
												check_pkg_found = TRUE;
												_tmp119_ = checked;
												_tmp120_ = pkg_to_add_name;
												_tmp121_ = g_strdup (_tmp120_);
												g_hash_table_insert (_tmp119_, _tmp121_, (gpointer) ((gintptr) (i + 1)));
											}
										} else {
											alpm_pkg_t* _tmp122_;
											GHashTable* _tmp123_;
											const gchar* _tmp124_;
											gchar* _tmp125_;
											_tmp122_ = pkg_to_add;
											check_pkg = _tmp122_;
											check_pkg_found = TRUE;
											_tmp123_ = checked;
											_tmp124_ = pkg_to_add_name;
											_tmp125_ = g_strdup (_tmp124_);
											g_hash_table_insert (_tmp123_, _tmp125_, (gpointer) ((gintptr) 0));
										}
									}
									break;
								}
								pkgs_to_add2 = alpm_list_next (pkgs_to_add2);
							}
							if (!dep_found) {
								const gchar* _tmp126_;
								_tmp126_ = requiredby_name;
								_g_free0 (_tmp126_);
							}
							if (dep_found) {
								_tmp127_ = TRUE;
							} else {
								_tmp127_ = check_pkg_found;
							}
							if (_tmp127_) {
								break;
							}
							requiredby_list = alpm_list_next (requiredby_list);
						}
						_tmp128_ = requiredby_list;
						if (_tmp128_ == NULL) {
							_alpm_list_free0 (pkg_requiredby);
							break;
						}
						_alpm_list_free0 (pkg_requiredby);
					}
					if (!dep_found) {
						alpm_list_t* depends_list = NULL;
						alpm_pkg_t* _tmp129_;
						alpm_list_t* _tmp130_;
						alpm_list_t* _tmp131_;
						_tmp129_ = trans_pkg;
						_tmp130_ = alpm_pkg_get_replaces (_tmp129_);
						_tmp131_ = _tmp130_;
						depends_list = _tmp131_;
						while (TRUE) {
							alpm_list_t* _tmp132_;
							gchar* depstring = NULL;
							alpm_list_t* _tmp133_;
							gconstpointer _tmp134_;
							gchar* _tmp135_;
							alpm_db_t* _tmp136_;
							alpm_db_t* _tmp137_;
							alpm_list_t* _tmp138_;
							alpm_list_t* _tmp139_;
							const gchar* _tmp140_;
							alpm_pkg_t* _tmp141_;
							_tmp132_ = depends_list;
							if (!(_tmp132_ != NULL)) {
								break;
							}
							_tmp133_ = depends_list;
							_tmp134_ = _tmp133_->data;
							_tmp135_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp134_);
							depstring = _tmp135_;
							_tmp136_ = alpm_get_localdb (alpm_handle);
							_tmp137_ = _tmp136_;
							_tmp138_ = alpm_db_get_pkgcache (_tmp137_);
							_tmp139_ = _tmp138_;
							_tmp140_ = depstring;
							_tmp141_ = alpm_find_satisfier (_tmp139_, _tmp140_);
							if (_tmp141_ != NULL) {
								PamacAlpmPackage* _tmp142_;
								GPtrArray* _tmp143_;
								GPtrArray* _tmp144_;
								alpm_list_t* _tmp145_;
								gconstpointer _tmp146_;
								gchar* _tmp147_;
								_tmp142_ = pkg;
								_tmp143_ = pamac_alpm_package_get_replaces (_tmp142_);
								_tmp144_ = _tmp143_;
								_tmp145_ = depends_list;
								_tmp146_ = _tmp145_->data;
								_tmp147_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp146_);
								g_ptr_array_add (_tmp144_, _tmp147_);
								_g_free0 (depstring);
								break;
							}
							depends_list = alpm_list_next (depends_list);
							_g_free0 (depstring);
						}
					}
				}
				_tmp148_ = pamac_transaction_summary_get_to_install (*summary);
				_tmp149_ = _tmp148_;
				_tmp150_ = pkg;
				_tmp151_ = _g_object_ref0 ((PamacPackage*) _tmp150_);
				g_ptr_array_add (_tmp149_, _tmp151_);
			} else {
				gint cmp = 0;
				PamacAlpmPackage* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				PamacAlpmPackage* _tmp155_;
				const gchar* _tmp156_;
				const gchar* _tmp157_;
				_tmp152_ = pkg;
				_tmp153_ = pamac_package_get_version ((PamacPackage*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = pkg;
				_tmp156_ = pamac_package_get_installed_version ((PamacPackage*) _tmp155_);
				_tmp157_ = _tmp156_;
				cmp = alpm_pkg_vercmp (_tmp154_, _tmp157_);
				if (cmp == 1) {
					GPtrArray* _tmp158_;
					GPtrArray* _tmp159_;
					PamacAlpmPackage* _tmp160_;
					PamacPackage* _tmp161_;
					_tmp158_ = pamac_transaction_summary_get_to_upgrade (*summary);
					_tmp159_ = _tmp158_;
					_tmp160_ = pkg;
					_tmp161_ = _g_object_ref0 ((PamacPackage*) _tmp160_);
					g_ptr_array_add (_tmp159_, _tmp161_);
				} else {
					if (cmp == 0) {
						GPtrArray* _tmp162_;
						GPtrArray* _tmp163_;
						PamacAlpmPackage* _tmp164_;
						PamacPackage* _tmp165_;
						_tmp162_ = pamac_transaction_summary_get_to_reinstall (*summary);
						_tmp163_ = _tmp162_;
						_tmp164_ = pkg;
						_tmp165_ = _g_object_ref0 ((PamacPackage*) _tmp164_);
						g_ptr_array_add (_tmp163_, _tmp165_);
					} else {
						GPtrArray* _tmp166_;
						GPtrArray* _tmp167_;
						PamacAlpmPackage* _tmp168_;
						PamacPackage* _tmp169_;
						_tmp166_ = pamac_transaction_summary_get_to_downgrade (*summary);
						_tmp167_ = _tmp166_;
						_tmp168_ = pkg;
						_tmp169_ = _g_object_ref0 ((PamacPackage*) _tmp168_);
						g_ptr_array_add (_tmp167_, _tmp169_);
					}
				}
			}
			_tmp170_ = db;
			if (_tmp170_ == NULL) {
				GPtrArray* _tmp171_;
				GPtrArray* _tmp172_;
				const gchar* _tmp173_;
				gchar* _tmp174_;
				_tmp171_ = pamac_transaction_summary_get_to_load (*summary);
				_tmp172_ = _tmp171_;
				_tmp173_ = trans_pkg_name;
				_tmp174_ = g_strdup (_tmp173_);
				g_ptr_array_add (_tmp172_, _tmp174_);
			}
			_g_object_unref0 (pkg);
		}
		pkgs_to_add = alpm_list_next (pkgs_to_add);
	}
	_tmp175_ = checked;
	g_hash_table_remove_all (_tmp175_);
	_tmp176_ = alpm_trans_get_remove (alpm_handle);
	pkgs_to_remove = _tmp176_;
	while (TRUE) {
		alpm_list_t* _tmp177_;
		alpm_pkg_t* trans_pkg = NULL;
		alpm_list_t* _tmp178_;
		gconstpointer _tmp179_;
		const gchar* trans_pkg_name = NULL;
		alpm_pkg_t* _tmp180_;
		const gchar* _tmp181_;
		const gchar* _tmp182_;
		PamacAlpmPackage* pkg = NULL;
		alpm_pkg_t* _tmp183_;
		PamacAlpmPackage* _tmp184_;
		GHashTable* _tmp185_;
		const gchar* _tmp186_;
		_tmp177_ = pkgs_to_remove;
		if (!(_tmp177_ != NULL)) {
			break;
		}
		_tmp178_ = pkgs_to_remove;
		_tmp179_ = _tmp178_->data;
		trans_pkg = (alpm_pkg_t*) _tmp179_;
		_tmp180_ = trans_pkg;
		_tmp181_ = alpm_pkg_get_name (_tmp180_);
		_tmp182_ = _tmp181_;
		trans_pkg_name = _tmp182_;
		_tmp183_ = trans_pkg;
		_tmp184_ = pamac_alpm_utils_initialise_pkg (self, alpm_handle, _tmp183_);
		pkg = _tmp184_;
		_tmp185_ = self->priv->to_remove;
		_tmp186_ = trans_pkg_name;
		if (g_hash_table_contains (_tmp185_, _tmp186_)) {
			GPtrArray* _tmp187_;
			GPtrArray* _tmp188_;
			PamacAlpmPackage* _tmp189_;
			PamacPackage* _tmp190_;
			_tmp187_ = pamac_transaction_summary_get_to_remove (*summary);
			_tmp188_ = _tmp187_;
			_tmp189_ = pkg;
			_tmp190_ = _g_object_ref0 ((PamacPackage*) _tmp189_);
			g_ptr_array_add (_tmp188_, _tmp190_);
		} else {
			GHashTable* _tmp191_;
			const gchar* _tmp192_;
			_tmp191_ = self->priv->required_to_remove;
			_tmp192_ = trans_pkg_name;
			if (g_hash_table_contains (_tmp191_, _tmp192_)) {
				gboolean dep_found = FALSE;
				alpm_pkg_t* check_pkg = NULL;
				alpm_pkg_t* _tmp193_;
				GPtrArray* _tmp232_;
				GPtrArray* _tmp233_;
				PamacAlpmPackage* _tmp234_;
				PamacPackage* _tmp235_;
				dep_found = FALSE;
				_tmp193_ = trans_pkg;
				check_pkg = _tmp193_;
				while (TRUE) {
					alpm_list_t* depends_list = NULL;
					alpm_pkg_t* _tmp194_;
					alpm_list_t* _tmp195_;
					alpm_list_t* _tmp196_;
					alpm_list_t* _tmp231_;
					if (!(!dep_found)) {
						break;
					}
					_tmp194_ = check_pkg;
					_tmp195_ = alpm_pkg_get_depends (_tmp194_);
					_tmp196_ = _tmp195_;
					depends_list = _tmp196_;
					while (TRUE) {
						alpm_list_t* _tmp197_;
						gchar* depstring = NULL;
						alpm_list_t* _tmp198_;
						gconstpointer _tmp199_;
						gchar* _tmp200_;
						alpm_pkg_t* dep = NULL;
						alpm_list_t* _tmp201_;
						const gchar* _tmp202_;
						alpm_pkg_t* _tmp203_;
						alpm_pkg_t* _tmp204_;
						_tmp197_ = depends_list;
						if (!(_tmp197_ != NULL)) {
							break;
						}
						_tmp198_ = depends_list;
						_tmp199_ = _tmp198_->data;
						_tmp200_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp199_);
						depstring = _tmp200_;
						_tmp201_ = alpm_trans_get_remove (alpm_handle);
						_tmp202_ = depstring;
						_tmp203_ = alpm_find_satisfier (_tmp201_, _tmp202_);
						dep = _tmp203_;
						_tmp204_ = dep;
						if (_tmp204_ != NULL) {
							GHashTable* _tmp205_;
							alpm_pkg_t* _tmp206_;
							const gchar* _tmp207_;
							const gchar* _tmp208_;
							gchar* _tmp209_;
							gboolean _tmp210_ = FALSE;
							GHashTable* _tmp211_;
							alpm_pkg_t* _tmp212_;
							const gchar* _tmp213_;
							const gchar* _tmp214_;
							_tmp205_ = checked;
							_tmp206_ = check_pkg;
							_tmp207_ = alpm_pkg_get_name (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp209_ = g_strdup (_tmp208_);
							g_hash_table_insert (_tmp205_, _tmp209_, (gpointer) ((gintptr) 0));
							_tmp211_ = self->priv->to_remove;
							_tmp212_ = dep;
							_tmp213_ = alpm_pkg_get_name (_tmp212_);
							_tmp214_ = _tmp213_;
							if (g_hash_table_contains (_tmp211_, _tmp214_)) {
								_tmp210_ = TRUE;
							} else {
								GHashTable* _tmp215_;
								alpm_pkg_t* _tmp216_;
								const gchar* _tmp217_;
								const gchar* _tmp218_;
								_tmp215_ = self->priv->conflicts_to_remove;
								_tmp216_ = dep;
								_tmp217_ = alpm_pkg_get_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp210_ = g_hash_table_contains (_tmp215_, _tmp218_);
							}
							if (_tmp210_) {
								PamacAlpmPackage* _tmp219_;
								GPtrArray* _tmp220_;
								GPtrArray* _tmp221_;
								alpm_pkg_t* _tmp222_;
								const gchar* _tmp223_;
								const gchar* _tmp224_;
								gchar* _tmp225_;
								_tmp219_ = pkg;
								_tmp220_ = pamac_alpm_package_get_depends (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = dep;
								_tmp223_ = alpm_pkg_get_name (_tmp222_);
								_tmp224_ = _tmp223_;
								_tmp225_ = g_strdup (_tmp224_);
								g_ptr_array_add (_tmp221_, _tmp225_);
								dep_found = TRUE;
							} else {
								GHashTable* _tmp226_;
								alpm_pkg_t* _tmp227_;
								const gchar* _tmp228_;
								const gchar* _tmp229_;
								_tmp226_ = checked;
								_tmp227_ = dep;
								_tmp228_ = alpm_pkg_get_name (_tmp227_);
								_tmp229_ = _tmp228_;
								if (g_hash_table_contains (_tmp226_, _tmp229_)) {
									dep_found = TRUE;
								} else {
									alpm_pkg_t* _tmp230_;
									_tmp230_ = dep;
									check_pkg = _tmp230_;
								}
							}
							_g_free0 (depstring);
							break;
						}
						depends_list = alpm_list_next (depends_list);
						_g_free0 (depstring);
					}
					_tmp231_ = depends_list;
					if (_tmp231_ == NULL) {
						break;
					}
				}
				_tmp232_ = pamac_transaction_summary_get_to_remove (*summary);
				_tmp233_ = _tmp232_;
				_tmp234_ = pkg;
				_tmp235_ = _g_object_ref0 ((PamacPackage*) _tmp234_);
				g_ptr_array_add (_tmp233_, _tmp235_);
			} else {
				GHashTable* _tmp236_;
				const gchar* _tmp237_;
				_tmp236_ = self->priv->orphans_to_remove;
				_tmp237_ = trans_pkg_name;
				if (g_hash_table_contains (_tmp236_, _tmp237_)) {
					gboolean dep_found = FALSE;
					alpm_pkg_t* check_pkg = NULL;
					alpm_pkg_t* _tmp238_;
					GPtrArray* _tmp265_;
					GPtrArray* _tmp266_;
					PamacAlpmPackage* _tmp267_;
					PamacPackage* _tmp268_;
					dep_found = FALSE;
					_tmp238_ = trans_pkg;
					check_pkg = _tmp238_;
					while (TRUE) {
						alpm_list_t* requiredby = NULL;
						alpm_pkg_t* _tmp239_;
						alpm_list_t* _tmp240_;
						alpm_list_t* _tmp241_;
						if (!(!dep_found)) {
							break;
						}
						_tmp239_ = check_pkg;
						_tmp240_ = alpm_pkg_compute_requiredby (_tmp239_);
						requiredby = _tmp240_;
						_tmp241_ = requiredby;
						if (_tmp241_ != NULL) {
							const gchar* name = NULL;
							alpm_list_t* _tmp242_;
							gconstpointer _tmp243_;
							GHashTable* _tmp244_;
							const gchar* _tmp245_;
							_tmp242_ = requiredby;
							_tmp243_ = _tmp242_->data;
							name = _tmp243_;
							_tmp244_ = self->priv->to_remove;
							_tmp245_ = name;
							if (g_hash_table_contains (_tmp244_, _tmp245_)) {
								PamacAlpmPackage* _tmp246_;
								GPtrArray* _tmp247_;
								GPtrArray* _tmp248_;
								const gchar* _tmp249_;
								_tmp246_ = pkg;
								_tmp247_ = pamac_alpm_package_get_requiredby (_tmp246_);
								_tmp248_ = _tmp247_;
								_tmp249_ = name;
								name = NULL;
								g_ptr_array_add (_tmp248_, (gchar*) _tmp249_);
								dep_found = TRUE;
							} else {
								alpm_db_t* _tmp250_;
								alpm_db_t* _tmp251_;
								const gchar* _tmp252_;
								alpm_pkg_t* _tmp253_;
								const gchar* _tmp254_;
								alpm_pkg_t* _tmp255_;
								GHashTable* _tmp256_;
								alpm_pkg_t* _tmp257_;
								const gchar* _tmp258_;
								const gchar* _tmp259_;
								GHashTable* _tmp260_;
								alpm_pkg_t* _tmp261_;
								const gchar* _tmp262_;
								const gchar* _tmp263_;
								gchar* _tmp264_;
								_tmp250_ = alpm_get_localdb (alpm_handle);
								_tmp251_ = _tmp250_;
								_tmp252_ = name;
								_tmp253_ = alpm_db_get_pkg (_tmp251_, _tmp252_);
								check_pkg = _tmp253_;
								_tmp254_ = name;
								_g_free0 (_tmp254_);
								_tmp255_ = check_pkg;
								if (_tmp255_ == NULL) {
									_alpm_list_free0 (requiredby);
									break;
								}
								_tmp256_ = checked;
								_tmp257_ = check_pkg;
								_tmp258_ = alpm_pkg_get_name (_tmp257_);
								_tmp259_ = _tmp258_;
								if (g_hash_table_contains (_tmp256_, _tmp259_)) {
									_alpm_list_free0 (requiredby);
									break;
								}
								_tmp260_ = checked;
								_tmp261_ = check_pkg;
								_tmp262_ = alpm_pkg_get_name (_tmp261_);
								_tmp263_ = _tmp262_;
								_tmp264_ = g_strdup (_tmp263_);
								g_hash_table_insert (_tmp260_, _tmp264_, (gpointer) ((gintptr) 0));
							}
						} else {
							_alpm_list_free0 (requiredby);
							break;
						}
						_alpm_list_free0 (requiredby);
					}
					_tmp265_ = pamac_transaction_summary_get_to_remove (*summary);
					_tmp266_ = _tmp265_;
					_tmp267_ = pkg;
					_tmp268_ = _g_object_ref0 ((PamacPackage*) _tmp267_);
					g_ptr_array_add (_tmp266_, _tmp268_);
				} else {
					gboolean conflict_found = FALSE;
					alpm_list_t* depends_list = NULL;
					alpm_pkg_t* _tmp269_;
					alpm_list_t* _tmp270_;
					alpm_list_t* _tmp271_;
					GPtrArray* _tmp305_;
					GPtrArray* _tmp306_;
					PamacAlpmPackage* _tmp307_;
					PamacPackage* _tmp308_;
					conflict_found = FALSE;
					_tmp269_ = trans_pkg;
					_tmp270_ = alpm_pkg_get_conflicts (_tmp269_);
					_tmp271_ = _tmp270_;
					depends_list = _tmp271_;
					while (TRUE) {
						alpm_list_t* _tmp272_;
						gchar* depstring = NULL;
						alpm_list_t* _tmp273_;
						gconstpointer _tmp274_;
						gchar* _tmp275_;
						alpm_list_t* _tmp276_;
						const gchar* _tmp277_;
						alpm_pkg_t* _tmp278_;
						_tmp272_ = depends_list;
						if (!(_tmp272_ != NULL)) {
							break;
						}
						_tmp273_ = depends_list;
						_tmp274_ = _tmp273_->data;
						_tmp275_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp274_);
						depstring = _tmp275_;
						_tmp276_ = alpm_trans_get_add (alpm_handle);
						_tmp277_ = depstring;
						_tmp278_ = alpm_find_satisfier (_tmp276_, _tmp277_);
						if (_tmp278_ != NULL) {
							PamacAlpmPackage* _tmp279_;
							GPtrArray* _tmp280_;
							GPtrArray* _tmp281_;
							gchar* _tmp282_;
							_tmp279_ = pkg;
							_tmp280_ = pamac_alpm_package_get_conflicts (_tmp279_);
							_tmp281_ = _tmp280_;
							_tmp282_ = depstring;
							depstring = NULL;
							g_ptr_array_add (_tmp281_, _tmp282_);
							conflict_found = TRUE;
							_g_free0 (depstring);
							break;
						}
						depends_list = alpm_list_next (depends_list);
						_g_free0 (depstring);
					}
					if (!conflict_found) {
						alpm_list_t* _tmp283_;
						_tmp283_ = alpm_trans_get_add (alpm_handle);
						pkgs_to_add = _tmp283_;
						while (TRUE) {
							alpm_list_t* _tmp284_;
							alpm_pkg_t* add_pkg = NULL;
							alpm_list_t* _tmp285_;
							gconstpointer _tmp286_;
							alpm_pkg_t* _tmp287_;
							alpm_list_t* _tmp288_;
							alpm_list_t* _tmp289_;
							_tmp284_ = pkgs_to_add;
							if (!(_tmp284_ != NULL)) {
								break;
							}
							_tmp285_ = pkgs_to_add;
							_tmp286_ = _tmp285_->data;
							add_pkg = (alpm_pkg_t*) _tmp286_;
							_tmp287_ = add_pkg;
							_tmp288_ = alpm_pkg_get_conflicts (_tmp287_);
							_tmp289_ = _tmp288_;
							depends_list = _tmp289_;
							while (TRUE) {
								alpm_list_t* _tmp290_;
								gchar* depstring = NULL;
								alpm_list_t* _tmp291_;
								gconstpointer _tmp292_;
								gchar* _tmp293_;
								alpm_list_t* list = NULL;
								alpm_pkg_t* _tmp294_;
								alpm_list_t* _tmp295_;
								const gchar* _tmp296_;
								alpm_pkg_t* _tmp297_;
								_tmp290_ = depends_list;
								if (!(_tmp290_ != NULL)) {
									break;
								}
								_tmp291_ = depends_list;
								_tmp292_ = _tmp291_->data;
								_tmp293_ = alpm_dep_compute_string ((alpm_depend_t*) _tmp292_);
								depstring = _tmp293_;
								list = NULL;
								_tmp294_ = trans_pkg;
								list = alpm_list_add (list, _tmp294_);
								_tmp295_ = list;
								_tmp296_ = depstring;
								_tmp297_ = alpm_find_satisfier (_tmp295_, _tmp296_);
								if (_tmp297_ != NULL) {
									PamacAlpmPackage* _tmp298_;
									GPtrArray* _tmp299_;
									GPtrArray* _tmp300_;
									alpm_pkg_t* _tmp301_;
									const gchar* _tmp302_;
									const gchar* _tmp303_;
									gchar* _tmp304_;
									_tmp298_ = pkg;
									_tmp299_ = pamac_alpm_package_get_conflicts (_tmp298_);
									_tmp300_ = _tmp299_;
									_tmp301_ = add_pkg;
									_tmp302_ = alpm_pkg_get_name (_tmp301_);
									_tmp303_ = _tmp302_;
									_tmp304_ = g_strdup (_tmp303_);
									g_ptr_array_add (_tmp300_, _tmp304_);
									conflict_found = TRUE;
									_alpm_list_free0 (list);
									_g_free0 (depstring);
									break;
								}
								depends_list = alpm_list_next (depends_list);
								_alpm_list_free0 (list);
								_g_free0 (depstring);
							}
							pkgs_to_add = alpm_list_next (pkgs_to_add);
						}
					}
					_tmp305_ = pamac_transaction_summary_get_conflicts_to_remove (*summary);
					_tmp306_ = _tmp305_;
					_tmp307_ = pkg;
					_tmp308_ = _g_object_ref0 ((PamacPackage*) _tmp307_);
					g_ptr_array_add (_tmp306_, _tmp308_);
				}
			}
		}
		pkgs_to_remove = alpm_list_next (pkgs_to_remove);
		_g_object_unref0 (pkg);
	}
	_g_hash_table_unref0 (checked);
}

static gboolean
pamac_alpm_utils_need_reboot (PamacAlpmUtils* self,
                              alpm_handle_t* alpm_handle)
{
	gboolean reboot_needed = FALSE;
	gchar** prefix = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint prefix_length1;
	gint _prefix_size_;
	gchar** contains = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint contains_length1;
	gint _contains_size_;
	gchar** full = NULL;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint full_length1;
	gint _full_size_;
	gchar** suffix = NULL;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint suffix_length1;
	gint _suffix_size_;
	alpm_list_t* to_add = NULL;
	alpm_list_t* _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	reboot_needed = FALSE;
	_tmp0_ = g_strdup ("linux-");
	_tmp1_ = g_strdup ("linux4");
	_tmp2_ = g_strdup ("linux5");
	_tmp3_ = g_strdup ("linux6");
	_tmp4_ = g_strdup ("nvidia-");
	_tmp5_ = g_strdup ("lib32-nvidia-");
	_tmp6_ = g_strdup ("systemd");
	_tmp7_ = g_strdup ("xf86-");
	_tmp8_ = g_strdup ("xorg-");
	_tmp9_ = g_new0 (gchar*, 9 + 1);
	_tmp9_[0] = _tmp0_;
	_tmp9_[1] = _tmp1_;
	_tmp9_[2] = _tmp2_;
	_tmp9_[3] = _tmp3_;
	_tmp9_[4] = _tmp4_;
	_tmp9_[5] = _tmp5_;
	_tmp9_[6] = _tmp6_;
	_tmp9_[7] = _tmp7_;
	_tmp9_[8] = _tmp8_;
	prefix = _tmp9_;
	prefix_length1 = 9;
	_prefix_size_ = prefix_length1;
	_tmp10_ = g_strdup ("mesa");
	_tmp11_ = g_strdup ("wayland");
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	contains = _tmp12_;
	contains_length1 = 2;
	_contains_size_ = contains_length1;
	_tmp13_ = g_strdup ("cryptsetup");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	full = _tmp14_;
	full_length1 = 1;
	_full_size_ = full_length1;
	_tmp15_ = g_strdup ("-ucode");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	suffix = _tmp16_;
	suffix_length1 = 1;
	_suffix_size_ = suffix_length1;
	_tmp17_ = alpm_trans_get_add (alpm_handle);
	to_add = _tmp17_;
	while (TRUE) {
		alpm_list_t* _tmp18_;
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp19_;
		gconstpointer _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp31_;
		gint _tmp31__length1;
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp18_ = to_add;
		if (!(_tmp18_ != NULL)) {
			break;
		}
		_tmp19_ = to_add;
		_tmp20_ = _tmp19_->data;
		pkg = (alpm_pkg_t*) _tmp20_;
		_tmp21_ = prefix;
		_tmp21__length1 = prefix_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp21_;
			str_collection_length1 = _tmp21__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp22_ = pkg;
					_tmp23_ = alpm_pkg_get_name (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = str;
					if (g_str_has_prefix (_tmp24_, _tmp25_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp26_ = contains;
		_tmp26__length1 = contains_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp26_;
			str_collection_length1 = _tmp26__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp27_ = pkg;
					_tmp28_ = alpm_pkg_get_name (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = str;
					if (string_contains (_tmp29_, _tmp30_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp31_ = full;
		_tmp31__length1 = full_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp31_;
			str_collection_length1 = _tmp31__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					const gchar* _tmp32_;
					alpm_pkg_t* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					_tmp32_ = str;
					_tmp33_ = pkg;
					_tmp34_ = alpm_pkg_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					if (g_strcmp0 (_tmp32_, _tmp35_) == 0) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		_tmp36_ = suffix;
		_tmp36__length1 = suffix_length1;
		{
			gchar** str_collection = NULL;
			gint str_collection_length1 = 0;
			gint _str_collection_size_ = 0;
			gint str_it = 0;
			str_collection = _tmp36_;
			str_collection_length1 = _tmp36__length1;
			for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
				const gchar* str = NULL;
				str = str_collection[str_it];
				{
					alpm_pkg_t* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp37_ = pkg;
					_tmp38_ = alpm_pkg_get_name (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = str;
					if (g_str_has_suffix (_tmp39_, _tmp40_)) {
						reboot_needed = TRUE;
						break;
					}
				}
			}
		}
		if (reboot_needed) {
			break;
		}
		to_add = alpm_list_next (to_add);
	}
	result = reboot_needed;
	suffix = (_vala_array_free (suffix, suffix_length1, (GDestroyNotify) g_free), NULL);
	full = (_vala_array_free (full, full_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
	prefix = (_vala_array_free (prefix, prefix_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		PamacAlpmUtils* self;
		self = _data55_->self;
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static gboolean
___lambda44_ (Block55Data* _data55_,
              const gchar* pkgname,
              const gchar* val)
{
	PamacAlpmUtils* self;
	alpm_pkg_t* pkg = NULL;
	alpm_db_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_pkg_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	gboolean result;
	self = _data55_->self;
	g_return_val_if_fail (pkgname != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = alpm_get_localdb (_data55_->alpm_handle);
	_tmp1_ = _tmp0_;
	_tmp2_ = alpm_db_get_pkg (_tmp1_, pkgname);
	pkg = _tmp2_;
	_tmp3_ = pkg;
	if (_tmp3_ != NULL) {
		alpm_pkg_t* _tmp4_;
		_tmp4_ = pkg;
		alpm_pkg_set_reason (_tmp4_, ALPM_PKG_REASON_DEPEND);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda44__ghr_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	gboolean result;
	result = ___lambda44_ (self, (const gchar*) key, (const gchar*) value);
	return result;
}

static gboolean
pamac_alpm_utils_trans_commit (PamacAlpmUtils* self,
                               alpm_handle_t* alpm_handle)
{
	Block55Data* _data55_;
	gboolean need_retry = FALSE;
	gboolean success = FALSE;
	gboolean reboot_needed = FALSE;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp45_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->self = g_object_ref (self);
	_data55_->alpm_handle = alpm_handle;
	pamac_alpm_utils_add_overwrite_files (self, _data55_->alpm_handle);
	need_retry = FALSE;
	success = FALSE;
	reboot_needed = FALSE;
	_tmp0_ = self->priv->to_syncfirst;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((guint) 0)) {
		pamac_alpm_utils_trans_release (self, _data55_->alpm_handle);
		success = pamac_alpm_utils_trans_init (self, _data55_->alpm_handle, self->priv->trans_flags, TRUE);
		if (success) {
			{
				GHashTableIter _name_it = {0};
				GHashTable* _tmp3_;
				GHashTableIter _tmp4_ = {0};
				const gchar* name = NULL;
				_tmp3_ = self->priv->to_syncfirst;
				g_hash_table_iter_init (&_tmp4_, _tmp3_);
				_name_it = _tmp4_;
				while (TRUE) {
					gconstpointer _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = _vala_hash_set_next_value (&_name_it);
					name = (const gchar*) _tmp5_;
					_tmp6_ = name;
					if (!(_tmp6_ != NULL)) {
						break;
					}
					_tmp7_ = name;
					success = pamac_alpm_utils_trans_add_pkg (self, _data55_->alpm_handle, _tmp7_, TRUE);
					if (!success) {
						break;
					}
				}
			}
			if (success) {
				success = pamac_alpm_utils_trans_prepare_real (self, _data55_->alpm_handle, TRUE);
			}
			if (success) {
				gboolean _tmp8_;
				reboot_needed = pamac_alpm_utils_need_reboot (self, _data55_->alpm_handle);
				_tmp8_ = pamac_alpm_utils_trans_commit_real (self, _data55_->alpm_handle, &need_retry);
				success = _tmp8_;
			}
			pamac_alpm_utils_trans_release (self, _data55_->alpm_handle);
			if (success) {
				gboolean _tmp15_ = FALSE;
				{
					GHashTableIter _name_it = {0};
					GHashTable* _tmp9_;
					GHashTableIter _tmp10_ = {0};
					const gchar* name = NULL;
					_tmp9_ = self->priv->to_syncfirst;
					g_hash_table_iter_init (&_tmp10_, _tmp9_);
					_name_it = _tmp10_;
					while (TRUE) {
						gconstpointer _tmp11_;
						const gchar* _tmp12_;
						GHashTable* _tmp13_;
						const gchar* _tmp14_;
						_tmp11_ = _vala_hash_set_next_value (&_name_it);
						name = (const gchar*) _tmp11_;
						_tmp12_ = name;
						if (!(_tmp12_ != NULL)) {
							break;
						}
						_tmp13_ = self->priv->to_install;
						_tmp14_ = name;
						g_hash_table_remove (_tmp13_, _tmp14_);
					}
				}
				success = pamac_alpm_utils_trans_init (self, _data55_->alpm_handle, self->priv->trans_flags, TRUE);
				if (success) {
					_tmp15_ = self->priv->sysupgrade;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					success = pamac_alpm_utils_trans_sysupgrade (self, _data55_->alpm_handle, TRUE);
				}
				if (success) {
					{
						GHashTableIter _name_it = {0};
						GHashTable* _tmp16_;
						GHashTableIter _tmp17_ = {0};
						const gchar* name = NULL;
						_tmp16_ = self->priv->to_install;
						g_hash_table_iter_init (&_tmp17_, _tmp16_);
						_name_it = _tmp17_;
						while (TRUE) {
							gconstpointer _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							_tmp18_ = _vala_hash_set_next_value (&_name_it);
							name = (const gchar*) _tmp18_;
							_tmp19_ = name;
							if (!(_tmp19_ != NULL)) {
								break;
							}
							_tmp20_ = name;
							success = pamac_alpm_utils_trans_add_pkg (self, _data55_->alpm_handle, _tmp20_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _name_it = {0};
						GHashTable* _tmp21_;
						GHashTableIter _tmp22_ = {0};
						const gchar* name = NULL;
						_tmp21_ = self->priv->to_remove;
						g_hash_table_iter_init (&_tmp22_, _tmp21_);
						_name_it = _tmp22_;
						while (TRUE) {
							gconstpointer _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							_tmp23_ = _vala_hash_set_next_value (&_name_it);
							name = (const gchar*) _tmp23_;
							_tmp24_ = name;
							if (!(_tmp24_ != NULL)) {
								break;
							}
							_tmp25_ = name;
							success = pamac_alpm_utils_trans_remove_pkg (self, _data55_->alpm_handle, _tmp25_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _path_it = {0};
						GHashTable* _tmp26_;
						GHashTableIter _tmp27_ = {0};
						const gchar* path = NULL;
						_tmp26_ = self->priv->local_paths;
						g_hash_table_iter_init (&_tmp27_, _tmp26_);
						_path_it = _tmp27_;
						while (TRUE) {
							gconstpointer _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							_tmp28_ = _vala_hash_set_next_value (&_path_it);
							path = (const gchar*) _tmp28_;
							_tmp29_ = path;
							if (!(_tmp29_ != NULL)) {
								break;
							}
							_tmp30_ = path;
							_tmp31_ = alpm_option_get_local_file_siglevel (_data55_->alpm_handle);
							_tmp32_ = _tmp31_;
							success = pamac_alpm_utils_trans_load_pkg (self, _data55_->alpm_handle, _tmp30_, _tmp32_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					{
						GHashTableIter _path_it = {0};
						GHashTable* _tmp33_;
						GHashTableIter _tmp34_ = {0};
						const gchar* path = NULL;
						_tmp33_ = self->priv->remote_paths;
						g_hash_table_iter_init (&_tmp34_, _tmp33_);
						_path_it = _tmp34_;
						while (TRUE) {
							gconstpointer _tmp35_;
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gint _tmp38_;
							gint _tmp39_;
							_tmp35_ = _vala_hash_set_next_value (&_path_it);
							path = (const gchar*) _tmp35_;
							_tmp36_ = path;
							if (!(_tmp36_ != NULL)) {
								break;
							}
							_tmp37_ = path;
							_tmp38_ = alpm_option_get_remote_file_siglevel (_data55_->alpm_handle);
							_tmp39_ = _tmp38_;
							success = pamac_alpm_utils_trans_load_pkg (self, _data55_->alpm_handle, _tmp37_, _tmp39_, TRUE);
							if (!success) {
								break;
							}
						}
					}
				}
				if (success) {
					gboolean _tmp40_ = FALSE;
					gboolean _tmp41_ = FALSE;
					success = pamac_alpm_utils_trans_prepare_real (self, _data55_->alpm_handle, TRUE);
					if (success) {
						alpm_list_t* _tmp42_;
						_tmp42_ = alpm_trans_get_add (_data55_->alpm_handle);
						_tmp41_ = _tmp42_ == NULL;
					} else {
						_tmp41_ = FALSE;
					}
					if (_tmp41_) {
						alpm_list_t* _tmp43_;
						_tmp43_ = alpm_trans_get_remove (_data55_->alpm_handle);
						_tmp40_ = _tmp43_ == NULL;
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						pamac_alpm_utils_trans_release (self, _data55_->alpm_handle);
						pamac_alpm_utils_trans_reset (self);
						result = TRUE;
						block55_data_unref (_data55_);
						_data55_ = NULL;
						return result;
					}
				}
				if (!success) {
					pamac_alpm_utils_trans_release (self, _data55_->alpm_handle);
				}
			} else {
				if (need_retry) {
					if (((gint) self->priv->commit_retries) < 1) {
						guint8 _tmp44_;
						_tmp44_ = self->priv->commit_retries;
						self->priv->commit_retries = _tmp44_ + 1;
						success = pamac_alpm_utils_trans_run_real (self, _data55_->alpm_handle);
					}
				}
			}
		}
		if (!success) {
			pamac_alpm_utils_trans_reset (self);
			result = FALSE;
			block55_data_unref (_data55_);
			_data55_ = NULL;
			return result;
		}
	}
	if (!reboot_needed) {
		reboot_needed = pamac_alpm_utils_need_reboot (self, _data55_->alpm_handle);
	}
	_tmp45_ = pamac_alpm_utils_trans_commit_real (self, _data55_->alpm_handle, &need_retry);
	success = _tmp45_;
	if (success) {
		GHashTable* _tmp77_;
		{
			GHashTableIter _path_it = {0};
			GHashTable* _tmp46_;
			GHashTableIter _tmp47_ = {0};
			const gchar* path = NULL;
			_tmp46_ = self->priv->local_paths;
			g_hash_table_iter_init (&_tmp47_, _tmp46_);
			_path_it = _tmp47_;
			while (TRUE) {
				gconstpointer _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp50_ = FALSE;
				gboolean _tmp51_ = FALSE;
				const gchar* _tmp52_;
				_tmp48_ = _vala_hash_set_next_value (&_path_it);
				path = (const gchar*) _tmp48_;
				_tmp49_ = path;
				if (!(_tmp49_ != NULL)) {
					break;
				}
				_tmp52_ = path;
				if (g_str_has_prefix (_tmp52_, "/var/tmp/pamac-build")) {
					_tmp51_ = TRUE;
				} else {
					const gchar* _tmp53_;
					_tmp53_ = path;
					_tmp51_ = g_str_has_prefix (_tmp53_, "/tmp/pamac-build");
				}
				if (_tmp51_) {
					_tmp50_ = TRUE;
				} else {
					const gchar* _tmp54_;
					PamacConfig* _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp54_ = path;
					_tmp55_ = self->priv->config;
					_tmp56_ = pamac_config_get_aur_build_dir (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp50_ = g_str_has_prefix (_tmp54_, _tmp57_);
				}
				if (_tmp50_) {
					if (self->priv->keep_built_pkgs) {
						alpm_list_t* cachedirs = NULL;
						alpm_list_t* _tmp58_;
						alpm_list_t* _tmp59_;
						const gchar* cachedir = NULL;
						alpm_list_t* _tmp60_;
						gconstpointer _tmp61_;
						_tmp58_ = alpm_option_get_cachedirs (_data55_->alpm_handle);
						_tmp59_ = _tmp58_;
						cachedirs = _tmp59_;
						_tmp60_ = cachedirs;
						_tmp61_ = _tmp60_->data;
						cachedir = (const gchar*) _tmp61_;
						{
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							_tmp62_ = path;
							_tmp63_ = cachedir;
							_tmp64_ = g_strdup_printf ("mv -f %s %s", _tmp62_, _tmp63_);
							_tmp65_ = _tmp64_;
							g_spawn_command_line_sync (_tmp65_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp65_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp66_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch0_g_spawn_error;
								}
								block55_data_unref (_data55_);
								_data55_ = NULL;
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp66_;
							}
						}
						goto __finally0;
						__catch0_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp67_;
							const gchar* _tmp68_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp67_ = e;
							_tmp68_ = _tmp67_->message;
							g_warning ("alpm_utils.vala:1925: %s", _tmp68_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp69_ = FALSE;
							block55_data_unref (_data55_);
							_data55_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp69_;
						}
					} else {
						{
							const gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							_tmp70_ = path;
							_tmp71_ = g_strdup_printf ("rm -f %s", _tmp70_);
							_tmp72_ = _tmp71_;
							g_spawn_command_line_sync (_tmp72_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp72_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp73_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch1_g_spawn_error;
								}
								block55_data_unref (_data55_);
								_data55_ = NULL;
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp73_;
							}
						}
						goto __finally1;
						__catch1_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp74_;
							const gchar* _tmp75_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp74_ = e;
							_tmp75_ = _tmp74_->message;
							g_warning ("alpm_utils.vala:1932: %s", _tmp75_);
							_g_error_free0 (e);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp76_ = FALSE;
							block55_data_unref (_data55_);
							_data55_ = NULL;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp76_;
						}
					}
				}
			}
		}
		_tmp77_ = self->priv->to_install_as_dep;
		g_hash_table_foreach_remove (_tmp77_, ____lambda44__ghr_func, _data55_);
		if (reboot_needed) {
			gchar* _tmp78_;
			gchar* _tmp79_;
			_tmp78_ = g_strconcat (g_dgettext (NULL, "A restart is required for the changes to take effect"), ".", NULL);
			_tmp79_ = _tmp78_;
			pamac_alpm_utils_do_emit_warning (self, _tmp79_);
			_g_free0 (_tmp79_);
		}
		if (self->priv->sysupgrade) {
			{
				g_spawn_command_line_sync ("rm -f /system-update", NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp80_ = FALSE;
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch2_g_spawn_error;
					}
					block55_data_unref (_data55_);
					_data55_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp80_;
				}
			}
			goto __finally2;
			__catch2_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp81_;
				const gchar* _tmp82_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp81_ = e;
				_tmp82_ = _tmp81_->message;
				g_warning ("alpm_utils.vala:1953: %s", _tmp82_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp83_ = FALSE;
				block55_data_unref (_data55_);
				_data55_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp83_;
			}
		}
	} else {
		if (need_retry) {
			if (((gint) self->priv->commit_retries) < 1) {
				guint8 _tmp84_;
				_tmp84_ = self->priv->commit_retries;
				self->priv->commit_retries = _tmp84_ + 1;
				success = pamac_alpm_utils_trans_run_real (self, _data55_->alpm_handle);
			}
		}
	}
	pamac_alpm_utils_trans_reset (self);
	result = success;
	block55_data_unref (_data55_);
	_data55_ = NULL;
	return result;
}

static gchar*
pamac_alpm_utils_backup_conflict_file (PamacAlpmUtils* self,
                                       const gchar* file_path)
{
	GString* backup_file_path = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GFile* backup_file = NULL;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = g_string_new (file_path);
	backup_file_path = _tmp0_;
	_tmp1_ = backup_file_path;
	g_string_append (_tmp1_, ".old");
	_tmp2_ = backup_file_path;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	backup_file = _tmp4_;
	_tmp5_ = backup_file;
	if (g_file_query_exists (_tmp5_, NULL)) {
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint _tmp8_;
				GString* new_backup_file_path = NULL;
				GString* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp11_;
				GString* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GString* _tmp15_;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				if (!_tmp6_) {
					GFile* _tmp7_;
					_tmp7_ = backup_file;
					if (!g_file_query_exists (_tmp7_, NULL)) {
						break;
					}
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				i = _tmp8_ + 1;
				_tmp9_ = backup_file_path;
				_tmp10_ = _tmp9_->str;
				_tmp11_ = g_string_new (_tmp10_);
				new_backup_file_path = _tmp11_;
				_tmp12_ = new_backup_file_path;
				_tmp13_ = g_strdup_printf ("%u", i);
				_tmp14_ = _tmp13_;
				g_string_append (_tmp12_, _tmp14_);
				_g_free0 (_tmp14_);
				_tmp15_ = new_backup_file_path;
				_tmp16_ = _tmp15_->str;
				_tmp17_ = g_file_new_for_path (_tmp16_);
				_g_object_unref0 (backup_file);
				backup_file = _tmp17_;
				_g_string_free0 (new_backup_file_path);
			}
		}
	}
	{
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GFile* _tmp23_;
		gchar* _tmp24_;
		_tmp18_ = backup_file;
		_tmp19_ = g_file_get_path (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup_printf ("mv -f %s %s", file_path, _tmp20_);
		_tmp22_ = _tmp21_;
		g_spawn_command_line_sync (_tmp22_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_object_unref0 (backup_file);
			_g_string_free0 (backup_file_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp23_ = backup_file;
		_tmp24_ = g_file_get_path (_tmp23_);
		result = _tmp24_;
		_g_object_unref0 (backup_file);
		_g_string_free0 (backup_file_path);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("alpm_utils.vala:1985: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (backup_file);
		_g_string_free0 (backup_file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (backup_file);
	_g_string_free0 (backup_file_path);
	return result;
}

static gboolean
pamac_alpm_utils_trans_commit_real (PamacAlpmUtils* self,
                                    alpm_handle_t* alpm_handle,
                                    gboolean* need_retry)
{
	gboolean success = FALSE;
	alpm_list_t* err_data = NULL;
	alpm_list_t* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	_tmp1_ = alpm_trans_commit (alpm_handle, &_tmp0_);
	_alpm_list_free0 (err_data);
	err_data = _tmp0_;
	if (_tmp1_ == -1) {
		alpm_errno_t err_no = 0;
		GPtrArray* details = NULL;
		GPtrArray* _tmp2_;
		err_no = alpm_errno (alpm_handle);
		*need_retry = FALSE;
		_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		details = _tmp2_;
		switch (err_no) {
			case 0:
			{
				break;
			}
			case ALPM_ERR_FILE_CONFLICTS:
			{
				GPtrArray* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp6_;
				_tmp3_ = details;
				_tmp4_ = alpm_strerror (err_no);
				_tmp5_ = g_strconcat (_tmp4_, ":", NULL);
				g_ptr_array_add (_tmp3_, _tmp5_);
				_tmp6_ = err_data;
				list = _tmp6_;
				while (TRUE) {
					alpm_list_t* _tmp7_;
					alpm_fileconflict_t* conflict = NULL;
					alpm_list_t* _tmp8_;
					gconstpointer _tmp9_;
					alpm_fileconflict_t* _tmp10_;
					alpm_fileconflict_t* _tmp76_;
					_tmp7_ = list;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = list;
					_tmp9_ = _tmp8_->data;
					conflict = _tmp9_;
					_tmp10_ = conflict;
					switch (_tmp10_->type) {
						case ALPM_FILECONFLICT_TARGET:
						{
							GPtrArray* _tmp11_;
							alpm_fileconflict_t* _tmp12_;
							const gchar* _tmp13_;
							alpm_fileconflict_t* _tmp14_;
							const gchar* _tmp15_;
							alpm_fileconflict_t* _tmp16_;
							const gchar* _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							_tmp11_ = details;
							_tmp12_ = conflict;
							_tmp13_ = _tmp12_->file;
							_tmp14_ = conflict;
							_tmp15_ = _tmp14_->target;
							_tmp16_ = conflict;
							_tmp17_ = _tmp16_->ctarget;
							_tmp18_ = g_strdup_printf (_ ("%1$s exists in both %2$s and %3$s"), _tmp13_, _tmp15_, _tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = g_strconcat ("- ", _tmp19_, NULL);
							g_ptr_array_add (_tmp11_, _tmp20_);
							_g_free0 (_tmp19_);
							break;
						}
						case ALPM_FILECONFLICT_FILESYSTEM:
						{
							alpm_fileconflict_t* _tmp21_;
							const gchar* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							_tmp21_ = conflict;
							_tmp22_ = _tmp21_->ctarget;
							_tmp23_ = strlen (_tmp22_);
							_tmp24_ = _tmp23_;
							if (_tmp24_ > 0) {
								GPtrArray* _tmp25_;
								alpm_fileconflict_t* _tmp26_;
								const gchar* _tmp27_;
								alpm_fileconflict_t* _tmp28_;
								const gchar* _tmp29_;
								alpm_fileconflict_t* _tmp30_;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								gchar* _tmp34_;
								_tmp25_ = details;
								_tmp26_ = conflict;
								_tmp27_ = _tmp26_->target;
								_tmp28_ = conflict;
								_tmp29_ = _tmp28_->file;
								_tmp30_ = conflict;
								_tmp31_ = _tmp30_->ctarget;
								_tmp32_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem (owned by %3$s)"), _tmp27_, _tmp29_, _tmp31_);
								_tmp33_ = _tmp32_;
								_tmp34_ = g_strconcat ("- ", _tmp33_, NULL);
								g_ptr_array_add (_tmp25_, _tmp34_);
								_g_free0 (_tmp33_);
							} else {
								if (((gint) self->priv->commit_retries) < 1) {
									gchar* backup_path = NULL;
									alpm_fileconflict_t* _tmp35_;
									const gchar* _tmp36_;
									gchar* _tmp37_;
									const gchar* _tmp38_;
									_tmp35_ = conflict;
									_tmp36_ = _tmp35_->file;
									_tmp37_ = pamac_alpm_utils_backup_conflict_file (self, _tmp36_);
									backup_path = _tmp37_;
									_tmp38_ = backup_path;
									if (_tmp38_ == NULL) {
										GPtrArray* _tmp39_;
										alpm_fileconflict_t* _tmp40_;
										const gchar* _tmp41_;
										alpm_fileconflict_t* _tmp42_;
										const gchar* _tmp43_;
										gchar* _tmp44_;
										gchar* _tmp45_;
										gchar* _tmp46_;
										gchar* _tmp47_;
										gchar* _tmp48_;
										GPtrArray* _tmp49_;
										gchar* _tmp50_;
										_tmp39_ = details;
										_tmp40_ = conflict;
										_tmp41_ = _tmp40_->target;
										_tmp42_ = conflict;
										_tmp43_ = _tmp42_->file;
										_tmp44_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp41_, _tmp43_);
										_tmp45_ = _tmp44_;
										_tmp46_ = g_strconcat ("- ", _tmp45_, NULL);
										_tmp47_ = _tmp46_;
										_tmp48_ = g_strconcat (_tmp47_, ",", NULL);
										g_ptr_array_add (_tmp39_, _tmp48_);
										_g_free0 (_tmp47_);
										_g_free0 (_tmp45_);
										_tmp49_ = details;
										_tmp50_ = g_strconcat ("  ", _ ("if this file is not needed, remove it and retry"), NULL);
										g_ptr_array_add (_tmp49_, _tmp50_);
									} else {
										gchar* _tmp51_;
										gchar* _tmp52_;
										alpm_fileconflict_t* _tmp53_;
										const gchar* _tmp54_;
										alpm_fileconflict_t* _tmp55_;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										gchar* _tmp59_;
										gchar* _tmp60_;
										const gchar* _tmp61_;
										gchar* _tmp62_;
										gchar* _tmp63_;
										_tmp51_ = g_strconcat (_ ("Warning"), ": ", NULL);
										_tmp52_ = _tmp51_;
										_tmp53_ = conflict;
										_tmp54_ = _tmp53_->target;
										_tmp55_ = conflict;
										_tmp56_ = _tmp55_->file;
										_tmp57_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp54_, _tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_strconcat (_tmp52_, _tmp58_, NULL);
										_tmp60_ = _tmp59_;
										pamac_alpm_utils_do_emit_warning (self, _tmp60_);
										_g_free0 (_tmp60_);
										_g_free0 (_tmp58_);
										_g_free0 (_tmp52_);
										_tmp61_ = backup_path;
										_tmp62_ = g_strdup_printf (_ ("It has been backed up to %s"), _tmp61_);
										_tmp63_ = _tmp62_;
										pamac_alpm_utils_do_emit_warning (self, _tmp63_);
										_g_free0 (_tmp63_);
										*need_retry = TRUE;
									}
									_g_free0 (backup_path);
								} else {
									GPtrArray* _tmp64_;
									alpm_fileconflict_t* _tmp65_;
									const gchar* _tmp66_;
									alpm_fileconflict_t* _tmp67_;
									const gchar* _tmp68_;
									gchar* _tmp69_;
									gchar* _tmp70_;
									gchar* _tmp71_;
									gchar* _tmp72_;
									gchar* _tmp73_;
									GPtrArray* _tmp74_;
									gchar* _tmp75_;
									_tmp64_ = details;
									_tmp65_ = conflict;
									_tmp66_ = _tmp65_->target;
									_tmp67_ = conflict;
									_tmp68_ = _tmp67_->file;
									_tmp69_ = g_strdup_printf (_ ("%1$s: %2$s already exists in filesystem"), _tmp66_, _tmp68_);
									_tmp70_ = _tmp69_;
									_tmp71_ = g_strconcat ("- ", _tmp70_, NULL);
									_tmp72_ = _tmp71_;
									_tmp73_ = g_strconcat (_tmp72_, ",", NULL);
									g_ptr_array_add (_tmp64_, _tmp73_);
									_g_free0 (_tmp72_);
									_g_free0 (_tmp70_);
									_tmp74_ = details;
									_tmp75_ = g_strconcat ("  ", _ ("if this file is not needed, remove it and retry"), NULL);
									g_ptr_array_add (_tmp74_, _tmp75_);
								}
							}
							break;
						}
						default:
						break;
					}
					_tmp76_ = conflict;
					_alpm_fileconflict_free0 (_tmp76_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_PKG_INVALID_CHECKSUM:
			{
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp77_;
				_tmp77_ = err_data;
				list = _tmp77_;
				if (((gint) self->priv->commit_retries) < 1) {
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp78_ = g_strconcat (_ ("Removing invalid files and retrying"), "...", NULL);
					_tmp79_ = _tmp78_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp79_);
					_g_free0 (_tmp79_);
					*need_retry = TRUE;
				} else {
					GPtrArray* _tmp80_;
					const gchar* _tmp81_;
					gchar* _tmp82_;
					_tmp80_ = details;
					_tmp81_ = alpm_strerror (err_no);
					_tmp82_ = g_strconcat (_tmp81_, ":", NULL);
					g_ptr_array_add (_tmp80_, _tmp82_);
				}
				while (TRUE) {
					alpm_list_t* _tmp83_;
					const gchar* filename = NULL;
					alpm_list_t* _tmp84_;
					gconstpointer _tmp85_;
					const gchar* _tmp95_;
					_tmp83_ = list;
					if (!(_tmp83_ != NULL)) {
						break;
					}
					_tmp84_ = list;
					_tmp85_ = _tmp84_->data;
					filename = _tmp85_;
					if (!(*need_retry)) {
						GPtrArray* _tmp86_;
						const gchar* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						gchar* _tmp91_;
						gchar* _tmp92_;
						GPtrArray* _tmp93_;
						gchar* _tmp94_;
						_tmp86_ = details;
						_tmp87_ = filename;
						_tmp88_ = g_strdup_printf (_ ("%s is invalid or corrupted"), _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = g_strconcat ("- ", _tmp89_, NULL);
						_tmp91_ = _tmp90_;
						_tmp92_ = g_strconcat (_tmp91_, ",", NULL);
						g_ptr_array_add (_tmp86_, _tmp92_);
						_g_free0 (_tmp91_);
						_g_free0 (_tmp89_);
						_tmp93_ = details;
						_tmp94_ = g_strconcat ("- ", _ ("you can remove this file and retry"), NULL);
						g_ptr_array_add (_tmp93_, _tmp94_);
					}
					_tmp95_ = filename;
					_g_free0 (_tmp95_);
					list = alpm_list_next (list);
				}
				break;
			}
			case ALPM_ERR_PKG_INVALID:
			case ALPM_ERR_PKG_INVALID_SIG:
			{
				alpm_list_t* list = NULL;
				alpm_list_t* _tmp101_;
				if (((gint) self->priv->commit_retries) < 1) {
					gchar* _tmp96_;
					gchar* _tmp97_;
					_tmp96_ = g_strconcat (_ ("Removing invalid files and retrying"), "...", NULL);
					_tmp97_ = _tmp96_;
					pamac_alpm_utils_do_emit_script_output (self, _tmp97_);
					_g_free0 (_tmp97_);
					*need_retry = TRUE;
				} else {
					GPtrArray* _tmp98_;
					const gchar* _tmp99_;
					gchar* _tmp100_;
					_tmp98_ = details;
					_tmp99_ = alpm_strerror (err_no);
					_tmp100_ = g_strconcat (_tmp99_, ":", NULL);
					g_ptr_array_add (_tmp98_, _tmp100_);
				}
				_tmp101_ = err_data;
				list = _tmp101_;
				while (TRUE) {
					alpm_list_t* _tmp102_;
					const gchar* filename = NULL;
					alpm_list_t* _tmp103_;
					gconstpointer _tmp104_;
					const gchar* _tmp121_;
					_tmp102_ = list;
					if (!(_tmp102_ != NULL)) {
						break;
					}
					_tmp103_ = list;
					_tmp104_ = _tmp103_->data;
					filename = _tmp104_;
					if (!(*need_retry)) {
						GPtrArray* _tmp105_;
						const gchar* _tmp106_;
						gchar* _tmp107_;
						gchar* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						gchar* _tmp111_;
						GPtrArray* _tmp112_;
						gchar* _tmp113_;
						_tmp105_ = details;
						_tmp106_ = filename;
						_tmp107_ = g_strdup_printf (_ ("%s is invalid or corrupted"), _tmp106_);
						_tmp108_ = _tmp107_;
						_tmp109_ = g_strconcat ("- ", _tmp108_, NULL);
						_tmp110_ = _tmp109_;
						_tmp111_ = g_strconcat (_tmp110_, ",", NULL);
						g_ptr_array_add (_tmp105_, _tmp111_);
						_g_free0 (_tmp110_);
						_g_free0 (_tmp108_);
						_tmp112_ = details;
						_tmp113_ = g_strconcat ("  ", _ ("you can remove this file and retry"), NULL);
						g_ptr_array_add (_tmp112_, _tmp113_);
					} else {
						{
							const gchar* _tmp114_;
							gchar* _tmp115_;
							gchar* _tmp116_;
							_tmp114_ = filename;
							_tmp115_ = g_strdup_printf ("rm -f %s", _tmp114_);
							_tmp116_ = _tmp115_;
							g_spawn_command_line_sync (_tmp116_, NULL, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp116_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gboolean _tmp117_ = FALSE;
								if (_inner_error0_->domain == G_SPAWN_ERROR) {
									goto __catch0_g_spawn_error;
								}
								_g_ptr_array_unref0 (details);
								_alpm_list_free0 (err_data);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp117_;
							}
						}
						goto __finally0;
						__catch0_g_spawn_error:
						{
							GError* e = NULL;
							GError* _tmp118_;
							const gchar* _tmp119_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp118_ = e;
							_tmp119_ = _tmp118_->message;
							g_warning ("alpm_utils.vala:2073: %s", _tmp119_);
							_g_error_free0 (e);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gboolean _tmp120_ = FALSE;
							_g_ptr_array_unref0 (details);
							_alpm_list_free0 (err_data);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp120_;
						}
					}
					_tmp121_ = filename;
					_g_free0 (_tmp121_);
					list = alpm_list_next (list);
				}
				break;
			}
			default:
			{
				GPtrArray* _tmp122_;
				const gchar* _tmp123_;
				gchar* _tmp124_;
				_tmp122_ = details;
				_tmp123_ = alpm_strerror (err_no);
				_tmp124_ = g_strdup (_tmp123_);
				g_ptr_array_add (_tmp122_, _tmp124_);
				break;
			}
		}
		success = FALSE;
		if (!(*need_retry)) {
			GPtrArray* _tmp125_;
			_tmp125_ = details;
			pamac_alpm_utils_do_emit_error (self, _ ("Failed to commit transaction"), _tmp125_);
		}
		_g_ptr_array_unref0 (details);
	}
	pamac_alpm_utils_trans_release (self, alpm_handle);
	result = success;
	_alpm_list_free0 (err_data);
	return result;
}

static void
pamac_alpm_utils_trans_release (PamacAlpmUtils* self,
                                alpm_handle_t* alpm_handle)
{
	g_return_if_fail (self != NULL);
	alpm_trans_release (alpm_handle);
	pamac_alpm_utils_remove_ignorepkgs (self, alpm_handle);
	pamac_alpm_utils_remove_overwrite_files (self, alpm_handle);
}

void
pamac_alpm_utils_trans_cancel (PamacAlpmUtils* self,
                               const gchar* sender)
{
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = self->priv->sender;
	if (g_strcmp0 (sender, _tmp0_) != 0) {
		return;
	}
	_tmp1_ = self->cancellable;
	g_cancellable_cancel (_tmp1_);
	pamac_alpm_utils_trans_reset (self);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static gchar*
pamac_alpm_utils_remove_bash_colors (PamacAlpmUtils* self,
                                     const gchar* msg)
{
	GRegex* regex = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "\\x1B\\[[0-9;]*[JKmsu]", 0));
	regex = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_regex_replace (regex, msg, (gssize) -1, 0, "", 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp1_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = g_strdup (msg);
		result = _tmp4_;
		_g_regex_unref0 (regex);
		return result;
	}
	__finally0:
	_g_regex_unref0 (regex);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
pamac_alpm_utils_emit_event (PamacAlpmUtils* self,
                             guint primary_event,
                             guint secondary_event,
                             GPtrArray* details)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	switch (primary_event) {
		case 1:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = g_strconcat (g_dgettext (NULL, "Checking dependencies"), "...", NULL);
			_tmp1_ = _tmp0_;
			pamac_alpm_utils_do_emit_action (self, _tmp1_);
			_g_free0 (_tmp1_);
			break;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strconcat (g_dgettext (NULL, "Checking file conflicts"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp2_;
			break;
		}
		case 5:
		{
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_strconcat (g_dgettext (NULL, "Resolving dependencies"), "...", NULL);
			_tmp4_ = _tmp3_;
			pamac_alpm_utils_do_emit_action (self, _tmp4_);
			_g_free0 (_tmp4_);
			break;
		}
		case 7:
		{
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = g_strconcat (g_dgettext (NULL, "Checking inter-conflicts"), "...", NULL);
			_tmp6_ = _tmp5_;
			pamac_alpm_utils_do_emit_action (self, _tmp6_);
			_g_free0 (_tmp6_);
			break;
		}
		case 11:
		{
			switch (secondary_event) {
				case 1:
				{
					gconstpointer _tmp7_;
					gchar* _tmp8_;
					gconstpointer _tmp9_;
					gconstpointer _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp7_ = g_ptr_array_index (details, (guint) 0);
					_tmp8_ = g_strdup ((const gchar*) _tmp7_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp8_;
					_tmp9_ = g_ptr_array_index (details, (guint) 0);
					_tmp10_ = g_ptr_array_index (details, (guint) 1);
					_tmp11_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp9_, (const gchar*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp14_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp15_;
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					break;
				}
				case 2:
				{
					gconstpointer _tmp16_;
					gchar* _tmp17_;
					gconstpointer _tmp18_;
					gconstpointer _tmp19_;
					gconstpointer _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp16_ = g_ptr_array_index (details, (guint) 0);
					_tmp17_ = g_strdup ((const gchar*) _tmp16_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp17_;
					_tmp18_ = g_ptr_array_index (details, (guint) 0);
					_tmp19_ = g_ptr_array_index (details, (guint) 1);
					_tmp20_ = g_ptr_array_index (details, (guint) 2);
					_tmp21_ = g_strdup_printf ("%s (%s -> %s)", (const gchar*) _tmp18_, (const gchar*) _tmp19_, (const gchar*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf (g_dgettext (NULL, "Upgrading %s"), _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp25_;
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					break;
				}
				case 3:
				{
					gconstpointer _tmp26_;
					gchar* _tmp27_;
					gconstpointer _tmp28_;
					gconstpointer _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp26_ = g_ptr_array_index (details, (guint) 0);
					_tmp27_ = g_strdup ((const gchar*) _tmp26_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp27_;
					_tmp28_ = g_ptr_array_index (details, (guint) 0);
					_tmp29_ = g_ptr_array_index (details, (guint) 1);
					_tmp30_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp28_, (const gchar*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strdup_printf (g_dgettext (NULL, "Reinstalling %s"), _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strconcat (_tmp33_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					break;
				}
				case 4:
				{
					gconstpointer _tmp35_;
					gchar* _tmp36_;
					gconstpointer _tmp37_;
					gconstpointer _tmp38_;
					gconstpointer _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp35_ = g_ptr_array_index (details, (guint) 0);
					_tmp36_ = g_strdup ((const gchar*) _tmp35_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp36_;
					_tmp37_ = g_ptr_array_index (details, (guint) 0);
					_tmp38_ = g_ptr_array_index (details, (guint) 1);
					_tmp39_ = g_ptr_array_index (details, (guint) 2);
					_tmp40_ = g_strdup_printf ("%s (%s -> %s)", (const gchar*) _tmp37_, (const gchar*) _tmp38_, (const gchar*) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_strdup_printf (g_dgettext (NULL, "Downgrading %s"), _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strconcat (_tmp43_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp44_;
					_g_free0 (_tmp43_);
					_g_free0 (_tmp41_);
					break;
				}
				case 5:
				{
					gconstpointer _tmp45_;
					gchar* _tmp46_;
					gconstpointer _tmp47_;
					gconstpointer _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp45_ = g_ptr_array_index (details, (guint) 0);
					_tmp46_ = g_strdup ((const gchar*) _tmp45_);
					_g_free0 (self->current_filename);
					self->current_filename = _tmp46_;
					_tmp47_ = g_ptr_array_index (details, (guint) 0);
					_tmp48_ = g_ptr_array_index (details, (guint) 1);
					_tmp49_ = g_strdup_printf ("%s (%s)", (const gchar*) _tmp47_, (const gchar*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup_printf (g_dgettext (NULL, "Removing %s"), _tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strconcat (_tmp52_, "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp53_;
					_g_free0 (_tmp52_);
					_g_free0 (_tmp50_);
					break;
				}
				default:
				break;
			}
			break;
		}
		case 13:
		{
			gchar* _tmp54_;
			_tmp54_ = g_strconcat (g_dgettext (NULL, "Checking integrity"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp54_;
			break;
		}
		case 15:
		{
			gchar* _tmp55_;
			_tmp55_ = g_strconcat (g_dgettext (NULL, "Loading packages files"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp55_;
			break;
		}
		case 17:
		{
			gchar* msg = NULL;
			gconstpointer _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			_tmp56_ = g_ptr_array_index (details, (guint) 0);
			_tmp57_ = pamac_alpm_utils_remove_bash_colors (self, (const gchar*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = string_replace (_tmp58_, "\n", "");
			_tmp60_ = _tmp59_;
			_g_free0 (_tmp58_);
			msg = _tmp60_;
			_tmp61_ = msg;
			pamac_alpm_utils_do_emit_script_output (self, _tmp61_);
			_tmp62_ = self->current_filename;
			if (g_strcmp0 (_tmp62_, "") != 0) {
				gchar* action = NULL;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gboolean _tmp74_;
				_tmp63_ = self->current_filename;
				_tmp64_ = g_strdup_printf (g_dgettext (NULL, "Configuring %s"), _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp65_, "...", NULL);
				_tmp67_ = _tmp66_;
				_g_free0 (_tmp65_);
				action = _tmp67_;
				_tmp68_ = action;
				_tmp69_ = self->current_action;
				if (g_strcmp0 (_tmp68_, _tmp69_) != 0) {
					gchar* _tmp70_;
					_tmp70_ = action;
					action = NULL;
					_g_free0 (self->current_action);
					self->current_action = _tmp70_;
				}
				_tmp71_ = msg;
				_tmp72_ = g_utf8_strdown (_tmp71_, (gssize) -1);
				_tmp73_ = _tmp72_;
				_tmp74_ = string_contains (_tmp73_, "error");
				_g_free0 (_tmp73_);
				if (_tmp74_) {
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp75_ = self->current_filename;
					_tmp76_ = g_strdup_printf (g_dgettext (NULL, "Error while configuring %s"), _tmp75_);
					_tmp77_ = _tmp76_;
					pamac_alpm_utils_do_emit_warning (self, _tmp77_);
					_g_free0 (_tmp77_);
					pamac_alpm_utils_do_important_details_outpout (self, TRUE);
				} else {
					pamac_alpm_utils_do_important_details_outpout (self, FALSE);
				}
				_g_free0 (action);
			}
			_g_free0 (msg);
			break;
		}
		case 18:
		{
			pamac_alpm_utils_do_start_downloading (self);
			break;
		}
		case 19:
		case 20:
		{
			pamac_alpm_utils_do_stop_downloading (self);
			break;
		}
		case 21:
		{
			pamac_alpm_utils_do_start_downloading (self);
			break;
		}
		case 22:
		{
			gchar* _tmp78_;
			GHashTable* _tmp79_;
			GQueue* _tmp80_;
			gchar* _tmp81_;
			pamac_alpm_utils_do_stop_downloading (self);
			_tmp78_ = g_strdup ("");
			_g_free0 (self->current_filename);
			self->current_filename = _tmp78_;
			_tmp79_ = self->multi_progress;
			g_hash_table_remove_all (_tmp79_);
			_tmp80_ = self->priv->download_rates;
			g_queue_clear (_tmp80_);
			self->priv->download_rate = (gdouble) 0;
			self->current_progress = (gdouble) 0;
			self->already_downloaded = (guint64) 0;
			_tmp81_ = g_strdup ("");
			_g_free0 (self->priv->current_status);
			self->priv->current_status = _tmp81_;
			self->total_download = (guint64) 0;
			break;
		}
		case 23:
		{
			gchar* _tmp82_;
			GHashTable* _tmp83_;
			GQueue* _tmp84_;
			gchar* _tmp85_;
			pamac_alpm_utils_do_stop_downloading (self);
			_tmp82_ = g_strdup ("");
			_g_free0 (self->current_filename);
			self->current_filename = _tmp82_;
			_tmp83_ = self->multi_progress;
			g_hash_table_remove_all (_tmp83_);
			_tmp84_ = self->priv->download_rates;
			g_queue_clear (_tmp84_);
			self->priv->download_rate = (gdouble) 0;
			self->current_progress = (gdouble) 0;
			self->already_downloaded = (guint64) 0;
			_tmp85_ = g_strdup ("");
			_g_free0 (self->priv->current_status);
			self->priv->current_status = _tmp85_;
			self->total_download = (guint64) 0;
			pamac_alpm_utils_do_emit_warning (self, g_dgettext (NULL, "failed to retrieve some files"));
			break;
		}
		case 24:
		{
			gchar* _tmp86_;
			_tmp86_ = g_strconcat (g_dgettext (NULL, "Checking available disk space"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp86_;
			break;
		}
		case 26:
		{
			gconstpointer _tmp87_;
			gconstpointer _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			_tmp87_ = g_ptr_array_index (details, (guint) 0);
			_tmp88_ = g_ptr_array_index (details, (guint) 1);
			_tmp89_ = g_strdup_printf (g_dgettext (NULL, "%1$s optionally requires %2$s"), (const gchar*) _tmp87_, (const gchar*) _tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_strdup_printf ("%s: %s", g_dgettext (NULL, "Warning"), _tmp90_);
			_tmp92_ = _tmp91_;
			pamac_alpm_utils_do_emit_warning (self, _tmp92_);
			_g_free0 (_tmp92_);
			_g_free0 (_tmp90_);
			break;
		}
		case 27:
		{
			break;
		}
		case 28:
		{
			gchar* _tmp93_;
			_tmp93_ = g_strconcat (g_dgettext (NULL, "Checking keyring"), "...", NULL);
			_g_free0 (self->current_action);
			self->current_action = _tmp93_;
			break;
		}
		case 30:
		{
			gchar* _tmp94_;
			gchar* _tmp95_;
			_tmp94_ = g_strconcat (g_dgettext (NULL, "Downloading required keys"), "...", NULL);
			_tmp95_ = _tmp94_;
			pamac_alpm_utils_do_emit_action (self, _tmp95_);
			_g_free0 (_tmp95_);
			break;
		}
		case 32:
		{
			gconstpointer _tmp96_;
			gconstpointer _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			_tmp96_ = g_ptr_array_index (details, (guint) 0);
			_tmp97_ = g_ptr_array_index (details, (guint) 0);
			_tmp98_ = g_strdup_printf (g_dgettext (NULL, "%1$s installed as %2$s.pacnew"), (const gchar*) _tmp96_, (const gchar*) _tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strconcat (_tmp99_, ".", NULL);
			_tmp101_ = _tmp100_;
			pamac_alpm_utils_do_emit_script_output (self, _tmp101_);
			_g_free0 (_tmp101_);
			_g_free0 (_tmp99_);
			break;
		}
		case 33:
		{
			gconstpointer _tmp102_;
			gconstpointer _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			_tmp102_ = g_ptr_array_index (details, (guint) 0);
			_tmp103_ = g_ptr_array_index (details, (guint) 0);
			_tmp104_ = g_strdup_printf (g_dgettext (NULL, "%1$s installed as %2$s.pacsave"), (const gchar*) _tmp102_, (const gchar*) _tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strconcat (_tmp105_, ".", NULL);
			_tmp107_ = _tmp106_;
			pamac_alpm_utils_do_emit_script_output (self, _tmp107_);
			_g_free0 (_tmp107_);
			_g_free0 (_tmp105_);
			break;
		}
		case 34:
		{
			switch (secondary_event) {
				case 1:
				{
					gchar* _tmp108_;
					_tmp108_ = g_strconcat (g_dgettext (NULL, "Running pre-transaction hooks"), "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp108_;
					break;
				}
				case 2:
				{
					gchar* _tmp109_;
					gchar* _tmp110_;
					_tmp109_ = g_strdup ("");
					_g_free0 (self->current_filename);
					self->current_filename = _tmp109_;
					_tmp110_ = g_strconcat (g_dgettext (NULL, "Running post-transaction hooks"), "...", NULL);
					_g_free0 (self->current_action);
					self->current_action = _tmp110_;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case 36:
		{
			gdouble progress = 0.0;
			gconstpointer _tmp111_;
			gconstpointer _tmp112_;
			gchar* status = NULL;
			gconstpointer _tmp113_;
			gconstpointer _tmp114_;
			gchar* _tmp115_;
			gboolean changed = FALSE;
			const gchar* _tmp116_;
			const gchar* _tmp117_;
			_tmp111_ = g_ptr_array_index (details, (guint) 2);
			_tmp112_ = g_ptr_array_index (details, (guint) 3);
			progress = ((gdouble) atoi ((const gchar*) _tmp111_)) / atoi ((const gchar*) _tmp112_);
			_tmp113_ = g_ptr_array_index (details, (guint) 2);
			_tmp114_ = g_ptr_array_index (details, (guint) 3);
			_tmp115_ = g_strdup_printf ("%s/%s", (const gchar*) _tmp113_, (const gchar*) _tmp114_);
			status = _tmp115_;
			changed = FALSE;
			if (progress != self->current_progress) {
				self->current_progress = progress;
				changed = TRUE;
			}
			_tmp116_ = status;
			_tmp117_ = self->priv->current_status;
			if (g_strcmp0 (_tmp116_, _tmp117_) != 0) {
				gchar* _tmp118_;
				_tmp118_ = status;
				status = NULL;
				_g_free0 (self->priv->current_status);
				self->priv->current_status = _tmp118_;
				changed = TRUE;
			}
			if (changed) {
				gconstpointer _tmp119_;
				_tmp119_ = g_ptr_array_index (details, (guint) 1);
				if (g_strcmp0 ((const gchar*) _tmp119_, "") != 0) {
					const gchar* _tmp120_;
					gconstpointer _tmp121_;
					const gchar* _tmp122_;
					gconstpointer _tmp123_;
					gchar* _tmp124_;
					gchar* _tmp125_;
					gboolean _tmp126_;
					_tmp120_ = self->current_action;
					_tmp121_ = g_ptr_array_index (details, (guint) 1);
					_tmp122_ = self->priv->current_status;
					pamac_alpm_utils_do_emit_hook_progress (self, _tmp120_, (const gchar*) _tmp121_, _tmp122_, self->current_progress);
					_tmp123_ = g_ptr_array_index (details, (guint) 1);
					_tmp124_ = g_utf8_strdown ((const gchar*) _tmp123_, (gssize) -1);
					_tmp125_ = _tmp124_;
					_tmp126_ = string_contains (_tmp125_, "error");
					_g_free0 (_tmp125_);
					if (_tmp126_) {
						pamac_alpm_utils_do_emit_warning (self, g_dgettext (NULL, "Error while running hooks"));
						pamac_alpm_utils_do_important_details_outpout (self, TRUE);
					}
				} else {
					const gchar* _tmp127_;
					gconstpointer _tmp128_;
					const gchar* _tmp129_;
					gconstpointer _tmp130_;
					gchar* _tmp131_;
					gchar* _tmp132_;
					gboolean _tmp133_;
					_tmp127_ = self->current_action;
					_tmp128_ = g_ptr_array_index (details, (guint) 0);
					_tmp129_ = self->priv->current_status;
					pamac_alpm_utils_do_emit_hook_progress (self, _tmp127_, (const gchar*) _tmp128_, _tmp129_, self->current_progress);
					_tmp130_ = g_ptr_array_index (details, (guint) 0);
					_tmp131_ = g_utf8_strdown ((const gchar*) _tmp130_, (gssize) -1);
					_tmp132_ = _tmp131_;
					_tmp133_ = string_contains (_tmp132_, "error");
					_g_free0 (_tmp132_);
					if (_tmp133_) {
						pamac_alpm_utils_do_emit_warning (self, g_dgettext (NULL, "Error while running hooks"));
						pamac_alpm_utils_do_important_details_outpout (self, TRUE);
					}
				}
			}
			_g_free0 (status);
			break;
		}
		default:
		{
			break;
		}
	}
}

void
pamac_alpm_utils_emit_progress (PamacAlpmUtils* self,
                                guint progress,
                                const gchar* pkgname,
                                guint percent,
                                guint n_targets,
                                guint current_target)
{
	gdouble fraction = 0.0;
	gchar* status = NULL;
	gchar* _tmp0_;
	gboolean changed = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgname != NULL);
	switch (progress) {
		case 0:
		case 1:
		case 2:
		case 3:
		case 4:
		{
			fraction = (((gdouble) (current_target - 1)) / n_targets) + (((gdouble) percent) / (100 * n_targets));
			break;
		}
		default:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
		{
			fraction = ((gdouble) percent) / 100;
			break;
		}
	}
	_tmp0_ = g_strdup_printf ("%lu/%lu", (gulong) current_target, (gulong) n_targets);
	status = _tmp0_;
	changed = FALSE;
	if (fraction != self->current_progress) {
		self->current_progress = fraction;
		changed = TRUE;
	}
	_tmp1_ = status;
	_tmp2_ = self->priv->current_status;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		gchar* _tmp3_;
		_tmp3_ = status;
		status = NULL;
		_g_free0 (self->priv->current_status);
		self->priv->current_status = _tmp3_;
		changed = TRUE;
	}
	if (changed) {
		const gchar* _tmp4_;
		_tmp4_ = self->current_action;
		if (g_strcmp0 (_tmp4_, "") != 0) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->current_action;
			_tmp6_ = self->priv->current_status;
			pamac_alpm_utils_do_emit_action_progress (self, _tmp5_, _tmp6_, self->current_progress);
		}
	}
	_g_free0 (status);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

void
pamac_alpm_utils_emit_download (PamacAlpmUtils* self,
                                guint64 xfered,
                                guint64 total)
{
	GString* text = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GString* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	g_return_if_fail (self != NULL);
	if (xfered == ((guint64) 0)) {
		GTimer* _tmp0_;
		_tmp0_ = self->rate_timer;
		g_timer_start (_tmp0_);
		if (self->total_download == ((guint64) 0)) {
			GQueue* _tmp1_;
			_tmp1_ = self->priv->download_rates;
			g_queue_clear (_tmp1_);
			self->priv->download_rate = (gdouble) 0;
		}
		return;
	}
	_tmp2_ = g_format_size_full (xfered, G_FORMAT_SIZE_DEFAULT);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_string_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	text = _tmp7_;
	if (self->current_progress < ((gdouble) 1)) {
		gdouble fraction = 0.0;
		fraction = ((gdouble) xfered) / total;
		if (fraction <= ((gdouble) 1)) {
			GString* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gdouble elapsed = 0.0;
			GTimer* _tmp13_;
			_tmp8_ = text;
			_tmp9_ = g_format_size_full (total, G_FORMAT_SIZE_DEFAULT);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf ("/%s", _tmp10_);
			_tmp12_ = _tmp11_;
			g_string_append (_tmp8_, _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			_tmp13_ = self->rate_timer;
			elapsed = g_timer_elapsed (_tmp13_, NULL);
			if (elapsed > ((gdouble) 1)) {
				gdouble current_rate = 0.0;
				GQueue* _tmp14_;
				GQueue* _tmp18_;
				gdouble* _tmp19_;
				GQueue* _tmp22_;
				current_rate = (xfered - self->already_downloaded) / elapsed;
				self->already_downloaded = xfered;
				_tmp14_ = self->priv->download_rates;
				if (_tmp14_->length > ((guint) 10)) {
					GQueue* _tmp15_;
					gpointer _tmp16_;
					gdouble* _tmp17_;
					_tmp15_ = self->priv->download_rates;
					_tmp16_ = g_queue_pop_head (_tmp15_);
					_tmp17_ = (gdouble*) _tmp16_;
					_g_free0 (_tmp17_);
				}
				_tmp18_ = self->priv->download_rates;
				_tmp19_ = __double_dup0 (&current_rate);
				g_queue_push_tail (_tmp18_, _tmp19_);
				if (xfered == total) {
					GTimer* _tmp20_;
					_tmp20_ = self->rate_timer;
					g_timer_stop (_tmp20_);
				} else {
					GTimer* _tmp21_;
					_tmp21_ = self->rate_timer;
					g_timer_start (_tmp21_);
				}
				_tmp22_ = self->priv->download_rates;
				if (_tmp22_->length == ((guint) 10)) {
					gdouble total_rates = 0.0;
					GQueue* _tmp23_;
					GList* _tmp24_;
					total_rates = (gdouble) 0;
					_tmp23_ = self->priv->download_rates;
					_tmp24_ = _tmp23_->head;
					{
						GList* previous_rate_collection = NULL;
						GList* previous_rate_it = NULL;
						previous_rate_collection = _tmp24_;
						for (previous_rate_it = previous_rate_collection; previous_rate_it != NULL; previous_rate_it = previous_rate_it->next) {
							gdouble previous_rate = 0.0;
							previous_rate = *((gdouble*) previous_rate_it->data);
							{
								total_rates += previous_rate;
							}
						}
					}
					self->priv->download_rate = total_rates / 10;
				}
			}
			if (self->priv->download_rate > ((gdouble) 0)) {
				guint remaining_seconds = 0U;
				GString* _tmp25_;
				remaining_seconds = (guint) round ((total - xfered) / self->priv->download_rate);
				_tmp25_ = text;
				g_string_append (_tmp25_, " ");
				if (remaining_seconds > ((guint) 0)) {
					if (remaining_seconds < ((guint) 60)) {
						GString* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp26_ = text;
						_tmp27_ = g_strdup_printf (g_dngettext (NULL, "About %lu second remaining", "About %lu seconds remaining", (gulong) remaining_seconds), (gulong) remaining_seconds);
						_tmp28_ = _tmp27_;
						g_string_append (_tmp26_, _tmp28_);
						_g_free0 (_tmp28_);
					} else {
						guint remaining_minutes = 0U;
						GString* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						remaining_minutes = (guint) round ((gdouble) (remaining_seconds / 60));
						_tmp29_ = text;
						_tmp30_ = g_strdup_printf (g_dngettext (NULL, "About %lu minute remaining", "About %lu minutes remaining", (gulong) remaining_minutes), (gulong) remaining_minutes);
						_tmp31_ = _tmp30_;
						g_string_append (_tmp29_, _tmp31_);
						_g_free0 (_tmp31_);
					}
				}
			}
		} else {
			GTimer* _tmp32_;
			fraction = (gdouble) 1;
			_tmp32_ = self->rate_timer;
			g_timer_stop (_tmp32_);
		}
		if (fraction != self->current_progress) {
			self->current_progress = fraction;
		}
	}
	_tmp33_ = text;
	_tmp34_ = _tmp33_->str;
	_tmp35_ = self->priv->current_status;
	if (g_strcmp0 (_tmp34_, _tmp35_) != 0) {
		GString* _tmp36_;
		gchar* _tmp37_;
		_tmp36_ = text;
		_tmp37_ = _tmp36_->str;
		_tmp36_->str = NULL;
		_g_free0 (self->priv->current_status);
		self->priv->current_status = _tmp37_;
	}
	_tmp38_ = self->current_action;
	_tmp39_ = self->priv->current_status;
	pamac_alpm_utils_do_emit_download_progress (self, _tmp38_, _tmp39_, self->current_progress);
	_g_string_free0 (text);
}

void
pamac_alpm_utils_emit_totaldownload (PamacAlpmUtils* self,
                                     guint64 total)
{
	GQueue* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->download_rates;
	g_queue_clear (_tmp0_);
	self->priv->download_rate = (gdouble) 0;
	self->current_progress = (gdouble) 0;
	self->already_downloaded = (guint64) 0;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->current_status);
	self->priv->current_status = _tmp1_;
	self->total_download = total;
}

void
pamac_alpm_utils_emit_log (PamacAlpmUtils* self,
                           guint level,
                           const gchar* msg)
{
	gchar* line = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	line = NULL;
	if (level == ((guint) 1)) {
		const gchar* _tmp0_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp0_ = self->current_filename;
		if (g_strcmp0 (_tmp0_, "") != 0) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = g_strconcat (g_dgettext (NULL, "Error"), ": ", NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = self->current_filename;
			_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, ": ", NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, msg, NULL);
			_g_free0 (line);
			line = _tmp8_;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp2_);
		} else {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = g_strconcat (g_dgettext (NULL, "Error"), ": ", NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp10_, msg, NULL);
			_g_free0 (line);
			line = _tmp11_;
			_g_free0 (_tmp10_);
		}
		pamac_alpm_utils_do_important_details_outpout (self, FALSE);
		_tmp12_ = line;
		_tmp13_ = string_replace (_tmp12_, "\n", "");
		_tmp14_ = _tmp13_;
		pamac_alpm_utils_do_emit_script_output (self, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		if (level == ((guint) (1 << 1))) {
			const gchar* _tmp15_;
			if (self->priv->no_confirm_commit) {
				_g_free0 (line);
				return;
			}
			_tmp15_ = self->current_filename;
			if (g_strcmp0 (_tmp15_, "manjaro-system") != 0) {
				const gchar* _tmp16_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp16_ = self->current_filename;
				if (g_strcmp0 (_tmp16_, "") != 0) {
					gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp17_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = self->current_filename;
					_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp21_, ": ", NULL);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat (_tmp23_, msg, NULL);
					_g_free0 (line);
					line = _tmp24_;
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
					_g_free0 (_tmp18_);
				} else {
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp25_ = g_strconcat (g_dgettext (NULL, "Warning"), ": ", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp26_, msg, NULL);
					_g_free0 (line);
					line = _tmp27_;
					_g_free0 (_tmp26_);
				}
				_tmp28_ = line;
				_tmp29_ = string_replace (_tmp28_, "\n", "");
				_tmp30_ = _tmp29_;
				pamac_alpm_utils_do_emit_script_output (self, _tmp30_);
				_g_free0 (_tmp30_);
			}
		}
	}
	_g_free0 (line);
}

static void
g_cclosure_user_marshal_INT__STRING_BOXED (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef gint (*GMarshalFunc_INT__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_INT__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
	g_value_set_int (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gdouble arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_double (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                  GValue * return_value,
                                                                  guint n_param_values,
                                                                  const GValue * param_values,
                                                                  gpointer invocation_hint,
                                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gdouble arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_double (param_values + 5), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_BOXED (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOXED) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
pamac_alpm_utils_class_init (PamacAlpmUtilsClass * klass,
                             gpointer klass_data)
{
	pamac_alpm_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacAlpmUtils_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_alpm_utils_finalize;
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_CHOOSE_PROVIDER_SIGNAL] = g_signal_new ("choose-provider", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__STRING_BOXED, G_TYPE_INT, 2, G_TYPE_STRING, G_TYPE_PTR_ARRAY);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_START_DOWNLOADING_SIGNAL] = g_signal_new ("start-downloading", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_STOP_DOWNLOADING_SIGNAL] = g_signal_new ("stop-downloading", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_SIGNAL] = g_signal_new ("emit-action", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ACTION_PROGRESS_SIGNAL] = g_signal_new ("emit-action-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_DOWNLOAD_PROGRESS_SIGNAL] = g_signal_new ("emit-download-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_HOOK_PROGRESS_SIGNAL] = g_signal_new ("emit-hook-progress", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_SCRIPT_OUTPUT_SIGNAL] = g_signal_new ("emit-script-output", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_WARNING_SIGNAL] = g_signal_new ("emit-warning", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_EMIT_ERROR_SIGNAL] = g_signal_new ("emit-error", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_PTR_ARRAY);
	pamac_alpm_utils_signals[PAMAC_ALPM_UTILS_IMPORTANT_DETAILS_OUTPOUT_SIGNAL] = g_signal_new ("important-details-outpout", PAMAC_TYPE_ALPM_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
}

static void
pamac_alpm_utils_instance_init (PamacAlpmUtils * self,
                                gpointer klass)
{
	self->priv = pamac_alpm_utils_get_instance_private (self);
}

static void
pamac_alpm_utils_finalize (GObject * obj)
{
	PamacAlpmUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	_g_free0 (self->priv->sender);
	_g_object_unref0 (self->priv->config);
	_alpm_config_unref0 (self->alpm_config);
	_g_free0 (self->priv->tmp_path);
	_g_object_unref0 (self->lockfile);
	_alpm_release0 (self->alpm_handle);
	_g_free0 (self->priv->current_status);
	_g_hash_table_unref0 (self->priv->to_install);
	_g_hash_table_unref0 (self->priv->deps_to_install);
	_g_hash_table_unref0 (self->priv->to_remove);
	_g_hash_table_unref0 (self->priv->required_to_remove);
	_g_hash_table_unref0 (self->priv->orphans_to_remove);
	_g_hash_table_unref0 (self->priv->conflicts_to_remove);
	_g_hash_table_unref0 (self->priv->local_paths);
	_g_hash_table_unref0 (self->priv->remote_paths);
	_g_hash_table_unref0 (self->priv->to_build);
	_g_hash_table_unref0 (self->priv->checked_deps);
	_g_hash_table_unref0 (self->priv->to_install_as_dep);
	_g_hash_table_unref0 (self->priv->ignorepkgs);
	_g_hash_table_unref0 (self->priv->overwrite_files);
	_g_hash_table_unref0 (self->priv->to_syncfirst);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->current_filename);
	_g_free0 (self->current_action);
	_g_ptr_array_unref0 (self->unresolvables);
	_g_hash_table_unref0 (self->multi_progress);
	_g_timer_destroy0 (self->rate_timer);
	(self->priv->download_rates == NULL) ? NULL : (self->priv->download_rates = (_g_queue_free__g_free0_ (self->priv->download_rates), NULL));
	G_OBJECT_CLASS (pamac_alpm_utils_parent_class)->finalize (obj);
}

static GType
pamac_alpm_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacAlpmUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_alpm_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacAlpmUtils), 0, (GInstanceInitFunc) pamac_alpm_utils_instance_init, NULL };
	GType pamac_alpm_utils_type_id;
	pamac_alpm_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacAlpmUtils", &g_define_type_info, 0);
	PamacAlpmUtils_private_offset = g_type_add_instance_private (pamac_alpm_utils_type_id, sizeof (PamacAlpmUtilsPrivate));
	return pamac_alpm_utils_type_id;
}

GType
pamac_alpm_utils_get_type (void)
{
	static volatile gsize pamac_alpm_utils_type_id__once = 0;
	if (g_once_init_enter (&pamac_alpm_utils_type_id__once)) {
		GType pamac_alpm_utils_type_id;
		pamac_alpm_utils_type_id = pamac_alpm_utils_get_type_once ();
		g_once_init_leave (&pamac_alpm_utils_type_id__once, pamac_alpm_utils_type_id);
	}
	return pamac_alpm_utils_type_id__once;
}

void
write_log_file (const gchar* event)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* log = NULL;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* file = NULL;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (event != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	_tmp2_ = g_date_time_format (_tmp1_, "[%Y-%m-%dT%H:%M:%S%z]");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s [PAMAC] %s\n", _tmp3_, event);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	log = _tmp5_;
	_tmp6_ = g_file_new_for_path ("/var/log/pacman.log");
	file = _tmp6_;
	{
		GFileOutputStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileOutputStream* _tmp9_;
		GDataOutputStream* dos = NULL;
		GDataOutputStream* _tmp10_;
		GDataOutputStream* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = file;
		_tmp9_ = g_file_append_to (_tmp8_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = g_data_output_stream_new ((GOutputStream*) _tmp7_);
		dos = _tmp10_;
		_tmp11_ = dos;
		_tmp12_ = log;
		g_data_output_stream_put_string (_tmp11_, _tmp12_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dos);
			_g_object_unref0 (_tmp7_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dos);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("alpm_utils.vala:2433: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (log);
		_g_date_time_unref0 (now);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (log);
	_g_date_time_unref0 (now);
}

void
cb_event (void* ctx,
          alpm_event_t* data)
{
	PamacAlpmUtils* alpm_utils = NULL;
	GPtrArray* details = NULL;
	GPtrArray* _tmp0_;
	guint secondary_type = 0U;
	PamacAlpmUtils* _tmp95_;
	GPtrArray* _tmp96_;
	g_return_if_fail (data != NULL);
	alpm_utils = G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	details = _tmp0_;
	secondary_type = (guint) 0;
	switch (data->type) {
		case ALPM_EVENT_HOOK_START:
		{
			switch (data->hook.when) {
				case ALPM_HOOK_PRE_TRANSACTION:
				{
					secondary_type = (guint) ALPM_HOOK_PRE_TRANSACTION;
					break;
				}
				case ALPM_HOOK_POST_TRANSACTION:
				{
					secondary_type = (guint) ALPM_HOOK_POST_TRANSACTION;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case ALPM_EVENT_HOOK_RUN_START:
		{
			GPtrArray* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_;
			GPtrArray* _tmp6_;
			gchar* _tmp7_;
			GPtrArray* _tmp8_;
			gchar* _tmp9_;
			GPtrArray* _tmp10_;
			gchar* _tmp11_;
			_tmp1_ = details;
			_tmp2_ = data->hook_run.name;
			_tmp3_ = g_strdup (_tmp2_);
			g_ptr_array_add (_tmp1_, _tmp3_);
			_tmp5_ = data->hook_run.desc;
			_tmp4_ = _tmp5_;
			if (_tmp4_ == NULL) {
				_tmp4_ = "";
			}
			_tmp6_ = details;
			_tmp7_ = g_strdup (_tmp4_);
			g_ptr_array_add (_tmp6_, _tmp7_);
			_tmp8_ = details;
			_tmp9_ = g_strdup_printf ("%" G_GSIZE_FORMAT, data->hook_run.position);
			g_ptr_array_add (_tmp8_, _tmp9_);
			_tmp10_ = details;
			_tmp11_ = g_strdup_printf ("%" G_GSIZE_FORMAT, data->hook_run.total);
			g_ptr_array_add (_tmp10_, _tmp11_);
			break;
		}
		case ALPM_EVENT_PACKAGE_OPERATION_START:
		{
			switch (data->package_operation.operation) {
				case ALPM_PACKAGE_REMOVE:
				{
					GPtrArray* _tmp12_;
					alpm_pkg_t* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					GPtrArray* _tmp17_;
					alpm_pkg_t* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp12_ = details;
					_tmp13_ = data->package_operation.oldpkg;
					_tmp14_ = alpm_pkg_get_name (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					g_ptr_array_add (_tmp12_, _tmp16_);
					_tmp17_ = details;
					_tmp18_ = data->package_operation.oldpkg;
					_tmp19_ = alpm_pkg_get_version (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strdup (_tmp20_);
					g_ptr_array_add (_tmp17_, _tmp21_);
					secondary_type = (guint) ALPM_PACKAGE_REMOVE;
					break;
				}
				case ALPM_PACKAGE_INSTALL:
				{
					GPtrArray* _tmp22_;
					alpm_pkg_t* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					GPtrArray* _tmp27_;
					alpm_pkg_t* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp22_ = details;
					_tmp23_ = data->package_operation.newpkg;
					_tmp24_ = alpm_pkg_get_name (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strdup (_tmp25_);
					g_ptr_array_add (_tmp22_, _tmp26_);
					_tmp27_ = details;
					_tmp28_ = data->package_operation.newpkg;
					_tmp29_ = alpm_pkg_get_version (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strdup (_tmp30_);
					g_ptr_array_add (_tmp27_, _tmp31_);
					secondary_type = (guint) ALPM_PACKAGE_INSTALL;
					break;
				}
				case ALPM_PACKAGE_REINSTALL:
				{
					GPtrArray* _tmp32_;
					alpm_pkg_t* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					GPtrArray* _tmp37_;
					alpm_pkg_t* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp32_ = details;
					_tmp33_ = data->package_operation.newpkg;
					_tmp34_ = alpm_pkg_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strdup (_tmp35_);
					g_ptr_array_add (_tmp32_, _tmp36_);
					_tmp37_ = details;
					_tmp38_ = data->package_operation.newpkg;
					_tmp39_ = alpm_pkg_get_version (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strdup (_tmp40_);
					g_ptr_array_add (_tmp37_, _tmp41_);
					secondary_type = (guint) ALPM_PACKAGE_REINSTALL;
					break;
				}
				case ALPM_PACKAGE_UPGRADE:
				{
					GPtrArray* _tmp42_;
					alpm_pkg_t* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					GPtrArray* _tmp47_;
					alpm_pkg_t* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					GPtrArray* _tmp52_;
					alpm_pkg_t* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp42_ = details;
					_tmp43_ = data->package_operation.oldpkg;
					_tmp44_ = alpm_pkg_get_name (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_strdup (_tmp45_);
					g_ptr_array_add (_tmp42_, _tmp46_);
					_tmp47_ = details;
					_tmp48_ = data->package_operation.oldpkg;
					_tmp49_ = alpm_pkg_get_version (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					g_ptr_array_add (_tmp47_, _tmp51_);
					_tmp52_ = details;
					_tmp53_ = data->package_operation.newpkg;
					_tmp54_ = alpm_pkg_get_version (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strdup (_tmp55_);
					g_ptr_array_add (_tmp52_, _tmp56_);
					secondary_type = (guint) ALPM_PACKAGE_UPGRADE;
					break;
				}
				case ALPM_PACKAGE_DOWNGRADE:
				{
					GPtrArray* _tmp57_;
					alpm_pkg_t* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					GPtrArray* _tmp62_;
					alpm_pkg_t* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					gchar* _tmp66_;
					GPtrArray* _tmp67_;
					alpm_pkg_t* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_;
					_tmp57_ = details;
					_tmp58_ = data->package_operation.oldpkg;
					_tmp59_ = alpm_pkg_get_name (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strdup (_tmp60_);
					g_ptr_array_add (_tmp57_, _tmp61_);
					_tmp62_ = details;
					_tmp63_ = data->package_operation.oldpkg;
					_tmp64_ = alpm_pkg_get_version (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = g_strdup (_tmp65_);
					g_ptr_array_add (_tmp62_, _tmp66_);
					_tmp67_ = details;
					_tmp68_ = data->package_operation.newpkg;
					_tmp69_ = alpm_pkg_get_version (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strdup (_tmp70_);
					g_ptr_array_add (_tmp67_, _tmp71_);
					secondary_type = (guint) ALPM_PACKAGE_DOWNGRADE;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case ALPM_EVENT_SCRIPTLET_INFO:
		{
			GPtrArray* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			_tmp72_ = details;
			_tmp73_ = data->scriptlet_info.line;
			_tmp74_ = g_strdup (_tmp73_);
			g_ptr_array_add (_tmp72_, _tmp74_);
			break;
		}
		case ALPM_EVENT_PKG_RETRIEVE_START:
		{
			PamacAlpmUtils* _tmp75_;
			GCancellable* _tmp76_;
			PamacAlpmUtils* _tmp77_;
			_tmp75_ = alpm_utils;
			_tmp76_ = _tmp75_->cancellable;
			if (g_cancellable_is_cancelled (_tmp76_)) {
				_g_ptr_array_unref0 (details);
				return;
			}
			_tmp77_ = alpm_utils;
			pamac_alpm_utils_emit_totaldownload (_tmp77_, data->pkg_retrieve.total_size);
			break;
		}
		case ALPM_EVENT_OPTDEP_REMOVAL:
		{
			GPtrArray* _tmp78_;
			alpm_pkg_t* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			gchar* _tmp82_;
			GPtrArray* _tmp83_;
			alpm_depend_t* _tmp84_;
			gchar* _tmp85_;
			_tmp78_ = details;
			_tmp79_ = data->optdep_removal.pkg;
			_tmp80_ = alpm_pkg_get_name (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strdup (_tmp81_);
			g_ptr_array_add (_tmp78_, _tmp82_);
			_tmp83_ = details;
			_tmp84_ = data->optdep_removal.optdep;
			_tmp85_ = alpm_dep_compute_string (_tmp84_);
			g_ptr_array_add (_tmp83_, _tmp85_);
			break;
		}
		case ALPM_EVENT_DATABASE_MISSING:
		{
			GPtrArray* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp86_ = details;
			_tmp87_ = data->database_missing.dbname;
			_tmp88_ = g_strdup (_tmp87_);
			g_ptr_array_add (_tmp86_, _tmp88_);
			break;
		}
		case ALPM_EVENT_PACNEW_CREATED:
		{
			GPtrArray* _tmp89_;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			_tmp89_ = details;
			_tmp90_ = data->pacnew_created.file;
			_tmp91_ = g_strdup (_tmp90_);
			g_ptr_array_add (_tmp89_, _tmp91_);
			break;
		}
		case ALPM_EVENT_PACSAVE_CREATED:
		{
			GPtrArray* _tmp92_;
			const gchar* _tmp93_;
			gchar* _tmp94_;
			_tmp92_ = details;
			_tmp93_ = data->pacsave_created.file;
			_tmp94_ = g_strdup (_tmp93_);
			g_ptr_array_add (_tmp92_, _tmp94_);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp95_ = alpm_utils;
	_tmp96_ = details;
	pamac_alpm_utils_emit_event (_tmp95_, (guint) data->type, secondary_type, _tmp96_);
	_g_ptr_array_unref0 (details);
}

void
cb_question (void* ctx,
             alpm_question_t* data)
{
	PamacAlpmUtils* alpm_utils = NULL;
	g_return_if_fail (data != NULL);
	alpm_utils = G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	switch (data->type) {
		case ALPM_QUESTION_INSTALL_IGNOREPKG:
		{
			data->install_ignorepkg.install = 0;
			break;
		}
		case ALPM_QUESTION_REPLACE_PKG:
		{
			data->replace.replace = 1;
			break;
		}
		case ALPM_QUESTION_CONFLICT_PKG:
		{
			data->conflict.remove = 1;
			break;
		}
		case ALPM_QUESTION_REMOVE_PKGS:
		{
			PamacAlpmUtils* _tmp0_;
			GPtrArray* _tmp1_;
			alpm_list_t* list = NULL;
			alpm_list_t* _tmp2_;
			_tmp0_ = alpm_utils;
			_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			_g_ptr_array_unref0 (_tmp0_->unresolvables);
			_tmp0_->unresolvables = _tmp1_;
			_tmp2_ = data->remove_pkgs.packages;
			list = _tmp2_;
			while (TRUE) {
				alpm_list_t* _tmp3_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp4_;
				gconstpointer _tmp5_;
				PamacAlpmUtils* _tmp6_;
				GPtrArray* _tmp7_;
				alpm_pkg_t* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp3_ = list;
				if (!(_tmp3_ != NULL)) {
					break;
				}
				_tmp4_ = list;
				_tmp5_ = _tmp4_->data;
				pkg = (alpm_pkg_t*) _tmp5_;
				_tmp6_ = alpm_utils;
				_tmp7_ = _tmp6_->unresolvables;
				_tmp8_ = pkg;
				_tmp9_ = alpm_pkg_get_name (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strdup (_tmp10_);
				g_ptr_array_add (_tmp7_, _tmp11_);
				list = alpm_list_next (list);
			}
			data->remove_pkgs.skip = 0;
			break;
		}
		case ALPM_QUESTION_SELECT_PROVIDER:
		{
			gchar* depend_str = NULL;
			alpm_depend_t* _tmp12_;
			gchar* _tmp13_;
			GPtrArray* providers_str = NULL;
			GPtrArray* _tmp14_;
			alpm_list_t* list = NULL;
			alpm_list_t* _tmp15_;
			PamacAlpmUtils* _tmp24_;
			const gchar* _tmp25_;
			GPtrArray* _tmp26_;
			_tmp12_ = data->select_provider.depend;
			_tmp13_ = alpm_dep_compute_string (_tmp12_);
			depend_str = _tmp13_;
			_tmp14_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
			providers_str = _tmp14_;
			_tmp15_ = data->select_provider.providers;
			list = _tmp15_;
			while (TRUE) {
				alpm_list_t* _tmp16_;
				alpm_pkg_t* pkg = NULL;
				alpm_list_t* _tmp17_;
				gconstpointer _tmp18_;
				GPtrArray* _tmp19_;
				alpm_pkg_t* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp16_ = list;
				if (!(_tmp16_ != NULL)) {
					break;
				}
				_tmp17_ = list;
				_tmp18_ = _tmp17_->data;
				pkg = (alpm_pkg_t*) _tmp18_;
				_tmp19_ = providers_str;
				_tmp20_ = pkg;
				_tmp21_ = alpm_pkg_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup (_tmp22_);
				g_ptr_array_add (_tmp19_, _tmp23_);
				list = alpm_list_next (list);
			}
			_tmp24_ = alpm_utils;
			_tmp25_ = depend_str;
			_tmp26_ = providers_str;
			data->select_provider.use_index = pamac_alpm_utils_do_choose_provider (_tmp24_, _tmp25_, _tmp26_);
			_g_ptr_array_unref0 (providers_str);
			_g_free0 (depend_str);
			break;
		}
		case ALPM_QUESTION_CORRUPTED_PKG:
		{
			data->corrupted.remove = 1;
			break;
		}
		case ALPM_QUESTION_IMPORT_KEY:
		{
			data->import_key.import = 1;
			break;
		}
		default:
		{
			data->any.answer = 0;
			break;
		}
	}
}

void
cb_progress (void* ctx,
             alpm_progress_t progress,
             const gchar* pkgname,
             gint percent,
             guint n_targets,
             guint current_target)
{
	PamacAlpmUtils* alpm_utils = NULL;
	g_return_if_fail (pkgname != NULL);
	alpm_utils = G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	pamac_alpm_utils_emit_progress (alpm_utils, (guint) progress, pkgname, (guint) percent, n_targets, current_target);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

void
compute_multi_download_progress (PamacAlpmUtils* alpm_utils)
{
	guint64 total_progress = 0ULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	guint64* progress = NULL;
	g_return_if_fail (alpm_utils != NULL);
	total_progress = (guint64) 0;
	_tmp0_ = alpm_utils->multi_progress;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		guint64* _tmp3_;
		guint64* _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_free0 (progress);
		_tmp3_ = __uint64_dup0 ((guint64*) _tmp1_);
		progress = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = progress;
		total_progress += *_tmp4_;
	}
	pamac_alpm_utils_emit_download (alpm_utils, total_progress, alpm_utils->total_download);
	_g_free0 (progress);
}

void
emit_download (PamacAlpmUtils* alpm_utils,
               const gchar* filename,
               guint64 xfered,
               guint64 total)
{
	g_return_if_fail (alpm_utils != NULL);
	g_return_if_fail (filename != NULL);
	if (alpm_utils->total_download == ((guint64) 0)) {
		pamac_alpm_utils_emit_download (alpm_utils, xfered, total);
	} else {
		GHashTable* _tmp0_;
		gchar* _tmp1_;
		guint64* _tmp2_;
		_tmp0_ = alpm_utils->multi_progress;
		_tmp1_ = g_strdup (filename);
		_tmp2_ = __uint64_dup0 (&xfered);
		g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
		compute_multi_download_progress (alpm_utils);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
cb_download (void* ctx,
             const gchar* filename,
             alpm_download_event_type_t event_type,
             void* event_data)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	GCancellable* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp8_;
	gchar* version_release = NULL;
	gchar* _tmp9_;
	g_return_if_fail (filename != NULL);
	alpm_utils = G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	_tmp0_ = alpm_utils;
	_tmp1_ = _tmp0_->cancellable;
	if (g_cancellable_is_cancelled (_tmp1_)) {
		PamacAlpmUtils* _tmp2_;
		alpm_handle_t* _tmp3_;
		PamacAlpmUtils* _tmp4_;
		PamacAlpmUtils* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = alpm_utils;
		_tmp3_ = _tmp2_->alpm_handle;
		alpm_unlock (_tmp3_);
		_tmp4_ = alpm_utils;
		pamac_alpm_utils_do_emit_script_output (_tmp4_, "");
		_tmp5_ = alpm_utils;
		_tmp6_ = g_strconcat (g_dgettext (NULL, "Transaction cancelled"), ".", NULL);
		_tmp7_ = _tmp6_;
		pamac_alpm_utils_do_emit_action (_tmp5_, _tmp7_);
		_g_free0 (_tmp7_);
		g_thread_exit ((gpointer) ((gintptr) -1));
	}
	_tmp8_ = g_strdup ("");
	name = _tmp8_;
	_tmp9_ = g_strdup ("");
	version_release = _tmp9_;
	switch (event_type) {
		case ALPM_DOWNLOAD_INIT:
		{
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			PamacAlpmUtils* _tmp38_;
			if (g_str_has_suffix (filename, ".db")) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = g_str_has_suffix (filename, ".files");
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = g_str_has_suffix (filename, ".json.gz");
			}
			if (_tmp10_) {
			} else {
				if (g_str_has_suffix (filename, ".sig")) {
				} else {
					gchar* name_version_release = NULL;
					gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = string_slice (filename, (glong) 0, (glong) string_last_index_of_char (filename, (gunichar) '-', 0));
					name_version_release = _tmp12_;
					_tmp13_ = name_version_release;
					if (_tmp13_ != NULL) {
						gchar* name_version = NULL;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						const gchar* _tmp17_;
						_tmp14_ = name_version_release;
						_tmp15_ = name_version_release;
						_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) string_last_index_of_char (_tmp15_, (gunichar) '-', 0));
						name_version = _tmp16_;
						_tmp17_ = name_version;
						if (_tmp17_ != NULL) {
							gint version_index = 0;
							const gchar* _tmp18_;
							gchar* tmp_name = NULL;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							const gchar* _tmp21_;
							_tmp18_ = name_version;
							version_index = string_last_index_of_char (_tmp18_, (gunichar) '-', 0);
							_tmp19_ = name_version;
							_tmp20_ = string_slice (_tmp19_, (glong) 0, (glong) version_index);
							tmp_name = _tmp20_;
							_tmp21_ = tmp_name;
							if (_tmp21_ != NULL) {
								const gchar* _tmp22_;
								gchar* _tmp23_;
								gchar* tmp_version_release = NULL;
								const gchar* _tmp24_;
								const gchar* _tmp25_;
								gint _tmp26_;
								gint _tmp27_;
								gchar* _tmp28_;
								const gchar* _tmp29_;
								_tmp22_ = tmp_name;
								_tmp23_ = g_strdup (_tmp22_);
								_g_free0 (name);
								name = _tmp23_;
								_tmp24_ = name_version_release;
								_tmp25_ = name_version_release;
								_tmp26_ = strlen (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = string_slice (_tmp24_, (glong) (version_index + 1), (glong) _tmp27_);
								tmp_version_release = _tmp28_;
								_tmp29_ = tmp_version_release;
								if (_tmp29_ != NULL) {
									const gchar* _tmp30_;
									gchar* _tmp31_;
									PamacAlpmUtils* _tmp32_;
									const gchar* _tmp33_;
									const gchar* _tmp34_;
									gchar* _tmp35_;
									gchar* _tmp36_;
									gchar* _tmp37_;
									_tmp30_ = tmp_version_release;
									_tmp31_ = g_strdup (_tmp30_);
									_g_free0 (version_release);
									version_release = _tmp31_;
									_tmp32_ = alpm_utils;
									_tmp33_ = name;
									_tmp34_ = version_release;
									_tmp35_ = g_strdup_printf ("%s (%s)", _tmp33_, _tmp34_);
									_tmp36_ = _tmp35_;
									_tmp37_ = g_strdup_printf (_ ("Download of %s started"), _tmp36_);
									_g_free0 (_tmp32_->current_action);
									_tmp32_->current_action = _tmp37_;
									_g_free0 (_tmp36_);
								}
								_g_free0 (tmp_version_release);
							}
							_g_free0 (tmp_name);
						}
						_g_free0 (name_version);
					}
					_g_free0 (name_version_release);
				}
			}
			_tmp38_ = alpm_utils;
			emit_download (_tmp38_, filename, (guint64) 0, (guint64) 0);
			break;
		}
		case ALPM_DOWNLOAD_PROGRESS:
		{
			PamacAlpmUtils* _tmp39_;
			const gchar* _tmp40_;
			alpm_download_event_progress_t* progress_data = NULL;
			PamacAlpmUtils* _tmp50_;
			alpm_download_event_progress_t* _tmp51_;
			alpm_download_event_progress_t* _tmp52_;
			_tmp39_ = alpm_utils;
			_tmp40_ = _tmp39_->current_action;
			if (!string_contains (_tmp40_, filename)) {
				gboolean _tmp41_ = FALSE;
				if (g_str_has_suffix (filename, ".db")) {
					_tmp41_ = TRUE;
				} else {
					_tmp41_ = g_str_has_suffix (filename, ".files");
				}
				if (_tmp41_) {
					PamacAlpmUtils* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					_tmp42_ = alpm_utils;
					_tmp43_ = g_strdup_printf (_ ("Refreshing %s"), filename);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strconcat (_tmp44_, "...", NULL);
					_g_free0 (_tmp42_->current_action);
					_tmp42_->current_action = _tmp45_;
					_g_free0 (_tmp44_);
				} else {
					if (g_str_has_suffix (filename, ".json.gz")) {
						PamacAlpmUtils* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp46_ = alpm_utils;
						_tmp47_ = g_strdup_printf (_ ("Refreshing %s"), _ ("AUR"));
						_tmp48_ = _tmp47_;
						_tmp49_ = g_strconcat (_tmp48_, "...", NULL);
						_g_free0 (_tmp46_->current_action);
						_tmp46_->current_action = _tmp49_;
						_g_free0 (_tmp48_);
					}
				}
			}
			progress_data = (alpm_download_event_progress_t*) event_data;
			_tmp50_ = alpm_utils;
			_tmp51_ = progress_data;
			_tmp52_ = progress_data;
			emit_download (_tmp50_, filename, _tmp51_->downloaded, _tmp52_->total);
			break;
		}
		case ALPM_DOWNLOAD_COMPLETED:
		{
			alpm_download_event_completed_t* completed_data = NULL;
			alpm_download_event_completed_t* _tmp53_;
			completed_data = (alpm_download_event_completed_t*) event_data;
			_tmp53_ = completed_data;
			if (_tmp53_->result == 0) {
				gboolean _tmp54_ = FALSE;
				gboolean _tmp55_ = FALSE;
				if (g_str_has_suffix (filename, ".db")) {
					_tmp55_ = TRUE;
				} else {
					_tmp55_ = g_str_has_suffix (filename, ".files");
				}
				if (_tmp55_) {
					_tmp54_ = TRUE;
				} else {
					_tmp54_ = g_str_has_suffix (filename, ".json.gz");
				}
				if (_tmp54_) {
				} else {
					if (g_str_has_suffix (filename, ".sig")) {
					} else {
						gchar* name_version_release = NULL;
						gchar* _tmp56_;
						const gchar* _tmp57_;
						guint64 size = 0ULL;
						alpm_download_event_completed_t* _tmp82_;
						PamacAlpmUtils* _tmp83_;
						_tmp56_ = string_slice (filename, (glong) 0, (glong) string_last_index_of_char (filename, (gunichar) '-', 0));
						name_version_release = _tmp56_;
						_tmp57_ = name_version_release;
						if (_tmp57_ != NULL) {
							gchar* name_version = NULL;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							gchar* _tmp60_;
							const gchar* _tmp61_;
							_tmp58_ = name_version_release;
							_tmp59_ = name_version_release;
							_tmp60_ = string_slice (_tmp58_, (glong) 0, (glong) string_last_index_of_char (_tmp59_, (gunichar) '-', 0));
							name_version = _tmp60_;
							_tmp61_ = name_version;
							if (_tmp61_ != NULL) {
								gint version_index = 0;
								const gchar* _tmp62_;
								gchar* tmp_name = NULL;
								const gchar* _tmp63_;
								gchar* _tmp64_;
								const gchar* _tmp65_;
								_tmp62_ = name_version;
								version_index = string_last_index_of_char (_tmp62_, (gunichar) '-', 0);
								_tmp63_ = name_version;
								_tmp64_ = string_slice (_tmp63_, (glong) 0, (glong) version_index);
								tmp_name = _tmp64_;
								_tmp65_ = tmp_name;
								if (_tmp65_ != NULL) {
									const gchar* _tmp66_;
									gchar* _tmp67_;
									gchar* tmp_version_release = NULL;
									const gchar* _tmp68_;
									const gchar* _tmp69_;
									gint _tmp70_;
									gint _tmp71_;
									gchar* _tmp72_;
									const gchar* _tmp73_;
									_tmp66_ = tmp_name;
									_tmp67_ = g_strdup (_tmp66_);
									_g_free0 (name);
									name = _tmp67_;
									_tmp68_ = name_version_release;
									_tmp69_ = name_version_release;
									_tmp70_ = strlen (_tmp69_);
									_tmp71_ = _tmp70_;
									_tmp72_ = string_slice (_tmp68_, (glong) (version_index + 1), (glong) _tmp71_);
									tmp_version_release = _tmp72_;
									_tmp73_ = tmp_version_release;
									if (_tmp73_ != NULL) {
										const gchar* _tmp74_;
										gchar* _tmp75_;
										PamacAlpmUtils* _tmp76_;
										const gchar* _tmp77_;
										const gchar* _tmp78_;
										gchar* _tmp79_;
										gchar* _tmp80_;
										gchar* _tmp81_;
										_tmp74_ = tmp_version_release;
										_tmp75_ = g_strdup (_tmp74_);
										_g_free0 (version_release);
										version_release = _tmp75_;
										_tmp76_ = alpm_utils;
										_tmp77_ = name;
										_tmp78_ = version_release;
										_tmp79_ = g_strdup_printf ("%s (%s)", _tmp77_, _tmp78_);
										_tmp80_ = _tmp79_;
										_tmp81_ = g_strdup_printf (_ ("Download of %s finished"), _tmp80_);
										_g_free0 (_tmp76_->current_action);
										_tmp76_->current_action = _tmp81_;
										_g_free0 (_tmp80_);
									}
									_g_free0 (tmp_version_release);
								}
								_g_free0 (tmp_name);
							}
							_g_free0 (name_version);
						}
						_tmp82_ = completed_data;
						size = _tmp82_->total;
						_tmp83_ = alpm_utils;
						emit_download (_tmp83_, filename, size, size);
						_g_free0 (name_version_release);
					}
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_g_free0 (version_release);
	_g_free0 (name);
}

void
cb_log (void* ctx,
        alpm_loglevel_t level,
        const gchar* fmt,
        va_list args)
{
	PamacAlpmUtils* alpm_utils = NULL;
	PamacAlpmUtils* _tmp0_;
	GCancellable* _tmp1_;
	alpm_loglevel_t logmask = 0;
	gchar* log = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (fmt != NULL);
	alpm_utils = G_TYPE_CHECK_INSTANCE_CAST (ctx, PAMAC_TYPE_ALPM_UTILS, PamacAlpmUtils);
	_tmp0_ = alpm_utils;
	_tmp1_ = _tmp0_->cancellable;
	if (g_cancellable_is_cancelled (_tmp1_)) {
		return;
	}
	logmask = ALPM_LOG_ERROR | ALPM_LOG_WARNING;
	if ((level & logmask) == 0) {
		return;
	}
	log = NULL;
	_tmp2_ = g_strdup_vprintf (fmt, args);
	_g_free0 (log);
	log = _tmp2_;
	_tmp3_ = log;
	if (_tmp3_ != NULL) {
		PamacAlpmUtils* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = alpm_utils;
		_tmp5_ = log;
		pamac_alpm_utils_emit_log (_tmp4_, (guint) level, _tmp5_);
	}
	_g_free0 (log);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

