﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elastictranscoder/ElasticTranscoder_EXPORTS.h>
#include <aws/elastictranscoder/model/AudioParameters.h>
#include <aws/elastictranscoder/model/Thumbnails.h>
#include <aws/elastictranscoder/model/VideoParameters.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ElasticTranscoder {
namespace Model {

/**
 * <p>Presets are templates that contain most of the settings for transcoding media
 * files from one format to another. Elastic Transcoder includes some default
 * presets for common formats, for example, several iPod and iPhone versions. You
 * can also create your own presets for formats that aren't included among the
 * default presets. You specify which preset you want to use when you create a
 * job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elastictranscoder-2012-09-25/Preset">AWS
 * API Reference</a></p>
 */
class Preset {
 public:
  AWS_ELASTICTRANSCODER_API Preset() = default;
  AWS_ELASTICTRANSCODER_API Preset(Aws::Utils::Json::JsonView jsonValue);
  AWS_ELASTICTRANSCODER_API Preset& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ELASTICTRANSCODER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Identifier for the new preset. You use this value to get settings for the
   * preset or to delete it.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  Preset& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the preset.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  Preset& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the preset.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Preset& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the preset.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Preset& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The container type for the output file. Valid values include
   * <code>flac</code>, <code>flv</code>, <code>fmp4</code>, <code>gif</code>,
   * <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>,
   * <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.</p>
   */
  inline const Aws::String& GetContainer() const { return m_container; }
  inline bool ContainerHasBeenSet() const { return m_containerHasBeenSet; }
  template <typename ContainerT = Aws::String>
  void SetContainer(ContainerT&& value) {
    m_containerHasBeenSet = true;
    m_container = std::forward<ContainerT>(value);
  }
  template <typename ContainerT = Aws::String>
  Preset& WithContainer(ContainerT&& value) {
    SetContainer(std::forward<ContainerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A section of the response body that provides information about the audio
   * preset values.</p>
   */
  inline const AudioParameters& GetAudio() const { return m_audio; }
  inline bool AudioHasBeenSet() const { return m_audioHasBeenSet; }
  template <typename AudioT = AudioParameters>
  void SetAudio(AudioT&& value) {
    m_audioHasBeenSet = true;
    m_audio = std::forward<AudioT>(value);
  }
  template <typename AudioT = AudioParameters>
  Preset& WithAudio(AudioT&& value) {
    SetAudio(std::forward<AudioT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A section of the response body that provides information about the video
   * preset values.</p>
   */
  inline const VideoParameters& GetVideo() const { return m_video; }
  inline bool VideoHasBeenSet() const { return m_videoHasBeenSet; }
  template <typename VideoT = VideoParameters>
  void SetVideo(VideoT&& value) {
    m_videoHasBeenSet = true;
    m_video = std::forward<VideoT>(value);
  }
  template <typename VideoT = VideoParameters>
  Preset& WithVideo(VideoT&& value) {
    SetVideo(std::forward<VideoT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A section of the response body that provides information about the thumbnail
   * preset values, if any.</p>
   */
  inline const Thumbnails& GetThumbnails() const { return m_thumbnails; }
  inline bool ThumbnailsHasBeenSet() const { return m_thumbnailsHasBeenSet; }
  template <typename ThumbnailsT = Thumbnails>
  void SetThumbnails(ThumbnailsT&& value) {
    m_thumbnailsHasBeenSet = true;
    m_thumbnails = std::forward<ThumbnailsT>(value);
  }
  template <typename ThumbnailsT = Thumbnails>
  Preset& WithThumbnails(ThumbnailsT&& value) {
    SetThumbnails(std::forward<ThumbnailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the preset is a default preset provided by Elastic Transcoder
   * (<code>System</code>) or a preset that you have defined
   * (<code>Custom</code>).</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  Preset& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_container;
  bool m_containerHasBeenSet = false;

  AudioParameters m_audio;
  bool m_audioHasBeenSet = false;

  VideoParameters m_video;
  bool m_videoHasBeenSet = false;

  Thumbnails m_thumbnails;
  bool m_thumbnailsHasBeenSet = false;

  Aws::String m_type;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticTranscoder
}  // namespace Aws
