﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FraudDetector {
namespace Model {
class GetListElementsResult {
 public:
  AWS_FRAUDDETECTOR_API GetListElementsResult() = default;
  AWS_FRAUDDETECTOR_API GetListElementsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FRAUDDETECTOR_API GetListElementsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The list elements. </p>
   */
  inline const Aws::Vector<Aws::String>& GetElements() const { return m_elements; }
  template <typename ElementsT = Aws::Vector<Aws::String>>
  void SetElements(ElementsT&& value) {
    m_elementsHasBeenSet = true;
    m_elements = std::forward<ElementsT>(value);
  }
  template <typename ElementsT = Aws::Vector<Aws::String>>
  GetListElementsResult& WithElements(ElementsT&& value) {
    SetElements(std::forward<ElementsT>(value));
    return *this;
  }
  template <typename ElementsT = Aws::String>
  GetListElementsResult& AddElements(ElementsT&& value) {
    m_elementsHasBeenSet = true;
    m_elements.emplace_back(std::forward<ElementsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The next page token. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetListElementsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetListElementsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_elements;
  bool m_elementsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FraudDetector
}  // namespace Aws
