﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Glue {
namespace Model {

/**
 */
class DescribeEntityRequest : public GlueRequest {
 public:
  AWS_GLUE_API DescribeEntityRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeEntity"; }

  AWS_GLUE_API Aws::String SerializePayload() const override;

  AWS_GLUE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the connection that contains the connection type credentials.</p>
   */
  inline const Aws::String& GetConnectionName() const { return m_connectionName; }
  inline bool ConnectionNameHasBeenSet() const { return m_connectionNameHasBeenSet; }
  template <typename ConnectionNameT = Aws::String>
  void SetConnectionName(ConnectionNameT&& value) {
    m_connectionNameHasBeenSet = true;
    m_connectionName = std::forward<ConnectionNameT>(value);
  }
  template <typename ConnectionNameT = Aws::String>
  DescribeEntityRequest& WithConnectionName(ConnectionNameT&& value) {
    SetConnectionName(std::forward<ConnectionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The catalog ID of the catalog that contains the connection. This can be null,
   * By default, the Amazon Web Services Account ID is the catalog ID.</p>
   */
  inline const Aws::String& GetCatalogId() const { return m_catalogId; }
  inline bool CatalogIdHasBeenSet() const { return m_catalogIdHasBeenSet; }
  template <typename CatalogIdT = Aws::String>
  void SetCatalogId(CatalogIdT&& value) {
    m_catalogIdHasBeenSet = true;
    m_catalogId = std::forward<CatalogIdT>(value);
  }
  template <typename CatalogIdT = Aws::String>
  DescribeEntityRequest& WithCatalogId(CatalogIdT&& value) {
    SetCatalogId(std::forward<CatalogIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the entity that you want to describe from the connection
   * type.</p>
   */
  inline const Aws::String& GetEntityName() const { return m_entityName; }
  inline bool EntityNameHasBeenSet() const { return m_entityNameHasBeenSet; }
  template <typename EntityNameT = Aws::String>
  void SetEntityName(EntityNameT&& value) {
    m_entityNameHasBeenSet = true;
    m_entityName = std::forward<EntityNameT>(value);
  }
  template <typename EntityNameT = Aws::String>
  DescribeEntityRequest& WithEntityName(EntityNameT&& value) {
    SetEntityName(std::forward<EntityNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A continuation token, included if this is a continuation call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeEntityRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the API used for the data store.</p>
   */
  inline const Aws::String& GetDataStoreApiVersion() const { return m_dataStoreApiVersion; }
  inline bool DataStoreApiVersionHasBeenSet() const { return m_dataStoreApiVersionHasBeenSet; }
  template <typename DataStoreApiVersionT = Aws::String>
  void SetDataStoreApiVersion(DataStoreApiVersionT&& value) {
    m_dataStoreApiVersionHasBeenSet = true;
    m_dataStoreApiVersion = std::forward<DataStoreApiVersionT>(value);
  }
  template <typename DataStoreApiVersionT = Aws::String>
  DescribeEntityRequest& WithDataStoreApiVersion(DataStoreApiVersionT&& value) {
    SetDataStoreApiVersion(std::forward<DataStoreApiVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectionName;
  bool m_connectionNameHasBeenSet = false;

  Aws::String m_catalogId;
  bool m_catalogIdHasBeenSet = false;

  Aws::String m_entityName;
  bool m_entityNameHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_dataStoreApiVersion;
  bool m_dataStoreApiVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
