﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/migrationhuborchestrator/MigrationHubOrchestrator_EXPORTS.h>
#include <aws/migrationhuborchestrator/model/PluginHealth.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MigrationHubOrchestrator {
namespace Model {

/**
 * <p>The summary of the Migration Hub Orchestrator plugin.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/PluginSummary">AWS
 * API Reference</a></p>
 */
class PluginSummary {
 public:
  AWS_MIGRATIONHUBORCHESTRATOR_API PluginSummary() = default;
  AWS_MIGRATIONHUBORCHESTRATOR_API PluginSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API PluginSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the plugin.</p>
   */
  inline const Aws::String& GetPluginId() const { return m_pluginId; }
  inline bool PluginIdHasBeenSet() const { return m_pluginIdHasBeenSet; }
  template <typename PluginIdT = Aws::String>
  void SetPluginId(PluginIdT&& value) {
    m_pluginIdHasBeenSet = true;
    m_pluginId = std::forward<PluginIdT>(value);
  }
  template <typename PluginIdT = Aws::String>
  PluginSummary& WithPluginId(PluginIdT&& value) {
    SetPluginId(std::forward<PluginIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the host.</p>
   */
  inline const Aws::String& GetHostname() const { return m_hostname; }
  inline bool HostnameHasBeenSet() const { return m_hostnameHasBeenSet; }
  template <typename HostnameT = Aws::String>
  void SetHostname(HostnameT&& value) {
    m_hostnameHasBeenSet = true;
    m_hostname = std::forward<HostnameT>(value);
  }
  template <typename HostnameT = Aws::String>
  PluginSummary& WithHostname(HostnameT&& value) {
    SetHostname(std::forward<HostnameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the plugin.</p>
   */
  inline PluginHealth GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(PluginHealth value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline PluginSummary& WithStatus(PluginHealth value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IP address at which the plugin is located.</p>
   */
  inline const Aws::String& GetIpAddress() const { return m_ipAddress; }
  inline bool IpAddressHasBeenSet() const { return m_ipAddressHasBeenSet; }
  template <typename IpAddressT = Aws::String>
  void SetIpAddress(IpAddressT&& value) {
    m_ipAddressHasBeenSet = true;
    m_ipAddress = std::forward<IpAddressT>(value);
  }
  template <typename IpAddressT = Aws::String>
  PluginSummary& WithIpAddress(IpAddressT&& value) {
    SetIpAddress(std::forward<IpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the plugin.</p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  PluginSummary& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the plugin was registered.</p>
   */
  inline const Aws::String& GetRegisteredTime() const { return m_registeredTime; }
  inline bool RegisteredTimeHasBeenSet() const { return m_registeredTimeHasBeenSet; }
  template <typename RegisteredTimeT = Aws::String>
  void SetRegisteredTime(RegisteredTimeT&& value) {
    m_registeredTimeHasBeenSet = true;
    m_registeredTime = std::forward<RegisteredTimeT>(value);
  }
  template <typename RegisteredTimeT = Aws::String>
  PluginSummary& WithRegisteredTime(RegisteredTimeT&& value) {
    SetRegisteredTime(std::forward<RegisteredTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_pluginId;
  bool m_pluginIdHasBeenSet = false;

  Aws::String m_hostname;
  bool m_hostnameHasBeenSet = false;

  PluginHealth m_status{PluginHealth::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_ipAddress;
  bool m_ipAddressHasBeenSet = false;

  Aws::String m_version;
  bool m_versionHasBeenSet = false;

  Aws::String m_registeredTime;
  bool m_registeredTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubOrchestrator
}  // namespace Aws
