﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>A vendor that generates a vulnerability report.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/VulnerabilityVendor">AWS
 * API Reference</a></p>
 */
class VulnerabilityVendor {
 public:
  AWS_SECURITYHUB_API VulnerabilityVendor() = default;
  AWS_SECURITYHUB_API VulnerabilityVendor(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API VulnerabilityVendor& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the vendor.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  VulnerabilityVendor& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL of the vulnerability advisory.</p>
   */
  inline const Aws::String& GetUrl() const { return m_url; }
  inline bool UrlHasBeenSet() const { return m_urlHasBeenSet; }
  template <typename UrlT = Aws::String>
  void SetUrl(UrlT&& value) {
    m_urlHasBeenSet = true;
    m_url = std::forward<UrlT>(value);
  }
  template <typename UrlT = Aws::String>
  VulnerabilityVendor& WithUrl(UrlT&& value) {
    SetUrl(std::forward<UrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The severity that the vendor assigned to the vulnerability.</p>
   */
  inline const Aws::String& GetVendorSeverity() const { return m_vendorSeverity; }
  inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }
  template <typename VendorSeverityT = Aws::String>
  void SetVendorSeverity(VendorSeverityT&& value) {
    m_vendorSeverityHasBeenSet = true;
    m_vendorSeverity = std::forward<VendorSeverityT>(value);
  }
  template <typename VendorSeverityT = Aws::String>
  VulnerabilityVendor& WithVendorSeverity(VendorSeverityT&& value) {
    SetVendorSeverity(std::forward<VendorSeverityT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates when the vulnerability advisory was created.</p> <p>For more
   * information about the validation and formatting of timestamp fields in Security
   * Hub, see <a
   * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
   */
  inline const Aws::String& GetVendorCreatedAt() const { return m_vendorCreatedAt; }
  inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }
  template <typename VendorCreatedAtT = Aws::String>
  void SetVendorCreatedAt(VendorCreatedAtT&& value) {
    m_vendorCreatedAtHasBeenSet = true;
    m_vendorCreatedAt = std::forward<VendorCreatedAtT>(value);
  }
  template <typename VendorCreatedAtT = Aws::String>
  VulnerabilityVendor& WithVendorCreatedAt(VendorCreatedAtT&& value) {
    SetVendorCreatedAt(std::forward<VendorCreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates when the vulnerability advisory was last updated.</p> <p>For more
   * information about the validation and formatting of timestamp fields in Security
   * Hub, see <a
   * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.</p>
   */
  inline const Aws::String& GetVendorUpdatedAt() const { return m_vendorUpdatedAt; }
  inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }
  template <typename VendorUpdatedAtT = Aws::String>
  void SetVendorUpdatedAt(VendorUpdatedAtT&& value) {
    m_vendorUpdatedAtHasBeenSet = true;
    m_vendorUpdatedAt = std::forward<VendorUpdatedAtT>(value);
  }
  template <typename VendorUpdatedAtT = Aws::String>
  VulnerabilityVendor& WithVendorUpdatedAt(VendorUpdatedAtT&& value) {
    SetVendorUpdatedAt(std::forward<VendorUpdatedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_url;
  bool m_urlHasBeenSet = false;

  Aws::String m_vendorSeverity;
  bool m_vendorSeverityHasBeenSet = false;

  Aws::String m_vendorCreatedAt;
  bool m_vendorCreatedAtHasBeenSet = false;

  Aws::String m_vendorUpdatedAt;
  bool m_vendorUpdatedAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
