﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/snow-device-management/SnowDeviceManagement_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SnowDeviceManagement {
namespace Model {

/**
 * <p>Information about the device's security group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/SecurityGroupIdentifier">AWS
 * API Reference</a></p>
 */
class SecurityGroupIdentifier {
 public:
  AWS_SNOWDEVICEMANAGEMENT_API SecurityGroupIdentifier() = default;
  AWS_SNOWDEVICEMANAGEMENT_API SecurityGroupIdentifier(Aws::Utils::Json::JsonView jsonValue);
  AWS_SNOWDEVICEMANAGEMENT_API SecurityGroupIdentifier& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SNOWDEVICEMANAGEMENT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The security group ID.</p>
   */
  inline const Aws::String& GetGroupId() const { return m_groupId; }
  inline bool GroupIdHasBeenSet() const { return m_groupIdHasBeenSet; }
  template <typename GroupIdT = Aws::String>
  void SetGroupId(GroupIdT&& value) {
    m_groupIdHasBeenSet = true;
    m_groupId = std::forward<GroupIdT>(value);
  }
  template <typename GroupIdT = Aws::String>
  SecurityGroupIdentifier& WithGroupId(GroupIdT&& value) {
    SetGroupId(std::forward<GroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The security group name.</p>
   */
  inline const Aws::String& GetGroupName() const { return m_groupName; }
  inline bool GroupNameHasBeenSet() const { return m_groupNameHasBeenSet; }
  template <typename GroupNameT = Aws::String>
  void SetGroupName(GroupNameT&& value) {
    m_groupNameHasBeenSet = true;
    m_groupName = std::forward<GroupNameT>(value);
  }
  template <typename GroupNameT = Aws::String>
  SecurityGroupIdentifier& WithGroupName(GroupNameT&& value) {
    SetGroupName(std::forward<GroupNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_groupId;
  bool m_groupIdHasBeenSet = false;

  Aws::String m_groupName;
  bool m_groupNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SnowDeviceManagement
}  // namespace Aws
