﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workmail/WorkMailRequest.h>
#include <aws/workmail/WorkMail_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkMail {
namespace Model {

/**
 */
class DeleteMobileDeviceAccessRuleRequest : public WorkMailRequest {
 public:
  AWS_WORKMAIL_API DeleteMobileDeviceAccessRuleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteMobileDeviceAccessRule"; }

  AWS_WORKMAIL_API Aws::String SerializePayload() const override;

  AWS_WORKMAIL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The WorkMail organization under which the rule will be deleted.</p>
   */
  inline const Aws::String& GetOrganizationId() const { return m_organizationId; }
  inline bool OrganizationIdHasBeenSet() const { return m_organizationIdHasBeenSet; }
  template <typename OrganizationIdT = Aws::String>
  void SetOrganizationId(OrganizationIdT&& value) {
    m_organizationIdHasBeenSet = true;
    m_organizationId = std::forward<OrganizationIdT>(value);
  }
  template <typename OrganizationIdT = Aws::String>
  DeleteMobileDeviceAccessRuleRequest& WithOrganizationId(OrganizationIdT&& value) {
    SetOrganizationId(std::forward<OrganizationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the rule to be deleted.</p>
   */
  inline const Aws::String& GetMobileDeviceAccessRuleId() const { return m_mobileDeviceAccessRuleId; }
  inline bool MobileDeviceAccessRuleIdHasBeenSet() const { return m_mobileDeviceAccessRuleIdHasBeenSet; }
  template <typename MobileDeviceAccessRuleIdT = Aws::String>
  void SetMobileDeviceAccessRuleId(MobileDeviceAccessRuleIdT&& value) {
    m_mobileDeviceAccessRuleIdHasBeenSet = true;
    m_mobileDeviceAccessRuleId = std::forward<MobileDeviceAccessRuleIdT>(value);
  }
  template <typename MobileDeviceAccessRuleIdT = Aws::String>
  DeleteMobileDeviceAccessRuleRequest& WithMobileDeviceAccessRuleId(MobileDeviceAccessRuleIdT&& value) {
    SetMobileDeviceAccessRuleId(std::forward<MobileDeviceAccessRuleIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_organizationId;
  bool m_organizationIdHasBeenSet = false;

  Aws::String m_mobileDeviceAccessRuleId;
  bool m_mobileDeviceAccessRuleIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
