﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workmail/WorkMail_EXPORTS.h>
#include <aws/workmail/model/MailboxExportJobState.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkMail {
namespace Model {

/**
 * <p>The details of a mailbox export job, including the user or resource ID
 * associated with the mailbox and the S3 bucket that the mailbox contents are
 * exported to.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/MailboxExportJob">AWS
 * API Reference</a></p>
 */
class MailboxExportJob {
 public:
  AWS_WORKMAIL_API MailboxExportJob() = default;
  AWS_WORKMAIL_API MailboxExportJob(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API MailboxExportJob& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the mailbox export job.</p>
   */
  inline const Aws::String& GetJobId() const { return m_jobId; }
  inline bool JobIdHasBeenSet() const { return m_jobIdHasBeenSet; }
  template <typename JobIdT = Aws::String>
  void SetJobId(JobIdT&& value) {
    m_jobIdHasBeenSet = true;
    m_jobId = std::forward<JobIdT>(value);
  }
  template <typename JobIdT = Aws::String>
  MailboxExportJob& WithJobId(JobIdT&& value) {
    SetJobId(std::forward<JobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the user or resource associated with the mailbox.</p>
   */
  inline const Aws::String& GetEntityId() const { return m_entityId; }
  inline bool EntityIdHasBeenSet() const { return m_entityIdHasBeenSet; }
  template <typename EntityIdT = Aws::String>
  void SetEntityId(EntityIdT&& value) {
    m_entityIdHasBeenSet = true;
    m_entityId = std::forward<EntityIdT>(value);
  }
  template <typename EntityIdT = Aws::String>
  MailboxExportJob& WithEntityId(EntityIdT&& value) {
    SetEntityId(std::forward<EntityIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The mailbox export job description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  MailboxExportJob& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the S3 bucket.</p>
   */
  inline const Aws::String& GetS3BucketName() const { return m_s3BucketName; }
  inline bool S3BucketNameHasBeenSet() const { return m_s3BucketNameHasBeenSet; }
  template <typename S3BucketNameT = Aws::String>
  void SetS3BucketName(S3BucketNameT&& value) {
    m_s3BucketNameHasBeenSet = true;
    m_s3BucketName = std::forward<S3BucketNameT>(value);
  }
  template <typename S3BucketNameT = Aws::String>
  MailboxExportJob& WithS3BucketName(S3BucketNameT&& value) {
    SetS3BucketName(std::forward<S3BucketNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The path to the S3 bucket and file that the mailbox export job exports
   * to.</p>
   */
  inline const Aws::String& GetS3Path() const { return m_s3Path; }
  inline bool S3PathHasBeenSet() const { return m_s3PathHasBeenSet; }
  template <typename S3PathT = Aws::String>
  void SetS3Path(S3PathT&& value) {
    m_s3PathHasBeenSet = true;
    m_s3Path = std::forward<S3PathT>(value);
  }
  template <typename S3PathT = Aws::String>
  MailboxExportJob& WithS3Path(S3PathT&& value) {
    SetS3Path(std::forward<S3PathT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The estimated progress of the mailbox export job, in percentage points.</p>
   */
  inline int GetEstimatedProgress() const { return m_estimatedProgress; }
  inline bool EstimatedProgressHasBeenSet() const { return m_estimatedProgressHasBeenSet; }
  inline void SetEstimatedProgress(int value) {
    m_estimatedProgressHasBeenSet = true;
    m_estimatedProgress = value;
  }
  inline MailboxExportJob& WithEstimatedProgress(int value) {
    SetEstimatedProgress(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the mailbox export job.</p>
   */
  inline MailboxExportJobState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(MailboxExportJobState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline MailboxExportJob& WithState(MailboxExportJobState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The mailbox export job start timestamp.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  MailboxExportJob& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The mailbox export job end timestamp.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  MailboxExportJob& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_jobId;
  bool m_jobIdHasBeenSet = false;

  Aws::String m_entityId;
  bool m_entityIdHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_s3BucketName;
  bool m_s3BucketNameHasBeenSet = false;

  Aws::String m_s3Path;
  bool m_s3PathHasBeenSet = false;

  int m_estimatedProgress{0};
  bool m_estimatedProgressHasBeenSet = false;

  MailboxExportJobState m_state{MailboxExportJobState::NOT_SET};
  bool m_stateHasBeenSet = false;

  Aws::Utils::DateTime m_startTime{};
  bool m_startTimeHasBeenSet = false;

  Aws::Utils::DateTime m_endTime{};
  bool m_endTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
