"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoopPolicy = void 0;
const abort_1 = require("./common/abort");
const Executor_1 = require("./common/Executor");
/**
 * A no-op policy, useful for unit tests and stubs.
 */
class NoopPolicy {
    constructor() {
        this.executor = new Executor_1.ExecuteWrapper();
        this.onSuccess = this.executor.onSuccess;
        this.onFailure = this.executor.onFailure;
    }
    async execute(fn, signal = abort_1.neverAbortedSignal) {
        return (0, Executor_1.returnOrThrow)(await this.executor.invoke(fn, { signal }));
    }
}
exports.NoopPolicy = NoopPolicy;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/0f0d87fa9e96c856c5212fc86db137ac0d783365/node_modules/cockatiel/dist/NoopPolicy.js.map