/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.access.DBAPrivilegeType;

public enum PostgrePrivilegeType implements DBAPrivilegeType
{
    ALL(' ', false, Object.class),
    SELECT('r', true, PostgreTableBase.class, PostgreTableColumn.class),
    INSERT('a', true, PostgreTableReal.class, PostgreTableColumn.class),
    UPDATE('w', true, PostgreTableBase.class, PostgreTableColumn.class),
    DELETE('d', true, PostgreTableReal.class, PostgreTableColumn.class),
    TRUNCATE('D', true, PostgreTableReal.class),
    REFERENCES('x', true, PostgreTableReal.class, PostgreTableColumn.class),
    TRIGGER('t', true, PostgreTableReal.class),
    CREATE('C', true, PostgreDatabase.class, PostgreSchema.class, PostgreTablespace.class),
    CONNECT('c', true, PostgreDatabase.class),
    TEMPORARY('T', true, PostgreDatabase.class),
    EXECUTE('X', true, PostgreProcedure.class),
    USAGE('U', true, PostgreSequence.class, PostgreDataType.class, PostgreSchema.class),
    MAINTAIN('m', true, PostgreTable.class, PostgreMaterializedView.class),
    RULE('R', true, PostgreTableReal.class),
    GRANT('g', true, PostgreDatabase.class, PostgreSchema.class, PostgreTableReal.class, PostgreDataType.class),
    ZONECONFIG('z', true, PostgreDatabase.class, PostgreTableReal.class),
    ALTER('A', true, PostgreDatabase.class, PostgreSchema.class, PostgreTableReal.class),
    UNKNOWN('\u0000', false, new Class[0]);

    private final Class<?>[] targetType;
    private final char code;
    private final boolean valid;

    private PostgrePrivilegeType(char code, boolean valid, Class<?> ... targetType) {
        this.code = code;
        this.valid = valid;
        this.targetType = targetType;
    }

    public char getCode() {
        return this.code;
    }

    public Class<?>[] getTargetType() {
        return this.targetType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean supportsType(@NotNull Class<?> objectType) {
        if (PostgreRole.class.isAssignableFrom(objectType)) {
            return true;
        }
        Class<?>[] classArray = this.targetType;
        int n = this.targetType.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            if (aClass.isAssignableFrom(objectType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getName() {
        return this.name();
    }

    public static PostgrePrivilegeType fromString(String type) {
        try {
            return PostgrePrivilegeType.valueOf(type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }

    public static PostgrePrivilegeType getByCode(char pCode) {
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = PostgrePrivilegeType.values();
        int n = postgrePrivilegeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
            if (pt.getCode() == pCode) {
                return pt;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

