/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;

abstract class AbstractCreateResourcesOperation
extends AbstractResourcesOperation {
    AbstractCreateResourcesOperation(IResourceSnapshot<? extends IResource>[] resourceDescriptions, String label) {
        super(resourceDescriptions, label);
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.recreate(monitor, uiInfo);
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.delete(monitor, uiInfo, false);
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean modified = false;
        if (operation == UNDO) {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                factory.delete(resource);
                modified = true;
                ++n2;
            }
        } else {
            IResourceSnapshot[] iResourceSnapshotArray = this.resourceDescriptions;
            int n = this.resourceDescriptions.length;
            int n3 = 0;
            while (n3 < n) {
                IResourceSnapshot resourceDescription = iResourceSnapshotArray[n3];
                if (resourceDescription != null) {
                    IResource resource = resourceDescription.createResourceHandle();
                    factory.create(resource);
                    modified = true;
                }
                ++n3;
            }
        }
        return modified;
    }

    @Override
    protected ISchedulingRule getExecuteSchedulingRule() {
        return super.computeCreateSchedulingRule();
    }

    @Override
    protected ISchedulingRule getUndoSchedulingRule() {
        return super.computeDeleteSchedulingRule();
    }

    @Override
    public IStatus computeExecutionStatus(IProgressMonitor monitor) {
        IStatus status = super.computeExecutionStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        return status;
    }

    @Override
    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeRedoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }
}

