/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.BranchXmlWriter;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class ExportToOoWriter
implements IExportEngine {
    public FileFilter getFileFilter() {
        return new CaseSensitiveFileNameExtensionFilter("odt", TextUtils.getText((String)"ExportToOoWriter.text"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(List<NodeModel> branches, File chosenFile) {
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            this.exportToOoWriter(branches, chosenFile);
        }
        catch (Exception ex) {
            LogUtils.warn((Throwable)ex);
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void applyXsltFile(String xsltFileName, StringWriter writer, Result result) {
        URL xsltUrl = ResourceController.getResourceController().getResource(xsltFileName);
        if (xsltUrl == null) {
            LogUtils.severe((String)("Can't find " + xsltFileName + " as resource."));
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        try (BufferedInputStream xsltStream = new BufferedInputStream(xsltUrl.openStream());){
            StringReader reader = new StringReader(writer.getBuffer().toString());
            TransformerFactory transFact = TransformerFactory.newInstance();
            StreamSource xsltSource = new StreamSource(xsltStream);
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(new StreamSource(reader), result);
            return;
        }
        catch (Exception e) {
            UITools.errorMessage((Object)e.getMessage());
            LogUtils.warn((Throwable)e);
            return;
        }
    }

    public void exportToOoWriter(List<NodeModel> branches, File file) throws IOException {
        try (ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(file));){
            StringWriter writer = new StringWriter();
            new BranchXmlWriter(branches).writeXml(writer, MapWriter.Mode.EXPORT);
            StreamResult result = new StreamResult(zipout);
            ZipEntry entry = new ZipEntry("content.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.xsl", writer, result);
            zipout.closeEntry();
            entry = new ZipEntry("META-INF/manifest.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.manifest.xsl", writer, result);
            zipout.closeEntry();
            entry = new ZipEntry("styles.xml");
            zipout.putNextEntry(entry);
            this.applyXsltFile("/xslt/export2oowriter.styles.xsl", writer, result);
            zipout.closeEntry();
        }
    }
}

