/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.Specificity;
import java.util.Comparator;
import org.w3c.dom.DOMException;

public class StyleRule
extends CSSStyleDeclarationRule
implements CSSStyleRule {
    private static final long serialVersionUID = 1L;

    public StyleRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)1, origin);
    }

    public StyleRule() {
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        SelectorList selist;
        Parser parser = this.createSACParser();
        try {
            selist = parser.parseSelectors(selectorText, new SheetNamespaceMap());
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        super.setSelectorList(selist);
    }

    @Override
    public SelectorList getSelectorList() {
        return super.getSelectorList();
    }

    RuleSpecificity getSpecificity(int index, SelectorMatcher matcher) {
        return new RuleSpecificity(this.getSelectorList().item(index), matcher);
    }

    private class SheetNamespaceMap
    implements Parser.NamespaceMap {
        private SheetNamespaceMap() {
        }

        @Override
        public String getNamespaceURI(String nsPrefix) {
            return ((BaseCSSStyleSheet)StyleRule.this.getParentStyleSheet()).getNamespaceURI(nsPrefix);
        }
    }

    class RuleSpecificity
    extends Specificity {
        private static final long serialVersionUID = 1L;

        public RuleSpecificity(Selector selector, SelectorMatcher matcher) {
            super(selector, matcher);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getCSSStyleRule().getOrigin();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.getCSSStyleRule().getOrigin() == ((RuleSpecificity)obj).getCSSStyleRule().getOrigin();
        }

        public StyleRule getCSSStyleRule() {
            return StyleRule.this;
        }
    }

    static class SpecificityComparator
    implements Comparator<RuleSpecificity> {
        SpecificityComparator() {
        }

        @Override
        public int compare(RuleSpecificity o1, RuleSpecificity o2) {
            return (o2.getCSSStyleRule().getOrigin() - o1.getCSSStyleRule().getOrigin()) * 131071 + Specificity.selectorCompare(o1, o2);
        }
    }
}

