/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntKeyIndexer;
import ghidra.util.datastruct.Prime;
import java.io.Serializable;

public class IntObjectHashtable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntKeyIndexer indexer;
    private T[] values;
    private int capacity;

    public IntObjectHashtable() {
        this(3);
    }

    public IntObjectHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntKeyIndexer(capacity);
        this.values = new Object[capacity];
    }

    public void put(int key, T value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public T get(int key) {
        int index = this.indexer.get(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public boolean remove(int key) {
        int index = this.indexer.remove(key);
        if (index >= 0) {
            this.values[index] = null;
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.indexer.clear();
        this.values = new Object[this.values.length];
    }

    public boolean contains(int key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public int[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        T[] oldValues = this.values;
        this.values = new Object[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

