/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.services.StringValidatorQuery;
import ghidra.app.services.StringValidityScore;
import ghidra.framework.plugintool.PluginTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface StringValidatorService {
    public static final StringValidatorService DUMMY = new DummyStringValidator();

    public static List<StringValidatorService> getCurrentStringValidatorServices(PluginTool tool) {
        ArrayList<StringValidatorService> results = new ArrayList<StringValidatorService>(List.of((StringValidatorService[])tool.getServices(StringValidatorService.class)));
        Collections.sort(results, (s1, s2) -> s1.getValidatorServiceName().compareTo(s2.getValidatorServiceName()));
        return results;
    }

    public String getValidatorServiceName();

    public StringValidityScore getStringValidityScore(StringValidatorQuery var1);

    public static class DummyStringValidator
    implements StringValidatorService {
        @Override
        public String getValidatorServiceName() {
            return "Dummy";
        }

        @Override
        public StringValidityScore getStringValidityScore(StringValidatorQuery query) {
            return StringValidityScore.makeDummyFor(query.stringValue());
        }
    }
}

