/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RepositoryItem
implements Serializable {
    public static final long serialVersionUID = 2L;
    public static final int FILE = 1;
    public static final int DATABASE = 2;
    protected String folderPath;
    protected String itemName;
    protected String fileID;
    protected int itemType;
    protected String contentType;
    protected int version;
    protected long versionTime;

    protected RepositoryItem() {
    }

    public RepositoryItem(String folderPath, String itemName, String fileID, int itemType, String contentType, int version, long versionTime) {
        this.folderPath = folderPath;
        this.itemName = itemName;
        this.fileID = fileID;
        this.itemType = itemType;
        this.contentType = contentType;
        this.version = version;
        this.versionTime = versionTime;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(2L);
        out.writeUTF(this.folderPath);
        out.writeUTF(this.itemName);
        out.writeUTF(this.fileID != null ? this.fileID : "");
        out.writeInt(this.itemType);
        out.writeUTF(this.contentType != null ? this.contentType : "");
        out.writeInt(this.version);
        out.writeLong(this.versionTime);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long serialVersion = in.readLong();
        if (serialVersion != 2L) {
            throw new ClassNotFoundException("Unsupported version of RepositoryItemStatus");
        }
        this.folderPath = in.readUTF();
        this.itemName = in.readUTF();
        this.fileID = in.readUTF();
        if (this.fileID.length() == 0) {
            this.fileID = null;
        }
        this.itemType = in.readInt();
        this.contentType = in.readUTF();
        if (this.contentType.length() == 0) {
            this.contentType = null;
        }
        this.version = in.readInt();
        this.versionTime = in.readLong();
    }

    public String getName() {
        return this.itemName;
    }

    public String getPathName() {
        return this.folderPath + FileSystem.SEPARATOR + this.itemName;
    }

    public String getParentPath() {
        return this.folderPath;
    }

    public int getItemType() {
        return this.itemType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileID() {
        return this.fileID;
    }

    public int getVersion() {
        return this.version;
    }

    public long getVersionTime() {
        return this.versionTime;
    }
}

