/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.widgets.filechooser.FileComparator;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.table.AbstractSortedTableModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

class DirectoryTableModel
extends AbstractSortedTableModel<File> {
    private static final long serialVersionUID = 1L;
    static final int FILE_COL = 0;
    static final int SIZE_COL = 1;
    static final int TIME_COL = 2;
    private GhidraFileChooser chooser;
    private List<File> files = new ArrayList<File>();

    DirectoryTableModel(GhidraFileChooser chooser) {
        super(0);
        this.chooser = chooser;
    }

    void insert(File file) {
        int len = this.files.size();
        this.files.add(file);
        this.fireTableRowsInserted(len, len);
    }

    void setFiles(List<File> fileList) {
        this.files.clear();
        this.files.addAll(fileList);
        this.fireTableDataChanged();
    }

    File getFile(int row) {
        if (row >= 0 && row < this.files.size()) {
            return this.files.get(row);
        }
        return null;
    }

    void setFile(int row, File file) {
        if (row >= 0 && row < this.files.size()) {
            this.files.set(row, file);
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public String getName() {
        return "Directory";
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return File.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Filename";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Modified";
            }
        }
        return "<<unknown>>";
    }

    @Override
    public Object getColumnValueForRow(File file, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return file;
            }
            case 1: {
                if (this.chooser.getModel().isDirectory(file)) break;
                return file.length();
            }
            case 2: {
                return new Date(file.lastModified());
            }
        }
        return null;
    }

    @Override
    public List<File> getModelData() {
        return this.files;
    }

    @Override
    protected int getIndexForRowObject(File rowObject) {
        return super.getIndexForRowObject(rowObject);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row < 0 || row >= this.files.size()) {
            return;
        }
        if (aValue == null) {
            return;
        }
        switch (column) {
            case 0: {
                this.files.set(row, (File)aValue);
                this.update();
            }
        }
    }

    void update() {
        this.fireTableDataChanged();
    }

    @Override
    protected Comparator<File> createSortComparator(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FileComparator(this.chooser.getModel(), 1111);
            }
            case 1: {
                return new FileComparator(this.chooser.getModel(), 2222);
            }
            case 2: {
                return new FileComparator(this.chooser.getModel(), 3333);
            }
        }
        return super.createSortComparator(columnIndex);
    }

    @Override
    public boolean isSortable(int columnIndex) {
        return true;
    }
}

