/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExpressionSolver<T extends PatternExpression> {
    private Class<T> tcls;
    protected RecursiveDescentSolver solver;
    protected final DbgTimer dbg = DbgTimer.INACTIVE;

    public AbstractExpressionSolver(Class<T> tcls) {
        this.tcls = tcls;
    }

    public abstract AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> var1, T var2, MaskedLong var3, Map<String, Long> var4, AssemblyResolvedPatterns var5, Set<SolverHint> var6, String var7) throws NeedsBackfillException;

    public abstract MaskedLong getValue(T var1, Map<String, Long> var2, AssemblyResolvedPatterns var3) throws NeedsBackfillException;

    public abstract int getInstructionLength(T var1);

    public abstract MaskedLong valueForResolution(T var1, Map<String, Long> var2, AssemblyResolvedPatterns var3);

    protected void register(RecursiveDescentSolver general) {
        this.solver = general;
        general.register(this.tcls, this);
    }
}

