/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.math.BigInteger;

public interface AddressRange
extends Comparable<AddressRange>,
Iterable<Address> {
    public long getLength();

    public BigInteger getBigLength();

    public boolean contains(Address var1);

    public AddressRange intersect(AddressRange var1);

    public AddressRange intersectRange(Address var1, Address var2);

    public boolean intersects(AddressRange var1);

    public boolean intersects(Address var1, Address var2);

    @Override
    public int compareTo(Address var1);

    public Address getMaxAddress();

    public Address getMinAddress();

    public AddressSpace getAddressSpace();

    public static void checkValidRange(Address start, Address end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Null start or end address was specified");
        }
        if (!start.getAddressSpace().equals(end.getAddressSpace())) {
            throw new IllegalArgumentException("Start and end addresses must be in same address space!  Start " + String.valueOf(start) + "   end = " + String.valueOf(end));
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start address must be less than or equal to end address:  Start " + String.valueOf(start) + "   end = " + String.valueOf(end));
        }
    }
}

