/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.util.NeighborCache;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.util.AfterRunnable;
import org.jungrapht.visualization.layout.algorithms.util.CircleLayoutReduceEdgeCrossing;
import org.jungrapht.visualization.layout.algorithms.util.ExecutorConsumer;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleLayoutAlgorithm<V>
implements LayoutAlgorithm<V>,
AfterRunnable,
Threaded,
ExecutorConsumer {
    private static final Logger log = LoggerFactory.getLogger(CircleLayoutAlgorithm.class);
    protected static final String CIRCLE_REDUCE_EDGE_CROSSING = "jungrapht.circle.reduceEdgeCrossing";
    protected static final String CIRCLE_REDUCE_EDGE_CROSSING_MAX_EDGES = "jungrapht.circle.reduceEdgeCrossingMaxEdges";
    protected static final String CIRCLE_THREADED = "jungrapht.circle.threaded";
    protected LayoutModel<V> layoutModel;
    protected Executor executor;
    protected double radius;
    protected boolean reduceEdgeCrossing;
    protected List<V> vertexOrderedList;
    protected Runnable after;
    private boolean threaded;
    CompletableFuture theFuture;
    protected int reduceEdgeCrossingMaxEdges;
    int crossingCount = -1;
    protected boolean cancelled;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    protected CircleLayoutAlgorithm(Builder<V, ?, ?> builder) {
        this(builder.executor, builder.radius, builder.reduceEdgeCrossing, builder.reduceEdgeCrossingMaxEdges, builder.threaded, builder.after);
    }

    private CircleLayoutAlgorithm(Executor executor, int radius, boolean reduceEdgeCrossing, int reduceEdgeCrossingMaxEdges, boolean threaded, Runnable after) {
        this.executor = executor;
        this.radius = radius;
        this.reduceEdgeCrossing = reduceEdgeCrossing;
        this.reduceEdgeCrossingMaxEdges = reduceEdgeCrossingMaxEdges;
        this.threaded = threaded;
        this.after = after;
        this.reduceEdgeCrossingMaxEdges = Integer.getInteger(CIRCLE_REDUCE_EDGE_CROSSING_MAX_EDGES, 100);
    }

    public CircleLayoutAlgorithm() {
        this(CircleLayoutAlgorithm.builder());
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    private void computeVertexOrder(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (this.reduceEdgeCrossing) {
            boolean bl = this.reduceEdgeCrossing = graph.edgeSet().size() < this.reduceEdgeCrossingMaxEdges;
        }
        if (this.reduceEdgeCrossing) {
            this.vertexOrderedList = new ArrayList<V>();
            ReduceCrossingRunnable reduceCrossingRunnable = new ReduceCrossingRunnable(graph, this.vertexOrderedList);
            if (this.threaded) {
                this.theFuture = this.executor != null ? CompletableFuture.runAsync(reduceCrossingRunnable, this.executor).thenRun(() -> {
                    log.trace("ReduceEdgeCrossing done");
                    this.layoutVertices(layoutModel, true);
                    this.runAfter();
                    layoutModel.getViewChangeSupport().fireViewChanged();
                    layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
                }) : CompletableFuture.runAsync(reduceCrossingRunnable).thenRun(() -> {
                    log.trace("ReduceEdgeCrossing done");
                    this.layoutVertices(layoutModel, true);
                    this.runAfter();
                    layoutModel.getViewChangeSupport().fireViewChanged();
                    layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
                });
            } else {
                reduceCrossingRunnable.run();
                this.layoutVertices(layoutModel, true);
                this.runAfter();
                layoutModel.getViewChangeSupport().fireViewChanged();
                layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
            }
        } else {
            this.vertexOrderedList = new ArrayList<V>(graph.vertexSet());
            this.layoutVertices(layoutModel, false);
            this.runAfter();
            layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
        }
        if (log.isTraceEnabled()) {
            log.trace("crossing count {}", (Object)CircleLayoutReduceEdgeCrossing.countCrossings(graph, this.vertexOrderedList.toArray()));
        }
    }

    public int getCrossingCount() {
        if (this.crossingCount < 0) {
            this.crossingCount = this.countCrossings();
        }
        return this.crossingCount;
    }

    @Override
    public boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void setVertexOrder(LayoutModel<V> layoutModel, List<V> vertexList) {
        Objects.requireNonNull(Boolean.valueOf(vertexList.containsAll(layoutModel.getGraph().vertexSet())), "Supplied list must include all vertices of the graph");
        this.vertexOrderedList = vertexList;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.layoutModel = layoutModel;
        if (layoutModel != null) {
            this.computeVertexOrder(layoutModel);
        }
    }

    private void layoutVertices(LayoutModel<V> layoutModel, boolean countCrossings) {
        double height = layoutModel.getHeight();
        double width = layoutModel.getWidth();
        if (this.radius <= 0.0) {
            this.radius = 0.35 * Math.max(width, height);
        }
        int i = 0;
        for (V vertex : this.vertexOrderedList) {
            double angle = Math.PI * 2 * (double)i / (double)this.vertexOrderedList.size();
            double posX = Math.cos(angle) * this.radius + width / 2.0;
            double posY = Math.sin(angle) * this.radius + height / 2.0;
            if (!layoutModel.isLocked(vertex)) {
                layoutModel.set(vertex, posX, posY);
            }
            if (log.isTraceEnabled()) {
                log.trace("set {} to {},{} ", new Object[]{vertex, posX, posY});
            }
            ++i;
        }
        if (countCrossings) {
            this.crossingCount = this.countCrossings();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void runAfter() {
        if (this.after != null) {
            this.after.run();
        }
    }

    @Override
    public void setAfter(Runnable after) {
        this.after = after;
    }

    public <E> int countCrossings() {
        if (this.vertexOrderedList.size() == 0) {
            return -1;
        }
        Object[] vertices = this.vertexOrderedList.toArray(new Object[0]);
        HashMap vertexListPositions = new HashMap();
        Graph graph = this.layoutModel.getGraph();
        IntStream.range(0, vertices.length).forEach(i -> vertexListPositions.put(vertices[i], i));
        int numberOfCrossings = 0;
        LinkedHashSet openEdgeList = new LinkedHashSet();
        ArrayList<Object> verticesSeen = new ArrayList<Object>();
        for (Object v : vertices) {
            log.trace("for vertex {}", v);
            verticesSeen.add(v);
            ArrayList incidentEdges = new ArrayList(graph.edgesOf(v));
            incidentEdges.sort((e, f) -> {
                int deltaf;
                Object oppe = Graphs.getOppositeVertex((Graph)graph, (Object)e, (Object)v);
                Object oppf = Graphs.getOppositeVertex((Graph)graph, (Object)f, (Object)v);
                int idxv = (Integer)vertexListPositions.get(v);
                int idxe = (Integer)vertexListPositions.get(oppe);
                int idxf = (Integer)vertexListPositions.get(oppf);
                int deltae = idxv - idxe;
                if (deltae < 0) {
                    deltae += vertices.length;
                }
                if ((deltaf = idxv - idxf) < 0) {
                    deltaf += vertices.length;
                }
                return Integer.compare(deltae, deltaf);
            });
            for (Object e2 : incidentEdges) {
                Object opposite = Graphs.getOppositeVertex(graph, e2, (Object)v);
                if (!verticesSeen.contains(opposite)) {
                    openEdgeList.add(e2);
                } else {
                    openEdgeList.remove(e2);
                    for (int i2 = verticesSeen.indexOf(opposite) + 1; i2 < verticesSeen.indexOf(v); ++i2) {
                        Object tween = verticesSeen.get(i2);
                        numberOfCrossings = (int)((long)numberOfCrossings + graph.edgesOf(tween).stream().filter(openEdgeList::contains).count());
                        log.trace("numberOfCrossings now {}", (Object)numberOfCrossings);
                    }
                }
                log.trace("added edge {}", e2);
            }
        }
        return numberOfCrossings;
    }

    @Override
    public boolean constrained() {
        return false;
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, T extends CircleLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected int radius;
        protected Executor executor;
        protected boolean reduceEdgeCrossing = Boolean.parseBoolean(System.getProperty("jungrapht.circle.reduceEdgeCrossing", "true"));
        protected int reduceEdgeCrossingMaxEdges = Integer.getInteger("jungrapht.circle.reduceEdgeCrossingMaxEdges", 200);
        protected Runnable after = () -> {};
        protected boolean threaded = Boolean.parseBoolean(System.getProperty("jungrapht.circle.threaded", "true"));

        B self() {
            return (B)this;
        }

        public B executor(Executor executor) {
            this.executor = executor;
            return this.self();
        }

        public B radius(int radius) {
            this.radius = radius;
            return this.self();
        }

        public B reduceEdgeCrossingMaxEdges(int reduceEdgeCrossingMaxEdges) {
            this.reduceEdgeCrossingMaxEdges = reduceEdgeCrossingMaxEdges;
            return this.self();
        }

        public B reduceEdgeCrossing(boolean reduceEdgeCrossing) {
            this.reduceEdgeCrossing = reduceEdgeCrossing;
            return this.self();
        }

        public B threaded(boolean threaded) {
            this.threaded = threaded;
            return this.self();
        }

        public B after(Runnable after) {
            this.after = after;
            return this.self();
        }

        @Override
        public T build() {
            return (T)new CircleLayoutAlgorithm(this);
        }
    }

    static class ReduceCrossingRunnable<V, E>
    implements Runnable {
        Graph<V, E> graph;
        private List<V> vertexOrderedList;
        int edgeCrossCount = 0;
        NeighborCache<V, E> neighborCache;

        ReduceCrossingRunnable(Graph<V, E> graph, List<V> vertexOrderList) {
            this.graph = graph;
            this.neighborCache = new NeighborCache(graph);
            this.vertexOrderedList = vertexOrderList;
        }

        @Override
        public void run() {
            ConnectivityInspector connectivityInspector = new ConnectivityInspector(this.graph);
            List componentVertices = connectivityInspector.connectedSets();
            ArrayList<V> vertexOrderedList = new ArrayList<V>();
            if (componentVertices.size() > 1) {
                for (Set vertexSet : componentVertices) {
                    Graph subGraph = GraphTypeBuilder.forGraph(this.graph).buildGraph();
                    vertexSet.forEach(arg_0 -> ((Graph)subGraph).addVertex(arg_0));
                    for (Object v2 : vertexSet.stream().filter(v -> !TreeLayout.isLoopVertex(subGraph, v)).collect(Collectors.toSet())) {
                        this.neighborCache.successorsOf(v2).forEach(s -> subGraph.addEdge(v2, s, this.graph.getEdge(v2, s)));
                        this.neighborCache.predecessorsOf(v2).forEach(p -> subGraph.addEdge(p, v2, this.graph.getEdge(p, v2)));
                    }
                    CircleLayoutReduceEdgeCrossing rec = new CircleLayoutReduceEdgeCrossing(subGraph);
                    vertexOrderedList.addAll(rec.getVertexOrderedList());
                }
            } else {
                CircleLayoutReduceEdgeCrossing<V, E> rec = new CircleLayoutReduceEdgeCrossing<V, E>(this.graph);
                vertexOrderedList.addAll(rec.getVertexOrderedList());
            }
            this.vertexOrderedList.clear();
            this.vertexOrderedList.addAll(vertexOrderedList);
        }
    }
}

