/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.LongKeyIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.NoValueException;
import java.io.Serializable;

public class LongLongHashtable
implements Serializable {
    private LongKeyIndexer indexer;
    private long[] values;
    private int capacity;

    public LongLongHashtable() {
        this(3);
    }

    public LongLongHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new LongKeyIndexer(capacity);
        this.values = new long[capacity];
    }

    public void put(long key, long value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public long get(long key) throws NoValueException {
        int index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public boolean remove(long key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(long key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public long[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        long[] oldValues = this.values;
        this.values = new long[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

