/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.app.util.query.AlignedObjectBasedPreviewTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.field.ReferenceFromAddressTableColumn;
import ghidra.util.table.field.ReferenceFromLabelTableColumn;
import ghidra.util.table.field.ReferenceFromPreviewTableColumn;
import ghidra.util.table.field.ReferenceToAddressTableColumn;
import ghidra.util.table.field.ReferenceToPreviewTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class FindReferencesTableModel
extends AlignedObjectBasedPreviewTableModel<ReferenceAddressPair> {
    private Address fromAddr;
    private AddressSetView fromAddressSet = null;

    public FindReferencesTableModel(Address fromAddr, ServiceProvider provider, Program prog) {
        super(fromAddr.toString(), provider, prog, null);
        this.fromAddr = fromAddr;
        this.setAlignment(prog.getLanguage().getInstructionAlignment());
    }

    public FindReferencesTableModel(AddressSetView fromAddresses, PluginTool tool, Program prog) {
        super("[ " + String.valueOf(fromAddresses) + " ]", (ServiceProvider)tool, prog, null, true);
        this.fromAddressSet = fromAddresses;
        this.fromAddr = this.fromAddressSet.getMinAddress();
        this.setAlignment(prog.getLanguage().getInstructionAlignment());
    }

    @Override
    protected TableColumnDescriptor<ReferenceAddressPair> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceFromAddressTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceFromLabelTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceFromPreviewTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceToAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceToPreviewTableColumn());
        return descriptor;
    }

    @Override
    protected void initializeUnalignedList(Accumulator<ReferenceAddressPair> accumulator, TaskMonitor monitor) throws CancelledException {
        ProgramMemoryUtil.loadDirectReferenceList(this.getProgram(), this.alignment, this.fromAddr, this.fromAddressSet, accumulator, monitor);
    }

    AddressSetView getSearchAddressSet() {
        return this.fromAddressSet;
    }

    Address getAddress() {
        return this.fromAddr;
    }

    @Override
    public Address getAddress(int row) {
        ReferenceAddressPair refAddrPair = (ReferenceAddressPair)this.filteredData.get(row);
        return refAddrPair.getSource();
    }

    @Override
    public Address getAlignmentAddress(List<ReferenceAddressPair> data, int index) {
        ReferenceAddressPair refAddrPair = data.get(index);
        return refAddrPair.getSource();
    }
}

