/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.program.model.listing.Program;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import pdb.symbolserver.SymbolServerInstanceCreatorRegistry;

public class SymbolServerInstanceCreatorContext {
    private final File rootDir;
    private final FSRL programFSRL;
    private final SymbolServerInstanceCreatorRegistry symbolServerInstanceCreatorRegistry;

    SymbolServerInstanceCreatorContext(SymbolServerInstanceCreatorRegistry symbolServerInstanceCreatorRegistry) {
        this(null, symbolServerInstanceCreatorRegistry);
    }

    SymbolServerInstanceCreatorContext(Program program, SymbolServerInstanceCreatorRegistry symbolServerInstanceCreatorRegistry) {
        if (program != null) {
            this.programFSRL = FSRL.fromProgram((Program)program);
            this.rootDir = new File(FilenameUtils.getFullPath((String)program.getExecutablePath()));
        } else {
            this.programFSRL = null;
            this.rootDir = null;
        }
        this.symbolServerInstanceCreatorRegistry = symbolServerInstanceCreatorRegistry;
    }

    public SymbolServerInstanceCreatorRegistry getSymbolServerInstanceCreatorRegistry() {
        return this.symbolServerInstanceCreatorRegistry;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public FSRL getProgramFSRL() {
        return this.programFSRL;
    }
}

