/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationContext;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class X86_32_CoffRelocationHandler
implements CoffRelocationHandler {
    public static final short IMAGE_REL_I386_ABSOLUTE = 0;
    public static final short IMAGE_REL_I386_DIR16 = 1;
    public static final short IMAGE_REL_I386_REL16 = 2;
    public static final short IMAGE_REL_I386_DIR32 = 6;
    public static final short IMAGE_REL_I386_DIR32NB = 7;
    public static final short IMAGE_REL_I386_SEG12 = 9;
    public static final short IMAGE_REL_I386_SECTION = 10;
    public static final short IMAGE_REL_I386_SECREL = 11;
    public static final short IMAGE_REL_I386_TOKEN = 12;
    public static final short IMAGE_REL_I386_SECREL7 = 13;
    public static final short IMAGE_REL_I386_REL32 = 20;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == 332;
    }

    public RelocationResult relocate(Address address, CoffRelocation relocation, CoffRelocationContext relocationContext) throws MemoryAccessException, RelocationException {
        Program program = relocationContext.getProgram();
        Memory mem = program.getMemory();
        int addend = mem.getInt(address);
        int byteLength = 4;
        switch (relocation.getType()) {
            case 6: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add((long)addend).getOffset();
                program.getMemory().setInt(address, value);
                break;
            }
            case 7: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add((long)addend).subtract(program.getImageBase());
                mem.setInt(address, value);
                break;
            }
            case 20: {
                int value = (int)relocationContext.getSymbolAddress(relocation).add((long)addend).subtract(address);
                mem.setInt(address, value -= 4);
                break;
            }
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                return RelocationResult.SKIPPED;
            }
            default: {
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

