/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Message;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

public class RequestArgumentSerializers {
    private final SerializerRegistry registry = new DefaultSerializerRegistry();

    public Serializer<Object> getSerializer(ClassLoader defaultClassLoader) {
        this.registry.register(Object.class, (Serializer)new JavaObjectSerializer(defaultClassLoader));
        return this.registry.build(Object.class);
    }

    public <T> void register(Class<T> type, Serializer<T> serializer) {
        this.registry.register(type, serializer);
    }

    public static class JavaObjectSerializer
    implements Serializer<Object> {
        private final ClassLoader classLoader;

        public JavaObjectSerializer(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public Object read(Decoder decoder) throws Exception {
            return Message.receive((InputStream)decoder.getInputStream(), (ClassLoader)this.classLoader);
        }

        public void write(Encoder encoder, Object value) throws Exception {
            Message.send((Object)value, (OutputStream)encoder.getOutputStream());
        }
    }
}

