/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenSyncListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/RefreshMavenProjectCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.maven"})
public final class RefreshMavenProjectCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "refreshMavenProject";
    @NotNull
    public static final String PREFIX = "%refreshMavenProject";

    public RefreshMavenProjectCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context2, @NotNull Continuation<? super Unit> $completion) {
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project myProject = project;
        String expectedFailurePattern = this.extractCommandArgument(PREFIX);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        ActionCallback callback = new ActionCallback();
        Ref.BooleanRef hasExpectedFailure = new Ref.BooleanRef();
        messageBus2.connect().subscribe(MavenSyncListener.Companion.getTOPIC(), (Object)new MavenSyncListener(myProject, expectedFailurePattern, hasExpectedFailure, callback){
            final /* synthetic */ Project $myProject;
            final /* synthetic */ String $expectedFailurePattern;
            final /* synthetic */ Ref.BooleanRef $hasExpectedFailure;
            final /* synthetic */ ActionCallback $callback;
            {
                this.$myProject = $myProject;
                this.$expectedFailurePattern = $expectedFailurePattern;
                this.$hasExpectedFailure = $hasExpectedFailure;
                this.$callback = $callback;
            }

            /*
             * WARNING - void declaration
             */
            public void syncFinished(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (this.$myProject == project) {
                    void $this$forEach$iv;
                    List<MavenProject> list = MavenProjectsManager.getInstance(project).getProjects();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
                    Object object = list;
                    String string = this.$expectedFailurePattern;
                    Ref.BooleanRef booleanRef = this.$hasExpectedFailure;
                    ActionCallback actionCallback = this.$callback;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        MavenProject it = (MavenProject)element$iv;
                        boolean bl = false;
                        Iterable $this$forEach$iv2 = it.getProblems();
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            MavenProjectProblem problem = (MavenProjectProblem)element$iv2;
                            boolean bl2 = false;
                            String string2 = problem.getDescription();
                            if (string2 == null) {
                                string2 = "";
                            }
                            String descriptor2 = string2;
                            Intrinsics.checkNotNull((Object)string);
                            if (((CharSequence)string).length() > 0 && StringsKt.contains$default((CharSequence)descriptor2, (CharSequence)string, (boolean)false, (int)2, null)) {
                                booleanRef.element = true;
                                continue;
                            }
                            actionCallback.reject(problem.getDescription());
                        }
                    }
                    object = this.$expectedFailurePattern;
                    Intrinsics.checkNotNull((Object)object);
                    if (((CharSequence)object).length() == 0 || this.$hasExpectedFailure.element) {
                        this.$callback.setDone();
                        v2 = Unit.INSTANCE;
                    } else {
                        ActionCallback actionCallback2 = this.$callback.reject("Error " + this.$expectedFailurePattern + " was expected but not received");
                        v2 = actionCallback2;
                        Intrinsics.checkNotNullExpressionValue((Object)actionCallback2, (String)"reject(...)");
                    }
                }
            }
        });
        ProjectRefreshAction.Manager.INSTANCE.refreshProject(myProject);
        Object object = Promises.await((Promise)Promises.toPromise((ActionCallback)callback), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/RefreshMavenProjectCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

