/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.remote.jdbc.LobInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseDataTypeConversion
implements DataTypeConversion {
    protected final GridColumn myFirstColumn;
    protected final Object myObject;
    protected final CoreGrid<GridRow, GridColumn> mySecondGrid;
    protected final ModelIndex<GridColumn> mySecondColumnIdx;
    protected final ModelIndex<GridRow> mySecondRowIdx;

    public BaseDataTypeConversion(@NotNull GridColumn firstColumn, @NotNull ModelIndex<GridColumn> secondColIdx, @NotNull ModelIndex<GridRow> secondRowIdx, @NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable Object object) {
        if (firstColumn == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(0);
        }
        if (secondColIdx == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(1);
        }
        if (secondRowIdx == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(2);
        }
        if (grid == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(3);
        }
        this.myFirstColumn = firstColumn;
        this.myObject = object;
        this.mySecondColumnIdx = secondColIdx;
        this.mySecondRowIdx = secondRowIdx;
        this.mySecondGrid = grid;
    }

    @NotNull
    public CellMutation.Builder convert(@NotNull ConversionGraph graph) {
        if (graph == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(4);
        }
        CellMutation.Builder builder = this.build();
        if (builder == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(5);
        }
        return builder;
    }

    @NotNull
    public CellMutation.Builder build() {
        CellMutation.Builder builder = new CellMutation.Builder().row(this.mySecondRowIdx).column(this.mySecondColumnIdx).value(null);
        CellMutation.Builder builder2 = builder.value(this.myObject);
        if (builder2 == null) {
            BaseDataTypeConversion.$$$reportNull$$$0(6);
        }
        return builder2;
    }

    public boolean isValid() {
        return this.mySecondColumnIdx.isValid(this.mySecondGrid) && this.mySecondRowIdx.isValid(this.mySecondGrid);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstColumn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondColIdx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondRowIdx";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/BaseDataTypeConversion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/BaseDataTypeConversion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class Builder
    implements DataTypeConversion.Builder {
        protected GridColumn myFirstColumn;
        protected int myFirstRowIdx;
        protected int myFirstColumnIdx;
        protected Object myObject;
        protected CoreGrid<GridRow, GridColumn> mySecondGrid;
        protected ModelIndex<GridColumn> mySecondColumnIdx;
        protected ModelIndex<GridRow> mySecondRowIdx;

        public Builder() {
        }

        public Builder(@Nullable GridColumn firstColumn, int firstRowIdx, int firstColumnIdx, @Nullable Object object, @Nullable CoreGrid<GridRow, GridColumn> secondGrid, @Nullable ModelIndex<GridColumn> secondColumnIdx, @Nullable ModelIndex<GridRow> secondRowIdx) {
            this.myFirstColumn = firstColumn;
            this.myFirstRowIdx = firstRowIdx;
            this.myFirstColumnIdx = firstColumnIdx;
            this.myObject = object;
            this.mySecondGrid = secondGrid;
            this.mySecondColumnIdx = secondColumnIdx;
            this.mySecondRowIdx = secondRowIdx;
        }

        @NotNull
        public Builder firstColumn(@NotNull GridColumn column) {
            if (column == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myFirstColumn = column;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder firstRowIdx(int rowIdx) {
            this.myFirstRowIdx = rowIdx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        public int firstRowIdx() {
            return this.myFirstRowIdx;
        }

        @NotNull
        public Builder firstColumnIdx(int columnIdx) {
            this.myFirstColumnIdx = columnIdx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        public int firstColumnIdx() {
            return this.myFirstColumnIdx;
        }

        @NotNull
        public Builder value(@Nullable Object value) {
            this.myObject = value;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        public int size() {
            Object object = this.myObject;
            if (object instanceof String) {
                String v = (String)object;
                return v.length();
            }
            object = this.myObject;
            if (object instanceof byte[]) {
                byte[] v = (byte[])object;
                return v.length;
            }
            object = this.myObject;
            if (object instanceof LobInfo) {
                LobInfo v = (LobInfo)object;
                return (int)Math.min(v.getLoadedDataLength(), Integer.MAX_VALUE);
            }
            return 1000;
        }

        @NotNull
        public Builder secondGrid(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.mySecondGrid = grid;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        public Builder secondColumnIndex(@NotNull ModelIndex<GridColumn> idx) {
            if (idx == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.mySecondColumnIdx = idx;
            return this;
        }

        @NotNull
        public Builder secondRowIdx(@NotNull ModelIndex<GridRow> idx) {
            if (idx == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.mySecondRowIdx = idx;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder offset(int rows, int columns) {
            this.secondRowIdx((ModelIndex<GridRow>)ViewIndex.forRow(this.mySecondGrid, (int)(this.myFirstRowIdx + rows)).toModel(this.mySecondGrid));
            Builder builder = this.secondColumnIndex((ModelIndex<GridColumn>)ViewIndex.forColumn(this.mySecondGrid, (int)(this.myFirstColumnIdx + columns)).toModel(this.mySecondGrid));
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder firstGrid(@Nullable CoreGrid<GridRow, GridColumn> grid) {
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder copy() {
            return new Builder(this.myFirstColumn, this.myFirstRowIdx, this.myFirstColumnIdx, this.myObject, this.mySecondGrid, this.mySecondColumnIdx, this.mySecondRowIdx);
        }

        @NotNull
        public DataTypeConversion build() {
            return new BaseDataTypeConversion(this.myFirstColumn, this.mySecondColumnIdx, this.mySecondRowIdx, this.mySecondGrid, this.myObject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 6, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/BaseDataTypeConversion$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/BaseDataTypeConversion$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstRowIdx";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstColumnIdx";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "value";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondGrid";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondRowIdx";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "offset";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "firstColumn";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "secondGrid";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "secondColumnIndex";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "secondRowIdx";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 6, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

