/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.LightJavaCodeInsightFixtureTestCaseWithUtils;
import com.intellij.refactoring.suggested.RefactoringAvailableGutterIconRenderer;
import com.intellij.refactoring.suggested.RefactoringDisabledGutterIconRenderer;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.SuggestedRefactoringProviderImpl;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0004J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0004J:\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001f2\b\b\u0002\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#H\u0004J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\tH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u0017\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest;", "Lcom/intellij/refactoring/suggested/LightJavaCodeInsightFixtureTestCaseWithUtils;", "<init>", "()V", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "ignoreErrors", "", "getIgnoreErrors", "()Z", "setIgnoreErrors", "(Z)V", "setUp", "", "changeSignatureAvailableTooltip", "", "name", "usages", "renameAvailableTooltip", "oldName", "newName", "intentionActionShortcutHint", "getIntentionActionShortcutHint", "()Ljava/lang/String;", "intentionActionShortcutHint$delegate", "Lkotlin/Lazy;", "doTest", "initialText", "expectedAvailability", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability;", "expectedAvailabilityAfterResolve", "expectedAvailabilityAfterBackgroundAmend", "editingActions", "Lkotlin/Function0;", "checkAvailability", "afterResolve", "Availability", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nBaseSuggestedRefactoringAvailabilityTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSuggestedRefactoringAvailabilityTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n295#2,2:113\n669#2,11:119\n11561#3:115\n11896#3,3:116\n*S KotlinDebug\n*F\n+ 1 BaseSuggestedRefactoringAvailabilityTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest\n*L\n84#1:113,2\n91#1:119,11\n90#1:115\n90#1:116,3\n*E\n"})
public abstract class BaseSuggestedRefactoringAvailabilityTest
extends LightJavaCodeInsightFixtureTestCaseWithUtils {
    private boolean ignoreErrors;
    @NotNull
    private final Lazy intentionActionShortcutHint$delegate = LazyKt.lazy(BaseSuggestedRefactoringAvailabilityTest::intentionActionShortcutHint_delegate$lambda$0);

    @NotNull
    protected abstract LanguageFileType getFileType();

    protected final boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    protected final void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    @Override
    protected void setUp() {
        this.ignoreErrors = false;
        super.setUp();
    }

    @NotNull
    protected final String changeSignatureAvailableTooltip(@NotNull String name, @NotNull String usages) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        Object[] objectArray = new Object[]{usages, name, this.getIntentionActionShortcutHint()};
        String string = RefactoringBundle.message((String)"suggested.refactoring.change.signature.gutter.icon.tooltip", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected final String renameAvailableTooltip(@NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Object[] objectArray = new Object[]{oldName, newName, this.getIntentionActionShortcutHint()};
        String string = RefactoringBundle.message((String)"suggested.refactoring.rename.gutter.icon.tooltip", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getIntentionActionShortcutHint() {
        Lazy lazy = this.intentionActionShortcutHint$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doTest(@NotNull String initialText, @NotNull Availability expectedAvailability, @NotNull Availability expectedAvailabilityAfterResolve, @NotNull Availability expectedAvailabilityAfterBackgroundAmend, @NotNull Function0<Unit> editingActions) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)expectedAvailability, (String)"expectedAvailability");
        Intrinsics.checkNotNullParameter((Object)expectedAvailabilityAfterResolve, (String)"expectedAvailabilityAfterResolve");
        Intrinsics.checkNotNullParameter((Object)expectedAvailabilityAfterBackgroundAmend, (String)"expectedAvailabilityAfterBackgroundAmend");
        Intrinsics.checkNotNullParameter(editingActions, (String)"editingActions");
        this.myFixture.configureByText((FileType)this.getFileType(), initialText);
        if (!this.ignoreErrors) {
            this.myFixture.testHighlighting(false, false, false, this.myFixture.getFile().getVirtualFile());
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SuggestedRefactoringProviderImpl provider = SuggestedRefactoringProviderImpl.Companion.getInstance(project);
        boolean amendStateInBackgroundSaved = provider.get_amendStateInBackgroundEnabled();
        try {
            provider.set_amendStateInBackgroundEnabled(false);
            this.executeEditingActions(editingActions);
            this.checkAvailability(expectedAvailability, false);
            this.checkAvailability(expectedAvailabilityAfterResolve, true);
            provider.set_amendStateInBackgroundEnabled(true);
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
            this.checkAvailability(expectedAvailabilityAfterBackgroundAmend, true);
        }
        finally {
            provider.set_amendStateInBackgroundEnabled(amendStateInBackgroundSaved);
        }
    }

    public static /* synthetic */ void doTest$default(BaseSuggestedRefactoringAvailabilityTest baseSuggestedRefactoringAvailabilityTest, String string, Availability availability, Availability availability2, Availability availability3, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTest");
        }
        if ((n & 4) != 0) {
            availability2 = availability;
        }
        if ((n & 8) != 0) {
            availability3 = availability2;
        }
        baseSuggestedRefactoringAvailabilityTest.doTest(string, availability, availability2, availability3, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAvailability(Availability expectedAvailability, boolean afterResolve) {
        Object v4;
        SuggestedRefactoringAvailabilityIndicator availabilityIndicator;
        block12: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object element$iv2;
            if (afterResolve) {
                Object v1;
                block11: {
                    List<IntentionAction> list = this.myFixture.getAvailableIntentions();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getAvailableIntentions(...)");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        IntentionAction it = (IntentionAction)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFamilyName(), (Object)"Suggested Refactoring")) continue;
                        v1 = element$iv2;
                        break block11;
                    }
                    v1 = null;
                }
                IntentionAction intention = v1;
                LightJavaCodeInsightFixtureTestCase.assertEquals((boolean)(expectedAvailability instanceof Availability.Available), (intention != null ? 1 : 0) != 0);
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            availabilityIndicator = SuggestedRefactoringProviderImpl.Companion.getInstance(project).getAvailabilityIndicator();
            RangeHighlighter[] rangeHighlighterArray = this.getEditor().getMarkupModel().getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
            Object[] $i$f$firstOrNull = rangeHighlighterArray;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RangeHighlighter rangeHighlighter = (RangeHighlighter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGutterIconRenderer());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv3 : $this$singleOrNull$iv) {
                GutterIconRenderer it = (GutterIconRenderer)element$iv3;
                boolean bl = false;
                if (!(it instanceof RefactoringAvailableGutterIconRenderer || it instanceof RefactoringDisabledGutterIconRenderer)) continue;
                if (found$iv) {
                    v4 = null;
                    break block12;
                }
                single$iv = element$iv3;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        GutterIconRenderer iconRenderer = v4;
        Availability availability = expectedAvailability;
        if (availability instanceof Availability.NotAvailable) {
            LightJavaCodeInsightFixtureTestCase.assertFalse((boolean)availabilityIndicator.getHasData());
            LightJavaCodeInsightFixtureTestCase.assertNull((Object)iconRenderer);
        } else if (availability instanceof Availability.Disabled) {
            LightJavaCodeInsightFixtureTestCase.assertTrue((boolean)availabilityIndicator.getHasData());
            LightJavaCodeInsightFixtureTestCase.assertTrue((boolean)(iconRenderer instanceof RefactoringDisabledGutterIconRenderer));
            GutterIconRenderer gutterIconRenderer = iconRenderer;
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)SuggestedRefactoringAvailabilityIndicator.Companion.getDisabledRefactoringTooltip(), (String)(gutterIconRenderer != null ? gutterIconRenderer.getTooltipText() : null));
        } else if (availability instanceof Availability.Available) {
            LightJavaCodeInsightFixtureTestCase.assertTrue((boolean)availabilityIndicator.getHasData());
            LightJavaCodeInsightFixtureTestCase.assertTrue((boolean)(iconRenderer instanceof RefactoringAvailableGutterIconRenderer));
            GutterIconRenderer gutterIconRenderer = iconRenderer;
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)((Availability.Available)expectedAvailability).getTooltip(), (String)(gutterIconRenderer != null ? gutterIconRenderer.getTooltipText() : null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final String intentionActionShortcutHint_delegate$lambda$0() {
        KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowIntentionActions");
        Intrinsics.checkNotNull((Object)keyboardShortcut);
        return "(" + KeymapUtil.getShortcutText((Shortcut)((Shortcut)keyboardShortcut)) + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability;", "", "<init>", "()V", "NotAvailable", "Disabled", "Available", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$Available;", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$Disabled;", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$NotAvailable;", "intellij.java.testFramework"})
    protected static abstract sealed class Availability {
        private Availability() {
        }

        public /* synthetic */ Availability(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$Available;", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability;", "tooltip", "", "<init>", "(Ljava/lang/String;)V", "getTooltip", "()Ljava/lang/String;", "intellij.java.testFramework"})
        public static final class Available
        extends Availability {
            @NotNull
            private final String tooltip;

            public Available(@NotNull String tooltip) {
                Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
                super(null);
                this.tooltip = tooltip;
            }

            @NotNull
            public final String getTooltip() {
                return this.tooltip;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$Disabled;", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability;", "<init>", "()V", "intellij.java.testFramework"})
        public static final class Disabled
        extends Availability {
            @NotNull
            public static final Disabled INSTANCE = new Disabled();

            private Disabled() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability$NotAvailable;", "Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringAvailabilityTest$Availability;", "<init>", "()V", "intellij.java.testFramework"})
        public static final class NotAvailable
        extends Availability {
            @NotNull
            public static final NotAvailable INSTANCE = new NotAvailable();

            private NotAvailable() {
                super(null);
            }
        }
    }
}

