/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.parallelScavenge;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.shared.MutableSpace;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PSOldGen
extends VMObject {
    private static AddressField objectSpaceField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PSOldGen");
        objectSpaceField = type.getAddressField("_object_space");
    }

    public PSOldGen(Address addr) {
        super(addr);
    }

    public MutableSpace objectSpace() {
        return (MutableSpace)VMObjectFactory.newObject(MutableSpace.class, objectSpaceField.getValue(this.addr));
    }

    public long capacity() {
        return this.objectSpace().capacity();
    }

    public long used() {
        return this.objectSpace().used();
    }

    public boolean isIn(Address a) {
        return this.objectSpace().contains(a);
    }

    public void printOn(PrintStream tty) {
        tty.print("PSOldGen [ ");
        this.objectSpace().printOn(tty);
        tty.print(" ] ");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PSOldGen.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

