/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.registry.json;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;

class TimeWindowMin {
    private static final AtomicIntegerFieldUpdater<TimeWindowMin> rotatingUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeWindowMin.class, "rotating");
    private final Clock clock;
    private final long durationBetweenRotatesMillis;
    private AtomicLong[] ringBuffer;
    private int currentBucket;
    private volatile long lastRotateTimestampMillis;
    private volatile int rotating = 0;

    public TimeWindowMin(Clock clock, DistributionStatisticConfig config) {
        this(clock, config.getExpiry().toMillis(), config.getBufferLength());
    }

    public TimeWindowMin(Clock clock, long rotateFrequencyMillis, int bufferLength) {
        this.clock = clock;
        this.durationBetweenRotatesMillis = rotateFrequencyMillis;
        this.lastRotateTimestampMillis = clock.wallTime();
        this.currentBucket = 0;
        this.ringBuffer = new AtomicLong[bufferLength];
        for (int i = 0; i < bufferLength; ++i) {
            this.ringBuffer[i] = new AtomicLong(Long.MAX_VALUE);
        }
    }

    public void record(double sample, TimeUnit timeUnit) {
        this.record(() -> (long)TimeUtils.convert((double)sample, (TimeUnit)timeUnit, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    private void record(LongSupplier sampleSupplier) {
        this.rotate();
        long sample = sampleSupplier.getAsLong();
        for (AtomicLong min : this.ringBuffer) {
            this.updateMin(min, sample);
        }
    }

    public double poll(TimeUnit timeUnit) {
        return this.poll(() -> TimeUtils.nanosToUnit((double)this.ringBuffer[this.currentBucket].get(), (TimeUnit)timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double poll(DoubleSupplier minSupplier) {
        this.rotate();
        TimeWindowMin timeWindowMin = this;
        synchronized (timeWindowMin) {
            return minSupplier.getAsDouble();
        }
    }

    public double poll() {
        return this.poll(() -> Double.longBitsToDouble(this.ringBuffer[this.currentBucket].get()));
    }

    public void record(double sample) {
        this.record(() -> Double.doubleToLongBits(sample));
    }

    private void updateMin(AtomicLong min, long sample) {
        long curMin;
        while ((curMin = min.get()) > sample && !min.compareAndSet(curMin, sample)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        long timeSinceLastRotateMillis = this.clock.wallTime() - this.lastRotateTimestampMillis;
        if (timeSinceLastRotateMillis < this.durationBetweenRotatesMillis) {
            return;
        }
        if (!rotatingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            int iterations = 0;
            TimeWindowMin timeWindowMin = this;
            synchronized (timeWindowMin) {
                do {
                    this.ringBuffer[this.currentBucket].set(0L);
                    if (++this.currentBucket >= this.ringBuffer.length) {
                        this.currentBucket = 0;
                    }
                    this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
                } while ((timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis) >= this.durationBetweenRotatesMillis && ++iterations < this.ringBuffer.length);
            }
        }
        finally {
            this.rotating = 0;
        }
    }
}

