/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

public enum ECCurve {
    P256,
    P384,
    P521;


    public static ECCurve fromStdCrv(String crv) {
        switch (crv) {
            case "P-256": 
            case "secp256r1": {
                return P256;
            }
            case "P-384": 
            case "secp384r1": {
                return P384;
            }
            case "P-521": 
            case "secp521r1": {
                return P521;
            }
        }
        throw new IllegalArgumentException("Unexpected EC curve: " + crv);
    }
}

