/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.time.Duration;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.workflow.WorkflowEventListener;
import org.keycloak.models.workflow.WorkflowRunnerScheduledTask;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.services.scheduled.ClusterAwareScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TaskRunner;
import org.keycloak.timer.TimerProvider;

public class WorkflowsEventListenerFactory
implements EventListenerProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String ID = "workflow-event-listener";
    private static final long DEFAULT_STEP_RUNNER_TASK_INTERVAL = Duration.ofHours(12L).toMillis();
    private long stepRunnerTaskInterval;

    public EventListenerProvider create(KeycloakSession session) {
        return new WorkflowEventListener(session);
    }

    public boolean isGlobal() {
        return true;
    }

    public void init(Config.Scope config) {
        this.stepRunnerTaskInterval = config.getLong("stepRunnerTaskInterval", Long.valueOf(DEFAULT_STEP_RUNNER_TASK_INTERVAL));
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            KeycloakSession session = event.getKeycloakSession();
            if (session != null) {
                this.onEvent(event, session);
            }
        });
        this.scheduleStepRunnerTask(factory);
    }

    private void onEvent(ProviderEvent event, KeycloakSession session) {
        WorkflowEventListener provider = (WorkflowEventListener)session.getProvider(EventListenerProvider.class, this.getId());
        provider.onEvent(event);
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.WORKFLOWS);
    }

    private void scheduleStepRunnerTask(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
            timer.schedule((TaskRunner)new ClusterAwareScheduledTaskRunner(factory, (ScheduledTask)new WorkflowRunnerScheduledTask(factory), this.stepRunnerTaskInterval), this.stepRunnerTaskInterval);
        }
    }
}

