/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public final class Json {
    private static final String OBJECT_START = "{";
    private static final String OBJECT_END = "}";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String NAME_VAL_SEPARATOR = ":";
    private static final String ENTRY_SEPARATOR = ",";
    private static final int CONTROL_CHAR_START = 0;
    private static final int CONTROL_CHAR_END = 31;
    private static final char CHAR_QUOTATION_MARK = '\"';
    private static final Map<Character, String> REPLACEMENTS = new HashMap<Character, String>();

    private Json() {
    }

    public static JsonArrayBuilder array() {
        return new JsonArrayBuilder(false);
    }

    public static JsonArrayBuilder array(boolean ignoreEmptyBuilders) {
        return new JsonArrayBuilder(ignoreEmptyBuilders);
    }

    public static JsonObjectBuilder object() {
        return new JsonObjectBuilder(false);
    }

    public static JsonObjectBuilder object(boolean ignoreEmptyBuilders) {
        return new JsonObjectBuilder(ignoreEmptyBuilders);
    }

    static void appendValue(StringBuilder builder, Object value) {
        if (value instanceof JsonObjectBuilder) {
            builder.append(((JsonObjectBuilder)value).build());
        } else if (value instanceof JsonArrayBuilder) {
            builder.append(((JsonArrayBuilder)value).build());
        } else if (value instanceof String) {
            Json.appendStringValue(builder, value.toString());
        } else if (value instanceof Boolean || value instanceof Integer || value instanceof Long) {
            builder.append(value.toString());
        } else {
            throw new IllegalStateException("Unsupported value type: " + String.valueOf(value));
        }
    }

    static void appendStringValue(StringBuilder builder, String value) {
        builder.append('\"');
        builder.append(Json.escape(value));
        builder.append('\"');
    }

    static String escape(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String replacement = REPLACEMENTS.get(Character.valueOf(c));
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            REPLACEMENTS.put(Character.valueOf((char)i), String.format("\\u%04x", i));
        }
        REPLACEMENTS.put(Character.valueOf('\"'), "\\\"");
        REPLACEMENTS.put(Character.valueOf('\\'), "\\\\");
    }

    public static class JsonArrayBuilder
    extends JsonBuilder<JsonArrayBuilder> {
        private final List<Object> values = new ArrayList<Object>();

        private JsonArrayBuilder(boolean ignoreEmptyBuilders) {
            super(ignoreEmptyBuilders);
        }

        public JsonArrayBuilder add(JsonArrayBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(JsonObjectBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(String value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(Boolean value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(Integer value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(Long value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder addAll(List<JsonObjectBuilder> value) {
            if (value != null && !value.isEmpty()) {
                this.values.addAll(value);
            }
            return this;
        }

        private void addInternal(Object value) {
            if (value != null) {
                this.values.add(value);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.isValuesEmpty(this.values);
        }

        @Override
        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append(Json.ARRAY_START);
            int idx = 0;
            ListIterator<Object> iterator = this.values.listIterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (this.isIgnored(value)) continue;
                if (++idx > 1) {
                    builder.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendValue(builder, value);
            }
            builder.append(Json.ARRAY_END);
            return builder.toString();
        }

        @Override
        protected JsonArrayBuilder self() {
            return this;
        }
    }

    public static class JsonObjectBuilder
    extends JsonBuilder<JsonObjectBuilder> {
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

        private JsonObjectBuilder(boolean ignoreEmptyBuilders) {
            super(ignoreEmptyBuilders);
        }

        public JsonObjectBuilder put(String name, String value) {
            this.addInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, JsonObjectBuilder value) {
            this.addInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, JsonArrayBuilder value) {
            this.addInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, Boolean value) {
            this.addInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, Integer value) {
            this.addInternal(name, value);
            return this;
        }

        public JsonObjectBuilder put(String name, Long value) {
            this.addInternal(name, value);
            return this;
        }

        public boolean has(String name) {
            return this.properties.containsKey(name);
        }

        private void addInternal(String name, Object value) {
            Objects.requireNonNull(name);
            if (value != null) {
                this.properties.put(name, value);
            }
        }

        @Override
        public boolean isEmpty() {
            if (this.properties.isEmpty()) {
                return true;
            }
            return this.isValuesEmpty(this.properties.values());
        }

        @Override
        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append(Json.OBJECT_START);
            int idx = 0;
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                if (this.isIgnored(entry.getValue())) continue;
                if (++idx > 1) {
                    builder.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendStringValue(builder, entry.getKey());
                builder.append(Json.NAME_VAL_SEPARATOR);
                Json.appendValue(builder, entry.getValue());
            }
            builder.append(Json.OBJECT_END);
            return builder.toString();
        }

        @Override
        protected JsonObjectBuilder self() {
            return this;
        }
    }

    static abstract class JsonBuilder<T> {
        protected final boolean ignoreEmptyBuilders;

        JsonBuilder(boolean ignoreEmptyBuilders) {
            this.ignoreEmptyBuilders = ignoreEmptyBuilders;
        }

        public abstract boolean isEmpty();

        public abstract String build();

        protected boolean isIgnored(Object value) {
            return value == null || this.ignoreEmptyBuilders && value instanceof JsonBuilder && ((JsonBuilder)value).isEmpty();
        }

        protected boolean isValuesEmpty(Collection<Object> values) {
            if (values.isEmpty()) {
                return true;
            }
            for (Object object : values) {
                if (object instanceof JsonBuilder) {
                    if (((JsonBuilder)object).isEmpty()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        protected abstract T self();
    }
}

