/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

abstract class OracleBufferedStream
extends InputStream {
    private final IntFunction<byte[]> allocateFunction;
    private final Consumer<byte[]> cacheFunction;
    private byte[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Integer.MAX_VALUE;
    boolean closed;
    OracleStatement statement;
    protected Monitor monitor;

    protected OracleBufferedStream(int initialBufferSize, Monitor monitor) {
        this(initialBufferSize, byte[]::new, bytes -> {}, monitor);
    }

    protected OracleBufferedStream(OracleStatement stmt, int initialBufferSize) {
        this(initialBufferSize, stmt.connection::getByteBuffer, stmt.connection::cacheBuffer, stmt.connection);
        this.statement = stmt;
    }

    protected OracleBufferedStream(int initialBufferSize, IntFunction<byte[]> allocateFunction, Consumer<byte[]> cacheFunction, Monitor monitor) {
        this.allocateFunction = allocateFunction;
        this.cacheFunction = cacheFunction;
        this.pos = 0;
        this.count = 0;
        this.closed = false;
        this.initialBufferSize = initialBufferSize;
        this.currentBufferSize = 0;
        this.resizableBuffer = null;
        this.monitor = monitor;
    }

    @Override
    public void close() throws IOException {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.closed = true;
            this.releaseBuffer();
        }
    }

    public boolean needBytes() throws IOException {
        return this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize));
    }

    public abstract boolean needBytes(int var1) throws IOException;

    public int flushBytes(int n) {
        int availableLength = n > this.count - this.pos ? this.count - this.pos : n;
        this.pos += availableLength;
        return availableLength;
    }

    public int writeBytes(byte[] destbuf, int offset, int length) {
        int availableLength = length > this.count - this.pos ? this.count - this.pos : length;
        System.arraycopy(this.resizableBuffer, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    @Override
    public int read() throws IOException {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            int n = this.readInternal();
            return n;
        }
    }

    private final int readInternal() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.resizableBuffer[this.pos++] & 0xFF;
        }
        this.releaseBuffer();
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] destbuf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            int n = this.readInternal(destbuf, offset, length);
            return n;
        }
    }

    protected final int readInternal(byte[] destbuf, int offset, int length) throws IOException {
        int start = offset;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int end = length > destbuf.length ? start + destbuf.length : start + length;
        if (!this.needBytes(length)) {
            this.releaseBuffer();
            return -1;
        }
        start += this.writeBytes(destbuf, start, end - start);
        while (start < end && this.needBytes(end - start)) {
            start += this.writeBytes(destbuf, start, end - start);
        }
        return start - offset;
    }

    @Override
    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();
        try {
            throw new IOException(DatabaseError.findMessage(194, null));
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long skip(int n) throws IOException {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            long l = this.skipInternal(n);
            return l;
        }
    }

    private final int skipInternal(int n) throws IOException {
        int start;
        int end = n;
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (!this.needBytes()) {
            this.releaseBuffer();
            return -1;
        }
        for (start = 0; start < end && this.needBytes(); start += this.flushBytes(end - start)) {
        }
        return start;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }

    protected final byte[] getBuffer(int size) {
        if (this.resizableBuffer == null) {
            this.resizableBuffer = this.allocateFunction.apply(size);
        } else if (this.resizableBuffer.length < size) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = this.allocateFunction.apply(size);
        }
        return this.resizableBuffer;
    }

    private void releaseBuffer() {
        if (this.resizableBuffer != null) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = null;
            this.currentBufferSize = 0;
        }
    }
}

