/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.grok;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.joni.Region;
import org.opensearch.grok.GrokCaptureConfig;
import org.opensearch.grok.GrokCaptureExtracter;

enum GrokCaptureType {
    STRING{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forString(emit -> this.rawExtracter(backRefs, (Consumer<? super String>)emit));
        }
    }
    ,
    INTEGER{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forInt(emit -> this.rawExtracter(backRefs, str -> emit.accept(Integer.parseInt(str))));
        }
    }
    ,
    LONG{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forLong(emit -> this.rawExtracter(backRefs, str -> emit.accept(Long.parseLong(str))));
        }
    }
    ,
    FLOAT{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forFloat(emit -> this.rawExtracter(backRefs, str -> emit.accept(Float.parseFloat(str))));
        }
    }
    ,
    DOUBLE{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forDouble(emit -> this.rawExtracter(backRefs, str -> emit.accept(Double.parseDouble(str))));
        }
    }
    ,
    BOOLEAN{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forBoolean(emit -> this.rawExtracter(backRefs, str -> emit.accept(Boolean.parseBoolean(str))));
        }
    };


    abstract <T> T nativeExtracter(int[] var1, GrokCaptureConfig.NativeExtracterMap<T> var2);

    static GrokCaptureType fromString(String str) {
        switch (str) {
            case "string": {
                return STRING;
            }
            case "int": {
                return INTEGER;
            }
            case "long": {
                return LONG;
            }
            case "float": {
                return FLOAT;
            }
            case "double": {
                return DOUBLE;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        return STRING;
    }

    protected final GrokCaptureExtracter rawExtracter(final int[] backRefs, final Consumer<? super String> emit) {
        return new GrokCaptureExtracter(this){

            @Override
            void extract(byte[] utf8Bytes, int offset, Region region) {
                for (int number : backRefs) {
                    if (region.getBeg(number) < 0) continue;
                    int matchOffset = offset + region.getBeg(number);
                    int matchLength = region.getEnd(number) - region.getBeg(number);
                    emit.accept(new String(utf8Bytes, matchOffset, matchLength, StandardCharsets.UTF_8));
                    return;
                }
            }
        };
    }
}

