/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BaseTermQueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.SpanQueryBuilder;

public class SpanTermQueryBuilder
extends BaseTermQueryBuilder<SpanTermQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_term";
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);

    public SpanTermQueryBuilder(String name, String value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, int value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, long value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, float value) {
        super(name, Float.valueOf(value));
    }

    public SpanTermQueryBuilder(String name, double value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, Object value) {
        super(name, value);
    }

    public SpanTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    protected SpanQuery doToQuery(QueryShardContext context) throws IOException {
        Term term;
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper == null) {
            term = new Term(this.fieldName, BytesRefs.toBytesRef(this.value));
        } else {
            Query termQuery = mapper.termQuery(this.value, context);
            term = MappedFieldType.extractTerm(termQuery);
        }
        return new SpanTermQuery(term);
    }

    public static SpanTermQueryBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                SpanTermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (BaseTermQueryBuilder.VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[span_term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            SpanTermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
        }
        SpanTermQueryBuilder result = new SpanTermQueryBuilder(fieldName, value);
        ((SpanTermQueryBuilder)result.boost(boost)).queryName(queryName);
        return result;
    }

    public String getWriteableName() {
        return NAME;
    }
}

