// Generated by dts-bundle-generator v9.5.1

declare const _default: any;
/**
 * Given an array of layers, some of which may contain `ref` properties
 * whose value is the `id` of another property, return a new array where
 * such layers have been augmented with the 'type', 'source', etc. properties
 * from the parent layer, and the `ref` property has been removed.
 *
 * The input is not modified. The output may contain references to portions
 * of the input.
 *
 * @private
 * @param {Array<Layer>} layers
 * @returns {Array<Layer>}
 */
export declare function derefLayers(layers: any): any;
export type ColorSpecification = string;
export type ProjectionDefinitionT = [
	string,
	string,
	number
];
export type ProjectionDefinitionSpecification = string | ProjectionDefinitionT | PropertyValueSpecification<ProjectionDefinitionT>;
export type PaddingSpecification = number | number[];
export type VariableAnchorOffsetCollectionSpecification = Array<string | [
	number,
	number
]>;
export type SpriteSpecification = string | {
	id: string;
	url: string;
}[];
export type FormattedSpecification = string;
export type ResolvedImageSpecification = string;
export type PromoteIdSpecification = {
	[_: string]: string;
} | string;
export type ExpressionInputType = string | number | boolean;
export type CollatorExpressionSpecification = [
	"collator",
	{
		"case-sensitive"?: boolean | ExpressionSpecification;
		"diacritic-sensitive"?: boolean | ExpressionSpecification;
		locale?: string | ExpressionSpecification;
	}
];
export type InterpolationSpecification = [
	"linear"
] | [
	"exponential",
	number | ExpressionSpecification
] | [
	"cubic-bezier",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
];
export type ExpressionSpecification = [
	"array",
	unknown | ExpressionSpecification
] | [
	"array",
	ExpressionInputType | ExpressionSpecification,
	unknown | ExpressionSpecification
] | [
	"array",
	ExpressionInputType | ExpressionSpecification,
	number | ExpressionSpecification,
	unknown | ExpressionSpecification
] | [
	"boolean",
	...(unknown | ExpressionSpecification)[],
	unknown | ExpressionSpecification
] | CollatorExpressionSpecification | [
	"format",
	...(string | [
		"image",
		ExpressionSpecification
	] | ExpressionSpecification | {
		"font-scale"?: number | ExpressionSpecification;
		"text-font"?: string[] | ExpressionSpecification;
		"text-color"?: ColorSpecification | ExpressionSpecification;
	})[]
] | [
	"image",
	unknown | ExpressionSpecification
] | [
	"literal",
	unknown
] | [
	"number",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"number-format",
	number | ExpressionSpecification,
	{
		"locale"?: string | ExpressionSpecification;
		"currency"?: string | ExpressionSpecification;
		"min-fraction-digits"?: number | ExpressionSpecification;
		"max-fraction-digits"?: number | ExpressionSpecification;
	}
] | [
	"object",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"string",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-boolean",
	unknown | ExpressionSpecification
] | [
	"to-color",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-number",
	unknown | ExpressionSpecification,
	...(unknown | ExpressionSpecification)[]
] | [
	"to-string",
	unknown | ExpressionSpecification
] | [
	"accumulated"
] | [
	"feature-state",
	string
] | [
	"geometry-type"
] | [
	"id"
] | [
	"line-progress"
] | [
	"properties"
] | [
	"at",
	number | ExpressionSpecification,
	ExpressionSpecification
] | [
	"get",
	string | ExpressionSpecification,
	(Record<string, unknown> | ExpressionSpecification)?
] | [
	"has",
	string | ExpressionSpecification,
	(Record<string, unknown> | ExpressionSpecification)?
] | [
	"in",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification
] | [
	"index-of",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification
] | [
	"length",
	string | ExpressionSpecification
] | [
	"slice",
	string | ExpressionSpecification,
	number | ExpressionSpecification,
	(number | ExpressionSpecification)?
] | [
	"!",
	boolean | ExpressionSpecification
] | [
	"!=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"<",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"<=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"==",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	">",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	">=",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	CollatorExpressionSpecification?
] | [
	"all",
	...(boolean | ExpressionSpecification)[]
] | [
	"any",
	...(boolean | ExpressionSpecification)[]
] | [
	"case",
	boolean | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	...(boolean | ExpressionInputType | ExpressionSpecification)[],
	ExpressionInputType | ExpressionSpecification
] | [
	"coalesce",
	...(ExpressionInputType | ExpressionSpecification)[]
] | [
	"match",
	ExpressionInputType | ExpressionSpecification,
	ExpressionInputType | ExpressionInputType[],
	ExpressionInputType | ExpressionSpecification,
	...(ExpressionInputType | ExpressionInputType[] | ExpressionSpecification)[],
	// repeated as above
	ExpressionInputType | ExpressionSpecification
] | [
	"within",
	unknown | ExpressionSpecification
] | [
	"distance",
	unknown | ExpressionSpecification
] | [
	"interpolate",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | number[] | ColorSpecification | ExpressionSpecification | ProjectionDefinitionSpecification)[]
] | [
	"interpolate-hcl",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | ColorSpecification)[]
] | [
	"interpolate-lab",
	InterpolationSpecification,
	number | ExpressionSpecification,
	...(number | ColorSpecification)[]
] | [
	"step",
	number | ExpressionSpecification,
	ExpressionInputType | ExpressionSpecification,
	...(number | ExpressionInputType | ExpressionSpecification)[]
] | [
	"let",
	string,
	ExpressionInputType | ExpressionSpecification,
	...(string | ExpressionInputType | ExpressionSpecification)[]
] | [
	"var",
	string
] | [
	"concat",
	...(ExpressionInputType | ExpressionSpecification)[]
] | [
	"downcase",
	string | ExpressionSpecification
] | [
	"is-supported-script",
	string | ExpressionSpecification
] | [
	"resolved-locale",
	CollatorExpressionSpecification
] | [
	"upcase",
	string | ExpressionSpecification
] | [
	"rgb",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"rgba",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"to-rgba",
	ColorSpecification | ExpressionSpecification
] | [
	"-",
	number | ExpressionSpecification,
	(number | ExpressionSpecification)?
] | [
	"*",
	number | ExpressionSpecification,
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"/",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"%",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"^",
	number | ExpressionSpecification,
	number | ExpressionSpecification
] | [
	"+",
	...(number | ExpressionSpecification)[]
] | [
	"abs",
	number | ExpressionSpecification
] | [
	"acos",
	number | ExpressionSpecification
] | [
	"asin",
	number | ExpressionSpecification
] | [
	"atan",
	number | ExpressionSpecification
] | [
	"ceil",
	number | ExpressionSpecification
] | [
	"cos",
	number | ExpressionSpecification
] | [
	"distance",
	Record<string, unknown> | ExpressionSpecification
] | [
	"ExpressionSpecification"
] | [
	"floor",
	number | ExpressionSpecification
] | [
	"ln",
	number | ExpressionSpecification
] | [
	"ln2"
] | [
	"log10",
	number | ExpressionSpecification
] | [
	"log2",
	number | ExpressionSpecification
] | [
	"max",
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"min",
	number | ExpressionSpecification,
	...(number | ExpressionSpecification)[]
] | [
	"pi"
] | [
	"round",
	number | ExpressionSpecification
] | [
	"sin",
	number | ExpressionSpecification
] | [
	"sqrt",
	number | ExpressionSpecification
] | [
	"tan",
	number | ExpressionSpecification
] | [
	"zoom"
] | [
	"heatmap-density"
];
export type ExpressionFilterSpecification = boolean | ExpressionSpecification;
export type LegacyFilterSpecification = [
	"has",
	string
] | [
	"!has",
	string
] | [
	"==",
	string,
	string | number | boolean
] | [
	"!=",
	string,
	string | number | boolean
] | [
	">",
	string,
	string | number | boolean
] | [
	">=",
	string,
	string | number | boolean
] | [
	"<",
	string,
	string | number | boolean
] | [
	"<=",
	string,
	string | number | boolean
] | [
	"in",
	string,
	...(string | number | boolean)[]
] | [
	"!in",
	string,
	...(string | number | boolean)[]
] | [
	"all",
	...LegacyFilterSpecification[]
] | [
	"any",
	...LegacyFilterSpecification[]
] | [
	"none",
	...LegacyFilterSpecification[]
];
export type FilterSpecification = ExpressionFilterSpecification | LegacyFilterSpecification;
export type TransitionSpecification = {
	duration?: number;
	delay?: number;
};
export type CameraFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		number,
		T
	]>;
} | {
	type: "interval";
	stops: Array<[
		number,
		T
	]>;
};
export type SourceFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		number,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "interval";
	stops: Array<[
		number,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "categorical";
	stops: Array<[
		string | number | boolean,
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "identity";
	property: string;
	default?: T;
};
export type CompositeFunctionSpecification<T> = {
	type: "exponential";
	stops: Array<[
		{
			zoom: number;
			value: number;
		},
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "interval";
	stops: Array<[
		{
			zoom: number;
			value: number;
		},
		T
	]>;
	property: string;
	default?: T;
} | {
	type: "categorical";
	stops: Array<[
		{
			zoom: number;
			value: string | number | boolean;
		},
		T
	]>;
	property: string;
	default?: T;
};
export type PropertyValueSpecification<T> = T | CameraFunctionSpecification<T> | ExpressionSpecification;
export type DataDrivenPropertyValueSpecification<T> = T | CameraFunctionSpecification<T> | SourceFunctionSpecification<T> | CompositeFunctionSpecification<T> | ExpressionSpecification;
export type StyleSpecification = {
	"version": 8;
	"name"?: string;
	"metadata"?: unknown;
	"center"?: Array<number>;
	"centerAltitude"?: number;
	"zoom"?: number;
	"bearing"?: number;
	"pitch"?: number;
	"roll"?: number;
	"light"?: LightSpecification;
	"sky"?: SkySpecification;
	"projection"?: ProjectionSpecification;
	"terrain"?: TerrainSpecification;
	"sources": {
		[_: string]: SourceSpecification;
	};
	"sprite"?: SpriteSpecification;
	"glyphs"?: string;
	"transition"?: TransitionSpecification;
	"layers": Array<LayerSpecification>;
};
export type LightSpecification = {
	"anchor"?: PropertyValueSpecification<"map" | "viewport">;
	"position"?: PropertyValueSpecification<[
		number,
		number,
		number
	]>;
	"color"?: PropertyValueSpecification<ColorSpecification>;
	"intensity"?: PropertyValueSpecification<number>;
};
export type SkySpecification = {
	"sky-color"?: PropertyValueSpecification<ColorSpecification>;
	"horizon-color"?: PropertyValueSpecification<ColorSpecification>;
	"fog-color"?: PropertyValueSpecification<ColorSpecification>;
	"fog-ground-blend"?: PropertyValueSpecification<number>;
	"horizon-fog-blend"?: PropertyValueSpecification<number>;
	"sky-horizon-blend"?: PropertyValueSpecification<number>;
	"atmosphere-blend"?: PropertyValueSpecification<number>;
};
export type ProjectionSpecification = {
	"type"?: PropertyValueSpecification<ProjectionDefinitionSpecification>;
};
export type TerrainSpecification = {
	"source": string;
	"exaggeration"?: number;
};
export type VectorSourceSpecification = {
	"type": "vector";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"scheme"?: "xyz" | "tms";
	"minzoom"?: number;
	"maxzoom"?: number;
	"attribution"?: string;
	"promoteId"?: PromoteIdSpecification;
	"volatile"?: boolean;
};
export type RasterSourceSpecification = {
	"type": "raster";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"minzoom"?: number;
	"maxzoom"?: number;
	"tileSize"?: number;
	"scheme"?: "xyz" | "tms";
	"attribution"?: string;
	"volatile"?: boolean;
};
export type RasterDEMSourceSpecification = {
	"type": "raster-dem";
	"url"?: string;
	"tiles"?: Array<string>;
	"bounds"?: [
		number,
		number,
		number,
		number
	];
	"minzoom"?: number;
	"maxzoom"?: number;
	"tileSize"?: number;
	"attribution"?: string;
	"encoding"?: "terrarium" | "mapbox" | "custom";
	"redFactor"?: number;
	"blueFactor"?: number;
	"greenFactor"?: number;
	"baseShift"?: number;
	"volatile"?: boolean;
};
export type GeoJSONSourceSpecification = {
	"type": "geojson";
	"data": GeoJSON.GeoJSON | string;
	"maxzoom"?: number;
	"attribution"?: string;
	"buffer"?: number;
	"filter"?: unknown;
	"tolerance"?: number;
	"cluster"?: boolean;
	"clusterRadius"?: number;
	"clusterMaxZoom"?: number;
	"clusterMinPoints"?: number;
	"clusterProperties"?: unknown;
	"lineMetrics"?: boolean;
	"generateId"?: boolean;
	"promoteId"?: PromoteIdSpecification;
};
export type VideoSourceSpecification = {
	"type": "video";
	"urls": Array<string>;
	"coordinates": [
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		]
	];
};
export type ImageSourceSpecification = {
	"type": "image";
	"url": string;
	"coordinates": [
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		],
		[
			number,
			number
		]
	];
};
export type SourceSpecification = VectorSourceSpecification | RasterSourceSpecification | RasterDEMSourceSpecification | GeoJSONSourceSpecification | VideoSourceSpecification | ImageSourceSpecification;
export type FillLayerSpecification = {
	"id": string;
	"type": "fill";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"fill-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"fill-antialias"?: PropertyValueSpecification<boolean>;
		"fill-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"fill-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-outline-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"fill-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"fill-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
	};
};
export type LineLayerSpecification = {
	"id": string;
	"type": "line";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"line-cap"?: PropertyValueSpecification<"butt" | "round" | "square">;
		"line-join"?: DataDrivenPropertyValueSpecification<"bevel" | "round" | "miter">;
		"line-miter-limit"?: PropertyValueSpecification<number>;
		"line-round-limit"?: PropertyValueSpecification<number>;
		"line-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"line-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"line-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"line-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"line-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"line-width"?: DataDrivenPropertyValueSpecification<number>;
		"line-gap-width"?: DataDrivenPropertyValueSpecification<number>;
		"line-offset"?: DataDrivenPropertyValueSpecification<number>;
		"line-blur"?: DataDrivenPropertyValueSpecification<number>;
		"line-dasharray"?: PropertyValueSpecification<Array<number>>;
		"line-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"line-gradient"?: ExpressionSpecification;
	};
};
export type SymbolLayerSpecification = {
	"id": string;
	"type": "symbol";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"symbol-placement"?: PropertyValueSpecification<"point" | "line" | "line-center">;
		"symbol-spacing"?: PropertyValueSpecification<number>;
		"symbol-avoid-edges"?: PropertyValueSpecification<boolean>;
		"symbol-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"symbol-z-order"?: PropertyValueSpecification<"auto" | "viewport-y" | "source">;
		"icon-allow-overlap"?: PropertyValueSpecification<boolean>;
		"icon-overlap"?: PropertyValueSpecification<"never" | "always" | "cooperative">;
		"icon-ignore-placement"?: PropertyValueSpecification<boolean>;
		"icon-optional"?: PropertyValueSpecification<boolean>;
		"icon-rotation-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"icon-size"?: DataDrivenPropertyValueSpecification<number>;
		"icon-text-fit"?: PropertyValueSpecification<"none" | "width" | "height" | "both">;
		"icon-text-fit-padding"?: PropertyValueSpecification<[
			number,
			number,
			number,
			number
		]>;
		"icon-image"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"icon-rotate"?: DataDrivenPropertyValueSpecification<number>;
		"icon-padding"?: DataDrivenPropertyValueSpecification<PaddingSpecification>;
		"icon-keep-upright"?: PropertyValueSpecification<boolean>;
		"icon-offset"?: DataDrivenPropertyValueSpecification<[
			number,
			number
		]>;
		"icon-anchor"?: DataDrivenPropertyValueSpecification<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
		"icon-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"text-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport" | "auto">;
		"text-rotation-alignment"?: PropertyValueSpecification<"map" | "viewport" | "viewport-glyph" | "auto">;
		"text-field"?: DataDrivenPropertyValueSpecification<FormattedSpecification>;
		"text-font"?: DataDrivenPropertyValueSpecification<Array<string>>;
		"text-size"?: DataDrivenPropertyValueSpecification<number>;
		"text-max-width"?: DataDrivenPropertyValueSpecification<number>;
		"text-line-height"?: PropertyValueSpecification<number>;
		"text-letter-spacing"?: DataDrivenPropertyValueSpecification<number>;
		"text-justify"?: DataDrivenPropertyValueSpecification<"auto" | "left" | "center" | "right">;
		"text-radial-offset"?: DataDrivenPropertyValueSpecification<number>;
		"text-variable-anchor"?: PropertyValueSpecification<Array<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">>;
		"text-variable-anchor-offset"?: DataDrivenPropertyValueSpecification<VariableAnchorOffsetCollectionSpecification>;
		"text-anchor"?: DataDrivenPropertyValueSpecification<"center" | "left" | "right" | "top" | "bottom" | "top-left" | "top-right" | "bottom-left" | "bottom-right">;
		"text-max-angle"?: PropertyValueSpecification<number>;
		"text-writing-mode"?: PropertyValueSpecification<Array<"horizontal" | "vertical">>;
		"text-rotate"?: DataDrivenPropertyValueSpecification<number>;
		"text-padding"?: PropertyValueSpecification<number>;
		"text-keep-upright"?: PropertyValueSpecification<boolean>;
		"text-transform"?: DataDrivenPropertyValueSpecification<"none" | "uppercase" | "lowercase">;
		"text-offset"?: DataDrivenPropertyValueSpecification<[
			number,
			number
		]>;
		"text-allow-overlap"?: PropertyValueSpecification<boolean>;
		"text-overlap"?: PropertyValueSpecification<"never" | "always" | "cooperative">;
		"text-ignore-placement"?: PropertyValueSpecification<boolean>;
		"text-optional"?: PropertyValueSpecification<boolean>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"icon-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"icon-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"icon-halo-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"icon-halo-width"?: DataDrivenPropertyValueSpecification<number>;
		"icon-halo-blur"?: DataDrivenPropertyValueSpecification<number>;
		"icon-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"icon-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"text-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"text-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"text-halo-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"text-halo-width"?: DataDrivenPropertyValueSpecification<number>;
		"text-halo-blur"?: DataDrivenPropertyValueSpecification<number>;
		"text-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"text-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
	};
};
export type CircleLayerSpecification = {
	"id": string;
	"type": "circle";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"circle-sort-key"?: DataDrivenPropertyValueSpecification<number>;
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"circle-radius"?: DataDrivenPropertyValueSpecification<number>;
		"circle-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"circle-blur"?: DataDrivenPropertyValueSpecification<number>;
		"circle-opacity"?: DataDrivenPropertyValueSpecification<number>;
		"circle-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"circle-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-pitch-scale"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-pitch-alignment"?: PropertyValueSpecification<"map" | "viewport">;
		"circle-stroke-width"?: DataDrivenPropertyValueSpecification<number>;
		"circle-stroke-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"circle-stroke-opacity"?: DataDrivenPropertyValueSpecification<number>;
	};
};
export type HeatmapLayerSpecification = {
	"id": string;
	"type": "heatmap";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"heatmap-radius"?: DataDrivenPropertyValueSpecification<number>;
		"heatmap-weight"?: DataDrivenPropertyValueSpecification<number>;
		"heatmap-intensity"?: PropertyValueSpecification<number>;
		"heatmap-color"?: ExpressionSpecification;
		"heatmap-opacity"?: PropertyValueSpecification<number>;
	};
};
export type FillExtrusionLayerSpecification = {
	"id": string;
	"type": "fill-extrusion";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"fill-extrusion-opacity"?: PropertyValueSpecification<number>;
		"fill-extrusion-color"?: DataDrivenPropertyValueSpecification<ColorSpecification>;
		"fill-extrusion-translate"?: PropertyValueSpecification<[
			number,
			number
		]>;
		"fill-extrusion-translate-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"fill-extrusion-pattern"?: DataDrivenPropertyValueSpecification<ResolvedImageSpecification>;
		"fill-extrusion-height"?: DataDrivenPropertyValueSpecification<number>;
		"fill-extrusion-base"?: DataDrivenPropertyValueSpecification<number>;
		"fill-extrusion-vertical-gradient"?: PropertyValueSpecification<boolean>;
	};
};
export type RasterLayerSpecification = {
	"id": string;
	"type": "raster";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"raster-opacity"?: PropertyValueSpecification<number>;
		"raster-hue-rotate"?: PropertyValueSpecification<number>;
		"raster-brightness-min"?: PropertyValueSpecification<number>;
		"raster-brightness-max"?: PropertyValueSpecification<number>;
		"raster-saturation"?: PropertyValueSpecification<number>;
		"raster-contrast"?: PropertyValueSpecification<number>;
		"raster-resampling"?: PropertyValueSpecification<"linear" | "nearest">;
		"raster-fade-duration"?: PropertyValueSpecification<number>;
	};
};
export type HillshadeLayerSpecification = {
	"id": string;
	"type": "hillshade";
	"metadata"?: unknown;
	"source": string;
	"source-layer"?: string;
	"minzoom"?: number;
	"maxzoom"?: number;
	"filter"?: FilterSpecification;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"hillshade-illumination-direction"?: PropertyValueSpecification<number>;
		"hillshade-illumination-anchor"?: PropertyValueSpecification<"map" | "viewport">;
		"hillshade-exaggeration"?: PropertyValueSpecification<number>;
		"hillshade-shadow-color"?: PropertyValueSpecification<ColorSpecification>;
		"hillshade-highlight-color"?: PropertyValueSpecification<ColorSpecification>;
		"hillshade-accent-color"?: PropertyValueSpecification<ColorSpecification>;
	};
};
export type BackgroundLayerSpecification = {
	"id": string;
	"type": "background";
	"metadata"?: unknown;
	"minzoom"?: number;
	"maxzoom"?: number;
	"layout"?: {
		"visibility"?: "visible" | "none";
	};
	"paint"?: {
		"background-color"?: PropertyValueSpecification<ColorSpecification>;
		"background-pattern"?: PropertyValueSpecification<ResolvedImageSpecification>;
		"background-opacity"?: PropertyValueSpecification<number>;
	};
};
export type LayerSpecification = FillLayerSpecification | LineLayerSpecification | SymbolLayerSpecification | CircleLayerSpecification | HeatmapLayerSpecification | FillExtrusionLayerSpecification | RasterLayerSpecification | HillshadeLayerSpecification | BackgroundLayerSpecification;
/**
 * Operations that can be performed by the diff.
 * Below are the operations and their arguments, the arguments should be aligned with the style methods in maplibre-gl-js.
 */
export type DiffOperationsMap = {
	"setStyle": [
		StyleSpecification
	];
	"addLayer": [
		LayerSpecification,
		string | null
	];
	"removeLayer": [
		string
	];
	"setPaintProperty": [
		string,
		string,
		unknown,
		string | null
	];
	"setLayoutProperty": [
		string,
		string,
		unknown,
		string | null
	];
	"setFilter": [
		string,
		unknown
	];
	"addSource": [
		string,
		SourceSpecification
	];
	"removeSource": [
		string
	];
	"setGeoJSONSourceData": [
		string,
		unknown
	];
	"setLayerZoomRange": [
		string,
		number,
		number
	];
	"setLayerProperty": [
		string,
		string,
		unknown
	];
	"setCenter": [
		number[]
	];
	"setCenterAltitude": [
		number
	];
	"setZoom": [
		number
	];
	"setBearing": [
		number
	];
	"setPitch": [
		number
	];
	"setRoll": [
		number
	];
	"setSprite": [
		SpriteSpecification
	];
	"setGlyphs": [
		string
	];
	"setTransition": [
		TransitionSpecification
	];
	"setLight": [
		LightSpecification
	];
	"setTerrain": [
		TerrainSpecification
	];
	"setSky": [
		SkySpecification
	];
	"setProjection": [
		ProjectionSpecification
	];
};
export type DiffOperations = keyof DiffOperationsMap;
export type DiffCommand<T extends DiffOperations> = {
	command: T;
	args: DiffOperationsMap[T];
};
/**
 * Diff two stylesheet
 *
 * Creates semanticly aware diffs that can easily be applied at runtime.
 * Operations produced by the diff closely resemble the maplibre-gl-js API. Any
 * error creating the diff will fall back to the 'setStyle' operation.
 *
 * Example diff:
 * [
 *     { command: 'setConstant', args: ['@water', '#0000FF'] },
 *     { command: 'setPaintProperty', args: ['background', 'background-color', 'black'] }
 * ]
 *
 * @private
 * @param {*} [before] stylesheet to compare from
 * @param {*} after stylesheet to compare to
 * @returns Array list of changes
 */
export declare function diff(before: StyleSpecification, after: StyleSpecification): DiffCommand<DiffOperations>[];
export declare class ValidationError {
	message: string;
	identifier: string;
	line: number;
	constructor(key: string, value: any & {
		__line__: number;
	}, message: string, identifier?: string | null);
}
export declare class ParsingError {
	message: string;
	error: Error;
	line: number;
	constructor(error: Error);
}
declare class ExpressionParsingError extends Error {
	key: string;
	message: string;
	constructor(key: string, message: string);
}
/**
 * @param r Red component 0..1
 * @param g Green component 0..1
 * @param b Blue component 0..1
 * @param alpha Alpha component 0..1
 */
export type RGBColor = [
	r: number,
	g: number,
	b: number,
	alpha: number
];
/**
 * @param h Hue as degrees 0..360
 * @param c Chroma 0..~230
 * @param l Lightness as percentage 0..100
 * @param alpha Alpha component 0..1
 */
export type HCLColor = [
	h: number,
	c: number,
	l: number,
	alpha: number
];
/**
 * @param l Lightness as percentage 0..100
 * @param a A axis value -125..125
 * @param b B axis value -125..125
 * @param alpha Alpha component 0..1
 */
export type LABColor = [
	l: number,
	a: number,
	b: number,
	alpha: number
];
export type InterpolationColorSpace = "rgb" | "hcl" | "lab";
/**
 * Color representation used by WebGL.
 * Defined in sRGB color space and pre-blended with alpha.
 * @private
 */
export declare class Color {
	readonly r: number;
	readonly g: number;
	readonly b: number;
	readonly a: number;
	/**
	 * @param r Red component premultiplied by `alpha` 0..1
	 * @param g Green component premultiplied by `alpha` 0..1
	 * @param b Blue component premultiplied by `alpha` 0..1
	 * @param [alpha=1] Alpha component 0..1
	 * @param [premultiplied=true] Whether the `r`, `g` and `b` values have already
	 * been multiplied by alpha. If `true` nothing happens if `false` then they will
	 * be multiplied automatically.
	 */
	constructor(r: number, g: number, b: number, alpha?: number, premultiplied?: boolean);
	static black: Color;
	static white: Color;
	static transparent: Color;
	static red: Color;
	/**
	 * Parses CSS color strings and converts colors to sRGB color space if needed.
	 * Officially supported color formats:
	 * - keyword, e.g. 'aquamarine' or 'steelblue'
	 * - hex (with 3, 4, 6 or 8 digits), e.g. '#f0f' or '#e9bebea9'
	 * - rgb and rgba, e.g. 'rgb(0,240,120)' or 'rgba(0%,94%,47%,0.1)' or 'rgb(0 240 120 / .3)'
	 * - hsl and hsla, e.g. 'hsl(0,0%,83%)' or 'hsla(0,0%,83%,.5)' or 'hsl(0 0% 83% / 20%)'
	 *
	 * @param input CSS color string to parse.
	 * @returns A `Color` instance, or `undefined` if the input is not a valid color string.
	 */
	static parse(input: Color | string | undefined | null): Color | undefined;
	/**
	 * Used in color interpolation and by 'to-rgba' expression.
	 *
	 * @returns Gien color, with reversed alpha blending, in sRGB color space.
	 */
	get rgb(): RGBColor;
	/**
	 * Used in color interpolation.
	 *
	 * @returns Gien color, with reversed alpha blending, in HCL color space.
	 */
	get hcl(): HCLColor;
	/**
	 * Used in color interpolation.
	 *
	 * @returns Gien color, with reversed alpha blending, in LAB color space.
	 */
	get lab(): LABColor;
	/**
	 * Lazy getter pattern. When getter is called for the first time lazy value
	 * is calculated and then overwrites getter function in given object instance.
	 *
	 * @example:
	 * const redColor = Color.parse('red');
	 * let x = redColor.hcl; // this will invoke `get hcl()`, which will calculate
	 * // the value of red in HCL space and invoke this `overwriteGetter` function
	 * // which in turn will set a field with a key 'hcl' in the `redColor` object.
	 * // In other words it will override `get hcl()` from its `Color` prototype
	 * // with its own property: hcl = [calculated red value in hcl].
	 * let y = redColor.hcl; // next call will no longer invoke getter but simply
	 * // return the previously calculated value
	 * x === y; // true - `x` is exactly the same object as `y`
	 *
	 * @param getterKey Getter key
	 * @param lazyValue Lazily calculated value to be memoized by current instance
	 * @private
	 */
	private overwriteGetter;
	/**
	 * Used by 'to-string' expression.
	 *
	 * @returns Serialized color in format `rgba(r,g,b,a)`
	 * where r,g,b are numbers within 0..255 and alpha is number within 1..0
	 *
	 * @example
	 * var purple = new Color.parse('purple');
	 * purple.toString; // = "rgba(128,0,128,1)"
	 * var translucentGreen = new Color.parse('rgba(26, 207, 26, .73)');
	 * translucentGreen.toString(); // = "rgba(26,207,26,0.73)"
	 */
	toString(): string;
	static interpolate(from: Color, to: Color, t: number, spaceKey?: InterpolationColorSpace): Color;
}
export type ResolvedImageOptions = {
	name: string;
	available: boolean;
};
export declare class ResolvedImage {
	name: string;
	available: boolean;
	constructor(options: ResolvedImageOptions);
	toString(): string;
	static fromString(name: string): ResolvedImage | null;
}
declare const VERTICAL_ALIGN_OPTIONS: readonly [
	"bottom",
	"center",
	"top"
];
export type VerticalAlign = typeof VERTICAL_ALIGN_OPTIONS[number];
export declare class FormattedSection {
	text: string;
	image: ResolvedImage | null;
	scale: number | null;
	fontStack: string | null;
	textColor: Color | null;
	verticalAlign: VerticalAlign | null;
	constructor(text: string, image: ResolvedImage | null, scale: number | null, fontStack: string | null, textColor: Color | null, verticalAlign: VerticalAlign | null);
}
export declare class Formatted {
	sections: Array<FormattedSection>;
	constructor(sections: Array<FormattedSection>);
	static fromString(unformatted: string): Formatted;
	isEmpty(): boolean;
	static factory(text: Formatted | string): Formatted;
	toString(): string;
}
export interface Point2D {
	x: number;
	y: number;
}
export interface ICanonicalTileID {
	z: number;
	x: number;
	y: number;
	key: string;
	equals(id: ICanonicalTileID): boolean;
	url(urls: Array<string>, pixelRatio: number, scheme: string | null): string;
	isChildOf(parent: ICanonicalTileID): boolean;
	getTilePoint(coord: IMercatorCoordinate): Point2D;
	toString(): string;
}
export interface IMercatorCoordinate {
	x: number;
	y: number;
	z: number;
	toLngLat(): ILngLat;
	toAltitude(): number;
	meterInMercatorCoordinateUnits(): number;
}
export interface ILngLat {
	lng: number;
	lat: number;
	wrap(): ILngLat;
	toArray(): [
		number,
		number
	];
	distanceTo(lngLat: ILngLat): number;
	toString(): string;
}
export type ILngLatLike = ILngLat | {
	lng: number;
	lat: number;
} | {
	lon: number;
	lat: number;
} | [
	number,
	number
];
export declare class EvaluationContext {
	globals: GlobalProperties;
	feature: Feature;
	featureState: FeatureState;
	formattedSection: FormattedSection;
	availableImages: Array<string>;
	canonical: ICanonicalTileID;
	_parseColorCache: {
		[_: string]: Color;
	};
	constructor();
	id(): any;
	geometryType(): string;
	geometry(): Point2D[][];
	canonicalID(): ICanonicalTileID;
	properties(): {
		[_: string]: any;
	};
	parseColor(input: string): Color;
}
export type NullTypeT = {
	kind: "null";
};
export type NumberTypeT = {
	kind: "number";
};
export type StringTypeT = {
	kind: "string";
};
export type BooleanTypeT = {
	kind: "boolean";
};
export type ColorTypeT = {
	kind: "color";
};
export type ProjectionDefinitionTypeT = {
	kind: "projectionDefinition";
};
export type ObjectTypeT = {
	kind: "object";
};
export type ValueTypeT = {
	kind: "value";
};
export type ErrorTypeT = {
	kind: "error";
};
export type CollatorTypeT = {
	kind: "collator";
};
export type FormattedTypeT = {
	kind: "formatted";
};
export type PaddingTypeT = {
	kind: "padding";
};
export type ResolvedImageTypeT = {
	kind: "resolvedImage";
};
export type VariableAnchorOffsetCollectionTypeT = {
	kind: "variableAnchorOffsetCollection";
};
export type EvaluationKind = "constant" | "source" | "camera" | "composite";
export type Type = NullTypeT | NumberTypeT | StringTypeT | BooleanTypeT | ColorTypeT | ProjectionDefinitionTypeT | ObjectTypeT | ValueTypeT | ArrayType | ErrorTypeT | CollatorTypeT | FormattedTypeT | PaddingTypeT | ResolvedImageTypeT | VariableAnchorOffsetCollectionTypeT;
export interface ArrayType<T extends Type = Type> {
	kind: "array";
	itemType: T;
	N: number;
}
export declare const NullType: NullTypeT;
export declare const ColorType: ColorTypeT;
export declare const ProjectionDefinitionType: ProjectionDefinitionTypeT;
export declare const FormattedType: FormattedTypeT;
declare function typeToString(type: Type): string;
declare class Intl$Collator {
	constructor(locales?: string | string[], options?: CollatorOptions);
	compare(a: string, b: string): number;
	resolvedOptions(): any;
}
export type CollatorOptions = {
	localeMatcher?: "lookup" | "best fit";
	usage?: "sort" | "search";
	sensitivity?: "base" | "accent" | "case" | "variant";
	ignorePunctuation?: boolean;
	numeric?: boolean;
	caseFirst?: "upper" | "lower" | "false";
};
declare class Collator {
	locale: string | null;
	sensitivity: "base" | "accent" | "case" | "variant";
	collator: Intl$Collator;
	constructor(caseSensitive: boolean, diacriticSensitive: boolean, locale: string | null);
	compare(lhs: string, rhs: string): number;
	resolvedLocale(): string;
}
/**
 * A set of four numbers representing padding around a box. Create instances from
 * bare arrays or numeric values using the static method `Padding.parse`.
 * @private
 */
export declare class Padding {
	/** Padding values are in CSS order: top, right, bottom, left */
	values: [
		number,
		number,
		number,
		number
	];
	constructor(values: [
		number,
		number,
		number,
		number
	]);
	/**
	 * Numeric padding values
	 * @param input A padding value
	 * @returns A `Padding` instance, or `undefined` if the input is not a valid padding value.
	 */
	static parse(input?: number | number[] | Padding | null): Padding | undefined;
	toString(): string;
	static interpolate(from: Padding, to: Padding, t: number): Padding;
}
/**
 * Utility class to assist managing values for text-variable-anchor-offset property. Create instances from
 * bare arrays using the static method `VariableAnchorOffsetCollection.parse`.
 * @private
 */
export declare class VariableAnchorOffsetCollection {
	/** Series of paired of anchor (string) and offset (point) values */
	values: VariableAnchorOffsetCollectionSpecification;
	constructor(values: VariableAnchorOffsetCollectionSpecification);
	static parse(input?: VariableAnchorOffsetCollectionSpecification | VariableAnchorOffsetCollection): VariableAnchorOffsetCollection | undefined;
	toString(): string;
	static interpolate(from: VariableAnchorOffsetCollection, to: VariableAnchorOffsetCollection, t: number): VariableAnchorOffsetCollection;
}
export declare class ProjectionDefinition {
	readonly from: string;
	readonly to: string;
	readonly transition: number;
	constructor(from: string, to: string, transition: number);
	static interpolate(from: string, to: string, t: number): ProjectionDefinition;
	static parse(input?: any): ProjectionDefinition;
}
export type Value = null | string | boolean | number | Color | ProjectionDefinition | Collator | Formatted | Padding | ResolvedImage | VariableAnchorOffsetCollection | ReadonlyArray<Value> | {
	readonly [x: string]: Value;
};
export declare function typeOf(value: Value): Type;
declare class Scope {
	parent: Scope;
	bindings: {
		[_: string]: Expression;
	};
	constructor(parent?: Scope, bindings?: Array<[
		string,
		Expression
	]>);
	concat(bindings: Array<[
		string,
		Expression
	]>): Scope;
	get(name: string): Expression;
	has(name: string): boolean;
}
declare class ParsingContext {
	registry: ExpressionRegistry;
	path: Array<number>;
	key: string;
	scope: Scope;
	errors: Array<ExpressionParsingError>;
	expectedType: Type;
	/**
	 * Internal delegate to inConstant function to avoid circular dependency to CompoundExpression
	 */
	private _isConstant;
	constructor(registry: ExpressionRegistry, isConstantFunc: (expression: Expression) => boolean, path?: Array<number>, expectedType?: Type | null, scope?: Scope, errors?: Array<ExpressionParsingError>);
	/**
	 * @param expr the JSON expression to parse
	 * @param index the optional argument index if this expression is an argument of a parent expression that's being parsed
	 * @param options
	 * @param options.omitTypeAnnotations set true to omit inferred type annotations.  Caller beware: with this option set, the parsed expression's type will NOT satisfy `expectedType` if it would normally be wrapped in an inferred annotation.
	 * @private
	 */
	parse(expr: unknown, index?: number, expectedType?: Type | null, bindings?: Array<[
		string,
		Expression
	]>, options?: {
		typeAnnotation?: "assert" | "coerce" | "omit";
	}): Expression;
	_parse(expr: unknown, options: {
		typeAnnotation?: "assert" | "coerce" | "omit";
	}): Expression;
	/**
	 * Returns a copy of this context suitable for parsing the subexpression at
	 * index `index`, optionally appending to 'let' binding map.
	 *
	 * Note that `errors` property, intended for collecting errors while
	 * parsing, is copied by reference rather than cloned.
	 * @private
	 */
	concat(index: number, expectedType?: Type | null, bindings?: Array<[
		string,
		Expression
	]>): ParsingContext;
	/**
	 * Push a parsing (or type checking) error into the `this.errors`
	 * @param error The message
	 * @param keys Optionally specify the source of the error at a child
	 * of the current expression at `this.key`.
	 * @private
	 */
	error(error: string, ...keys: Array<number>): void;
	/**
	 * Returns null if `t` is a subtype of `expected`; otherwise returns an
	 * error message and also pushes it to `this.errors`.
	 * @param expected The expected type
	 * @param t The actual type
	 * @returns null if `t` is a subtype of `expected`; otherwise returns an error message
	 */
	checkSubtype(expected: Type, t: Type): string;
}
/**
 * Expression
 */
export interface Expression {
	readonly type: Type;
	evaluate(ctx: EvaluationContext): any;
	eachChild(fn: (a: Expression) => void): void;
	/**
	 * Statically analyze the expression, attempting to enumerate possible outputs. Returns
	 * false if the complete set of outputs is statically undecidable, otherwise true.
	 */
	outputDefined(): boolean;
}
export type ExpressionParser = (args: ReadonlyArray<unknown>, context: ParsingContext) => Expression;
export type ExpressionRegistration = {
	new (...args: any): Expression;
} & {
	readonly parse: ExpressionParser;
};
export type ExpressionRegistry = {
	[_: string]: ExpressionRegistration;
};
/**
 * A type used for returning and propagating errors. The first element of the union
 * represents success and contains a value, and the second represents an error and
 * contains an error value.
 * @private
 */
export type Result<T, E> = {
	result: "success";
	value: T;
} | {
	result: "error";
	value: E;
};
declare function interpolateNumber(from: number, to: number, t: number): number;
declare function interpolateArray<T extends number[]>(from: T, to: T, t: number): T;
export type Stops = Array<[
	number,
	Expression
]>;
export type InterpolationType = {
	name: "linear";
} | {
	name: "exponential";
	base: number;
} | {
	name: "cubic-bezier";
	controlPoints: [
		number,
		number,
		number,
		number
	];
};
export type InterpolatedValueType = NumberTypeT | ColorTypeT | ProjectionDefinitionTypeT | PaddingTypeT | VariableAnchorOffsetCollectionTypeT | ArrayType<NumberTypeT>;
export declare class Interpolate implements Expression {
	type: InterpolatedValueType;
	operator: "interpolate" | "interpolate-hcl" | "interpolate-lab";
	interpolation: InterpolationType;
	input: Expression;
	labels: Array<number>;
	outputs: Array<Expression>;
	constructor(type: InterpolatedValueType, operator: "interpolate" | "interpolate-hcl" | "interpolate-lab", interpolation: InterpolationType, input: Expression, stops: Stops);
	static interpolationFactor(interpolation: InterpolationType, input: number, lower: number, upper: number): number;
	static parse(args: ReadonlyArray<unknown>, context: ParsingContext): Expression;
	evaluate(ctx: EvaluationContext): any;
	eachChild(fn: (_: Expression) => void): void;
	outputDefined(): boolean;
}
declare const interpolateFactory: {
	color: typeof Color.interpolate;
	number: typeof interpolateNumber;
	padding: typeof Padding.interpolate;
	variableAnchorOffsetCollection: typeof VariableAnchorOffsetCollection.interpolate;
	array: typeof interpolateArray;
};
export type Feature = {
	readonly type: 0 | 1 | 2 | 3 | "Unknown" | "Point" | "MultiPoint" | "LineString" | "MultiLineString" | "Polygon" | "MultiPolygon";
	readonly id?: any;
	readonly properties: {
		[_: string]: any;
	};
	readonly patterns?: {
		[_: string]: {
			"min": string;
			"mid": string;
			"max": string;
		};
	};
	readonly geometry?: Array<Array<Point2D>>;
};
export type FeatureState = {
	[_: string]: any;
};
export type GlobalProperties = Readonly<{
	zoom: number;
	heatmapDensity?: number;
	lineProgress?: number;
	isSupportedScript?: (_: string) => boolean;
	accumulated?: Value;
}>;
export declare class StyleExpression {
	expression: Expression;
	_evaluator: EvaluationContext;
	_defaultValue: Value;
	_warningHistory: {
		[key: string]: boolean;
	};
	_enumValues: {
		[_: string]: any;
	};
	constructor(expression: Expression, propertySpec?: StylePropertySpecification | null);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
}
export declare function isExpression(expression: unknown): boolean;
/**
 * Parse and typecheck the given style spec JSON expression.  If
 * options.defaultValue is provided, then the resulting StyleExpression's
 * `evaluate()` method will handle errors by logging a warning (once per
 * message) and returning the default value.  Otherwise, it will throw
 * evaluation errors.
 *
 * @private
 */
export declare function createExpression(expression: unknown, propertySpec?: StylePropertySpecification | null): Result<StyleExpression, Array<ExpressionParsingError>>;
export declare class ZoomConstantExpression<Kind extends EvaluationKind> {
	kind: Kind;
	isStateDependent: boolean;
	_styleExpression: StyleExpression;
	constructor(kind: Kind, expression: StyleExpression);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
}
export declare class ZoomDependentExpression<Kind extends EvaluationKind> {
	kind: Kind;
	zoomStops: Array<number>;
	isStateDependent: boolean;
	_styleExpression: StyleExpression;
	interpolationType: InterpolationType;
	constructor(kind: Kind, expression: StyleExpression, zoomStops: Array<number>, interpolationType?: InterpolationType);
	evaluateWithoutErrorHandling(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	evaluate(globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection): any;
	interpolationFactor(input: number, lower: number, upper: number): number;
}
export declare function isZoomExpression(expression: any): expression is ZoomConstantExpression<"source"> | ZoomDependentExpression<"source">;
export type ConstantExpression = {
	kind: "constant";
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>) => any;
};
export type SourceExpression = {
	kind: "source";
	isStateDependent: boolean;
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection) => any;
};
export type CameraExpression = {
	kind: "camera";
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>) => any;
	readonly interpolationFactor: (input: number, lower: number, upper: number) => number;
	zoomStops: Array<number>;
	interpolationType: InterpolationType;
};
export type CompositeExpression = {
	kind: "composite";
	isStateDependent: boolean;
	readonly evaluate: (globals: GlobalProperties, feature?: Feature, featureState?: FeatureState, canonical?: ICanonicalTileID, availableImages?: Array<string>, formattedSection?: FormattedSection) => any;
	readonly interpolationFactor: (input: number, lower: number, upper: number) => number;
	zoomStops: Array<number>;
	interpolationType: InterpolationType;
};
export type StylePropertyExpression = ConstantExpression | SourceExpression | CameraExpression | CompositeExpression;
export declare function createPropertyExpression(expressionInput: unknown, propertySpec: StylePropertySpecification): Result<StylePropertyExpression, Array<ExpressionParsingError>>;
export declare class StylePropertyFunction<T> {
	_parameters: PropertyValueSpecification<T>;
	_specification: StylePropertySpecification;
	kind: EvaluationKind;
	evaluate: (globals: GlobalProperties, feature?: Feature) => any;
	interpolationFactor: ((input: number, lower: number, upper: number) => number);
	zoomStops: Array<number>;
	constructor(parameters: PropertyValueSpecification<T>, specification: StylePropertySpecification);
	static deserialize<T>(serialized: {
		_parameters: PropertyValueSpecification<T>;
		_specification: StylePropertySpecification;
	}): StylePropertyFunction<T>;
	static serialize<T>(input: StylePropertyFunction<T>): {
		_parameters: PropertyValueSpecification<T>;
		_specification: StylePropertySpecification;
	};
}
export declare function normalizePropertyExpression<T>(value: PropertyValueSpecification<T>, specification: StylePropertySpecification): StylePropertyExpression;
export type FilterExpression = (globalProperties: GlobalProperties, feature: Feature, canonical?: ICanonicalTileID) => boolean;
export type FeatureFilter = {
	filter: FilterExpression;
	needGeometry: boolean;
};
declare function isExpressionFilter(filter: any): filter is ExpressionFilterSpecification;
/**
 * Given a filter expressed as nested arrays, return a new function
 * that evaluates whether a given feature (with a .properties or .tags property)
 * passes its test.
 *
 * @private
 * @param {Array} filter MapLibre filter
 * @returns {Function} filter-evaluating function
 */
export declare function featureFilter(filter: any): FeatureFilter;
export type ExpectedTypes = {
	[_: string]: ExpressionInputType;
};
export declare function convertFilter(filter: FilterSpecification, expectedTypes?: ExpectedTypes): ExpressionFilterSpecification;
export declare function isFunction(value: any): boolean;
export declare function createFunction(parameters: any, propertySpec: any): {
	kind: string;
	interpolationType: {
		name: string;
	};
	interpolationFactor: any;
	zoomStops: any[];
	evaluate({ zoom }: {
		zoom: any;
	}, properties: any): any;
} | {
	kind: string;
	interpolationType: {
		name: string;
		base: any;
	};
	interpolationFactor: any;
	zoomStops: any;
	evaluate: ({ zoom }: {
		zoom: any;
	}) => any;
} | {
	kind: string;
	evaluate(_: any, feature: any): any;
	interpolationType?: undefined;
	interpolationFactor?: undefined;
	zoomStops?: undefined;
};
export declare function convertFunction(parameters: any, propertySpec: StylePropertySpecification): any;
declare function eachSource(style: StyleSpecification, callback: (_: SourceSpecification) => void): void;
declare function eachLayer(style: StyleSpecification, callback: (_: LayerSpecification) => void): void;
export type PropertyCallback = (a: {
	path: [
		string,
		"paint" | "layout",
		string
	];
	key: string;
	value: PropertyValueSpecification<unknown> | DataDrivenPropertyValueSpecification<unknown>;
	reference: StylePropertySpecification;
	set: (a: PropertyValueSpecification<unknown> | DataDrivenPropertyValueSpecification<unknown>) => void;
}) => void;
declare function eachProperty(style: StyleSpecification, options: {
	paint?: boolean;
	layout?: boolean;
}, callback: PropertyCallback): void;
export declare function supportsPropertyExpression(spec: StylePropertySpecification): boolean;
export declare const expressions: ExpressionRegistry;
/**
 * Given an array of layers, return an array of arrays of layers where all
 * layers in each group have identical layout-affecting properties. These
 * are the properties that were formerly used by explicit `ref` mechanism
 * for layers: 'type', 'source', 'source-layer', 'minzoom', 'maxzoom',
 * 'filter', and 'layout'.
 *
 * The input is not modified. The output layers are references to the
 * input layers.
 *
 * @private
 * @param {Array<Layer>} layers
 * @param {Object} [cachedKeys] - an object to keep already calculated keys.
 * @returns {Array<Array<Layer>>}
 */
export declare function groupByLayout(layers: any, cachedKeys: any): any[];
export declare function emptyStyle(): StyleSpecification;
/**
 * Validate a MapLibre style against the style specification.
 * Use this when running in the browser.
 *
 * @param style - The style to be validated.
 * @param styleSpec - The style specification to validate against.
 * If omitted, the latest style spec is used.
 * @returns an array of errors, or an empty array if no errors are found.
 * @example
 *   const validate = require('@maplibre/maplibre-gl-style-spec/').validateStyleMin;
 *   const errors = validate(style);
 */
export declare function validateStyleMin(style: StyleSpecification, styleSpec?: {
	$version: number;
	$root: {
		version: {
			required: boolean;
			type: string;
			values: number[];
			doc: string;
			example: number;
		};
		name: {
			type: string;
			doc: string;
			example: string;
		};
		metadata: {
			type: string;
			doc: string;
			example: {
				"styleeditor:slimmode": boolean;
				"styleeditor:comment": string;
				"styleeditor:version": string;
				"example:object": {
					String: string;
					Number: number;
					Boolean: boolean;
				};
			};
		};
		center: {
			type: string;
			value: string;
			doc: string;
			example: number[];
		};
		centerAltitude: {
			type: string;
			doc: string;
			example: number;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		zoom: {
			type: string;
			doc: string;
			example: number;
		};
		bearing: {
			type: string;
			default: number;
			period: number;
			units: string;
			doc: string;
			example: number;
		};
		pitch: {
			type: string;
			default: number;
			units: string;
			doc: string;
			example: number;
			"sdk-support": {
				"0-60 degrees": {
					js: string;
					android: string;
					ios: string;
				};
				"0-85 degrees": {
					js: string;
					android: string;
					ios: string;
				};
				"0-180 degrees": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		roll: {
			type: string;
			default: number;
			units: string;
			doc: string;
			example: number;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		light: {
			type: string;
			doc: string;
			example: {
				anchor: string;
				color: string;
				intensity: number;
			};
		};
		sky: {
			type: string;
			doc: string;
			example: {
				"sky-color": string;
				"sky-horizon-blend": number;
				"horizon-color": string;
				"horizon-fog-blend": number;
				"fog-color": string;
				"fog-ground-blend": number;
				"atmosphere-blend": (string | number | string[])[];
			};
		};
		projection: {
			type: string;
			doc: string;
			example: {
				type: (string | number | string[])[];
			};
		};
		terrain: {
			type: string;
			doc: string;
			example: {
				source: string;
				exaggeration: number;
			};
		};
		sources: {
			required: boolean;
			type: string;
			doc: string;
			example: {
				"maplibre-demotiles": {
					type: string;
					url: string;
				};
				"maplibre-tilejson": {
					type: string;
					url: string;
				};
				"maplibre-streets": {
					type: string;
					tiles: string[];
					maxzoom: number;
				};
				"wms-imagery": {
					type: string;
					tiles: string[];
					tileSize: number;
				};
			};
		};
		sprite: {
			type: string;
			doc: string;
			example: string;
		};
		glyphs: {
			type: string;
			doc: string;
			example: string;
		};
		transition: {
			type: string;
			doc: string;
			example: {
				duration: number;
				delay: number;
			};
		};
		layers: {
			required: boolean;
			type: string;
			value: string;
			doc: string;
			example: {
				id: string;
				source: string;
				"source-layer": string;
				type: string;
				paint: {
					"line-color": string;
				};
			}[];
		};
	};
	sources: {
		"*": {
			type: string;
			doc: string;
		};
	};
	source: string[];
	source_vector: {
		type: {
			required: boolean;
			type: string;
			values: {
				vector: {
					doc: string;
				};
			};
			doc: string;
		};
		url: {
			type: string;
			doc: string;
		};
		tiles: {
			type: string;
			value: string;
			doc: string;
		};
		bounds: {
			type: string;
			value: string;
			length: number;
			default: number[];
			doc: string;
		};
		scheme: {
			type: string;
			values: {
				xyz: {
					doc: string;
				};
				tms: {
					doc: string;
				};
			};
			default: string;
			doc: string;
		};
		minzoom: {
			type: string;
			default: number;
			doc: string;
		};
		maxzoom: {
			type: string;
			default: number;
			doc: string;
		};
		attribution: {
			type: string;
			doc: string;
		};
		promoteId: {
			type: string;
			doc: string;
		};
		volatile: {
			type: string;
			default: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					android: string;
					ios: string;
					js: string;
				};
			};
		};
		"*": {
			type: string;
			doc: string;
		};
	};
	source_raster: {
		type: {
			required: boolean;
			type: string;
			values: {
				raster: {
					doc: string;
				};
			};
			doc: string;
		};
		url: {
			type: string;
			doc: string;
		};
		tiles: {
			type: string;
			value: string;
			doc: string;
		};
		bounds: {
			type: string;
			value: string;
			length: number;
			default: number[];
			doc: string;
		};
		minzoom: {
			type: string;
			default: number;
			doc: string;
		};
		maxzoom: {
			type: string;
			default: number;
			doc: string;
		};
		tileSize: {
			type: string;
			default: number;
			units: string;
			doc: string;
		};
		scheme: {
			type: string;
			values: {
				xyz: {
					doc: string;
				};
				tms: {
					doc: string;
				};
			};
			default: string;
			doc: string;
		};
		attribution: {
			type: string;
			doc: string;
		};
		volatile: {
			type: string;
			default: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					android: string;
					ios: string;
					js: string;
				};
			};
		};
		"*": {
			type: string;
			doc: string;
		};
	};
	source_raster_dem: {
		type: {
			required: boolean;
			type: string;
			values: {
				"raster-dem": {
					doc: string;
				};
			};
			doc: string;
		};
		url: {
			type: string;
			doc: string;
		};
		tiles: {
			type: string;
			value: string;
			doc: string;
		};
		bounds: {
			type: string;
			value: string;
			length: number;
			default: number[];
			doc: string;
		};
		minzoom: {
			type: string;
			default: number;
			doc: string;
		};
		maxzoom: {
			type: string;
			default: number;
			doc: string;
		};
		tileSize: {
			type: string;
			default: number;
			units: string;
			doc: string;
		};
		attribution: {
			type: string;
			doc: string;
		};
		encoding: {
			type: string;
			values: {
				terrarium: {
					doc: string;
				};
				mapbox: {
					doc: string;
				};
				custom: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"mapbox, terrarium": {
					js: string;
					ios: string;
					android: string;
				};
				custom: {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		redFactor: {
			type: string;
			default: number;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		blueFactor: {
			type: string;
			default: number;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		greenFactor: {
			type: string;
			default: number;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		baseShift: {
			type: string;
			default: number;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		volatile: {
			type: string;
			default: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					android: string;
					ios: string;
					js: string;
				};
			};
		};
		"*": {
			type: string;
			doc: string;
		};
	};
	source_geojson: {
		type: {
			required: boolean;
			type: string;
			values: {
				geojson: {
					doc: string;
				};
			};
			doc: string;
		};
		data: {
			required: boolean;
			type: string;
			doc: string;
		};
		maxzoom: {
			type: string;
			default: number;
			doc: string;
		};
		attribution: {
			type: string;
			doc: string;
		};
		buffer: {
			type: string;
			default: number;
			maximum: number;
			minimum: number;
			doc: string;
		};
		filter: {
			type: string;
			doc: string;
		};
		tolerance: {
			type: string;
			default: number;
			doc: string;
		};
		cluster: {
			type: string;
			default: boolean;
			doc: string;
		};
		clusterRadius: {
			type: string;
			default: number;
			minimum: number;
			doc: string;
		};
		clusterMaxZoom: {
			type: string;
			doc: string;
		};
		clusterMinPoints: {
			type: string;
			doc: string;
		};
		clusterProperties: {
			type: string;
			doc: string;
		};
		lineMetrics: {
			type: string;
			default: boolean;
			doc: string;
		};
		generateId: {
			type: string;
			default: boolean;
			doc: string;
		};
		promoteId: {
			type: string;
			doc: string;
		};
	};
	source_video: {
		type: {
			required: boolean;
			type: string;
			values: {
				video: {
					doc: string;
				};
			};
			doc: string;
		};
		urls: {
			required: boolean;
			type: string;
			value: string;
			doc: string;
		};
		coordinates: {
			required: boolean;
			doc: string;
			type: string;
			length: number;
			value: {
				type: string;
				length: number;
				value: string;
				doc: string;
			};
		};
	};
	source_image: {
		type: {
			required: boolean;
			type: string;
			values: {
				image: {
					doc: string;
				};
			};
			doc: string;
		};
		url: {
			required: boolean;
			type: string;
			doc: string;
		};
		coordinates: {
			required: boolean;
			doc: string;
			type: string;
			length: number;
			value: {
				type: string;
				length: number;
				value: string;
				doc: string;
			};
		};
	};
	layer: {
		id: {
			type: string;
			doc: string;
			required: boolean;
		};
		type: {
			type: string;
			values: {
				fill: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				line: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				symbol: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				circle: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				heatmap: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				"fill-extrusion": {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				raster: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				hillshade: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
				background: {
					doc: string;
					"sdk-support": {
						"basic functionality": {
							js: string;
							android: string;
							ios: string;
						};
					};
				};
			};
			doc: string;
			required: boolean;
		};
		metadata: {
			type: string;
			doc: string;
			example: {
				"source:comment": string;
			};
		};
		source: {
			type: string;
			doc: string;
		};
		"source-layer": {
			type: string;
			doc: string;
		};
		minzoom: {
			type: string;
			minimum: number;
			maximum: number;
			doc: string;
		};
		maxzoom: {
			type: string;
			minimum: number;
			maximum: number;
			doc: string;
		};
		filter: {
			type: string;
			doc: string;
		};
		layout: {
			type: string;
			doc: string;
		};
		paint: {
			type: string;
			doc: string;
		};
	};
	layout: string[];
	layout_background: {
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_fill: {
		"fill-sort-key": {
			type: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_circle: {
		"circle-sort-key": {
			type: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_heatmap: {
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	"layout_fill-extrusion": {
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_line: {
		"line-cap": {
			type: string;
			values: {
				butt: {
					doc: string;
				};
				round: {
					doc: string;
				};
				square: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-join": {
			type: string;
			values: {
				bevel: {
					doc: string;
				};
				round: {
					doc: string;
				};
				miter: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-miter-limit": {
			type: string;
			default: number;
			doc: string;
			requires: {
				"line-join": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-round-limit": {
			type: string;
			default: number;
			doc: string;
			requires: {
				"line-join": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-sort-key": {
			type: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_symbol: {
		"symbol-placement": {
			type: string;
			values: {
				point: {
					doc: string;
				};
				line: {
					doc: string;
				};
				"line-center": {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"`line-center` value": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"symbol-spacing": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			requires: {
				"symbol-placement": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"symbol-avoid-edges": {
			type: string;
			default: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"symbol-sort-key": {
			type: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"symbol-z-order": {
			type: string;
			values: {
				auto: {
					doc: string;
				};
				"viewport-y": {
					doc: string;
				};
				source: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-allow-overlap": {
			type: string;
			default: boolean;
			doc: string;
			requires: (string | {
				"!": string;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-overlap": {
			type: string;
			values: {
				never: {
					doc: string;
				};
				always: {
					doc: string;
				};
				cooperative: {
					doc: string;
				};
			};
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-ignore-placement": {
			type: string;
			default: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-optional": {
			type: string;
			default: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-rotation-alignment": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
				auto: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"`auto` value": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-size": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-text-fit": {
			type: string;
			values: {
				none: {
					doc: string;
				};
				width: {
					doc: string;
				};
				height: {
					doc: string;
				};
				both: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"stretchable icons": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-text-fit-padding": {
			type: string;
			value: string;
			length: number;
			default: number[];
			units: string;
			doc: string;
			requires: (string | {
				"icon-text-fit": string[];
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-image": {
			type: string;
			doc: string;
			tokens: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-rotate": {
			type: string;
			default: number;
			period: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-padding": {
			type: string;
			default: number[];
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-keep-upright": {
			type: string;
			default: boolean;
			doc: string;
			requires: (string | {
				"icon-rotation-alignment": string;
				"symbol-placement"?: undefined;
			} | {
				"symbol-placement": string[];
				"icon-rotation-alignment"?: undefined;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-offset": {
			type: string;
			value: string;
			length: number;
			default: number[];
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-anchor": {
			type: string;
			values: {
				center: {
					doc: string;
				};
				left: {
					doc: string;
				};
				right: {
					doc: string;
				};
				top: {
					doc: string;
				};
				bottom: {
					doc: string;
				};
				"top-left": {
					doc: string;
				};
				"top-right": {
					doc: string;
				};
				"bottom-left": {
					doc: string;
				};
				"bottom-right": {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-pitch-alignment": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
				auto: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-pitch-alignment": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
				auto: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"`auto` value": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-rotation-alignment": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
				"viewport-glyph": {
					doc: string;
				};
				auto: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"`auto` value": {
					js: string;
					android: string;
					ios: string;
				};
				"`viewport-glyph` value": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-field": {
			type: string;
			default: string;
			tokens: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-font": {
			type: string;
			value: string;
			default: string[];
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-size": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-max-width": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-line-height": {
			type: string;
			default: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-letter-spacing": {
			type: string;
			default: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-justify": {
			type: string;
			values: {
				auto: {
					doc: string;
				};
				left: {
					doc: string;
				};
				center: {
					doc: string;
				};
				right: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
				auto: {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-radial-offset": {
			type: string;
			units: string;
			default: number;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			requires: string[];
			"property-type": string;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
		};
		"text-variable-anchor": {
			type: string;
			value: string;
			values: {
				center: {
					doc: string;
				};
				left: {
					doc: string;
				};
				right: {
					doc: string;
				};
				top: {
					doc: string;
				};
				bottom: {
					doc: string;
				};
				"top-left": {
					doc: string;
				};
				"top-right": {
					doc: string;
				};
				"bottom-left": {
					doc: string;
				};
				"bottom-right": {
					doc: string;
				};
			};
			requires: (string | {
				"symbol-placement": string[];
			})[];
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-variable-anchor-offset": {
			type: string;
			requires: (string | {
				"symbol-placement": string[];
			})[];
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
				"data-driven styling": {
					js: string;
					ios: string;
					android: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-anchor": {
			type: string;
			values: {
				center: {
					doc: string;
				};
				left: {
					doc: string;
				};
				right: {
					doc: string;
				};
				top: {
					doc: string;
				};
				bottom: {
					doc: string;
				};
				"top-left": {
					doc: string;
				};
				"top-right": {
					doc: string;
				};
				"bottom-left": {
					doc: string;
				};
				"bottom-right": {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: (string | {
				"!": string;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-max-angle": {
			type: string;
			default: number;
			units: string;
			doc: string;
			requires: (string | {
				"symbol-placement": string[];
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-writing-mode": {
			type: string;
			value: string;
			values: {
				horizontal: {
					doc: string;
				};
				vertical: {
					doc: string;
				};
			};
			doc: string;
			requires: (string | {
				"symbol-placement": string[];
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-rotate": {
			type: string;
			default: number;
			period: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-padding": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-keep-upright": {
			type: string;
			default: boolean;
			doc: string;
			requires: (string | {
				"text-rotation-alignment": string;
				"symbol-placement"?: undefined;
			} | {
				"symbol-placement": string[];
				"text-rotation-alignment"?: undefined;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-transform": {
			type: string;
			values: {
				none: {
					doc: string;
				};
				uppercase: {
					doc: string;
				};
				lowercase: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-offset": {
			type: string;
			doc: string;
			value: string;
			units: string;
			length: number;
			default: number[];
			requires: (string | {
				"!": string;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-allow-overlap": {
			type: string;
			default: boolean;
			doc: string;
			requires: (string | {
				"!": string;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-overlap": {
			type: string;
			values: {
				never: {
					doc: string;
				};
				always: {
					doc: string;
				};
				cooperative: {
					doc: string;
				};
			};
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-ignore-placement": {
			type: string;
			default: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-optional": {
			type: string;
			default: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_raster: {
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	layout_hillshade: {
		visibility: {
			type: string;
			values: {
				visible: {
					doc: string;
				};
				none: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			"property-type": string;
		};
	};
	filter: {
		type: string;
		value: string;
		doc: string;
	};
	filter_operator: {
		type: string;
		values: {
			"==": {
				doc: string;
			};
			"!=": {
				doc: string;
			};
			">": {
				doc: string;
			};
			">=": {
				doc: string;
			};
			"<": {
				doc: string;
			};
			"<=": {
				doc: string;
			};
			in: {
				doc: string;
			};
			"!in": {
				doc: string;
			};
			all: {
				doc: string;
			};
			any: {
				doc: string;
			};
			none: {
				doc: string;
			};
			has: {
				doc: string;
			};
			"!has": {
				doc: string;
			};
		};
		doc: string;
	};
	geometry_type: {
		type: string;
		values: {
			Point: {
				doc: string;
			};
			LineString: {
				doc: string;
			};
			Polygon: {
				doc: string;
			};
		};
		doc: string;
	};
	function: {
		expression: {
			type: string;
			doc: string;
		};
		stops: {
			type: string;
			doc: string;
			value: string;
		};
		base: {
			type: string;
			default: number;
			minimum: number;
			doc: string;
		};
		property: {
			type: string;
			doc: string;
			default: string;
		};
		type: {
			type: string;
			values: {
				identity: {
					doc: string;
				};
				exponential: {
					doc: string;
				};
				interval: {
					doc: string;
				};
				categorical: {
					doc: string;
				};
			};
			doc: string;
			default: string;
		};
		colorSpace: {
			type: string;
			values: {
				rgb: {
					doc: string;
				};
				lab: {
					doc: string;
				};
				hcl: {
					doc: string;
				};
			};
			doc: string;
			default: string;
		};
		default: {
			type: string;
			required: boolean;
			doc: string;
		};
	};
	function_stop: {
		type: string;
		minimum: number;
		maximum: number;
		value: string[];
		length: number;
		doc: string;
	};
	expression: {
		type: string;
		value: string;
		minimum: number;
		doc: string;
	};
	expression_name: {
		doc: string;
		type: string;
		values: {
			let: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | (string | number | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			var: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			literal: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			array: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | (string | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			at: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | (string | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			in: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"index-of": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			slice: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			case: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | (string | boolean | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			match: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			coalesce: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | (string | (string | string[])[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			step: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			interpolate: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"interpolate-hcl": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						ios: string;
						android: string;
					};
				};
			};
			"interpolate-lab": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						ios: string;
						android: string;
					};
				};
			};
			ln2: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			pi: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			e: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			typeof: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			string: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			number: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			boolean: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | boolean | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			object: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			collator: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | {
						"case-sensitive": boolean;
						"diacritic-sensitive": boolean;
						locale: string;
					})[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			format: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | (string | string[])[] | {
						"font-scale": number;
						"vertical-align"?: undefined;
					} | {
						"font-scale"?: undefined;
						"vertical-align"?: undefined;
					} | {
						"font-scale": number;
						"vertical-align": string;
					})[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					"text-font": {
						js: string;
						android: string;
						ios: string;
					};
					"font-scale": {
						js: string;
						android: string;
						ios: string;
					};
					"text-color": {
						js: string;
						android: string;
						ios: string;
					};
					"vertical-align": {
						js: string;
						android: string;
						ios: string;
					};
					image: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			image: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"number-format": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[] | {
						"min-fraction-digits": number;
						"max-fraction-digits": number;
					})[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"to-string": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"to-number": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"to-boolean": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"to-rgba": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"to-color": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			rgb: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			rgba: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			get: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			has: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			length: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			properties: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"feature-state": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						ios: string;
						android: string;
					};
				};
			};
			"geometry-type": {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			id: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			zoom: {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"heatmap-density": {
				doc: string;
				example: {
					syntax: {
						method: any[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"line-progress": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			accumulated: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						ios: string;
						android: string;
					};
				};
			};
			"+": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"*": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"-": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"/": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"%": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"^": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			sqrt: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			log10: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			ln: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			log2: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			sin: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			cos: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			tan: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			asin: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			acos: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			atan: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			min: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			max: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			round: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			abs: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			ceil: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			floor: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			distance: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | {
						type: string;
						coordinates: number[];
					})[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"==": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"!=": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | boolean)[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			">": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"<": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			">=": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"<=": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | number | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
					collator: {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			all: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | (string | number | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			any: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | (string | number | string[])[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"!": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			within: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | {
						type: string;
						coordinates: number[][][];
					})[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"is-supported-script": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: string[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			upcase: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			downcase: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			concat: {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | string[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
			"resolved-locale": {
				doc: string;
				example: {
					syntax: {
						method: string[];
						result: string;
					};
					value: (string | (string | {
						"case-sensitive": boolean;
						"diacritic-sensitive": boolean;
						locale: string;
					})[])[];
				};
				group: string;
				"sdk-support": {
					"basic functionality": {
						js: string;
						android: string;
						ios: string;
					};
				};
			};
		};
	};
	light: {
		anchor: {
			type: string;
			default: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			"property-type": string;
			transition: boolean;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			doc: string;
			example: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		position: {
			type: string;
			default: number[];
			length: number;
			value: string;
			"property-type": string;
			transition: boolean;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			doc: string;
			example: number[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		color: {
			type: string;
			"property-type": string;
			default: string;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
		intensity: {
			type: string;
			"property-type": string;
			default: number;
			minimum: number;
			maximum: number;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
		};
	};
	sky: {
		"sky-color": {
			type: string;
			"property-type": string;
			default: string;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"horizon-color": {
			type: string;
			"property-type": string;
			default: string;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"fog-color": {
			type: string;
			"property-type": string;
			default: string;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"fog-ground-blend": {
			type: string;
			"property-type": string;
			default: number;
			minimum: number;
			maximum: number;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"horizon-fog-blend": {
			type: string;
			"property-type": string;
			default: number;
			minimum: number;
			maximum: number;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"sky-horizon-blend": {
			type: string;
			"property-type": string;
			default: number;
			minimum: number;
			maximum: number;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
		"atmosphere-blend": {
			type: string;
			"property-type": string;
			default: number;
			minimum: number;
			maximum: number;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			transition: boolean;
			doc: string;
		};
	};
	terrain: {
		source: {
			type: string;
			doc: string;
			required: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
		exaggeration: {
			type: string;
			minimum: number;
			doc: string;
			default: number;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
		};
	};
	projection: {
		type: {
			type: string;
			doc: string;
			default: string;
			"property-type": string;
			transition: boolean;
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
		};
	};
	paint: string[];
	paint_fill: {
		"fill-antialias": {
			type: string;
			default: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-opacity": {
			type: string;
			default: number;
			minimum: number;
			maximum: number;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			requires: {
				"!": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-outline-color": {
			type: string;
			doc: string;
			transition: boolean;
			requires: ({
				"!": string;
				"fill-antialias"?: undefined;
			} | {
				"fill-antialias": boolean;
				"!"?: undefined;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-pattern": {
			type: string;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	"paint_fill-extrusion": {
		"fill-extrusion-opacity": {
			type: string;
			default: number;
			minimum: number;
			maximum: number;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			requires: {
				"!": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-pattern": {
			type: string;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-height": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-base": {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
			transition: boolean;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"fill-extrusion-vertical-gradient": {
			type: string;
			default: boolean;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					ios: string;
					android: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_line: {
		"line-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-color": {
			type: string;
			doc: string;
			default: string;
			transition: boolean;
			requires: {
				"!": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-width": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-gap-width": {
			type: string;
			default: number;
			minimum: number;
			doc: string;
			transition: boolean;
			units: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-offset": {
			type: string;
			default: number;
			doc: string;
			transition: boolean;
			units: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-blur": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-dasharray": {
			type: string;
			value: string;
			doc: string;
			minimum: number;
			transition: boolean;
			units: string;
			requires: {
				"!": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					ios: string;
					android: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-pattern": {
			type: string;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"line-gradient": {
			type: string;
			doc: string;
			transition: boolean;
			requires: ({
				"!": string;
				source?: undefined;
				has?: undefined;
			} | {
				source: string;
				has: {
					lineMetrics: boolean;
				};
				"!"?: undefined;
			})[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_circle: {
		"circle-radius": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-blur": {
			type: string;
			default: number;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-pitch-scale": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-pitch-alignment": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-stroke-width": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-stroke-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"circle-stroke-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_heatmap: {
		"heatmap-radius": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"heatmap-weight": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"heatmap-intensity": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"heatmap-color": {
			type: string;
			default: (string | number | string[])[];
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"heatmap-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_symbol: {
		"icon-opacity": {
			doc: string;
			type: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-color": {
			type: string;
			default: string;
			transition: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-halo-color": {
			type: string;
			default: string;
			transition: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-halo-width": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-halo-blur": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"icon-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-color": {
			type: string;
			doc: string;
			default: string;
			transition: boolean;
			overridable: boolean;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-halo-color": {
			type: string;
			default: string;
			transition: boolean;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-halo-width": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-halo-blur": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-translate": {
			type: string;
			value: string;
			length: number;
			default: number[];
			transition: boolean;
			units: string;
			doc: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"text-translate-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			doc: string;
			default: string;
			requires: string[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_raster: {
		"raster-opacity": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-hue-rotate": {
			type: string;
			default: number;
			period: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-brightness-min": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-brightness-max": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-saturation": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-contrast": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-resampling": {
			type: string;
			doc: string;
			values: {
				linear: {
					doc: string;
				};
				nearest: {
					doc: string;
				};
			};
			default: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"raster-fade-duration": {
			type: string;
			default: number;
			minimum: number;
			transition: boolean;
			units: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_hillshade: {
		"hillshade-illumination-direction": {
			type: string;
			default: number;
			minimum: number;
			maximum: number;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"hillshade-illumination-anchor": {
			type: string;
			values: {
				map: {
					doc: string;
				};
				viewport: {
					doc: string;
				};
			};
			default: string;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"hillshade-exaggeration": {
			type: string;
			doc: string;
			default: number;
			minimum: number;
			maximum: number;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"hillshade-shadow-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"hillshade-highlight-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"hillshade-accent-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	paint_background: {
		"background-color": {
			type: string;
			default: string;
			doc: string;
			transition: boolean;
			requires: {
				"!": string;
			}[];
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"background-pattern": {
			type: string;
			transition: boolean;
			doc: string;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
				"data-driven styling": {};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
		"background-opacity": {
			type: string;
			default: number;
			minimum: number;
			maximum: number;
			doc: string;
			transition: boolean;
			"sdk-support": {
				"basic functionality": {
					js: string;
					android: string;
					ios: string;
				};
			};
			expression: {
				interpolated: boolean;
				parameters: string[];
			};
			"property-type": string;
		};
	};
	transition: {
		duration: {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
		};
		delay: {
			type: string;
			default: number;
			minimum: number;
			units: string;
			doc: string;
		};
	};
	"property-type": {
		"data-driven": {
			type: string;
			doc: string;
		};
		"cross-faded": {
			type: string;
			doc: string;
		};
		"cross-faded-data-driven": {
			type: string;
			doc: string;
		};
		"color-ramp": {
			type: string;
			doc: string;
		};
		"data-constant": {
			type: string;
			doc: string;
		};
		constant: {
			type: string;
			doc: string;
		};
	};
	promoteId: {
		"*": {
			type: string;
			doc: string;
		};
	};
}): Array<ValidationError>;
export declare namespace validateStyleMin {
	var source: (...args: any[]) => any[];
	var sprite: (...args: any[]) => any[];
	var glyphs: (...args: any[]) => any[];
	var light: (...args: any[]) => any[];
	var sky: (...args: any[]) => any[];
	var terrain: (...args: any[]) => any[];
	var layer: (...args: any[]) => any[];
	var filter: (...args: any[]) => any[];
	var paintProperty: (...args: any[]) => any[];
	var layoutProperty: (...args: any[]) => any[];
}
export declare class Step implements Expression {
	type: Type;
	input: Expression;
	labels: Array<number>;
	outputs: Array<Expression>;
	constructor(type: Type, input: Expression, stops: Stops);
	static parse(args: ReadonlyArray<unknown>, context: ParsingContext): Expression;
	evaluate(ctx: EvaluationContext): any;
	eachChild(fn: (_: Expression) => void): void;
	outputDefined(): boolean;
}
export type FormattedSectionExpression = {
	content: Expression;
	scale: Expression | null;
	font: Expression | null;
	textColor: Expression | null;
	verticalAlign: Expression | null;
};
export declare class FormatExpression implements Expression {
	type: Type;
	sections: Array<FormattedSectionExpression>;
	constructor(sections: Array<FormattedSectionExpression>);
	static parse(args: ReadonlyArray<unknown>, context: ParsingContext): Expression;
	evaluate(ctx: EvaluationContext): Formatted;
	eachChild(fn: (_: Expression) => void): void;
	outputDefined(): boolean;
}
export declare class Literal implements Expression {
	type: Type;
	value: Value;
	constructor(type: Type, value: Value);
	static parse(args: ReadonlyArray<unknown>, context: ParsingContext): Expression;
	evaluate(): Value;
	eachChild(): void;
	outputDefined(): boolean;
}
export type Varargs = {
	type: Type;
};
export type Signature = Array<Type> | Varargs;
export type Evaluate = (b: EvaluationContext, a: Array<Expression>) => Value;
export type Definition = [
	Type,
	Signature,
	Evaluate
] | {
	type: Type;
	overloads: Array<[
		Signature,
		Evaluate
	]>;
};
export declare class CompoundExpression implements Expression {
	name: string;
	type: Type;
	_evaluate: Evaluate;
	args: Array<Expression>;
	static definitions: {
		[_: string]: Definition;
	};
	constructor(name: string, type: Type, evaluate: Evaluate, args: Array<Expression>);
	evaluate(ctx: EvaluationContext): Value;
	eachChild(fn: (_: Expression) => void): void;
	outputDefined(): boolean;
	static parse(args: ReadonlyArray<unknown>, context: ParsingContext): Expression;
	static register(registry: ExpressionRegistry, definitions: {
		[_: string]: Definition;
	}): void;
}
/**
 * Format a MapLibre Style.  Returns a stringified style with its keys
 * sorted in the same order as the reference style.
 *
 * The optional `space` argument is passed to
 * [`JSON.stringify`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON/stringify)
 * to generate formatted output.
 *
 * If `space` is unspecified, a default of `2` spaces will be used.
 *
 * @private
 * @param {Object} style a MapLibre Style
 * @param {number} [space] space argument to pass to `JSON.stringify`
 * @returns {string} stringified formatted JSON
 * @example
 * var fs = require('fs');
 * var format = require('maplibre-gl-style-spec').format;
 * var style = fs.readFileSync('./source.json', 'utf8');
 * fs.writeFileSync('./dest.json', format(style));
 * fs.writeFileSync('./dest.min.json', format(style, 0));
 */
export declare function format(style: any, space?: number): string;
/**
 * Main recursive validation function used internally.
 * You should use `validateStyleMin` in the browser or `validateStyle` in node env.
 * @param options - the options object
 * @param options.key - string representing location of validation in style tree. Used only
 * for more informative error reporting.
 * @param options.value - current value from style being evaluated. May be anything from a
 * high level object that needs to be descended into deeper or a simple
 * scalar value.
 * @param options.valueSpec - current spec being evaluated. Tracks value.
 * @param options.styleSpec - current full spec being evaluated.
 * @param options.validateSpec - the validate function itself
 * @param options.style - the style object
 * @param options.objectElementValidators - optional object of functions that will be called
 * @returns an array of errors, or an empty array if no errors are found.
 */
export declare function validate(options: {
	key: any;
	value: any;
	valueSpec: any;
	styleSpec: any;
	validateSpec?: any;
	style: any;
	objectElementValidators?: any;
}): ValidationError[];
/**
 * Migrate a Mapbox/MapLibre GL Style to the latest version.
 *
 * @param style - a MapLibre Style
 * @returns a migrated style
 * @example
 * const fs = require('fs');
 * const migrate = require('@maplibre/maplibre-gl-style-spec').migrate;
 * const style = fs.readFileSync('./style.json', 'utf8');
 * fs.writeFileSync('./style.json', JSON.stringify(migrate(style)));
 */
export declare function migrate(style: StyleSpecification): StyleSpecification;
export type RingWithArea<T extends Point2D> = T[] & {
	area?: number;
};
/**
 * Classifies an array of rings into polygons with outer rings and holes
 * @param rings - the rings to classify
 * @param maxRings - the maximum number of rings to include in a polygon, use 0 to include all rings
 * @returns an array of polygons with internal rings as holes
 */
export declare function classifyRings<T extends Point2D>(rings: RingWithArea<T>[], maxRings?: number): RingWithArea<T>[][];
export declare const v8: any;
export type ExpressionType = "data-driven" | "cross-faded" | "cross-faded-data-driven" | "color-ramp" | "data-constant" | "constant";
export type ExpressionParameters = Array<"zoom" | "feature" | "feature-state" | "heatmap-density" | "line-progress">;
export type ExpressionSpecificationDefinition = {
	interpolated: boolean;
	parameters: ExpressionParameters;
};
export type StylePropertySpecification = {
	type: "number";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: number;
} | {
	type: "string";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: string;
	tokens?: boolean;
} | {
	type: "boolean";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: boolean;
} | {
	type: "enum";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	values: {
		[_: string]: {};
	};
	transition: boolean;
	default?: string;
} | {
	type: "color";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: ColorSpecification;
	overridable: boolean;
} | {
	type: "array";
	value: "number";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	length?: number;
	transition: boolean;
	default?: Array<number>;
} | {
	type: "array";
	value: "string";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	length?: number;
	transition: boolean;
	default?: Array<string>;
} | {
	type: "padding";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: PaddingSpecification;
} | {
	type: "variableAnchorOffsetCollection";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: VariableAnchorOffsetCollectionSpecification;
} | {
	type: "projectionDefinition";
	"property-type": ExpressionType;
	expression?: ExpressionSpecificationDefinition;
	transition: boolean;
	default?: ProjectionDefinitionSpecification;
};
export declare const expression: {
	StyleExpression: typeof StyleExpression;
	StylePropertyFunction: typeof StylePropertyFunction;
	ZoomConstantExpression: typeof ZoomConstantExpression;
	ZoomDependentExpression: typeof ZoomDependentExpression;
	createExpression: typeof createExpression;
	createPropertyExpression: typeof createPropertyExpression;
	isExpression: typeof isExpression;
	isExpressionFilter: typeof isExpressionFilter;
	isZoomExpression: typeof isZoomExpression;
	normalizePropertyExpression: typeof normalizePropertyExpression;
};
declare const styleFunction: {
	convertFunction: typeof convertFunction;
	createFunction: typeof createFunction;
	isFunction: typeof isFunction;
};
export declare const visit: {
	eachLayer: typeof eachLayer;
	eachProperty: typeof eachProperty;
	eachSource: typeof eachSource;
};

export {
	_default as latest,
	interpolateFactory as interpolates,
	styleFunction as function,
	typeToString as toString,
};

export {};
