/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoryRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportDeleteMemoryAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportDeleteMemoryAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MemoryContainerHelper memoryContainerHelper;

    @Inject
    public TransportDeleteMemoryAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting, MemoryContainerHelper memoryContainerHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/memory/delete", transportService, actionFilters, MLDeleteMemoryRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.memoryContainerHelper = memoryContainerHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLDeleteMemoryRequest deleteRequest = MLDeleteMemoryRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = deleteRequest.getMemoryContainerId();
        MemoryType memoryType = deleteRequest.getMemoryType();
        String memoryId = deleteRequest.getMemoryId();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to delete memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            String memoryIndexName = this.memoryContainerHelper.getMemoryIndexName((MLMemoryContainer)container, memoryType);
            if (memoryIndexName == null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Memory index not found", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            GetRequest getRequest = new GetRequest(memoryIndexName, memoryId);
            ActionListener getResponseActionListener = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Memory not found", RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                String ownerId = (String)getResponse.getSourceAsMap().get("owner_id");
                if (!this.memoryContainerHelper.checkMemoryAccess(user, ownerId)) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to delete this memory", RestStatus.FORBIDDEN, new Object[0]));
                    return;
                }
                log.info("Delete memory - Event: MEMORY_DELETED, Memory ID: {}, Memory Type: {}, Container ID: {}, User: {}, Timestamp: {}", (Object)memoryId, (Object)memoryType, (Object)memoryContainerId, (Object)(user != null ? user.getName() : "unknown"), (Object)Instant.now());
                DeleteRequest deleteMemoryRequest = new DeleteRequest(memoryIndexName, memoryId);
                this.memoryContainerHelper.deleteData(container.getConfiguration(), deleteMemoryRequest, actionListener);
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0));
            this.memoryContainerHelper.getData(container.getConfiguration(), getRequest, (ActionListener<GetResponse>)getResponseActionListener);
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }
}

