'''OpenGL extension ARB.indirect_parameters

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.indirect_parameters to provide a more 
Python-friendly API

Overview (from the spec)
	
	    OpenGL 4.3 (with the introduction of the GL_ARB_multi_draw_indirect
	extension) enhanced the ability of OpenGL to allow a large sets of
	parameters for indirect draws (introduced with OpenGL 4.0) into a buffer
	object and dispatch the entire list with one API call. This allows, for
	example, a shader (such as a compute shader via shader storage buffers,
	or a geometry shader via transform feedback) to produce lists of draw
	commands that can then be consumed by OpenGL without a server-client
	round trip. However, when a variable and potentially unknown number of
	draws are produced by such a shader, it becomes difficult to know how
	many draws are in the output array(s). Applications must resort to
	techniques such as transform feedback primitive queries, or mapping
	buffers containing the content of atomic counters, which can cause stalls
	or bubbles in the OpenGL pipeline.
	
	    This extension introduces the concept of the "parameter buffer", which
	is a target allowing buffers to store parameters for certain drawing
	commands. Also in this extension, new variants of MultiDrawArraysIndirect
	and MultiDrawElementsIndirect are introduced that source some of their
	parameters from this buffer. Further commands could potentially be
	introduced that source other parameters from a buffer.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/indirect_parameters.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.indirect_parameters import *
from OpenGL.raw.GL.ARB.indirect_parameters import _EXTENSION_NAME

def glInitIndirectParametersARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION