/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.EmptyRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.RegionDecoLineRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.SegmentedRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.watabou.noosa.audio.Music;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import com.watabou.utils.Rect;
import java.util.ArrayList;

public class VaultLevel
extends Level {
    public VaultLevel() {
        this.color1 = 4941366;
        this.color2 = 0xF2F2F2;
    }

    @Override
    public void playLevelMusic() {
        Music.INSTANCE.playTracks(CityLevel.CITY_TRACK_LIST, CityLevel.CITY_TRACK_CHANCES, false);
    }

    @Override
    public String tilesTex() {
        return "environment/tiles_city.png";
    }

    @Override
    public String waterTex() {
        return "environment/water3.png";
    }

    @Override
    protected boolean build() {
        this.setSize(34, 34);
        ArrayList<StandardRoom> rooms = new ArrayList<StandardRoom>();
        RegionDecoLineRoom finalRoom = null;
        Room entryRoom = null;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x == 3 && y <= 1) {
                    if (y == 1) continue;
                    RegionDecoLineRoom regionDecoLineRoom = new RegionDecoLineRoom();
                    regionDecoLineRoom.set(1 + 8 * x, 1 + 8 * y, 9 + 8 * x, 17);
                    rooms.add(regionDecoLineRoom);
                    finalRoom = regionDecoLineRoom;
                    continue;
                }
                if (x == 0 && y == 3) {
                    EmptyRoom emptyRoom = new EmptyRoom();
                    emptyRoom.set(1 + 8 * x, 1 + 8 * y, 9 + 8 * x, 9 + 8 * y);
                    rooms.add(emptyRoom);
                    entryRoom = emptyRoom;
                    continue;
                }
                SegmentedRoom segmentedRoom = new SegmentedRoom();
                segmentedRoom.set(1 + 8 * x, 1 + 8 * y, 9 + 8 * x, 9 + 8 * y);
                rooms.add(segmentedRoom);
            }
        }
        Room[] ra = rooms.toArray(new Room[0]);
        for (int i = 0; i < ra.length - 1; ++i) {
            for (int j = i + 1; j < ra.length; ++j) {
                ra[i].addNeigbour(ra[j]);
            }
        }
        for (Room room : rooms) {
            for (Room room2 : room.neigbours) {
                if (room2.height() > 10) continue;
                if (room.height() > 10) {
                    if (!room.canConnect(room2) || room.bottom != room2.top) continue;
                    room.connect(room2);
                    continue;
                }
                if (!room.canConnect(room2)) continue;
                room.connect(room2);
            }
        }
        for (Room room : rooms) {
            for (Room room3 : room.connected.keySet()) {
                Room.Door door = room.connected.get(room3);
                if (door != null) continue;
                Rect i = room.intersect(room3);
                ArrayList<Point> doorSpots = new ArrayList<Point>();
                for (Point p : i.getPoints()) {
                    if (!room.canConnect(p) || !room3.canConnect(p)) continue;
                    doorSpots.add(p);
                }
                if (doorSpots.isEmpty()) {
                    ShatteredPixelDungeon.reportException(new RuntimeException("Could not place a door! r=" + room.getClass().getSimpleName() + " n=" + room3.getClass().getSimpleName()));
                    continue;
                }
                door = new Room.Door((Point)Random.element(doorSpots));
                room.connected.put(room3, door);
                room3.connected.put(room, door);
            }
        }
        for (Room room : rooms) {
            room.paint(this);
            if (room instanceof RegionDecoLineRoom) {
                Painter.fill(this, room, 1, 14);
                Painter.fill(this, room.left + 1, room.top + 1, 7, 1, 34);
                Painter.fill(this, room.left + 1, room.top + 1, 1, 14, 34);
                Painter.fill(this, room.right - 1, room.top + 1, 1, 14, 34);
            }
            for (Point point : room.connected.values()) {
                Painter.set((Level)this, point, 5);
            }
        }
        this.entrance = this.pointToCell(entryRoom.random());
        this.transitions.add(new LevelTransition(this, this.entrance, LevelTransition.Type.BRANCH_ENTRANCE, Dungeon.depth, 0, LevelTransition.Type.BRANCH_EXIT));
        rooms.remove(entryRoom);
        rooms.remove(finalRoom);
        for (Room room : rooms) {
            int n;
            if (Random.Int(5) == 0) continue;
            Item item = Generator.randomUsingDefaults(Random.oneOf(Generator.Category.WEAPON, Generator.Category.WEAPON, Generator.Category.ARMOR, Generator.Category.WAND, Generator.Category.RING));
            while (this.map[n = this.pointToCell(room.random())] != 1) {
            }
            if (item.cursed) {
                item.cursed = false;
                if (item instanceof MeleeWeapon && ((MeleeWeapon)item).hasCurseEnchant()) {
                    ((MeleeWeapon)item).enchant(null);
                } else if (item instanceof Armor && ((Armor)item).hasCurseGlyph()) {
                    ((Armor)item).inscribe(null);
                }
            }
            item.identify();
            this.drop(item, n);
        }
        return true;
    }

    @Override
    public boolean activateTransition(Hero hero, LevelTransition transition) {
        return false;
    }

    @Override
    public Mob createMob() {
        return null;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        Random.pushGenerator(Random.Long());
        ArrayList<Item> bonesItems = Bones.get();
        if (bonesItems != null) {
            for (Item i : bonesItems) {
                this.drop((Item)i, (int)(this.entrance() - this.width())).setHauntedIfCursed().type = Heap.Type.REMAINS;
            }
        }
        Random.popGenerator();
    }

    @Override
    public int randomRespawnCell(Char ch) {
        return this.entrance() - this.width();
    }
}

