/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import org.apache.solr.client.api.endpoint.SwapCoresApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SwapCoresRequestBody;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class SwapCores
extends CoreAdminAPIBase
implements SwapCoresApi {
    @Inject
    public SwapCores(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse swapCores(String coreName, SwapCoresRequestBody requestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        this.ensureRequiredRequestBodyProvided(requestBody);
        this.ensureRequiredParameterProvided("with", requestBody.with);
        SolrJerseyResponse solrJerseyResponse = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        return this.handlePotentiallyAsynchronousTask(solrJerseyResponse, coreName, requestBody.async, "swap", () -> {
            this.coreContainer.swap(coreName, requestBody.with);
            return solrJerseyResponse;
        });
    }
}

