/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.node;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.google.common.base.Enums;
import io.prometheus.metrics.model.snapshots.Labels;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrNoOpMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.node.PrometheusNodeFormatterInfo;
import org.apache.solr.metrics.prometheus.node.SolrNodeContainerMetric;
import org.apache.solr.metrics.prometheus.node.SolrNodeHandlerMetric;

public class SolrPrometheusNodeFormatter
extends SolrPrometheusFormatter
implements PrometheusNodeFormatterInfo {
    @Override
    public void exportDropwizardMetric(Metric dropwizardMetric, String metricName) {
        if (metricName.contains(".threadPool.")) {
            this.exportThreadPoolMetric(dropwizardMetric, metricName);
            return;
        }
        SolrMetric solrNodeMetric = this.categorizeMetric(dropwizardMetric, metricName);
        solrNodeMetric.parseLabels().toPrometheus(this);
    }

    @Override
    public SolrMetric categorizeMetric(Metric dropwizardMetric, String metricName) {
        String metricCategory = metricName.split("\\.", 2)[0];
        if (!Enums.getIfPresent(PrometheusNodeFormatterInfo.NodeCategory.class, (String)metricCategory).isPresent()) {
            return new SolrNoOpMetric();
        }
        switch (PrometheusNodeFormatterInfo.NodeCategory.valueOf(metricCategory)) {
            case ADMIN: 
            case UPDATE: {
                return new SolrNodeHandlerMetric(dropwizardMetric, metricName);
            }
            case CONTAINER: {
                return new SolrNodeContainerMetric(dropwizardMetric, metricName);
            }
        }
        return new SolrNoOpMetric();
    }

    private void exportThreadPoolMetric(Metric dropwizardMetric, String metricName) {
        String[] parsedMetric = metricName.split("\\.");
        Labels labels = parsedMetric.length >= 5 ? Labels.of((String[])new String[]{"category", parsedMetric[0], "handler", parsedMetric[1], "executer", parsedMetric[3], "task", parsedMetric[parsedMetric.length - 1]}) : Labels.of((String[])new String[]{"category", parsedMetric[0], "executer", parsedMetric[2], "task", parsedMetric[parsedMetric.length - 1]});
        if (dropwizardMetric instanceof Counter) {
            this.exportCounter("solr_metrics_node_thread_pool", (Counter)dropwizardMetric, labels);
        } else if (dropwizardMetric instanceof Meter) {
            this.exportMeter("solr_metrics_node_thread_pool", (Meter)dropwizardMetric, labels);
        }
    }
}

