/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.jasper.compiler.Localizer;

public class BodyContentImpl
extends BodyContent {
    private final boolean limitBuffer;
    private final int tagBufferSize;
    private char[] cb;
    private int nextChar;
    private boolean closed;
    private Writer writer;

    public BodyContentImpl(JspWriter jspWriter, boolean bl, int n) {
        super(jspWriter);
        this.limitBuffer = bl;
        this.tagBufferSize = n;
        this.cb = new char[n];
        this.bufferSize = this.cb.length;
        this.nextChar = 0;
        this.closed = false;
    }

    public void write(int n) throws IOException {
        if (this.writer != null) {
            this.writer.write(n);
        } else {
            this.ensureOpen();
            if (this.nextChar >= this.bufferSize) {
                this.reAllocBuff(1);
            }
            this.cb[this.nextChar++] = (char)n;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray, n, n2);
        } else {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (n2 >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(n2);
            }
            System.arraycopy(cArray, n, this.cb, this.nextChar, n2);
            this.nextChar += n2;
        }
    }

    public void write(char[] cArray) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray);
        } else {
            this.write(cArray, 0, cArray.length);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.writer != null) {
            this.writer.write(string, n, n2);
        } else {
            this.ensureOpen();
            if (n2 >= this.bufferSize - this.nextChar) {
                this.reAllocBuff(n2);
            }
            string.getChars(n, n + n2, this.cb, this.nextChar);
            this.nextChar += n2;
        }
    }

    public void write(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            this.write(string, 0, string.length());
        }
    }

    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(System.lineSeparator());
        } else {
            this.write(System.lineSeparator());
        }
    }

    public void print(boolean bl) throws IOException {
        if (this.writer != null) {
            this.writer.write(bl ? "true" : "false");
        } else {
            this.write(bl ? "true" : "false");
        }
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    public void print(int n) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(n));
        } else {
            this.write(String.valueOf(n));
        }
    }

    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void print(char[] cArray) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray);
        } else {
            this.write(cArray);
        }
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            this.write(string);
        }
    }

    public void print(Object object) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(object));
        } else {
            this.write(String.valueOf(object));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.println();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.println();
    }

    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.nextChar = 0;
        if (this.limitBuffer && this.cb.length > this.tagBufferSize) {
            this.cb = new char[this.tagBufferSize];
            this.bufferSize = this.cb.length;
        }
    }

    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.closed = true;
        }
    }

    public int getBufferSize() {
        return this.writer == null ? this.bufferSize : 0;
    }

    public int getRemaining() {
        return this.writer == null ? this.bufferSize - this.nextChar : 0;
    }

    public Reader getReader() {
        return this.writer == null ? new CharArrayReader(this.cb, 0, this.nextChar) : null;
    }

    public String getString() {
        return this.writer == null ? new String(this.cb, 0, this.nextChar) : null;
    }

    public void writeOut(Writer writer) throws IOException {
        if (this.writer == null) {
            writer.write(this.cb, 0, this.nextChar);
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        this.closed = false;
        if (writer == null) {
            this.clearBody();
        }
    }

    protected void recycle() {
        this.writer = null;
        try {
            this.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Localizer.getMessage("jsp.error.stream.closed"));
        }
    }

    private void reAllocBuff(int n) {
        if (this.bufferSize + n <= this.cb.length) {
            this.bufferSize = this.cb.length;
            return;
        }
        if (n < this.cb.length) {
            n = this.cb.length;
        }
        char[] cArray = new char[this.cb.length + n];
        System.arraycopy(this.cb, 0, cArray, 0, this.cb.length);
        this.cb = cArray;
        this.bufferSize = this.cb.length;
    }
}

